!----------------------------------------------------------------------------
!Basically this is a placeholder so we know when a "string" was used in Verb
object textstring
{
    is known
    misc "" !This will hold the actual value of the string.
    before {
        xobject { return BeforeString(self.misc) }
    }
    after {
        xobject { return AfterString(self.misc) }
    }
}

!----------------------------------------------------------------------------
routine DoSkip
{
    if (object is not skippable) {
        "You can't "; : print word[1];
        print MatchPlural(object, "that", "those"); "."
    } else {
        if (xobject) {
            if (object = xobject) {
                "It wouldn't make sense to do that."
            } else {
                "Nothing is to be gained by trying to ";
                print word[1]; " ";
                if (object is plural) {
                    print object.name; " ";
                } else {
                    print Art(object); " ";
                }
                print word[3]; " ";
                print Art(xobject); ". ";
                "It probably wouldn't even work."
            }
        } else {
            "You should be more specific about what you want to ";
            print word[1];
            print MatchPlural(object, "that ", "those "); "at."
        }
    }
}

!----------------------------------------------------------------------------
routine DoJumpOver
{
    !I.e., "You can't jump over the bridge."
    "You can't "; : print word[1]; " ";
    if (word[2] = "over", "across") {
        print word[2]; " ";
    } else {
        print "over ";
    }
    print Art(object); "."
}

!----------------------------------------------------------------------------
routine DoJumpInto
{
    !I.e., "You can't jump into the water."
    "You can't "; : print word[1]; " ";
    print word[2]; " ";
    print Art(object); "."
}

!----------------------------------------------------------------------------
routine DoClearScreen
{
    local slh
    window 0 : cls
    slh = display.statusline_height + 1
    !if (allow_image) { locate 1, slh }
    locate 1, slh
	PrintStatusLine
}

!----------------------------------------------------------------------------
replace DoSwim
{
    local inword : inword = word[2]
    if (inword ~= "in","into","across","through","on") {
        if word[1] = "dive"
            inword = "into"
        else
            inword = "in"
    }
    if (object) {
        if (object is not swimmable) {
            "You can't "; : print word[1]; " "; inword;
            print MatchPlural(object, "that", "those"); ". Maybe you ";
            "meant to do something else?"
        } else {
            !Object is swimmable, but no handler exists.
            "Now isn't the time for such exercises."
        }
    } else {
        !The equivalent of DoVague for the DoSwim scenario.
        print "What do you want to "; word[1]; " "; inword; "?"
    }
}

!----------------------------------------------------------------------------
routine DoFill
{
    if (object is not container) {
        "It wasn't really intended for that."
    } elseif (xobject = 0) {
        "Please be more specific about what you want to ";
        print word[1];
        MatchPlural(object,"it","them")
        if (word[1] = "fill") { " with." }
        if (word[1] = "dip") { " in." }
    } else {
        "You deem it unnecessary, perhaps impossible, to ";
        print word[1]; " "; Art(object); " ";
        if (word[1] = "fill") { "with "; }
        if (word[1] = "dip") { "in "; }
        print Art(xobject); "."
    }
}

!----------------------------------------------------------------------------
!This way, we can re-display the cut-scene after we do a restore from disk.
replace DoRestore
{
    local rst : rst = restore

    !So that saved version doesn't override.
    allow_image = true : CheckForGraphics

    !So that saved version doesn't override.
    allow_music = true : CheckForMusic

    if (rst) {
        !Start playing the same tune from before
        PlayMusic(MUSIC_STOP) !So we start the song over again.
        PlaySong(player.misc #13)
        DoViewChapter(true) : return true
    } else {
        VMessage(&DoRestore, 2) ! "Unable to restore."
    }
}

!----------------------------------------------------------------------------
!Handles the "view" verb
routine DoViewPicture
{
    if (allow_image) {
        DoViewChapter(false)
    } else {
        "Graphics are not enabled or not available. Sorry."
    }
}

!----------------------------------------------------------------------------
!This way, we can re-display the cut-scene after we do a restore from disk.
routine DoViewChapter(didrestore)
{
    if (allow_image) { ReadyTheIntro } else { print " " }
    ShowChapterScene(Chapter,Section)
    if (allow_image) { ReadyTheScreen }
    FindLight(location)
    PrintStatusline
    if (didrestore) { VMessage(&DoRestore, 1) } ! "Restored."
    DescribePlace(location, true)
    run location.each_turn !Because we do some stuff afterwards
    !!!!runevents !Do I need this???
    !!!!RunScripts !And do I need this???
    roomdesc_seen = false !To set it up for next turn.
}

!----------------------------------------------------------------------------
routine DoModeParsing
{
    if IsEqual(parse$,"normal","Normal","NORMAL") {
        DoModeNormal
    } elseif IsEqual(parse$,"intox","Intox","INTOX") {
        DoModeIntox
    } elseif IsEqual(parse$,"compass","Compass","COMPASS") {
        DoModeCompass
    } elseif IsEqual(parse$,"translate","Translate","TRANSLATE") {
        DoModeTranslate
    } elseif IsEqual(parse$,"xyzzy","Xyzzy","XYZZY") {
        DoXyzzy
    } else {
        DoMode(99) !Will give the "nothing happens" message.
    }
}

!----------------------------------------------------------------------------
routine DoModeNormal
{ DoMode(0) }
routine DoModeIntox
{ DoMode(1) }
routine DoModeCompass
{ DoMode(2) }
routine DoModeTranslate
{ DoMode(3) }

!----------------------------------------------------------------------------
!This is the default "MODE" verb handler.
routine DoMode(modenum)
{
    SetWatchMode(modenum) !Just pass it along to the routine in MISC.HUG.
}

!----------------------------------------------------------------------------
routine DoPointFinger
{
    Perform(&DoPoint,0,object) !Turns object into xobject
}
!----------------------------------------------------------------------------
routine DoPoint
{
    if (object) {
        if (xobject) {
            if (object = xobject) {
                print "You can't "; word[1]; " something at itself."
            } else {
                print "Nothing is gained by "; word[1]; "ing that at ";
                print Art(xobject); "."
            }
        } else {
            print "You didn't "; word[1]; " that at anything."
        }
    } else {
        if (xobject) {
            "You point your finger at";
            if (xobject is living) {
                 print " "; : PrintHimHer(xobject)
            } else {
                 MatchPlural(xobject,"that","them")
            }
            print ", but nothing happens."
        } else {
            Perform(&DoVague,object,xobject)
        }
    }
}

!----------------------------------------------------------------------------
routine DoRead
{
    !If the object doesn't have a custom "read" handler, then we send it
    !on to "look" instead, as was the default in the Hugo libraries.
    Perform(&DoLook, object)
}

!----------------------------------------------------------------------------
routine DoUnfold
{
    !We're going to have to assume that every object we can fold or unfold
    !has a custom handler built-in. Otherwise, we have to make it generic
    !by adding an "is foldable" property, and that's unecessary right now.
    !Note that if we did that later, we'd want to change the VERB object.
    ParseError(12,object)
}

!----------------------------------------------------------------------------
routine DoFold
{
    !We're going to have to assume that every object we can fold or unfold
    !has a custom handler built-in. Otherwise, we have to make it generic
    !by adding an "is foldable" property, and that's unecessary right now.
    !Note that if we did that later, we'd want to change the VERB object.
    ParseError(12,object)
}

!----------------------------------------------------------------------------
replace DoUndo
{
    local und : und = undo_counter

    if not UNDO_OFF {
        if (und < 3) {
            if undo {
                und++ : undo_counter=und
                print "(Undo of the ";
                if (und=2) { "second "; }
                if (und=3) { "third "; }
                print "most recent turn successful)"
                PrintStatusline
                DescribePlace(location)
            } else {
                VMessage(&DoUndo)
            }
        } else {
            "(Undo available for the three most recent turns only)"
        }
    } else {
		VMessage(&DoUndo)
    }
}

!----------------------------------------------------------------------------
routine DoGetReverse
{
    !This is a front-end for "Ask NPC for Object" to use GET as a routine.
    if CheckReach(xobject) {
        if Contains(object,xobject) {
            Perform(&DoGet,xobject,object) !Reverse so OBJ=Object, XOBJ=Person.
        } else {
            local obj : obj = xobject : xobject = object
            ParseError(14,obj)
        }
    }
}

!----------------------------------------------------------------------------
routine DoYellReverse
{
    !This is only a front-end to DoYell in which we swap objects orders.
    Perform(&DoYell,xobject,object) !Reverse so OBJ=Person, XOBJ=About
}

!----------------------------------------------------------------------------
routine DoYellString
{
    !Front end for when we yell a "string" out.
    textstring.misc = parse$
    Perform(&DoYell,object,textstring)
}

!----------------------------------------------------------------------------
!Object contains person we're yelling at, xobject contains what it's about.
!
replace DoYell
{
    if (object=0) and (speaking>0) {
        print "(assuming you are "; word[1]; "ing at "; speaking.name; ")"
        object=speaking
    }
    if (object=player) {
        print "You can't "; word[1]; " at yourself."
    } else {
        if (object ~= 0,nothing) {
            speaking=object !We're "talking" to this individual.
            if (xobject ~= 0,nothing) {
                if (not object.after) and (not xobject.after) {
                    print capital word[1];
                    "ing isn't needed in the present situation.
                    A more civil approach might be to\I tell \i";
                    print object.name;
                    if (xobject=textstring) {
                        print " \""; textstring.misc; "\" ";
                    } else {
                        " about";
                        if (xobject is living) {
                            print " "; xobject.pronoun #2; ", ";
                        } else {
                            MatchPlural(xobject,"that","them")
                            print ", ";
                        }
                    }
                    print "instead."
                    #ifclear NO_SCRIPTS
                    SkipScript(object)
                    #endif
                }
            } else {
                if (not object.after) {
                    print "It isn't ordinarily in your nature to "; word[1];
                    print " at other people, and nothing about the present
                    situation demands an exception."
                }
            }
        } else {
            if (xobject ~= 0,nothing) {
                if (not xobject.after) {
                    if (xobject=textstring) {
                        print "You "; word[1]; " \""; textstring.misc; "\" -- ";
                    } else {
                        print "You "; word[1]; " about "; Art(xobject); ", ";
                    }
                    "but nothing happens."
                }
            } else {
                print capital word[1]; "ing for "; word[1]; "ing's sake may be a vent
                for frustration, but you decide against it now. Besides, it might be
                more useful to "; word[1]; "\I at \isomeone or\I about \isomething."
            }
        }
    }
}

!----------------------------------------------------------------------------
routine DoTellReverse
{
    !This is only a front-end to DoTell in which we swap objects orders.
    Perform(&DoTell,xobject,object) !Reverse so OBJ=Person, XOBJ=About
}

!----------------------------------------------------------------------------
routine DoTellString
{
    !Front end for when we say a "string" instead.
    textstring.misc = parse$
    Perform(&DoTell,object,textstring)
}

!----------------------------------------------------------------------------
replace DoTell
{
    if (object=0) and (speaking>0) {
        print "(assuming you are talking to "; speaking.name; ")"
        object=speaking
    }

    if (object = player) {
        VMessage(&DoAsk, 2) ! "Talking to yourself..."
    } else {
        if (object ~= 0,nothing) {
            speaking=object !We're "talking" to this individual.
            if (xobject ~= 0,nothing) {
                if (not object.after) and (not xobject.after) {
                    if (object is unfriendly) {
                        if (not object.ignore_response) {
                            Message(&Speakto, 4)  ! "X ignores you."
                        }
                        speaking = 0
                    } else {
                        if (xobject=textstring) {
                            if IsEqual(textstring.misc,"hi","hello","howdy") {
                                Perform(&DoHello,object)
                            } else {
                                print capital object.pronoun #1;
                                " doesn't respond to ";
                                print "\""; textstring.misc; "\""
                            }
                        } else {
                            if (not xobject.after) {
                                VMessage(&DoTell, 2) ! "Not interested..."
                            }
                        }
                        #ifclear NO_SCRIPTS
                        SkipScript(object)
                        #endif
                    }
                    return true
                }
            } else {
                if (not object.after) {
                    VMessage(&DoTell, 1) ! "Tell about something specific..."
                    return false
                }
            }
        } else {
            !*************** Special Condition for Trading Punches **********
            if (Chapter=2) and (ruhnestory=10) {
                "Your voice is lost to the roar of the wind."
                return
            }
            !****************************************************************
            if (xobject ~= 0,nothing) {
                if (not xobject.after) {
                    if (xobject=textstring) {
                        if IsEqual(textstring.misc,"hi","hello","howdy") {
                            Perform(&DoHello,object) : return true
                        } else {
                            print "You say \""; textstring.misc; "\" -- ";
                        }
                    } else {
                        print "You "; word[1]; " about "; Art(xobject); ", ";
                    }
                    "but nothing happens."
                }
            } else {
                !Not needed, because our verb def prevents this situation.
                !!! VMessage(&DoTell, 1) ! "Tell about something specific..."
                !!! return false
            }
        }
    }
}

!----------------------------------------------------------------------------
replace DoPush
{
    if not CheckReach(object): return false
    !**** CUSTOM MODIFICATION BEGIN
    if (location = airlock) {
        if (object = n_obj) {
            perform(&DoPush, airlocknorth)
            return true
        }
        if (object = s_obj) {
            perform(&DoPush, airlocksouth)
            return true
        }
    }
    !**** CUSTOM MODIFICATION END
    "Pushing ";
    The(object, true)
    " doesn't get ";
    print player.pronoun #2;
    " anywhere."
    return true
}

!----------------------------------------------------------------------------
replace DoPull
{
    if not CheckReach(object): return false
    "Pulling ";
    The(object, true)
    " doesn't get ";
    print player.pronoun #2;
    " anywhere."
    return true
}

!----------------------------------------------------------------------------
routine DoPoke
{
    if not CheckReach(object): return false
    "Poking ";
    The(object, true)
    if (xobject) {
        print " with "; art(xobject);
    } else {
        " with your finger";
    }
    " doesn't get ";
    print player.pronoun #2;
    " anywhere."
    return true
}

!----------------------------------------------------------------------------
routine DoPryReverse
{
    !This is only a front-end to DoPry in which we swap objects orders.
    Perform(&DoPry,xobject,object) !Reverse so OBJ=Openable, XOBJ=Held
}

!----------------------------------------------------------------------------
routine DoPry
{
    if (not object.after) and (not xobject.after) {
        if (object is open) {
            print CArt(object); " is already open."
        } else {
            print capital word[1]; "ing"; MatchPlural(object,"it","them");       
            " open is not really necessary, and perhaps not even possible."
        }
    }

}

!----------------------------------------------------------------------------
routine DoTurn
{
    if (not object.after) and (not xobject.after) {
        print "You have no reason to try "; word[1]; "ing";
        print MatchPlural(object,"that","those"); "."
    }
}

!----------------------------------------------------------------------------
!Basically, we need to hack this so that we don't get confused by pressing
!the "north" when implying "north portal"
!
replace DoTouch
{
    !**** CUSTOM MODIFICATION BEGIN
    if (location = airlock) {
        if (object = n_obj) {
            perform(&DoTouch, airlocknorth)
            return true
        }
        if (object = s_obj) {
            perform(&DoTouch, airlocksouth)
            return true
        }
    }
    !**** CUSTOM MODIFICATION END
    "Fiddling with ";
    The(object, true)
    " like that probably isn't the best use of ";
    print player.pronoun #3;
    " time at the moment."
}


!----------------------------------------------------------------------------
routine DoPlaySong
{
    PlayMusic(MUSIC_STOP)
    PlaySong(parse$)
}

!----------------------------------------------------------------------------
routine DoWalkthru
{
    "The solution to Trading Punches was included with your download. The
    file name is \"trading.txt\" -- enjoy!"
}

!----------------------------------------------------------------------------
routine DoXyzzy
{
    if Contains(player,wristwatch) {
        if (wristwatch is worn) and \
           (divesuit is not worn) and \
           (wristwatch.misc #2 = true) {
            "Clever, clever! Well, whatever."
            "One reward for this endeavor."
            "Reach the end to see one more."
            "That's a freebie: TP's score."
            "If you plead, and if you beg,"
            "You still won't find the final egg."
        } else {
            "Nothing happens -- Father's wristwatch does not respond."
        }
    } else {
        "Try that mode when modes are tried."
    }
}

!----------------------------------------------------------------------------
routine DoPlugh
{
    "Are you coughing?"
}

!----------------------------------------------------------------------------
routine DoAbout
{
    PrintAboutMessage()
}

!----------------------------------------------------------------------------
replace DoScore
{
    "Thyras might keep score, but you've always considered it unnecessary."
}
