/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import org.zmpp.encoding.ZsciiEncoding;
import org.zmpp.io.IOSystem;
import org.zmpp.io.OutputStream;

public class TranscriptOutputStream
implements OutputStream {
    private IOSystem iosys;
    private BufferedWriter output;
    private Writer transcriptWriter;
    private boolean enabled;
    private StringBuilder linebuffer;
    private ZsciiEncoding encoding;

    public TranscriptOutputStream(IOSystem iOSystem, ZsciiEncoding zsciiEncoding) {
        this.iosys = iOSystem;
        this.encoding = zsciiEncoding;
        this.linebuffer = new StringBuilder();
    }

    private void initFile() {
        if (this.transcriptWriter == null) {
            this.transcriptWriter = this.iosys.getTranscriptWriter();
            this.output = new BufferedWriter(this.transcriptWriter);
        }
    }

    public void print(short s, boolean bl) {
        this.initFile();
        if (this.output != null) {
            if (s == 13) {
                this.flush();
            } else if (s == 8) {
                this.linebuffer.deleteCharAt(this.linebuffer.length() - 1);
            } else {
                this.linebuffer.append(this.encoding.getUnicodeChar(s));
            }
        }
    }

    public void select(boolean bl) {
        this.enabled = bl;
    }

    public boolean isSelected() {
        return this.enabled;
    }

    public void flush() {
        try {
            if (this.output != null) {
                this.output.write(this.linebuffer.toString());
                this.output.write("\n");
                this.linebuffer = new StringBuilder();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
        }
    }

    public void close() {
        if (this.output != null) {
            try {
                this.output.close();
                this.output = null;
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
        if (this.transcriptWriter != null) {
            try {
                this.transcriptWriter.close();
                this.transcriptWriter = null;
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }

    public void deletePrevious(short s) {
    }
}

