/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.encoding;

import org.zmpp.encoding.AlphabetTable;

public class DefaultAlphabetTable
implements AlphabetTable {
    private static final String A0CHARS = "abcdefghijklmnopqrstuvwxyz";
    private static final String A1CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String A2CHARS = " \n0123456789.,!?_#'\"/\\-:()";

    public short getA0Char(byte by) {
        if (by == 0) {
            return 32;
        }
        return (short)A0CHARS.charAt(by - 6);
    }

    public short getA1Char(byte by) {
        if (by == 0) {
            return 32;
        }
        return (short)A1CHARS.charAt(by - 6);
    }

    public short getA2Char(byte by) {
        if (by == 0) {
            return 32;
        }
        return (short)A2CHARS.charAt(by - 6);
    }

    public final byte getA0CharCode(short s) {
        return DefaultAlphabetTable.getCharCodeFor(A0CHARS, s);
    }

    public final byte getA1CharCode(short s) {
        return DefaultAlphabetTable.getCharCodeFor(A1CHARS, s);
    }

    public byte getA2CharCode(short s) {
        return DefaultAlphabetTable.getCharCodeFor(A2CHARS, s);
    }

    protected static byte getCharCodeFor(String string, short s) {
        int n = string.indexOf(s);
        if (n >= 0) {
            n += 6;
        }
        return (byte)n;
    }

    public boolean isShift1(short s) {
        return s == 4;
    }

    public boolean isShift2(short s) {
        return s == 5;
    }

    public boolean isShift(short s) {
        return this.isShift1(s) || this.isShift2(s);
    }

    public boolean isShiftLock(short s) {
        return false;
    }

    public boolean isAbbreviation(short s) {
        return 1 <= s && s <= 3;
    }
}

