/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.swingui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import org.zmpp.swingui.Canvas;

public class CanvasImpl
implements Canvas {
    private BufferedImage image;
    private Graphics graphics;
    private ImageObserver observer;

    public CanvasImpl(BufferedImage bufferedImage, ImageObserver imageObserver) {
        this.image = bufferedImage;
        this.graphics = bufferedImage.getGraphics();
        this.observer = imageObserver;
    }

    public int getWidth() {
        return this.image.getWidth();
    }

    public int getHeight() {
        return this.image.getHeight();
    }

    public void setFont(Font font) {
        this.image.getGraphics().setFont(font);
    }

    public int getFontHeight(Font font) {
        return this.graphics.getFontMetrics(font).getHeight();
    }

    public int getFontAscent(Font font) {
        return this.graphics.getFontMetrics().getMaxAscent();
    }

    public int getCharWidth(Font font, char c) {
        return this.graphics.getFontMetrics(font).charWidth(c);
    }

    public int getFontDescent(Font font) {
        return this.graphics.getFontMetrics(font).getMaxDescent();
    }

    public int getStringWidth(Font font, String string) {
        return this.graphics.getFontMetrics(font).stringWidth(string);
    }

    public void fillRect(Color color, int n, int n2, int n3, int n4) {
        this.graphics.setColor(color);
        this.graphics.fillRect(n, n2, n3, n4);
    }

    public void drawString(Color color, Font font, int n, int n2, String string) {
        this.graphics.setFont(font);
        this.graphics.setColor(color);
        this.graphics.drawString(string, n, n2);
    }

    public void scrollUp(Color color, Font font, int n, int n2) {
        int n3 = this.getFontHeight(font);
        this.graphics.copyArea(0, n + n3, this.getWidth(), n2 - n3, 0, -n3);
        this.graphics.setColor(color);
        this.graphics.fillRect(0, n + n2 - n3, this.getWidth(), n3 + 1);
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.graphics.setClip(n, n2, n3, n4);
    }

    public void drawImage(BufferedImage bufferedImage, int n, int n2) {
        this.graphics.drawImage(bufferedImage, n, n2, this.observer);
    }
}

