/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.vm;

import java.util.HashMap;
import java.util.Map;
import org.zmpp.base.MemoryAccess;
import org.zmpp.encoding.ZCharDecoder;
import org.zmpp.vm.ObjectTree;
import org.zmpp.vm.ZObject;

public abstract class AbstractObjectTree
implements ObjectTree {
    private Map<Integer, ZObject> objectCache = new HashMap<Integer, ZObject>();
    private boolean illegalAccessReported;
    private MemoryAccess memaccess;
    private int address;
    private ZCharDecoder decoder;

    public AbstractObjectTree(MemoryAccess memoryAccess, int n, ZCharDecoder zCharDecoder) {
        this.memaccess = memoryAccess;
        this.address = n;
        this.decoder = zCharDecoder;
    }

    protected MemoryAccess getMemoryAccess() {
        return this.memaccess;
    }

    protected int getAddress() {
        return this.address;
    }

    protected ZCharDecoder getDecoder() {
        return this.decoder;
    }

    public short getPropertyDefault(int n) {
        int n2 = n - 1;
        return this.memaccess.readShort(this.address + n2 * 2);
    }

    public ZObject getObject(int n) {
        if (n > 0) {
            Integer n2 = n;
            ZObject zObject = this.objectCache.get(n2);
            if (zObject == null) {
                zObject = this.createObject(n);
                this.objectCache.put(n2, zObject);
            }
            return zObject;
        }
        if (!this.illegalAccessReported) {
            System.err.println("invalid access to object 0");
            this.illegalAccessReported = true;
        }
        return null;
    }

    protected abstract ZObject createObject(int var1);

    public int getNumObjects() {
        return (this.getObject(1).getPropertyTableAddress() - this.getObjectTreeStart()) / this.getObjectEntrySize();
    }

    public void removeObject(int n) {
        ZObject zObject = this.getObject(n);
        ZObject zObject2 = this.getObject(zObject.getParent());
        zObject.setParent(0);
        if (zObject2 != null) {
            if (zObject2.getChild() == n) {
                zObject2.setChild(zObject.getSibling());
            } else {
                ZObject zObject3 = this.getObject(zObject2.getChild());
                int n2 = zObject3.getSibling();
                while (n2 != 0 && n2 != n) {
                    zObject3 = this.getObject(n2);
                    n2 = zObject3.getSibling();
                }
                if (n2 == n) {
                    zObject3.setSibling(zObject.getSibling());
                }
            }
        }
        zObject.setSibling(0);
    }

    public void insertObject(int n, int n2) {
        ZObject zObject = this.getObject(n);
        ZObject zObject2 = this.getObject(n2);
        if (zObject2.getParent() > 0) {
            this.removeObject(n2);
        }
        int n3 = zObject.getChild();
        zObject2.setParent(n);
        zObject.setChild(n2);
        zObject2.setSibling(n3);
    }

    protected abstract int getPropertyDefaultsSize();

    protected int getObjectTreeStart() {
        return this.getAddress() + this.getPropertyDefaultsSize();
    }

    protected abstract int getObjectEntrySize();
}

