#charset "us-ascii"

/*
 *   Copyright (c) 2002 by Joao Mendes.
 *   ericlocs.t: Eric's Gift locations.
 */

#include <adv3.h>
#include <en_us.h>

plaza: OutdoorRoom
    'Turill Plaza'
    "One of the focal points of the city, this plaza is dominated by the old
     clock tower, with its giant 3D advertising board. Streets flow out of here
     in just about every direction. Above, the full moon shines."

    noGoText = 'You shouldn\'t go home just yet. Not without finding if that
                woman is the one you have been looking for.'

    cannotGoThatWay()
    {
        reportFailure(noGoText);
    }
;

+ LocVoc
    'turill plaza/street*streets'
    'Turill Plaza'

    isProperName = true;
;

+ Decoration
    'advertising advertisement ad clock tower/board*ads'
    'clock tower'
    "The clock tower stands in the middle of the plaza. People still call it
     that, although the old clock was replaced by a giant electronic 3D
     advertisement board a long time ago."
;

+ Decoration
    'full moon light/moon/moonlight'
    'moon'
    "The moon is shining its pale blue light on the plaza."
;

+ Decoration
    'buildings'
    'buildings'
    "They are ordinary city dwellings and office premises."
;

diner: Room
    'Sal\'s Diner'
    "Sal's Diner is just about the only open place near Turill plaza at this
     hour of night. Not the best synthcaf in town, but decent stuff. You are
     sitting at a corner table, with a cup of synthcaf in your hands."
;

+ LocVoc
    'sal sal\'s diner'
    'Sal\'s Diner'

    isProperName = true;
;


+ Decoration
    'full moon light/moon/moonlight/window'
    'moon'
    "Through the window, you see the moon shining its pale blue light on the
     street outside."

    dobjFor(LookThrough) asDobjFor(Examine)
;

+ Decoration, Actor
    'sal'
    'Sal'
    "Sal is your typical diner operator. A night owl, he takes care of business
     at night, leaving the heavier day work to his employees."

    actorHereDesc = "Sal is behind the counter, washing and wiping cups."
    isProperName = true
    isHim = true
;

+ Decoration
    'corner table'
    'table'
    "This is a discreet table in the back corner of Sal's Diner. It is rather
     clean, as is the rest of the diner."
;

+ theBench: Chair, Decoration
    'bench'
    'bench at the corner table'
    "It is a simple, unimposing bench."
;

+ theCoffee: Fixed
    'coffee synthcaf cup'
    'synthcaf'
    "Synthetic Caffeine Beverage, synthcaf for short, is just about the most
     popular drink in town, these days."

    dobjFor(Take)
    {
        verify()
        {
            illogical('You don\'t want to take Sal\'s cup home with you.');
        }
    }

    tasteDesc = "The synthcaf is delightful. Sal was at his best on this one."
    isTasted = nil
    dobjFor(Drink) asDobjFor(Taste)
    dobjFor(Taste)
    {
        verify() {}
        action()
        {
            inherited();
            isTasted = true;
            if ( isSmelt )
                coffeeFlashback();
            else
                " And the aroma is simply delicious.";
        }
    }

    smellPresence = true
    isSmellListedInRoom = true
    smellHereDesc = "A delicious aroma is steaming up from your cup."
    smellDesc = "Slowly, you take in the bittersweet aroma."
    isSmelt = nil
    dobjFor(Smell)
    {
        precond = [touchObj]
        action()
        {
            inherited();
            isSmelt = true;
            if ( isTasted )
                coffeeFlashback();
            else
                " You can't wait to taste it.";
        }
    }

    beforeAction()
    {
        inherited();
        if ( gAction.ofKind(StandAction) || gAction.ofKind(TravelAction) ||
             gAction.ofKind(GetOutOfAction) || gAction.ofKind(GetOffOfAction) )
        {
            reportFailure('You don\'t want to get up just yet. After all, this
                           is what you have been going out for, for the past
                           four years.');
            exit;
        }
    }
;

/******************************************************************************/

apartment: Room
    'Your Apartment'
    "This is a single room home, complete with auto-cook, self-making bed and
     tri-di set. All the comforts of modern living."

    out = outgo

    noGoText = 'Your apartment is much too small for that.'

    cannotGoThatWay()
    {
        reportFailure(noGoText);
    }
;

+ LocVoc
    'my apartment/room'
    'Your apartment'

    isProperName = true;
;

+ Decoration
    'auto cook/auto-cook'
    'auto-cook'
    "It is a modern state-of-the-art appliance, capable of configuring every
     synthetic food known to man. Completely adequate to your needs."
;

+ Bed, Decoration
    'self making self-making bed'
    'self-making bed'
    "It is a comfortable bed, complete with self-renewing pressostatic sheets
     and adjustable hardness mattress. You've slept many a restful night here."
;

+ Decoration
    'tri di tri-di television set/tv'
    'tri-di set'
    "It is a standard plasma field generator, with a one-thousand channel
     tuner, full octaphonic surround sound and built-in aroma driver.
     Unfortunately, there is nothing on but old re-runs."
;

outgo: TravelMessage
    ->street
    "Grabbing your outdoorwear, you decide to go out for a walk to clear your
     mind. This is as good a time as any to think about a couple of jingles
     you have been working on, to try and see how they might sound."
;

street: OutdoorRoom
    'Out in the Street'
    "You are out in the streets of Eppin. It is windy this time of year, but
     still, people come and go all about. They carry out their own lives,
     some tranquil, some hurried, all in all ignoring you."

    in = nogoin

    noGoText = 'You wander aimlessly amid the streets, only to end up where you
                begun. Echoes of possible melodies fizzle through your head.'

    cannotGoThatWay()
    {
        reportFailure(noGoText);
    }
;

+ LocVoc
    'out street of in street/eppin*streets'
    'streets'

    isPlural = true;
;

+ Decoration
    'full moon light/moon/moonlight'
    'moon'
    "The moon isn't out tonight."
;

+ Decoration
    'urban person/dwellers/people/crowd'
    'crowd'
    "These are urban dwellers, going on about their business. Even though you
     have lived in this neighborhood for quite some time, none of them look at
     all familiar."
;

+ Decoration
    'buildings'
    'buildings'
    "They are ordinary city dwellings and office premises."
;

nogoin: TravelMessage
    ->apartment
    "You return to your apartment, disappointed in yourself for not being
     able to come up with any new tunes. And there is still nothing to do here."
;

theHat: Wearable
    'hat'
    'hat'
    "It is your hat. Your friend JB gave you this hat, long ago, when you
     were still in college."

    everWorn = nil
    dobjFor(Wear)
    {
        action()
        {
            inherited();
            if ( everWorn )
                return;
            everWorn = true;
            hatFlashback();
        }
    }
    dobjFor(Take)
    {
        verify()
        {
            if ( location == rack )
                illogicalNow('You won\'t need that again until you are ready to
                              leave.');
        }
        action()
        {
            mainReport('You are now holding your hat.');
            inherited();
        }
    }
;

/******************************************************************************/

streetJB: OutdoorRoom
    'Frennig Street'
    "JB's building overlooks the river, in a wide and cheerful street
     dominated by the Kemstone building. As you come up to JB's own building,
     you can't help but recall what this street used to look like, before all
     the new construction took place..."

    in = goingup
    up = goingup

    noGoText = 'Hey, you came this far, you might as well go up and say hello.'

    cannotGoThatWay()
    {
        reportFailure(noGoText);
    }
;

+ LocVoc
    'frennig street*streets'
    'Frennig Street'

    isProperName = true;
;

+ Decoration
    'full moon light/moon/moonlight'
    'moon'
    "The moon isn't out tonight."
;

+ Decoration
    'river'
    'West River'
    "The West River runs its majestic if polluted course amid the city streets.
     It once had a different name, you recall, and it used to be cleaner, or
     so your parents said."
;

+ kemstoneBuilding: Enterable, Decoration
    ->gointokemstone
    'kemstone electronics headquarters building*buildings'
    'Kemstone Building'

    isExxed = nil
    desc()
    {
        "This huge building, the new headquarters for Kemstone Electronics
         Corporation, dominates the whole street. What a shame it was to tear
         down the old Museum of Arts and Sciences to build this.";
        if ( !isExxed )
        {
            isExxed = true;
            if ( jbBuilding.isExxed )
                "\bBut enough reminiscing. That is all in the past.";
        }
    }
;

+ jbBuilding: Enterable, Decoration
    ->goingup
    'jb\'s where jb lives building*buildings'
    'building where JB lives'

    isExxed = nil
    desc()
    {
        "JB's building is a standard apartment building, overlooking the
         river. It was built on the site of an old Victorian three-story house
         that actually stood here for over three hundred years.";
        if ( !isExxed )
        {
            isExxed = true;
            if ( kemstoneBuilding.isExxed )
                "\bBut enough reminiscing. That is all in the past.";
        }
    }
;

gointokemstone: NoTravelMessage
    "The Kemstone Electronics Headquarters is closed at this hour."
;

goingup: TravelMessage
    ->hallway
    "Cursing progress, civilization, chewing gum and baseball cards, you go up
     to greet JB."

    canTravelerPass(traveler)
    {
        if ( jbBuilding.isExxed && kemstoneBuilding.isExxed )
            return inherited(traveler);
        return nil;
    }
    explainTravelBarrier(traveler)
    {
        if ( jbBuilding.isExxed && kemstoneBuilding.isExxed )
        {
            inherited(traveler);
            return;
        }
        reportFailure('As you prepare to go up to greet JB, you hesitate,
                       recalling old images of the very street you are
                       standing on. You\'ve never really taken the time to
                       see what has changed...');
    }
;

hallway: Room
    'Out in the Hallway'
    "You are standing outside JB's apartment door, to the east. This is an
     unimposing hallway, complete with stairs going up and down and another
     door leading into the elevator to the south. Other apartments stand to
     the north and west."

    up = leavingJB
    down = leavingJB
    south = leavingJB
    north = unknown
    west = unknown
    east = doorJB
;

+ LocVoc
    'hallway'
    'hallway'
;

+ doorJB: Door
    'north jb door'
    'door to JB\'s apartment'
    "It leads into JB's apartment."

    everKnocked = nil
    dobjFor(KnockOn)
    {
        action()
        {
            inherited();
            if ( everKnocked )
                return;
            everKnocked = true;
            knockOnDoor();
        }
    }

    dobjFor(Open)
    {
        verify()
        {
            illogical('JB is your buddy, but you should still knock.');
        }
    }
;

leavingJB: NoTravelMessage
    travelDesc = "<<noGoDesc>>"
    noGoDesc = 'Hey, you came this far. Might as well knock and say hello.'

    isConnectorApparent(origin, actor)
    {
        return true;
    }
;

unknown: NoTravelMessage
    travelDesc = "<<noGoDesc>>"
    noGoDesc = 'You don\'t know those people. Best to leave them alone.'

    isConnectorApparent(origin, actor)
    {
        return true;
    }
;

forcePastWoman: NoTravelMessage
    "The woman is standing in your way."

    isConnectorApparent(origin, actor)
    {
        return true;
    }
;

/******************************************************************************/

living: Room
    'Living Room'
    "<<hereDesc>> The furniture is discreet but comfortable, and the walls are
     lined with jet paintings. Off in the corner, a coat rack supports a
     number of garments<<rack.doConts>>."

    hereDesc = 'You are in the living room of what used to be JB\'s
                apartment. The new owners certainly seem to have more taste
                than he did.'

    noGoText = 'You have no desire to go wandering through the rest of the
                house uninvited.'

    cannotGoThatWay()
    {
        reportFailure(noGoText);
    }
;

+ LocVoc
    'living room'
    'living room'
;

+ rack: Surface, Decoration
    'coat rack/coatrack/hanger/coathanger'
    'coat rack'
    "It is a coat rack, supporting a number of garments<<doConts>>."

    showObjectContents(pov, lister, options, indent, infoList) {}
    examineSurfaceContents() {}

    doConts
    {
        if ( theHat.location == self || theCoat.location == self )
            ", including your ";
        if ( theCoat.location == self )
        {
            "coat";
            if ( theHat.location == self )
                " and ";
        }
        if ( theHat.location == self )
            "hat";
    }
;

++ Fixed
    'outdoorwear/garments'
    'outdoorwear'
    "Just assorted outdoorwear of no consequence."
;

+ Decoration
    'furniture'
    'furniture'
    "The furniture is discreet but comfortable. It includes a wide sofa,
     seating three, an armchair and two smaller chairs. On the south wall, a
     large bookcase is void of literature, sporting instead a rather large
     number of curious oddities and decorative items. On the north wall, there
     is a fake fireplace."
;

+ sofa: Chair, Decoration
    'wide large comfortable sofa'
    'large sofa'
    "It is a large comfortable-looking sofa, easily seating three people. "

    bulkCapacity = 30;
;

+ Chair, Decoration
    'arm chair/armchair'
    'armchair'
    "It is an enterily unremarkable armchair."
;

+ Chair, Decoration
    'first smaller small chair*chairs'
    'first chair'
    "It is a small, yet comfortable chair."
;

+ Chair, Decoration
    'second smaller small chair*chairs'
    'second chair'
    "It is a small, yet comfortable chair."
;

+ Decoration
    'large simple south book case/bookcase'
    'large bookcase'
    "It is a simple bookcase, sporting a rather large number of curious
     oddities and decorative items."

    isPlural = true
;

++ Decoration
    'decorative oddities/items'
    'decorative items'
    "These are a number of decorative items, expertly distributed throughout
     the bookcase. The effect is quite quaint."
;

+ Decoration
    'fake fireplace'
    'fireplace'
    "It is a make-believe fireplace. All too common in these days, but still
     quite effective, decoration-wise."
;

+ Decoration
    'jet paintings'
    'paintings'
    "The jet paintings are actually quite good. The style is what art critics
     still call hyper-realism, which is fortunate, since that's the only kind
     of painting you can understand at all. Yet the scenes aren't what you
     would expect from modern jet-painters. These are everyday city scenes,
     some humorous, some quite tragic, others yet entirely trivial.\bOne giant
     panel above the fireplace strikes you particularly."

    isPlural = true
;

+ panel: Decoration
    'large giant panel/painting'
    'giant panel'
    "The panel depicts a couple of old buildings ablaze, in a quiet suburban
     street. Outdoors, a figure can be seen, calmly walking away from the
     fire. There is no sense of panic, or even fear, about this person, only a
     tranquil, unresisted grief. The painting is exquisitely detailed."
;

++ panelBuildings: Decoration
    'burning buildings/fire'
    'buildings in the panel'
    "<<doDesc()>>"

    isPlural = true

    isEnding = nil
    doDesc
    {
        if ( isEnding )
            endVisit();
        else
            "The burning buildings are quite old. They look somewhat familiar,
             but you can't quite place them.";
            setExxed();
    }

    isExxed = nil
    setExxed()
    {
        if ( !isExxed && cappellaEarly.history.indexOf(cappellaTopic) )
            new Fuse(self, &myFuse, 1);
        isExxed = true;
    }
    myFuse()
    {
        enterEric();
    }
;

++ Decoration
    'figure/person'
    'figure in the panel'
    "The figure is simply walking from the fire, in a resigned manner."
;

theCoat: Wearable
    'coat'
    'coat'
    "This is your coat. It is remarkably featureless."

    dobjFor(Take)
    {
        verify()
        {
            if ( location == rack )
            {
                illogicalNow('You won\'t need that again until you are ready to
                              leave.');
            }
        }
    }
;

study: Room
    'Study'
    "This is a rather modern jet-painter's studio, complete with all the
     typical tools and implements. In the middle of the room, a canvas is
     assembled, displaying a half-finished painting."

    noGoText = 'You have no desire to go wandering through the rest of the
                house uninvited.'

    cannotGoThatWay()
    {
        reportFailure(noGoText);
    }
;

+ LocVoc
    'study'
    'study'
;

+ thePortrait: Decoration
    'canvas/painting/portrait/picture/work'
    'painting'
    "<<seePainting()>>"
;

dining: Room
    'Dining Room'
    "The Chandlers turned JB's cluttered storage room into an amiable dining
     room. Four sturdy and comfortable chairs surround a round table, on which
     dinner has been served. The walls in this room are also lined with
     paintings."
;

+ LocVoc
    'dining room'
    'dining room'
;

+ Decoration
    'jet paintings'
    'paintings'
    "The jet paintings are as good if not better than the ones in the living
     room. Yet the scenes are also much the same. Everyday city scenes, some
     humurous, some quite tragic, others yet entirely trivial.<<doLargest()>>"

    isPlural = true

    doLargest()
    {
        if ( thePainting.location == location )
            "\bCappella pointed at a large panel as she told her story.";
    }
;

+ chairs: Chair, Decoration
    'chair*chairs'
    'chairs'
    "The chairs are sturdy and comfortable."

    actorInName = 'at the table'
    bulkCapacity = 40
;

+ Decoration, Fixed
    'dining round table'
    'dining table'
    "It is an entirely unremarkle table, on which dinner has been served."
;

++ theDinner: Fixed
    'fried orange dinner/food/turkey/synthurkey/meal/rice/orange/slices'
    'dinner'
    "The dinner consists of grilled synthurkey with fried rice and orange
     slices, served with red wine. It smells delicious."

    dobjFor(Take)
    {
        verify()
        {
            illogical('You can\'t possibly just pick up all of the food.');
        }
    }

    tasteDesc = tasteFood()

    canEnd = nil
    dobjFor(Eat) asDobjFor(Taste)
    dobjFor(Taste)
    {
        verify() {}
        action
        {
            inherited();

            if ( canEnd )
                endDinner();
        }
    }

    smellPresence = true
    isSmellListedInRoom = true
    smellHereDesc = "The food smells simply delicious."
    smellDesc = "The aroma steaming up from the food whets your appetite."
    dobjFor(Smell)
    {
        precond = [touchObj]
    }

    beforeAction()
    {
        inherited();
        if ( gAction.ofKind(StandAction) || gAction.ofKind(TravelAction) )
        {
            reportFailure('You don\'t want to get up just yet. Dinner isn\'t
                           over and it would be rude.');
            exit;
        }
    }
;

++ Fixed
    'red wine'
    'wine'
    "The wine glints with a bold ruby color."

    dobjFor(Take)
    {
        verify()
        {
            illogical('That\'s for drinking, not for taking.');
        }
    }

    dobjFor(Drink) asDobjFor(Taste)
    dobjFor(Taste)
    {
        verify() {}
    }
    tasteDesc = "The wine has a bold, almost fruity taste and leaves the most
                 subtle of aftertastes. Although strong, it combines impeccably
                 with dinner."

    smellPresence = true
    smellDesc = "The wine has a subtle and suggestive bouquet."
    dobjFor(Smell)
    {
        precond = [touchObj]
    }
;

thePainting: Decoration
    'large largest painting'
    'large painting'
    "It is a painting of two cars that bumped into each other. The two drivers
     are outside, arguing violently. There is a woman inside each car. In the
     background, there is a statue of Li Yang Po, the guy who managed to
     revive communism in East China, about fourteen years ago. He hung on for
     about two years, then was thrown down by the military. The statue no
     longer exists. Still, the scene has a rather humorous touch to it."
;

+ Decoration
    'man/woman/person/figure/driver*men*women*people*figures*drivers'
    'people in the painting'
    "One of the drivers is clearly Eric, and one of the women looks like
     Cappella. The other two aren't familiar."

    isPlural = true
;

+ Decoration
    'rental car*cars'
    'cars in the painting'
    "They are entirely unremarkable cars."

    isPlural = true
;

+ Decoration
    'statue/li/yang/po'
    'statue of Li Yang Po'
    "The actual statue was torn down over ten years ago, but from what you
     recall, it looked exactly like the one in the painting."
;
