/*
;	MOIST SOURCE CODE V1.06
;	Copyright (c) 1996, 1999 Scarlet Herring (scarlet_herring@yahoo.com).
;
;	THIS SOURCE CODE IS MEANT FOR STUDYING PURPOSES ONLY. YOU ARE NOT 
;	ALLOWED TO CHANGE THE GAME AND RELEASE YOUR OWN VERSION OF IT.
;
;	Since this file is part of an adult text adventure, you are not
;	allowed to use it if you are underaged, and if you are easily
;	offended, you also best leave it alone.
;
;	Please read the enclosed READSRC.TXT for general comments.
*/

/*	MOIST.T
;	
;	This file contains the main Moist source code, and this is the file
;	that needs to be compiled. Any version of TADS from 2.2.0 upwards should
;	work.
*/

#include <advd.t>
#include <stdd.t>
#include <fanny.t>
#include <kim.t>
#include <ilsa.t>
#include <morghana.t>
#include <statue.t>

lighterDaemon: function;
earthquakeDaemon: function;
excitementDaemon: function;
batteryDaemon: function;
lubeDaemon: function;
glitterDaemon: function;
encrypt: function;
randomhint: function;

version: object
    sdesc = "*** MOIST [1.06] ***"
    tadsversion =
    {
        "Compiled with TADS "; say( __TADS_VERSION_MAJOR ); ".";
        say( __TADS_VERSION_MINOR ); ", "; say( __DATE__ ); ", ";
        say( __TIME__ );
    }
;

instructions: object
    sdesc = "\"Moist\" is a typical text adventure, and you play
        it just like you would play any other text adventure. It is made
        with the Text Adventure Development System (TADS), a tool created by
        Michael J.\ Roberts. I recommend this tool heartily to anyone who
        wants to build complex text adventure games. It took me about a week
        to program this game with TADS, and you will find the game is quite
        sophisticated. Incidently, Michael is in no way responsible for
        the contents of this game.\n
        The game screen consists of a status line and a field wherein text
        is shown. The status line gives you the name of the room you are in, and
        at the right side your score and the number of moves you've played.\n
        You play the game by giving commands. The game describes your
        situation, and when the prompt '>' appears, you may type in the
        command you want to give. The commands are plain english, and may
        consist of several words.\n
        If the game cannot show all the text it wants to show, you will
        see '[More]' on the last line. Press the space bar to see a new
        page, or press enter to see one more line of text.\n
        To move around in the game, you use directions. The
        possible directions are 'n' for north, 'e' for east, 's' for south,
        'w' for west, 'u' for up and 'd' for down (it is possible to use, for
        instance, 'ne' for north-east, but I've limited this game to just
        six directions, to make it easier to map it).\n
        Most commands have two words, a verb and a noun. For
        instance, if you see a blue book lying somewhere, you would enter
        'take book' to get it. Also possible are 'get book', 'take the
        blue book' and lots of other ways you may think of to phrase your
        command.\nSometimes commands need to be more complex. For instance,
        if you want to place the book in a cupboard, the shortest way to give
        the command would be 'put book in cupboard'. Of course, you might
        also give the same command in a more elaborate way, like 'put the
        blue book in the wooden cupboard'.\nThe most common commands to be
        used with objects in the game are 'get', 'drop' and 'examine' (which
        can be abbreviated to 'x'). Some
        objects can be read with the command 'read'. If you suspect an object
        to hide something else, you might try to 'search' it. An object that
        could be a lightsource, might be turned on with the command
        'light' (or 'turn on', if you like) and can be turned off again
        with 'extinguish' (or just 'turn off'). If you want to
        execute
        a command on all the visible objects in a room, you can use the
        noun 'all'. For instance 'get all' would try to take all the
        takeable objects in the room, and 'open all' would try to open all
        objects.\nSome commands are
        given as just one word. The most important of these are 'inventory'
        (or 'i', for short)
        to see everything you are carrying, 'save' to save your game,
        'restore' to restore an earlier saved game, 'quit' to leave the
        game and 'undo' to undo the previous move ('undo' works several levels
        deep). If you want to repeat the last command, type 'again' or 'g'.
        If you want to look around in a room, type 'look' or 'l'. If you
        want to do nothing, type 'wait' or 'z'. If you want a complete
        report of your actions, give the command 'script'. You can end
        script-mode with the command 'unscript'.\n
        There are several other persons in the game. If you want them
        to do something, you can ask them to do it by typing their name,
        followed by a comma, followed by the command; for instance, you
        would type 'Petra, get the blue book' if you want Petra to take the
        blue book.\n
        If the game doesn't understand a word
        you've typed, it will say so. If you typed the word correctly, you
        should rephrase your command. If you made an error in your typing,
        you just have to type 'oops' followed by the correct word. The
        game will now execute the command with the new word inserted for
        the wrong one.\n
        If you get really stuck, you might ask for a hint about some
        object. For instance, if you don't know how to tackle Petra,
        you might give the command 'hint Petra', while you're in the
        same room as Petra. Repeating this command
        may give other hints. I must warn you that
        there's not much adventuring fun if you just ask for all the hints.
        To discourage the use of hints, they are encrypted. Every letter
        is replaced by the next letter in the alphabet, while the Z
        becomes an A. For instance, the hints show the word BOOK as CPPL.
        Beware, not all hints are useful.\n
        It is impossible to die in this adventure. It is, however, very
        well possible to manoeuvre yourself into a situation from where
        it is not possible any more to solve the adventure. The 'undo'
        command may help you in such a case, and it is, of course, wise to
        save the game often.\n
        Happy adventuring! ";
;

init: function
{
    initSearch();
    randomize();
    "\bYou are spending your holiday in a nudist colony, and you started
    out on a small hike this morning, dressed in your holiday outfit. You are
    wandering through dark woods. Lost in thought, you lost your way.
    There is no one around to ask directions, and you begin to wonder
    if you'll find your way out of the woods by yourself. Then you
    get to a small clearing between the trees. It seems to be a
    picknick spot, so you guess you're not that far from civilization.\b";
    version.sdesc;
    "\bA Scarlet Herring Erotic Text Adventure Game. ";
    "\bWARNING: This game contains scenes of an explicit sexual nature.
    If you're underaged, easily offended or just don't care for this
    kind of game, PLEASE QUIT NOW. Second warning: It's normally mostly
    males who play games like these, and I've not prepared the game for
    a female lead. Also, the game is entirely heterosexual. I'm sorry if
    you wished it to be different.\b";
    "This game is freeware. You may copy and distribute it freely, under the
    strict condition that no fee is charged, except to cover the
    distribution costs. The copyrights remain with Scarlet Herring
    (scarlet_herring@yahoo.com).\b";
    "If you need instructions, just give the command \"instructions\".\b";
    setdaemon( turncount, nil );
    setdaemon( lighterDaemon, nil );
    setdaemon( earthquakeDaemon, nil );
    setdaemon( fannymoveDaemon, nil );
    setdaemon( excitementDaemon, nil );
    setdaemon( fannyexcitementDaemon, nil );
    setdaemon( kimexcitementDaemon, nil );
    setdaemon( morgexcitementDaemon, nil );
    setdaemon( batteryDaemon, nil );
    setdaemon( lubeDaemon, nil );
    setdaemon( ilsaexcitementDaemon, nil );
    setdaemon( ilsameetDaemon, nil );
    setdaemon( glitterDaemon, nil );
    Me.location := startroom;
    startroom.lookAround( true );
    startroom.isseen := true;
    global.color := rand( 4 );
    global.face := rand( 4 );
}

/*
;	Handles the glittering on the chandelier.
*/
glitterDaemon: function( parm )
{
    local r;
    if  (Me.location = dining_room and diamond.location = nil)
    {
        ++global.glitter;
        if  (global.glitter = 3)
        {
            "\n\t";
            r := rand( 10 );
            if  (r < 4)
                "A sparkle on one of the chandeliers catches your eye. ";
            else if  (r < 7)
                "A bright flash from one of the chandeliers hits your eye. ";
            else
                "You imagine you see something glittering on one of the
                chandeliers. ";
            global.glitter := 0;
        }
    }
}

/*
;	Handles the extinguishing of the lighter.
*/
lighterDaemon: function( parm )
{
    if  (lighter.islit)
    {
        lighter.stuff -= 1;
        if  (lighter.stuff <= 0)
        {
            if  (lighter.location = Me.location or
                lighter.location = Me)
                "\n\tThe lighter suddenly goes out. ";
            lighter.islit := nil;
        }
    }
}

/*
;	Handles the running down of the battery.
*/
batteryDaemon: function( parm )
{
    if  (vibrator.activated)
    {
        battery.stuff -= 1;
        if  (battery.stuff <= 0)
        {
            if  (vibrator.location = Me.location or
                vibrator.location = Me)
                "\n\tThe vibrator suddenly stops buzzing. ";
            else if
                (
                (Me.location = Fanny.location and
                (vibrator.location = fanny_ass or
                vibrator.location = fanny_pussy)) or
                (Me.location = Morghana.location and
                (vibrator.location = morg_ass or
                vibrator.location = morg_pussy)) or
                (Me.location = grotesque_statue.location and
                (vibrator.location = statue_ass or
                vibrator.location = statue_pussy)) or
                (Me.location = Kim.location and
                (vibrator.location = kim_ass or
                vibrator.location = kim_pussy)) or
                (Me.location = Ilsa.location and
                (vibrator.location = ilsa_ass or
                vibrator.location = ilsa_pussy))
                )
            {
                "\n\tThe vibrator inserted in "; vibrator.location.thedesc;
                " suddenly stops buzzing. ";
            }
            vibrator.activated := nil;
        }
    }
    else if  (toothbrush.activated)
    {
        battery.stuff -= 1;
        if  (battery.stuff <= 0)
        {
            if  (toothbrush.location = Me.location or
                toothbrush.location = Me)
                "\n\tThe toothbrush suddenly stops its movements. ";
            toothbrush.activated := nil;
        }
    }
    if  (battery.stuff = 10 and (vibrator.activated or toothbrush.activated))
    {
        "\n\t(Here follows a gentle warning from the game creator:
        The battery is running out. It can be used for just 10 more moves.) ";
    }
}

/*
;	Handles the drying of the lubrication fluid. Note that this would have been
;	far better handled with a fuse or a notification.
*/
lubeDaemon: function( parm )
{
    if  (fanny_ass.lubricated)
    {
        fanny_ass.lubetime -= 1;
        if  (fanny_ass.lubetime <= 0)
        {
            fanny_ass.lubricated := nil;
            if  (Fanny.location = Me.location)
                "\n\tThe jelly seems to have dried up on Fanny's ass now. ";
        }
    }
    if  (morg_ass.lubricated)
    {
        morg_ass.lubetime -= 1;
        if  (morg_ass.lubetime <= 0)
        {
            morg_ass.lubricated := nil;
            if  (Morghana.location = Me.location)
                "\n\tThe jelly seems to have dried up on Morghana's ass now. ";
        }
    }
    if  (kim_ass.lubricated)
    {
        kim_ass.lubetime -= 1;
        if  (kim_ass.lubetime <= 0)
        {
            kim_ass.lubricated := nil;
            if  (Kim.location = Me.location)
                "\n\tThe jelly seems to have dried up on Kim's ass now. ";
        }
    }
    if  (ilsa_ass.lubricated)
    {
        ilsa_ass.lubetime -= 1;
        if  (ilsa_ass.lubetime <= 0)
        {
            ilsa_ass.lubricated := nil;
            if  (Ilsa.location = Me.location)
                "\n\tThe jelly seems to have dried up on Ilsa's ass now. ";
        }
    }
    if  (dick.lubricated)
    {
        dick.lubetime -= 1;
        if  (dick.lubetime <= 0)
        {
            dick.lubricated := nil;
            "\n\tThe jelly seems to have dried up on your dick now. ";
        }
    }
    if  (vibrator.lubricated)
    {
        vibrator.lubetime -= 1;
        if  (vibrator.lubetime <= 0)
        {
            vibrator.lubricated := nil;
            if  (vibrator.location = Me.location or
                 vibrator.location = Me)
                "\n\tThe jelly seems to have dried up on the vibrator now. ";
            else if
                (
                (vibrator.location = fanny_ass and
                Fanny.location = Me.location) or
                (vibrator.location = kim_ass and
                Kim.location = Me.location) or
                (vibrator.location = morg_ass and
                Morghana.location = Me.location) or
                (vibrator.location = ilsa_ass and
                Ilsa.location = Me.location)
                )
            {
                "\n\tThe jelly has washed off the vibrator now, but it
                is already snugly encased in "; vibrator.location.thedesc;
                ". ";
            }
            else if
                (
                (vibrator.location = fanny_pussy and
                Fanny.location = Me.location) or
                (vibrator.location = morg_pussy and
                Morghana.location = Me.location) or
                (vibrator.location = kim_pussy and
                Kim.location = Me.location) or
                (vibrator.location = ilsa_pussy and
                Ilsa.location = Me.location)
                )
            {
                "\n\t"; caps(); vibrator.location.thedesc;
                " juices have washed the
                lubrication from the vibrator by now. ";
            }
            else if  ((vibrator.location = statue_ass or
                vibrator.location = statue_pussy) and
                grotesque_statue.location = Me.location)
            {
                "\n\tThe jelly on the vibrator in the statue has dried up by
                now. ";
            }
        }
    }
    if  (dildo.lubricated)
    {
        dildo.lubetime -= 1;
        if  (dildo.lubetime <= 0)
        {
            dildo.lubricated := nil;
            if  (dildo.location = Me.location or
                 dildo.location = Me)
                "\n\tThe jelly seems to have dried up on the dildo now. ";
            else if
                (
                (dildo.location = fanny_ass and
                Fanny.location = Me.location) or
                (dildo.location = morg_ass and
                Morghana.location = Me.location) or
                (dildo.location = kim_ass and
                Kim.location = Me.location) or
                (dildo.location = ilsa_ass and
                Ilsa.location = Me.location)
                )
            {
                "\n\tThe jelly has washed off the dildo now, but it
                is already firmly encased in "; dildo.location.thedesc;
                ". It may be a bit more difficult to get it out now. ";
            }
            else if
                (
                (dildo.location = fanny_pussy and
                Fanny.location = Me.location) or
                (dildo.location = morg_pussy and
                Morghana.location = Me.location) or
                (dildo.location = kim_pussy and
                Kim.location = Me.location) or
                (dildo.location = ilsa_pussy and
                Ilsa.location = Me.location)
                )
            {
                "\n\t"; caps(); dildo.location.thedesc;
                " juices have washed the jelly
                from the dildo now, and her cunt lips keep it firmly in
                place. ";
            }
            else if  ((dildo.location = statue_pussy or
                dildo.location = statue_ass) and
                grotesque_statue.location = Me.location)
                "\n\tThe jelly on the dildo inserted in the statue has
                dried up. ";
        }
    }
}

/*
;	Handles the earthquake. A fuse would have been the ideal solution here,
;	but what did I know.
*/
earthquakeDaemon: function( parm )
{
    if  (global.earthquake > 0)
        global.earthquake -= 1;
    if  (global.earthquake = 1)
    {
        "\n\tSuddenly the ground shakes under your feet. It's an earthquake!
        You hear rocks falling. Luckily it lasts only a few seconds. ";
        if  (Me.location = startroom or Me.location = cave_entrance)
            "Unluckily, the rock face has crumbled and the crack is now
            filled with rubble, blocking the way in and out of the caves. ";
        else
        {
            cave_entrance.isseen := nil;
            startroom.isseen := nil;
        }
        rubble.moveInto( startroom );
        rubble2.moveInto( cave_entrance );
    }
}

/*
;	The player's excitement development.
*/
excitementDaemon: function( parm )
{
    if  (Me.excitement > 0)
        Me.excitement -= 1;
    if  (Me.excitement < 0)
        Me.excitement += 1;
    if  (Me.excitement_needed > 40)
        Me.excitement_needed -= 1;
}

/*
;	The rooms.
*/
startroom: room
    sdesc = "Picknick Spot"
    east = woods
    west =
    {
        if  (global.earthquake <= 1)
        {
            "The entrance is blocked by rubble. ";
            return( nil );
        }
        else
            return( cave_entrance );
    }
    ldesc =
    {
        "You're in a clearing in the middle of dense woods.
        This looks like a nice place to have a picknick. ";
        if  (global.earthquake <= 1)
            "A crack in the rock face to your west is filled with rubble,
            blocking the way into the caves. The only exit is to the
            east, where you can enter the woods. ";
        else
            "The west side of the area is a rock face.
            The rock is cracked, and behind the crack a passageway
            is revealed leading into darkness. You could enter the
            rock through the crack. To the east you can enter the woods. ";
        "There is a large picknick table in the middle of the clearing. ";
    }
;

cave_entrance: room
    sdesc = "Cave Entrance"
    east =
    {
        if  (global.earthquake <= 1)
        {
            "The exit is blocked by rubble. ";
            return( nil );
        }
        else
            return( startroom );
    }
    west = t_junction
    ldesc =
    {
        "You are at the entrance of a dark cave, which you entered
        through a crack to the east. A dark passage leads west. ";
        if  (global.earthquake <= 1)
            "The crack is filled with rubble, blocking the way out of
            the caves. Some light still penetrates the room through
            the small portion of the crack that's still open. ";
    }
;

t_junction: room
    sdesc = "T-Junction"
    east = cave_entrance
    north = sloping_passage
    south = narrow_passage
    ldesc =
        "You are at the west end of a passageway through which you
        entered the caves. A sloping hallway leads north, and a
        narrow passage goes south. This place is still lit from
        the east, but the north and south passages look dark and
        foreboding. "
;

narrow_passage: darkroom
    sdesc = "Narrow Passage"
    north = t_junction
    south = large_grotto
    ldesc =
        "This narrow passage comes from the north and continues to the
        south. ";
;

large_grotto: darkroom
    sdesc = "Large Grotto"
    north = narrow_passage
    west = wooden_door
    east = tunnel
    ldesc =
        "You enter a large grotto. Its walls are quite smooth, and an
        artist from possibly centuries ago has painted lively scenes
        on the walls. Some of the scenes make you blush a little.
        There seems to have been a large entrance to the grotto in the
        south wall, but it has collapsed long ago. A narrow passage leads
        north, and a tunnel east. There is also an exit through a wooden door
        to the west. Next to the door you see a small sign. "
;

tunnel: darkroom
    sdesc = "Tunnel"
    west = large_grotto
    south = dead_end
    ldesc =
        "This is a dark tunnel, coming from a grotto to the west, and
        bending towards the south. "
;

dead_end: darkroom
    sdesc = "Dead End"
    north = tunnel
    ldesc =
        "You are in a small cave at the end of the tunnel extending to the
        north. There is a small, round pool of water here, about seven feet
        across and two feet deep. "
;

sloping_passage: darkroom
    sdesc = "Sloping Passage"
    south = t_junction
    north = end_of_passage
    ldesc =
        "This passage slopes upwards from the south to the north. "
;

servants_entrance: darkroom
    sdesc = "Servant's Entrance"
    east = wooden_door2
    west = east_wing
    ldesc =
        "This is a narrow, dark hallway that is meant to be used as a
        servant's entrance. The walls are solid rock. To the east is a
        wooden door. The other exit is west. "
;

end_of_passage: darkroom
    sdesc = "End of Passage"
    south = sloping_passage
    ldesc =
        "You've reached the end of the passage. There is a bronze plaque
        fastened on the wall, with lettering on it. ";
;

east_wing: darkroom
    sdesc = "East Wing"
    east = servants_entrance
    west = dining_room
    south = se_corner
    north = ne_corner
    npc_west = true
    npc_north = true
    npc_south = true
    ldesc =
        "You are standing in a large hallway, hewn out of solid rock.
        It runs from the north to the south. You can also use the
        servant's entrance to the east, or enter a large room through
        a doorway to the west. "
;

west_wing: darkroom
    sdesc = "West Wing"
    east = dining_room
    west = kitchen
    south = sw_corner
    north = nw_corner
    npc_west = true
    npc_north = true
    npc_south = true
    npc_east = true
    ldesc =
        "You are standing in a large hallway, hewn out of solid rock.
        It runs from the north to the south. You can enter a large room
        through a doorway to the east. You spot a kitchen to the west. "
;

kitchen: darkroom
    sdesc = "Kitchen"
    east = west_wing
    west = rusty_door
    npc_east = true
    ldesc =
        "This is the castle's kitchen. Normal kitchen utensils are
        scattered all over the place, there are cupboards along the wall,
        a large oven, a gas cooker, a refrigerator and a sink. High on
        the wall in a corner is a brass bell. A door
        with a rusty handle leads to a closet to the west. "
;

closet: darkroom
    sdesc = "Closet"
    east = rusty_door2
    ldesc =
        "This closet is normally in use for the storing of food. There
        is one shelf against the wall. "
;

dining_room: room
    sdesc = "Dining Room"
    east = east_wing
    west = west_wing
    npc_east = true
    npc_west = true
    ldesc =
        "This is the dining room. It's a long hall, with a doorway in
        both the east and the west walls. A long table stands in the middle
        of the hall. Chairs surround the table. The hall is lit by large
        chandeliers hanging high from the ceiling. "
;

guest_quarters: darkroom
    sdesc = "Guest Quarters"
    west = se_corner
    npc_west = true
    ldesc =
        "The guest quarters are furnished sparingly. There is a simple
        bed with a sheet on it, a closet and a sink. The walls are bare.
        You don't feel guests are very welcome here. "
;

se_corner: darkroom
    sdesc = "South-East Corner"
    east = guest_quarters
    west = south_wing
    south = library
    north = east_wing
    npc_north = true
    npc_west = true
    npc_east = true
    ldesc =
        "You are at the corner of the east and the south wing.
        You can enter the two wings to the north and west. There is
        also a doorway leading to guest quarters to the east, and
        the library lies to the south. "
;

sw_corner: darkroom
    sdesc = "South-West Corner"
    east = south_wing
    west = restroom
    south = games_room
    north = west_wing
    npc_north = true
    npc_east = true
    ldesc =
        "You are at the corner of the west and the south wing.
        You can enter the two wings to the north and east. There is
        also a doorway leading to a restroom to the west, and
        the games room lies to the south. "
;

nw_corner: room
    sdesc = "North-West Corner"
    east = north_wing
    south = west_wing
    up = nw_tower
    down = torture_chamber
    npc_south = true
    npc_east = true
    ldesc =
        "You are at the corner of the west and the north wing.
        You can enter the two wings to the south and east. A
        spiralling staircase leads up into the north-west tower,
        and down into a dark and foreboding cellar. There is some
        light coming from above. "
;

torture_chamber: room
    sdesc = "Torture Chamber"
    up = nw_corner
    down = oubliette
    north = celldoor
    ldesc =
    {
        "You are in a grim and sinister looking torture chamber. The room
        is lighted by torches which are placed in iron grips along
        the walls. There is a rack in the middle of the room, and
        all kinds of devices are placed on a bench against the wall.
        A hole in the floor leads down to a dark oubliette, and to the north
        there is a cell door. ";
        if  (rope.location = rack)
            "A rope is tied to the rack and dangles down into the
            oubliette. ";
    }
;

oubliette: darkroom
    points = 1
    sdesc = "Oubliette"
    up =
    {
        if  (oubliette_rope.location <> self)
        {
            "There is no way out. ";
            return( nil );
        }
        else
        {
            Me.moveInto( torture_chamber );
            "You climb up to the torture chamber. ";
            return( nil );
        }
    }
    ldesc =
    {
        "You are at the bottom of a deep, dark oubliette. There is no way
        out except for the opening high above your head, way out of your
        reach. ";
        if  (rope.location = rack)
            "There is a rope dangling down from the opening above. ";
        incscore( self.points );
        self.points := 0;
    }
;

cell: room
    sdesc = "Cell"
    south = celldoor2
    ldesc =
        "In this bare cell prisoners are kept awaiting their punishments
        in the torture chamber to the south. "
;

nw_tower: room
    sdesc = "North-West Tower"
    north = ilsa_room
    west = fanny_room
    south = kim_room
    down = nw_corner
    ldesc =
        "You are standing at the top of the north-west tower. There are
        three doors here, leading to the north, west and south. There
        are small windows in the wall, which let light filter into the
        tower. A spiral staircase leads down. "
;

ilsa_room: room
    sdesc = "Ilsa's Room"
    south = nw_tower
    ldesc =
        "This is the chamber of Ilsa, the guard. It's decoration is quite
        spartan. There is a large chest here, and an uncomfortable looking
        bed, which is covered with white sheets. Ilsa's vanity shows by
        the large mirror in one corner, in front of a set of weights. "
;

fanny_room: room
    sdesc = "Fanny's Room"
    east = nw_tower
    ldesc =
        "This is the chamber of Fanny, the maid. Fanny is obviously the
        'girly' type. Most of the room is painted pink. She has a soft bed,
        with lots of pillows on it, a make-up table with a large,
        golden-rimmed mirror, a large, standing chest and a small nightstand
        with one drawer.
        The make-up table is littered with bottles, combs and lipsticks. "
;

kim_room: room
    sdesc = "Kim's Room"
    north = nw_tower
    ldesc =
        "This is the chamber of Kim, the secretary. Kim seems to be some
        kind of very efficient business woman. The room is sparingly
        decorated, but still feminine in a subtle way. The bed is made
        with clean, silk sheets. The table in front of her mirror
        contains a few make-up items. There is also a nightstand with
        one drawer next to the bed, and a cabinet against the wall. "
;

ne_corner: room
    sdesc = "North-East Corner"
    south = east_wing
    west = north_wing
    up = ne_tower
    down = cellar_entrance
    npc_south = true
    npc_west = true
    ldesc =
        "You are at the corner of the east and the north wing.
        You can enter the two wings to the south and west. A
        spiralling staircase leads up into the north-east tower,
        and down into a dark cellar. There is some light coming from above. "
;

ne_tower: room
    sdesc = "North-East Tower"
    north = bedroom_door
    east = living_room
    south = bathroom
    down = ne_corner
    ldesc =
        "You are standing at the top of the north-east tower. There are
        three rooms here, to the north, east and south. There
        are small windows in the wall, which let light filter into the
        tower. A spiral staircase leads down. The entrance to the room
        to the north is through a firm door. "
;

bathroom: room
    sdesc = "Bathroom"
    north = ne_tower
    ldesc =
        "This is a really luxurious bathroom. The marble bath is immense,
        the walls a floors are covered with smooth, marble tiles, and a
        beautiful mirror is fastened above a sink made of pink marble. "
;

living_room: room
    sdesc = "Living Room"
    west = ne_tower
    ldesc =
        "You are in a cosy livingroom, furnished with very comfortable
        looking chairs around a low table. There is a hand-made carpet
        on the floor, and a cupboard against the wall. "
;

bedroom: room
    sdesc = "Bedroom"
    south = bedroom_door2
    points = 1
    ldesc =
    {
        incscore( self.points );
        self.points := 0;
        "You have entered queen Morghana's bedroom. The room is almost
        totally filled up with a huge bed standing in the middle. The
        bed is covered with sheets weaved from gold threads. The bed is
        topped with a ceiling made from dark cloth, fastened to four
        high bedposts. In one corner, a cord hangs down from the ceiling.
        There is a door leading south out of the room. ";
    }
;

cellar_entrance: room
    sdesc = "Entrance to Wine Cellar"
    up = ne_corner
    north = iron_gate
    ldesc =
        "You are at the entrance to the wine cellar. The wines are kept cool
        in a cellar to the north, behind an iron gate. Next to the gate
        is a plastic statue of a woman of grotesque, almost cartoon-like
        proportions. "
;

wine_cellar: room
    sdesc = "Wine Cellar"
    south = iron_gate2
    ldesc =
        "You are standing in a damp, cool and musky wine cellar. Bottles
        of wine are kept at constant temperatures in niches in the walls. "
;

south_wing: darkroom
    sdesc = "South Wing"
    east = se_corner
    west = sw_corner
    south = gallery
    npc_west = true
    npc_east = true
    ldesc =
        "You are in the south wing. You can exit to the east and
        west, or enter the gallery south. "
;

north_wing: room
    sdesc = "North Wing"
    east = ne_corner
    west = nw_corner
    north = entrance_hall
    npc_west = true
    npc_east = true
    ldesc =
        "You are in the north wing. You can exit to the east and
        west. A large doorway leads north to the entrance hall,
        from where some light filters into this room. "
;

entrance_hall: room
    sdesc = "Entrance Hall"
    north = gates
    south = north_wing
    ldesc =
        "This is the large and quite astounding entrance hall. Obviously
        it has been designed to impress the guests to the castle. The
        hallway stretches from the south to the north, and to both sides
        huge marble pillars are erected, plunging down into the ground, and
        penetrating the ceiling... (sorry, I got carried away a little there).
        Anyway, the impressive hallway ends at some very solid gates, which
        lead out of the castle. "
;

outside: room
    sdesc = "Outside the Castle"
    south = gates2
    west = horizon
    north = police
    east = police
    points = 1
    ldesc =
    {
        incscore( self.points );
        self.points := 0;
        "You are standing on a grassy hill, in front of the castle. You
        can see how the facade of the castle is built against a large
        rock, and you see the forest lying behind it. Before
        the castle, lush, green fields stretch out towards the horizon.
        You can walk west to finish the game.
        There is a pedestal here, with some writing on it. ";
    }
;

horizon: room
    sdesc = "Horizon"
    ldesc =
    {
        "As an old western hero, you walk into the setting sun.\b";
        scoreRank();
        "\b";
        terminate();
	    quit();
        abort;
    }
;

// This was suggested by my first playtester.
police: room
    sdesc = "Indecent Exposure"
    ldesc =
    {
        "You decided to forego the romantic ending, where you walk
        away into the setting sun, but run straight into the arms
        of a police officer who is fully dressed, just like most
        people are around here. Remember, the nudist colony's
        area stretches only so far. I'm afraid you're now arrested
        for indecent exposure. Oh well, that's one way to finish
        the game.\b";
        scoreRank();
        "\b";
        terminate();
	    quit();
        abort;
    }
;

library: darkroom
    sdesc = "Library"
    north = se_corner
    ldesc =
        "You are standing in a large library. There are hundreds of books in
        bookcases here. Most of them seem to be erotic literature. "
;

gallery: darkroom
    sdesc = "Gallery"
    north = south_wing
    ldesc =
        "This is the gallery of the castle. Numerous statues and sculptures
        are placed in this room, and there are paintings on the walls. "
;

restroom: darkroom
    sdesc = "Restroom"
    east = sw_corner
    ldesc =
        "This is a very simple restroom, mostly used by servants. There
        is a simple shower and a toilet in one corner. "
;

games_room: room
    sdesc = "Games Room"
    north = sw_corner
    ldesc =
        "This is the games room. You maybe would have expected it to be
        suited for games of a kinky kind, but that is in fact not the
        case. There is a thick carpet on the floor, and game tables are
        placed in several locations. Most of them are covered with
        green cloth. Against one of the walls a desk is standing. "
;

/*
;	The woods were an experiment. I wanted to create an endless room, which still
;	could be traversed in an orderly fashion. It works, although, if you drop
; 	an object in one room, you'll spot it again in the next. Fairly useless
;	part of the game, this.
*/
woods: room
    sdesc = "Woods"
    dir_n = 0
    dir_e = 0
    north =
    {
        self.dir_n += 1;
        self.isseen := nil;
        return( self );
    }
    ne =
    {
        self.dir_n += 1;
        self.dir_e += 1;
        self.isseen := nil;
        return( self );
    }
    east =
    {
        self.dir_e += 1;
        self.isseen := nil;
        return( self );
    }
    se =
    {
        self.dir_n -= 1;
        self.dir_e += 1;
        self.isseen := nil;
        return( self );
    }
    south =
    {
        self.dir_n -= 1;
        self.isseen := nil;
        return( self );
    }
    sw =
    {
        self.dir_n -= 1;
        self.dir_e -= 1;
        self.isseen := nil;
        return( self );
    }
    west =
    {
        if  (self.dir_n = 0 and self.dir_e = 0)
            return( startroom );
        else
        {
            self.dir_e -= 1;
            self.isseen := nil;
            return( self );
       }
    }
    nw =
    {
        self.dir_n += 1;
        self.dir_e -= 1;
        self.isseen := nil;
        return( self );
    }
    ldesc =
    {
        "You are wandering in dark woods. ";
        if  (self.dir_n = 0 and self.dir_e = 0)
            "To the west you can make out a clearing. ";
    }
;

/*
;	The doorways.
*/
wooden_door: doorway
    noun = 'door'
    adjective = 'wooden'
    sdesc = "wooden door"
    noAutoOpen = true
    location = large_grotto
    ldesc =
    {
        "It's wooden door that is meant to be used as a servant's entrance.
        There is a sign next to it. ";
        if  (self.isopen)
            "The door is open. ";
        else
            "The door is closed. ";
    }
    otherside = wooden_door2
    doordest = servants_entrance
    verDoKnock( actor ) = {}
    doKnock( actor ) =
    {
        "You knock on the door. There is no answer. ";
    }
    doHint( actor ) =
    {
        switch (self.hint)
        {
            case 0:
                encrypt( 'Knock on the door. ' );
                break;
            case 1:
                encrypt( 'Nobody answers if you knock... ' );
                break;
            case 2:
                encrypt( 'You can just open the door. Ignore the sign. ' );
                break;
            default:
                randomhint();
                break;
        }
        ++self.hint;
        abort;
    }
;

wooden_door2: doorway
    noun = 'door'
    adjective = 'wooden'
    sdesc = "wooden door"
    noAutoOpen = true
    location = servants_entrance
    ldesc =
    {
        if  (self.isopen)
            "The door is open. ";
        else
            "The door is closed. ";
    }
    otherside = wooden_door
    doordest = large_grotto
    verDoKnock( actor ) = {}
    doKnock( actor ) =
    {
        "You knock on the door. There is no answer. ";
    }
;

rusty_door: doorway, lubeitem
    noun = 'door' 'handle'
    adjective = 'closet'
    sdesc = "closet door"
    noAutoOpen = true
    location = kitchen
    ldesc =
    {
        "The wooden door has a very rusty handle. ";
        if  (self.isopen)
            "The door is open. ";
        else if  (self.lubricated)
        {
            "The jelly on the handle makes it possible to open the door. ";
        }
        else
            "It is impossible to move the handle. ";
    }
    verDoOpen( actor ) =
    {
        if  (self.isopen)
            "It is already open. ";
        else if  (not ( self.lubricated ))
            "The handle is completely rusted shut. You cannot budge it. ";
    }
    doOpen( actor ) =
    {
        "The jelly on the handle makes it possible for you to open the
        closet door. ";
        self.isopen := true;
        if  (self.otherside)
            self.otherside.isopen := true;
    }
    otherside = rusty_door2
    doordest = closet
    verDoKnock( actor ) = {}
    doKnock( actor ) =
    {
        "You knock on the door. There seems to be nobody in the closet. ";
    }
    doHint( actor ) =
    {
        if  (self.lubricated)
        {
            encrypt( 'There is no need for a hint here anymore. ' );
            abort;
        }
        switch (self.hint)
        {
            case 0:
                encrypt( 'The handle is very rusty. Maybe you can open the door
                if you make the handle a bit more slippery. ' );
                break;
            case 1:
                encrypt( 'Have you got the tube out of the pool? ' );
                break;
            case 2:
                encrypt( 'Make sure you have the tube from the pool. Then
                lubricate the handle and open the door. ' );
                break;
            default:
                randomhint();
                break;
        }
        ++self.hint;
        abort;
    }
;

rusty_door2: doorway
    noun = 'door'
    adjective = 'closet'
    sdesc = "closet door"
    noAutoOpen = true
    location = closet
    otherside = rusty_door
    doordest = kitchen
    verDoKnock( actor ) = {}
    doKnock( actor ) =
    {
        "You knock on the door. This is useless. ";
    }
;

gates2: lockableDoorway
    noun = 'gates' 'gate' 'gateway' 'doors' 'door'
    adjective = 'solid'
    sdesc = "solid gateway"
    noAutoOpen = true
    mykey = gate_key
    location = outside
    ldesc =
    {
        "This is a very impressive, solid gateway, which leads into the
        castle. ";
        if  (self.isopen)
            "The gateway is open. ";
        else if  (self.islocked)
            "The gateway is locked. ";
        else
            "The gateway is closed. ";
    }
    otherside = gates
    doordest = entrance_hall
    verDoKnock( actor ) = {}
    doKnock( actor ) =
    {
        "You knock on the gates. They feel solid. ";
    }
;

iron_gate: doorway
    noun = 'door' 'gate'
    adjective = 'iron'
    sdesc = "iron gate"
    adesc = "an iron gate"
    noAutoOpen = true
    location = cellar_entrance
    ldesc =
    {
        "The gate is made out of iron. Behind it you can see the wine cellar. ";
        if  (self.isopen)
            "The gate is open. ";
        else
            "The gate is closed. ";
    }
    verDoOpen( actor ) =
    {
        if  (self.isopen)
            "It is already open. ";
        else
            "That's not the way to open the gate. ";
    }
    otherside = iron_gate2
    doordest = wine_cellar
    verDoKnock( actor ) = {}
    doKnock( actor ) =
    {
        "You knock on the gate. It won't budge. ";
    }
    doHint( actor ) =
    {
        if  (self.isopen)
        {
            encrypt( 'There is no need for a hint here anymore. ' );
            abort;
        }
        switch (self.hint)
        {
            case 0:
                encrypt( 'There is no ordinary key for this gate. The mechanism
                to open it is of a different kind. ' );
                break;
            case 1:
                encrypt( 'Ilsa knows how to open the gate. ' );
                break;
            case 2:
                encrypt( 'If you offer Ilsa a drink, she might give you a hint
                about the gate. ' );
                break;
            case 3:
                encrypt( 'You need to enter the right \"key\" in the right
                \"keyhole\". ' );
                break;
            case 4:
                encrypt( 'The \"keyhole\" is close to the gate. The servants
                leave the \"key\" normally close to the keyhole. ' );
                break;
            case 5:
                encrypt( 'The \"keyhole\" is found on the statue. ' );
                break;
            case 6:
                encrypt( 'One of the statue\'s orifices is the \"keyhole\". ' );
                break;
            case 7:
                encrypt( 'The dildo is the \"key\". ' );
                break;
            case 8:
                encrypt( 'The dildo should be pretty slippery to enter the
                right hole. ' );
                break;
            case 9:
                if  (jelly.location = pool)
                {
                    encrypt( 'First get the tube from the pool. ' );
                    --self.hint;
                }
                else
                    encrypt( 'Have you already got the tube from the pool? ' );
                break;
            case 10:
                encrypt( 'First lubricate the dildo. Then shove it up
                the statue\'s ass. ' );
                break;
            default:
                randomhint();
                break;
        }
        ++self.hint;
        abort;
    }
;

iron_gate2: doorway
    noun = 'door' 'gate'
    adjective = 'iron'
    sdesc = "iron gate"
    adesc = "an iron gate"
    noAutoOpen = true
    location = wine_cellar
    verDoOpen( actor ) =
    {
        "You cannot open the gate from this room. ";
    }
    verDoClose( actor ) =
    {
        "You cannot close the gate from this room. ";
    }
    otherside = iron_gate
    doordest = cellar_entrance
    verDoKnock( actor ) = {}
    doKnock( actor ) =
    {
        "You knock on the gate. Why? ";
    }
;

gates: lockableDoorway
    noun = 'gates' 'gate' 'gateway' 'doors' 'door'
    adjective = 'solid'
    sdesc = "solid gateway"
    noAutoOpen = true
    mykey = gate_key
    location = entrance_hall
    ldesc =
    {
        "This is a very impressive, solid gateway, which leads out of the
        castle. ";
        if  (self.isopen)
            "The gateway is open. ";
        else if  (self.islocked)
            "The gateway is locked. ";
        else
            "The gateway is closed. ";
    }
    otherside = gates2
    doordest = outside
    verDoKnock( actor ) = {}
    doKnock( actor ) =
    {
        "You knock on the gate. It feels solid. ";
    }
    doHint( actor ) =
    {
        if  (self.isopen)
        {
            encrypt( 'There is no need for a hint here anymore. ' );
            abort;
        }
        switch (self.hint)
        {
            case 0:
                encrypt( 'Have you read the plaque in the grotto where you
                found the torch? ' );
                break;
            case 1:
                encrypt( 'You can only open this gate with the right key. ' );
                break;
            case 2:
                encrypt( 'Queen Morghana has the key. She\'ll give it to you
                only after you\'ve satisfied her. ' );
                break;
            default:
                randomhint();
                break;
        }
        ++self.hint;
        abort;
    }
;

bedroom_door: lockableDoorway
    noun = 'door'
    adjective = 'firm'
    sdesc = "firm door"
    noAutoOpen = true
    mykey = bedroom_key
    location = ne_tower
    ldesc =
    {
        "There is a firm door here which leads to the bedroom. ";
        if  (self.isopen)
            "The door is open. ";
        else if  (self.islocked)
            "The door is locked. ";
        else
            "The door is closed. ";
    }
    otherside = bedroom_door2
    doordest = bedroom
    verDoKnock( actor ) = {}
    doKnock( actor ) =
    {
        "You knock on the door. ";
        if  (rope.location = Morghana)
            "Morghana, who can't move at the moment, doesn't come. ";
        else if  (Morghana.orgasms <= 0 and Morghana.excitement < 15)
        {
            "The door opens slightly. Queen Morghana looks through the
            opening at you. She looks at your face, and then her eyes sink
            down to your manhood. \"Humpf,\" she mumbles, and closes the
            door again. ";
        }
        else
        {
            "Morghana opens the door. \"Come in,\" she says. ";
            self.isopen := true;
            self.islocked := nil;
            self.otherside.isopen := true;
            self.otherside.islocked := nil;
        }
    }
    doHint( actor ) =
    {
        if  (not( self.islocked ))
        {
            encrypt( 'There is no need for a hint here anymore. ' );
            abort;
        }
        switch (self.hint)
        {
            case 0:
                encrypt( 'Maybe there\'s someone inside... ' );
                break;
            case 1:
                encrypt( 'Knock on the door. ' );
                break;
            case 2:
                encrypt( 'You can find the key to this door somewhere
                in the castle. ' );
                break;
            case 3:
                encrypt( 'It\'s the key you can win from Kim. ' );
                break;
            case 4:
                encrypt( 'You don\'t really need to open this door.
                It will open automatically when the right time arrives.
                Still, it can be fun to open it earlier. ' );
                break;
            default:
                randomhint();
                break;
        }
        ++self.hint;
        abort;
    }
;

bedroom_door2: lockableDoorway
    noun = 'door'
    adjective = 'firm'
    sdesc = "firm door"
    noAutoOpen = true
    mykey = bedroom_key
    location = bedroom
    ldesc =
    {
        "There is a firm door here which leads out of the bedroom. ";
        if  (self.isopen)
            "The door is open. ";
        else if  (self.islocked)
            "The door is locked. ";
        else
            "The door is closed. ";
    }
    otherside = bedroom_door
    doordest = ne_tower
    verDoKnock( actor ) = {}
    doKnock( actor ) =
    {
        "You knock on the door. But you are already inside. Silly sod. ";
    }
    verDoLockWith( actor, io ) =
    {
        "<<io.thedesc>> does not seem to fit the lock. ";
        if (io = bedroom_key)
        {
            "A bit strange, since it is the bedroom door key. It seems
            the lock on the inside requires another key than the lock on
            the outside. ";
        }
    }
;

celldoor: lockableDoorway
    noun = 'door'
    adjective = 'cell' 'metal'
    sdesc = "cell door"
    noAutoOpen = true
    mykey = cell_key
    location = torture_chamber
    ldesc =
    {
        "There is a metal door here which leads to a cell. ";
        if  (self.isopen)
            "The door is open. ";
        else if  (self.islocked)
            "The door is locked. ";
        else
            "The door is closed. ";
    }
    otherside = celldoor2
    doordest = cell
    verDoKnock( actor ) = {}
    doKnock( actor ) =
    {
        "You knock on the door. There is no answer. ";
    }
    doHint( actor ) =
    {
        if  (not( self.islocked ))
        {
            encrypt( 'There is no need for a hint here anymore. ' );
            abort;
        }
        switch (self.hint)
        {
            case 0:
                encrypt( 'It\'s the door to a cell. ' );
                break;
            case 1:
                encrypt( 'Most of the time, the jailkeeper holds the
                key to a cell door. ' );
                break;
            case 2:
                encrypt( 'Ilsa has the key hidden on her body. ' );
                break;
            case 3:
                encrypt( 'You can only get the key when Ilsa isn\'t able
                to defend herself. ' );
                break;
            case 4:
                encrypt( 'There is nothing interesting in the cell, so
                just forget it. ' );
                break;
            case 5:
                encrypt( 'If Ilsa is unconscious or disabled, you can search
                her boots to get the key. You don\'t need to enter the
                cell, however. ' );
                break;
            default:
                randomhint();
                break;
        }
        ++self.hint;
        abort;
    }
;

celldoor2: lockableDoorway
    noun = 'door'
    adjective = 'metal' 'cell'
    sdesc = "cell door"
    noAutoOpen = true
    mykey = cell_key
    location = cell
    ldesc =
    {
        "There is a metal door here which leads out of the cell. ";
        if  (self.isopen)
            "The door is open. ";
        else if  (self.islocked)
            "The door is locked. ";
        else
            "The door is closed. ";
    }
    otherside = celldoor
    doordest = torture_chamber
    verDoKnock( actor ) =
    {
        if  (self.isopen)
            "It's of no use to knock on an open door. ";
        else if  (not( self.islocked ))
            "You don't need to knock on the cell door. It is not locked. ";
    }
    doKnock( actor ) =
    {
        if  (Ilsa.drugged <= 0 and not( Ilsa.tied ))
        {
            local yesno;
            local wineobj;
            wineobj := nil;
            "You hear someone approach. A key clicks in the lock.
            Ilsa enters the cell, and asks, \"Is something the
            matter? Do you want to leave? I can imagine, but you should
            have thought of that before.\" She ponders for a few moments. ";
            if  (red_wine.location = Me and not( red_wine.drugged ))
                wineobj := red_wine;
            else if  (white_wine.location = Me and not( white_wine.drugged ))
                wineobj := white_wine;
            if  (wineobj <> nil)
            {
                "\"If you give me that "; wineobj.sdesc; ", I will let you
                go.\" she says. Do you give her the wine? (YES or NO) > ";
                yesno := yorn();
                "\b";
                if  (yesno <> 1)
                {
                    "\"Sorry, you won't get the wine.\" you say, defiantly. ";
                    "\"Okay,\" Ilsa says, \"Then rot in this cell.\"
                    She leaves, and closes the door behind her. ";
                    return;
                }
                "You hand Ilsa the bottle. She sets it to her lips, and
                gurgles it down. She then throws the bottle in a corner.
                She takes you by an arm, and leads you out of the cell,
                through the torture_chamber, and leaves you in the hallway. ";
                wineobj.moveInto( box );
                Me.moveInto( nw_corner );
                return;
            }
            "\"Maybe, if you proved to be a good boy...\" ";
            if  (ilsa_body.location = Ilsa)
                "She removes her leather body, and shows you her torso
                in all its naked glory. ";
            "Her voice becomes harsh. \"On your knees, punk!\" Do you obey?
            (YES or NO) > ";
            yesno := yorn();
            "\b";
            if  (yesno <> 1)
            {
                "\"I won't kneel for you!\" you say, defiantly. ";
                if  (ilsa_body.location = Ilsa)
                    "Ilsa puts her body back on. ";
                "\"Okay. If you wish to rot in this cell, I'll let you.\"
                She leaves, and closes the door behind her. ";
                return;
            }
            "You kneel before Ilsa. She takes a step forward, and positions
            her almost bald pussy before your face. \"Lick it! Lick it well!\"
            she says. Do you obey? (YES or NO) > ";
            yesno := yorn();
            "\b";
            if  (yesno <> 1)
            {
                "\"I won't lick that cunt of yours!\" you say, defiantly. ";
                if  (ilsa_body.location = Ilsa)
                    "Ilsa puts her body back on. ";
                "\"Okay. If you wish to rot in this cell, I'll let you.\"
                She leaves, and closes the door behind her. ";
                return;
            }
            Ilsa.excitement := Ilsa.excitement + 5;
            Me.excitement := Me.excitement + 3;
            "You push your head between her legs, and start licking her soft
            cuntlips. Your tongue runs over them, along the inside of her
            legs, and then you manage to move your tongue inside. You suck
            on her clit, while her juices wet your face. After some time,
            Ilsa pushes you away and turns around. She shows you her pink
            asshole. \"Now,\" she says. \"Lick me there.\" Do you lick her
            ass? (YES or NO) > ";
            yesno := yorn();
            "\b";
            if  (yesno <> 1)
            {
                "\"I won't lick your asshole!\" you say, defiantly. ";
                if  (ilsa_body.location = Ilsa)
                    "Ilsa puts her body back on. ";
                "\"Okay. If you wish to rot in this cell, I'll let you.\"
                She leaves, and closes the door behind her. ";
                return;
            }
            Ilsa.excitement := Ilsa.excitement + 5;
            Me.excitement := Me.excitement + 3;
            "You stick your tongue between her buttocks, and lick her ass.
            You go up and down in her crack, and push your tongue against
            the little hole. Ilsa breathes deeply. Then she gets up. ";
            if  (ilsa_body.location = Ilsa)
                "She puts her body back on. ";
            "\"Okay,\" she says. \"I've got enough of this. You may go, but
            don't disturb me or the queen again, or you'll be sorry.\"
            She leads you out of the cell, through the torture chamber, and
            leaves you standing in the hallway. ";
            Me.moveInto( nw_corner );
        }
    }
    doHint( actor ) =
    {
        if  (not( self.islocked ))
        {
            encrypt( 'There is no need for a hint here anymore. ' );
            abort;
        }
        switch (self.hint)
        {
            case 0:
                encrypt( 'Who do you think has the key to the cell door? ' );
                break;
            case 1:
                encrypt( 'Wouldn\'t you agree that the jailkeeper will be
                able to open the cell door? ' );
                break;
            case 2:
                encrypt( 'Since the cell door leads to the torture chamber,
                you might try to attract Ilsa\'s attention. ' );
                break;
            case 3:
                encrypt( 'To attract Ilsa\'s attention, just knock on the
                door. ' );
                break;
            default:
                randomhint();
                break;
        }
        ++self.hint;
        abort;
    }
;

/*
;	This is the main player's bodypart. There's a lot of code in here that would have
;	been far better implemented with the girls. But I didn't know how to accomplish
;	that at the time. 
*/
dick: fuckitem, lubeitem, lightsource
    weight = 0
    bulk = 0
    isListed = true
    sdesc = "dick"
    thedesc = "your penis"
    adesc = "your penis"
    noun = 'dick' 'penis' 'tool' 'cock' 'rod' 'shaft' 'prick' 'meat' 'whopper' 'sausage' 'willy' 'percy' 'dong' 'stiffy' 'pork'
    	// All these synonyms were suggested by the first playtester.
    adjective = 'my'
    location = Me
    ldesc =
    {
        if  (Me.excitement < 5)
            "Your penis is at the moment completely limp, and rests on
            your heavy, hairy balls. ";
        else if  (Me.excitement < 15)
            "Your penis is at the moment half erect. ";
        else if  (Me.excitement < 25)
            "Your penis is at the moment fully erect. It's a full
            7 inches long en is crowned with a purple, gleaming head. ";
        else if  (Me.excitement < Me.excitement_needed)
            "Your penis is in a state of tremendous arousal. It
            is very thick and it's coming to its maximum size of more
            than 7 inches long. The head is dark purple. ";
        else
            "Your penis is swollen to magnificent proportions. It's very
            thick, about 8 inches long and it is pulsating with the blood
            that fills its veins. The head is deep purple. It seems ready
            to explode. ";
        if  (self.lubricated)
            "Your rod is gleaming from lubrication fluid. ";
    }
    verDoFeel( actor ) =
    {
        if  (actor = Ilsa)
        {
            if  (Ilsa.drugged > 0)
                "The unconscious Ilsa won't touch anything. ";
            else
            {
                "\"OK,\" she says, grabs you member, and almost yanks it off
                your rump. You scream in pain. ";
                Me.excitement -= 10;
            }
        }
    }
    doFeel( actor ) =
    {
        caps(); "%you% touch%es% your dick. ";
        caps(); "%you% move%s% %your% hand a few times up and down the
            shaft. ";
        if  (self.lubricated)
            "The lubrication makes it slip in the palm of %your% hand. ";
        caps(); "%you% then take%s% the rod firmly in %your% hand, and
        move%s% it rapidly to and from, making the foreskin glide over the
        rim of the head. ";
        "With %your% other hand, %you% massage%s% your balls. ";
        caps(); "%your% thumb sometimes touches the head of your dick,
        sending shivers of pleasure up your spine. ";
        Me.excitement += 5;
        if  (actor <> Me)
            actor.excitement += 3;
        if  (Me.excitement > Me.excitement_needed)
        {
            Me.excitement_needed += 20;
            Me.orgasms += 1;
            Me.excitement := 0;
            caps(); "Your cock starts to swell in %your% hand. Your
            balls contract, and %your% hand moves very fast to get you
            to climax. There it comes! Your body stiffens, and huge
            wads of sperm sail through the air, splashing on the floor
            and on %your% hand. You relax a bit. ";
            if  (actor <> Me)
            {
                caps(); "%you% lick%s% %your% hand clean. ";
            }
            else
                "You wipe your hand on your thigh. It feels a bit sticky. ";
        }
    }
    verDoPutIn( actor, io ) =
    {
        "You should specify your action in more direct terms, for
        instance, \"fuck "; io.sdesc; "\". ";
    }
    verDoSuck( actor ) =
    {
        if  (actor = Me)
            "That would be quite a feat! ";
        else if  (actor = Fanny and Fanny.excitement < 5)
            "That's a little too kinky for her at this time. ";
        else if  (actor = Morghana and Morghana.excitement < 15)
            "She doesn't feel like it just now. ";
        else if  (actor = Ilsa)
            "Ilsa laughs menacingly. \"Sure! I'll suck your dick! Come
            over here!\" She grins, and shows you a row of very white,
            very sharp teeth. On second thoughts, this doesn't seem to
            be such a swell idea. ";
    }
    doSuck( actor ) =
    {
        if  (actor = Fanny)
        {
            if  (fanny_mouth.filled < global.turnsofar - 1)
            {
                "She sinks on her knees and licks the tip of your
                rod with her pink tongue. Then she takes the head completely
                in her mouth, and starts moving her head up and down the
                shaft of your cock. ";
                if  (Me.excitement < 17)
                {
                    "Your penis starts to grow. It gets bigger and bigger. ";
                    caps(); actor.thedesc; " has trouble reaching the root of
                    the shaft now. Your penis gets fully erect. ";
                    Me.excitement := 10;
                }
            }
            else
            {
                caps(); actor.thedesc; " continues blowing your member. She
                licks and sucks until your head starts spinning. ";
            }
            Me.excitement += 7;
            actor.excitement += 7;
            "She leaves the shaft for a moment and start licking your balls.
            She sucks them into her mouth one by one. She smiles up at you.
            Then she attacks your cock once more, and sucks it deep into
            her throat. Up and down she goes. Her saliva drips down the shaft.
            God, she's good! ";
            if  (actor.excitement > 15)
                "You can see this arouses her enormously. ";
            if  (Me.excitement > Me.excitement_needed)
            {
                Me.excitement := 0;
                "Then it gets too much for you. You feel the semen flowing
                through your tool, racing to the head, and you spurt it deep
                into her throat. ";
                caps(); actor.thedesc; " pulls her head back, and the second
                flow creams her face. She manages to catch the third and
                last flow in her mouth again. Your penis starts to become limp. ";
                caps(); actor.thedesc; " smiles at you. The cum drips from her
                face onto her beautiful chest. She licks some drops from the
                corner of her mouth, savouring the salty taste. She closes her
                eyes for a moment and sighs. ";
                if  (actor.excitement >= 15)
                    "\"Now it's my turn,\" she says. ";
                fanny_mouth.filled := -1;
                Me.excitement_needed += 20;
                Me.orgasms += 1;
                Fanny.face_semen := true;
                fanny_sperm.moveInto( Fanny );
            }
            else
                fanny_mouth.filled := global.turnsofar;
        }
        else if  (actor = Kim)
        {
            if  (kim_mouth.filled < global.turnsofar - 1)
            {
                "Kim motions towards the table, and you sit down on it.
                \"All right, boy,\" she says, \"I'm gonna suck you so
                hard you'll have to pluck the table cloth out of your ass
                when I'm finished with you.\"
                Kim takes your rod in her hand, strokes it a few times,
                and then bends over and takes it in her mouth. Her tongue
                dances like a snake around the tip of you cock. Her head
                bobs up and down, with her lips tightly around your shaft. ";
                if  (Me.excitement < 17)
                {
                    "She is an expert. Your cock becomes rock-hard. ";
                    Me.excitement := 17;
                }
            }
            else
            {
                "Kim keeps blowing your dick. Her expertise is phenomenal. ";
            }
            Me.excitement += 7;
            actor.excitement += 7;
            if  (rope.location <> Kim)
                "She massages your balls with her right hand, while her left
                hand holds on to your shaft, and moves up and down with
                her head. ";
            else
                "Restrained by the rope, she cannot use her hands to
                stimulate you even more, but still she's fantastic. ";
            "She sucks at your cock like a vacuum cleaner. She manages
            to take the whole length in her mouth, and you feel your
            cock entering her throat. ";
            if  (actor.excitement > 15)
                "Her fervour convinces you she enjoys this a lot. ";
            if  (Me.excitement > Me.excitement_needed)
            {
                Me.excitement := 0;
                "The tip of your cock swells in her mouth. She knows you
                are ready to get off. Teasingly, she pulls her head back,
                and look at your quivering tool. ";
                if  (rope.location <> Kim)
                    "With one hand she tickles your balls. ";
                "Her sharp tongue lashes out at the head of your cock,
                and runs quick circles around it. This is it! A small
                jet of pre-cum hits her tongue. ";
                if  (rope.location <> Kim)
                    "This is the sign she's been waiting for, and suddenly
                    she presses a thumb up your ass. You might have been shocked
                    by this, but not at this very moment. ";
                "Then you really get off, and you eject a long spurt of
                cum right across her face. Kim laughs, opens her mouth wide
                and catches the next two spurts there. She closes here mouth
                and presses her lips together. You see her swallowing your
                sperm, which makes you eject one last stream into her hair.
                Kim's eyes sparkle. ";
                kim_mouth.filled := -1;
                Me.excitement_needed += 20;
                Me.orgasms += 1;
                Kim.face_semen := true;
                kim_sperm.moveInto( Kim );
            }
            else
                kim_mouth.filled := global.turnsofar;
        }
        else if  (actor = Morghana)
        {
            if  (Morghana.excitement < 15 and Morghana.orgasms < 1)
                morghana_refuses();
            else if  (morg_mouth.filled < global.turnsofar - 1)
            {
                "Morghana bends over, and starts to suck your cock in a way
                you know she has been raised on lollipops. ";
                if  (Me.excitement < 17)
                {
                    "Your penis erects. ";
                    Me.excitement := 10;
                }
            }
            else
            {
                caps(); actor.thedesc; " continues blowing your member. ";
            }
            Me.excitement += 7;
            actor.excitement += 5;
            "She sucks the shaft deep into her throat, and even with her
            lips stretched around the root of your cock, she manages to
            drop her chin a little bit, stick her tongue out, and touch
            your balls with it. ";
            if  (Me.excitement > Me.excitement_needed)
            {
                Me.excitement := 0;
                "The royal blow is more than you can endure. You spurt
                your semen deep into her throat. She swallows. Twice. ";
                check_morghana_orgasm();
                morg_mouth.filled := -1;
                Me.excitement_needed += 20;
                Me.orgasms += 1;
                Morghana.face_semen := true;
                morg_sperm.moveInto( Morghana );
            }
            else
                morg_mouth.filled := global.turnsofar;
        }
    }
    verDoKiss( actor ) =
    {
        if  (actor = Me)
            "Auto-erotica can go too far. ";
    }
    verDoTurnon( actor ) =
    {
        if  (not( global.debugon ))
            "You cannot light your dick. ";
        else if  (self.islit )
            "It's already on! ";
    }
    // In debug-mode, you can go through the game without a torch simply
    // by lighting your dick.
    doTurnon( actor ) =
    {
        "In debug-mode, you light your dick. Isn't this amazing? ";
        self.islit := true;
    }
    verDoTurnoff( actor ) =
    {
        if  (not( global.debugon ))
            "You cannot turn off your dick. ";
        else if  (not self.islit)
            "It's not on. ";
    }
    doTurnoff( actor ) =
    {
        "You extinguish your dick. Isn't debug-mode fun? ";
        self.islit := nil;
    }
    doHint( actor ) =
    {
        if  (Me.excitement >= 15)
        {
            encrypt( 'There is no need for a hint here anymore. ' );
            abort;
        }
        encrypt( 'There are many ways to get a hard-on. Just arouse yourself. ' );
        abort;
    }
;

/*
;	The player's second bodypart.
*/
balls: fuckitem
    weight = 0
    bulk = 0
    isListed = true
    sdesc = "balls"
    thedesc = "your balls"
    adesc = "your balls"
    noun = 'balls' 'ball' 'scrotum' 'sack' 'nuts'
    adjective = 'my' 'hairy'
    location = Me
    ldesc =
        "Your balls are heavy and hairy. "
    verDoFeel( actor ) =
    {
        if  (actor = Ilsa)
        {
            if  (Ilsa.drugged > 0)
                "The unconscious Ilsa won't touch anything. ";
            else
            {
                "\"OK,\" she says, grabs you balls, and almost yanks them off
                your rump. You scream in pain. You're filled with nausea. ";
                Me.excitement -= 15;
            }
        }
    }
    doFeel( actor ) =
    {
        caps(); "%you% touch%es% your balls. ";
        caps(); "%you% cup%s% them in %your% hand, and massage%s% them a
            little. ";
        caps(); "%your% thumb sometimes touches the root of your dick,
        sending shivers of pleasure up your spine. ";
        Me.excitement += 5;
        if  (actor <> Me)
            actor.excitement += 3;
    }
    verDoPutIn( actor, io ) =
    {
        "Don't be silly! ";
    }
    verDoSuck( actor ) =
    {
        if  (actor = Me)
            "That would be quite a feat! ";
        else if  (actor = Fanny and Fanny.excitement < 5)
            "That's a little too kinky for her at this time. ";
        else if  (actor = Morghana and Morghana.excitement < 15)
            "She's not yet ready for that. ";
        else if  (actor = Ilsa)
            "Ilsa laughs menacingly. \"Sure! I'll suck your balls! Come
            over here!\" She grins, and shows you a row of very white,
            very sharp teeth. You think you rather keep your balls a
            little while longer. ";
    }
    doSuck( actor ) =
    {
        caps(); actor.thedesc; " puts her lips on your scrotum, and her
        tongue circles around it. She takes the individual balls in her
        mouth, one by one, and carefully stimulates them with her
        tongue and teeth. Then her tongue licks underneath, and even
        touches your asshole for a moment. ";
        Me.excitement += 4;
        actor.excitement += 3;
    }
    verDoKiss( actor ) =
    {
        if  (actor = Me)
            "Auto-erotica can go too far. ";
    }
;

/*
;	The game objects.
*/
battery: readable, betitem
    weight = 1
    bulk = 1
    stuff = 100
    max_stuff = 100
    location = toothbrush
    sdesc = "battery"
    noun = 'battery'
    ldesc =
        "A small battery battery with some text on it. "
    readdesc =
    {
        if  (self.stuff > 0)
        {
            "It says: This battery contains energy for ";
            say( self.stuff ); " more turn";
            if  (self.stuff <> 1)
                "s";
            ". ";
        }
        else
            "It says: This battery is empty. ";
    }
    verDoRecharge( actor ) =
    {
        if  (recharger.location <> Me)
            "You don't have a recharger. ";
    }
    doRecharge( actor ) =
    {
        "You recharge the battery. ";
        self.stuff := self.max_stuff;
    }
    doHint( actor ) =
    {
        switch (self.hint)
        {
            case 0:
                encrypt( 'The toothbrush isn\'t the only item that the
                battery is useful for. ' );
                break;
            case 1:
                encrypt( 'The battery can be used with some sex-toy. ' );
                break;
            case 2:
                if  (vibrator.location = teddy_bear)
                {
                    encrypt( 'There is a vibrator hidden somewhere... ' );
                    --self.hint;
                }
                else
                    encrypt( 'The battery fits in the vibrator. ' );
                break;
            case 3:
                encrypt( 'If the battery is empty, none of the objects
                which you use it for can be turned on anymore. ' );
                break;
            default:
                randomhint();
                break;
        }
        ++self.hint;
        abort;
    }
;

dildo: lubeitem, betitem
    weight = 3
    bulk = 1
    sdesc = "dildo"
    noun = 'dildo'
    location = grotesque_statue
    ldesc =
    {
        "This is a dildo of gargantuan proportions. It is at least
        12 inches long, and it is very thick, more than two inches
        in diameter. It has the shape of Goliath's penis. ";
        if  (self.lubricated)
            "The dildo is gleaming from lubrication fluid. ";
        if  (self.location = fanny_ass or self.location = fanny_pussy
            or self.location = kim_ass or self.location = kim_pussy
            or self.location = ilsa_ass or self.location = ilsa_pussy
            or self.location = morg_ass or self.location = morg_pussy
            or self.location = statue_ass or self.location = statue_pussy)
        {
            "A large part of the dildo is inserted in ";
            self.location.thedesc; ". ";
        }
    }
    verDoPush( actor ) =
    {
        if  (self.location <> fanny_ass and self.location <> fanny_pussy and
            self.location <> kim_ass and self.location <> kim_pussy and
            self.location <> ilsa_ass and self.location <> ilsa_pussy and
            self.location <> morg_ass and self.location <> morg_pussy and
            self.location <> statue_ass and self.location <> statue_pussy)
            "Pushing the dildo has no effect. ";
    }
    doPush( actor ) =
    {
        "You want to push the dildo a bit further up ";
        self.location.thedesc; ", but it's no use.
        It's as far in as it will go for now. ";
    }
    doHint( actor ) =
    {
        switch (self.hint)
        {
            case 0:
                encrypt( 'Come on! What would you use a dildo for? ' );
                break;
            case 1:
                encrypt( 'It\'s a sex-toy! Use it that way! ' );
                break;
            case 2:
                encrypt( 'Besides being a sex-toy, the dildo also
                has a second purpose... ' );
                break;
            default:
                randomhint();
                break;
        }
        ++self.hint;
        abort;
    }
;

bible: readable, betitem
    weight = 3
    bulk = 1
    sdesc = "bible"
    location = nightstand
    noun = 'book' 'bible'
    adjective = 'holy'
    ldesc =
    {
        "The presence of the bible in Fanny's room gives the impression
        that she's a very devout and righteous girl. ";
        if  (vibrator.location <> nil)
            "However, the fact that you've found a vibrator hidden in her
            room destroys that idea. ";
    }
    readdesc =
    {
    	// Copyright Monty Python, The Holy Grail.
        "Armaments 2:9-21:\nAnd St.Attila raised the hand grenade up on high,
        saying \"O Lord, bless this thy hand grenade, that with it thou mayest
        blow thine enemies to tiny bits, in thy mercy.\" And the Lord did grin,
        and the people did feast upon the lambs, and sloths, and carp, and
        anchovies, and orang-utans, and breakfast cereals, and fruit bats,
        and... (you skip a bit) ...and the Lord spake, saying, \"First shalt
        thou take out the Holy Pin, then shalt thou count to three, no more,
        no less. Three shall be the number thou shalt count, and the number
        of the counting shall be three. Four shalt thou not count, neither
        count thou two, excepting that thou then proceed to three. Five is
        right out. Once the number three, being the third number, be reached,
        then lobbest thou thy Holy Hand Grenade of Antioch towards thy foe,
        who, being naughty in my sight, shall snuff it.\n(Amen) ";
    }
    doHint( actor ) =
    {
        switch (self.hint)
        {
            case 0:
                encrypt( 'This is Fanny\'s bible. ' );
                break;
            case 1:
                encrypt( 'Does Fanny strike you as a religious girl? ' );
                break;
            case 2:
                encrypt( 'You might try to read the bible. ' );
                break;
            case 3:
                encrypt( 'It\'s just a bible. It hasn\'t got a use in the
                game. ' );
                break;
            default:
                randomhint();
                break;
        }
        ++self.hint;
        abort;
    }
;

rope: betitem
    weight = 2
    bulk = 2
    location = shelves
    sdesc = "white rope"
    noun = 'rope'
    adjective = 'white'
    ldesc =
    {
        "The rope is about 20 feet long. ";
        if  (self.location = Fanny)
            "Fanny is tied up with it. ";
        if  (self.location = Morghana)
            "Morghana is tied up with it. ";
        else if  (self.location = Kim)
            "Kim is tied up with it. ";
        else if  (self.location = rack)
            "The rope is tied to the rack and dangles down into the
            oubliette. ";
    }
    verIoTieWith( actor ) = {}
    ioTieWith( actor, dobj ) =
    {
        if  (dobj = Ilsa)
        {
            "It wouldn't be wise to tie Ilsa with the rope. She's so
            strong she would break out of it very soon, and then you
            wouldn't have a rope anymore. ";
        }
        else if  (dobj <> Fanny and dobj <> Kim and dobj <> Morghana)
        {
            "I don't know how to tie "; dobj.thedesc; " with the rope. ";
        }
        else if  (dobj = Fanny)
        {
            if  (Fanny.serving > 0)
            {
                "Fanny quickly evades your attack. ";
                return;
            }
            "You grab Fanny roughly, and you tie her hands behind her back. The
            remaining piece of the rope you use to tie her feet together. ";
            self.moveInto( Fanny );
            if  (Fanny.excitement >= 15)
                "Fanny winks at you. She likes it kinky. ";
            else
                "Fanny is now restrained and cannot stop you from doing with
                her whatever you like. ";
        }
        else if  (dobj = Kim)
        {
            if  (not( Kim.obedience ) or Kim.excitement < 5)
                "Kim jumps back, and makes a few lightning-quick kung-fu
                moves. You find yourself lying on the floor, with Kim
                looking at you triumphant, saying, \"Don't try that again.\" ";
            else
            {
                self.moveInto( Kim );
                "Kim likes your kinky idea, and lets herself be tied up by
                you. ";
            }
        }
        else if  (dobj = Morghana)
        {
            if  (Morghana.excitement < 15)
                "Morghana says, \"No! If you don't back off, I'll
                get you removed from here by force!\" You decide to drop the
                idea, at least for now. ";
            else
            {
                self.moveInto( Morghana );
                "Morghana feels attracted to a bit of kinky stuff.
                She submits herself to you, and you tie her down to the
                bed, using the bedposts to stretch her out. ";
            }
        }
    }
    verDoUntie( actor ) =
    {
        if  (rope.location <> Fanny and rope.location <> rack and
             rope.location <> Kim and rope.location <> Morghana)
            "The rope is not tied to anything. ";
    }
    doUntie( actor ) =
    {
        "You untie the rope and drop it on the floor. ";
        if  (rope.location = rack)
            oubliette_rope.moveInto( nil );
        self.moveInto( Me.location );
    }
    doHint( actor ) =
    {
        switch (self.hint)
        {
            case 0:
                encrypt( 'What would you do with a rope? ' );
                break;
            case 1:
                encrypt( 'You could tie it to something. ' );
                break;
            case 2:
                encrypt( 'You could tie someone up with it, if you would
                like to. ' );
                break;
            case 3:
                encrypt( 'If a girl doesn\'t like your avances, you could
                tie her up to force her. ' );
                break;
            case 4:
                encrypt( 'Besides using the rope in sex-play, you need
                it to solve some puzzle. ' );
                break;
            default:
                randomhint();
                break;
        }
        ++self.hint;
        abort;
    }
;

oubliette_rope: fixeditem
    location = nil
    sdesc = "dangling rope"
    noun = 'rope'
    adjective = 'dangling'
    ldesc =
    {
        "The rope is dangles down from the opening above your head. It is
        within your reach. ";
    }
    verDoClimb( actor ) = {}
    doClimb( actor ) =
    {
        "You climb out of the oubliette. ";
        Me.moveInto( torture_chamber );
    }
    verDoUntie( actor ) =
    {
        "The rope is tied at the other end. You cannot untie it from here. ";
    }
;

large_entrance: fixeditem
    location = large_grotto
    sdesc = "large entrance"
    noun = 'entrance'
    adjective = 'large'
    ldesc =
    {
        "The entrance has collapsed long ago. You won't be able to leave
        this way. ";
    }
;

potion: drinkable, betitem
    weight = 1
    bulk = 1
    location = living_cupboard
    sdesc = "pink flask"
    noun = 'flask' 'potion' 'liquid'
    points = 1
    adjective = 'pink'
    ldesc =
        "It's an intricate flask, which is filled with pink liquid. "
    verDoDrink( actor ) = {}
    doDrink( actor ) =
    {
        caps(); "%you% sniff%s% the flask, and then take%s% a sip. Suddenly
        %you% start%s% to feel very hot. Little pearls of transpiration
        appear on %your% forehead. ";
        caps(); "%you% lick%s% %your% lips, gulp%s% the flask down and
        throw%s% it away. ";
        self.moveInto( box );
        actor.excitement := 30;
        if  (actor = Me)
            "Your mind is being filled with images of hot bodies crawling
            all over each other, sweaty, oily and sticky people, grasping
            each other's arms, legs, breasts, buttocks and sexual organs,
            and all kinds of appendages filling every kind of hole. You
            need sex very urgently. ";
        else
            "She then approaches you with nothing but untamed lust in her
            eyes. ";
    }
    doPutIn( actor, io ) =
    {
        if  (io = milk)
        {
            "You manage to empty the flask into the milk. It mixes with
            the milk without leaving a trace. ";
            if  (milk.cooled)
                milk.cooled := nil;
            else
            {
                milk.drugged := true;
                incscore( self.points );
                self.points := 0;
            }
            self.moveInto( box );
        }
        else if  (io = mineral_water)
        {
            "You drop a bit from the flask in the mineral water. A chemical
            reaction starts! (obviously the wrong minerals.) The water is
            boiling, the plastic bottle heats up, melts, and the water seeps
            away in the floor. If you want to mix it, you need something else. ";
            io.moveInto( box );
        }
        else if  (io = red_wine or io = white_wine)
        {
            "You drop a bit from the flask in the wine. An eruption takes
            place in the bottle, and the wine spurts from the bottle like a
            tremendous ejaculation. It leaves the bottle empty. You throw
            the bottle away. If you want to mix it, you need something else
            (possibly without alcohol). ";
            io.moveInto( box );
        }
        else
        {
            self.moveInto( io );
            "Done. ";
        }
    }
    doHint( actor ) =
    {
        switch (self.hint)
        {
            case 0:
                encrypt( 'You could drink the potion to try it. But use \'undo\'
                afterwards. ' );
                break;
            case 1:
                encrypt( 'This is not just a quick way to arouse a girl. You
                do need the potion at some point in the game. ' );
                break;
            case 2:
                encrypt( 'Keep the potion until you\'re ready for the queen. ' );
                break;
            default:
                randomhint();
                break;
        }
        ++self.hint;
        abort;
    }
;

milk: drinkable, container
    drugged = nil
    weight = 1
    bulk = 1
    location = nil
    sdesc = "bottle of goat's milk"
    noun = 'milk' 'bottle'
    adjective = 'goat'
    ldesc =
        "It's a bottle of goat's milk. "
    verDoDrink( actor ) = {}
    doDrink( actor ) =
    {
        "%You% drink%s% the milk, and throw%s% the bottle away. ";
        if  (milk.cooled)
        {
            "%You% suddenly feel%s% icy cold. If there's one thing %you% %are%
            not interested in right now it's... it's... (God, I've
            even trouble writing it)... you know... thingy... the act of
            intercourse. ";
            if  (actor.excitement > -5)
                actor.excitement := -5;
        }
        else if  (milk.drugged)
        {
            "%You% start%s% to sweat. SEX %Your% mind SEX is suddenly SEX
            occupied with SEX sex. ";
            if  (actor.excitement < 30)
                actor.excitement := 30;
        }
        self.moveInto( nil );
        milk.drugged := nil;
        milk.cooled := nil;
    }
    doHint( actor ) =
    {
        if  (Morghana.orgasms >= 1)
        {
            encrypt( 'There is no need for a hint here anymore. ' );
            abort;
        }
        switch (self.hint)
        {
            case 0:
                encrypt( 'What can you do with milk? ' );
                break;
            case 1:
                encrypt( 'You can drink it. ' );
                break;
            case 2:
                encrypt( 'Have you tried following Fanny when she\'s running around
                with the milk? ' );
                break;
            case 3:
                encrypt( 'The milk is intended for Morghana. ' );
                break;
            case 4:
                if  (Fanny.orgasms < 1 or Kim.orgasms < 1 or
                    Ilsa.orgasms < 1)
                {
                    encrypt( 'Since you haven\'t satisfied the three servants at
                    this moment, just forget about the milk for now. ' );
                    --self.hint;
                }
                else
                    encrypt( 'You have already given the three servants their orgasms.
                    What comes next? ' );
                break;
            case 5:
                encrypt( 'Have you already tried to enter Morghana\'s bedroom? ' );
                break;
            case 6:
                encrypt( 'Have you already searched Morghana\'s living room? ' );
                break;
            case 7:
                encrypt( 'You might try to feed Morghana something via the milk. ' );
                break;
            case 8:
                encrypt( 'Empty the pink flask in the milk. Then wait until Morghana
                has drunk the milk. However, only do this if you\'re ready
                for Morghana, because the effect of the potion will wear off
                in a few moves. ' );
                break;
            default:
                randomhint();
                break;
        }
        ++self.hint;
        abort;
    }
;

cooloff_potion: drinkable, betitem
    weight = 1
    bulk = 1
    location = cupboard
    sdesc = "blue flask"
    noun = 'flask' 'potion' 'liquid'
    adjective = 'blue'
    ldesc =
        "It's an intricate flask, which is filled with blue liquid. "
    verDoDrink( actor ) = {}
    doDrink( actor ) =
    {
        caps(); "%you% sniff%s% the flask, and then gulp%s% it down. Suddenly
        %you% start%s% to feel very icy. ";
        caps(); "%you% throw%s% the flask away. ";
        self.moveInto( box );
        if  (actor.excitement > -5)
            actor.excitement := -5;
        if  (actor = Me)
            "Your mind is filled with images of tax papers, gardening
            programs, long runs and cold showers. ";
        else
            "She looks at you like an ice queen. ";
    }
    doPutIn( actor, io ) =
    {
        if  (io = milk)
        {
            "You manage to empty the flask into the milk. It mixes with
            the milk without leaving a trace. ";
            if  (milk.drugged)
                milk.drugged := nil;
            else
                milk.cooled := true;
            self.moveInto( box );
        }
        else if  (io = mineral_water)
        {
            "You drop a bit from the flask in the mineral water. A chemical
            reaction starts! (obviously the wrong minerals.) The water is
            freezes, the plastic bottle cracks and breaks. The block of ice
            falls on the ground and breaks in a thousand pieces. They melt in
            time, and seep away in the floor. If you want to mix it, you need
            something else. ";
            io.moveInto( box );
        }
        else if  (io = red_wine or io = white_wine)
        {
            "You drop a bit from the flask in the wine. Some kind of implosion
            takes place. Air is sucked into the bottle, and a hollow bang
            sounds. The bottle is empty. You throw it away. If you want to mix
            it, you need something else (possibly without alcohol). ";
            io.moveInto( box );
        }
        else
        {
            self.moveInto( io );
            "Done. ";
        }
    }
    doHint( actor ) =
    {
        switch (self.hint)
        {
            case 0:
                encrypt( 'Have you tried to drink the potion? ' );
                break;
            case 1:
                encrypt( 'The potion removes every feeling of lust you
                might have. ' );
                break;
            case 2:
                encrypt( 'The potion also works on girls. Just ask them
                to drink it. ' );
                break;
            case 3:
                encrypt( 'Why would you want to cool off a girl in a
                game like this? (This is a rethorical question - the
                potion is not useful in any puzzle). ' );
                break;
            default:
                randomhint();
                break;
        }
        ++self.hint;
        abort;
    }
;

pills: fooditem, betitem
    weight = 2
    bulk = 1
    location = kim_nightstanddrawer
    sdesc = "some pills"
    adesc = "some pills"
    thedesc = "some pills"
    noun = 'pills' 'pill'
    ldesc =
        "The pills are small and white. "
    doEat( actor ) =
    {
        "You eat a tiny bit one of the pills. You immediately feel very drowsy,
        and have to sit down to let the feeling pass. After a few minutes,
        you start to feel better. ";
    }
    doPutIn( actor, io ) =
    {
        if  (io = pool or io = mineral_water or io = milk)
            "If you want to put the pills in the liquid, you may do that,
            but I must tell you that they'll dissolve only in alcohol. ";
        else if  (io = red_wine or io = white_wine)
        {
            "You drop the pills in "; io.thedesc; ", and they immediately
            dissolve, leaving no trace. ";
            io.drugged := true;
            self.moveInto( box );
            return;
        }
        self.moveInto( io );
        "Done. ";
    }
    doHint( actor ) =
    {
        switch (self.hint)
        {
            case 0:
                encrypt( 'What can you do with pills? ' );
                break;
            case 1:
                encrypt( 'Eat them. ' );
                break;
            case 2:
                encrypt( 'They\'re sleeping pills. ' );
                break;
            case 3:
                encrypt( 'Is there someone who you might like to get asleep? ' );
                break;
            default:
                randomhint();
                break;
        }
        ++self.hint;
        abort;
    }
;

recharger: betitem
    weight = 1
    bulk = 1
    location = pedestal
    sdesc = "recharger"
    noun = 'recharger'
;

picknick_table: surface, fixeditem
    sdesc = "picknick table"
    noun = 'table'
    adjective = 'picknick'
    location = startroom
    ldesc =
        "It's a wooden table which is stained and damaged from
        long time use. "
;

torture_table: surface, fixeditem
    sdesc = "bench"
    noun = 'bench'
    location = torture_chamber
    ldesc =
        "The bench is strewn with sinister looking devices. "
;

game_table: surface, fixeditem
    sdesc = "table"
    noun = 'table'
    location = games_room
    ldesc =
        "The table is covered with a green cloth. ";
;

green_cloth: surface, fixeditem
    sdesc = "cloth"
    noun = 'cloth'
    adjective = 'green'
    location = game_table
    ldesc =
        "The green cloth covers the table. "
;

nightstand: surface, fixeditem
    sdesc = "nightstand"
    noun = 'nightstand' 'stand'
    location = fanny_room
    ldesc =
    {
        "The nightstand has one drawer. The drawer is ";
        if  (nightstanddrawer.isopen)
            "open. ";
        else
            "closed. ";
    }
;

kim_nightstand: surface, fixeditem
    sdesc = "nightstand"
    noun = 'nightstand' 'stand'
    location = kim_room
    ldesc =
    {
        "The nightstand has one drawer. The drawer is ";
        if  (kim_nightstanddrawer.isopen)
            "open. ";
        else
            "closed. ";
    }
    doHint( actor ) =
    {
        if  (kim_nightstanddrawer.isopen)
        {
            encrypt( 'There is no need for a hint here anymore. ' );
            abort;
        }
        encrypt( 'Just open the drawer. ' );
        abort;
    }
;

fanny_table: surface, fixeditem
    sdesc = "make-up table"
    noun = 'table'
    location = fanny_room
    ldesc =
        "The make-up table is littered with bottles of perfume, creams,
        nail polish, lipsticks, eye-shadows, combs and whatmore. ";
;

fanny_makeup: fixeditem
    sdesc = "make-up"
    noun = 'bottles' 'bottle' 'eye-shadow' 'lipstick' 'perfume' 'creams' 'cream' 'combs' 'comb' 'make-up'
    location = fanny_room
    ldesc =
        "It's all girl's stuff, it's of no use to you. ";
;

kim_table: surface, fixeditem
    sdesc = "make-up table"
    noun = 'table'
    location = kim_room
    ldesc =
        "The make-up table contains a few bottles, a comb and
        some lipstick. ";
;

kim_makeup: fixeditem
    sdesc = "make-up"
    noun = 'bottles' 'bottle' 'lipstick' 'perfume' 'comb' 'make-up' 'items' 'item'
    location = kim_room
    ldesc =
        "There is nothing here you could use. ";
;

nightstanddrawer: fixeditem, openable
    sdesc = "nightstand drawer"
    noun = 'drawer'
    location = fanny_room
    isopen = nil
    ldesc =
    {
        "The drawer is ";
        if  (self.isopen)
            "open. ";
        else
            "closed. ";
    }
;

kim_nightstanddrawer: fixeditem, openable
    sdesc = "nightstand drawer"
    noun = 'drawer'
    location = kim_room
    isopen = nil
    ldesc =
    {
        "The drawer is ";
        if  (self.isopen)
            "open. ";
        else
            "closed. ";
    }
;

fanny_chest: fixeditem, openable
    sdesc = "standing chest"
    noun = 'chest'
    adjective = 'standing'
    location = fanny_room
    isopen = nil
    ldesc =
    {
        if  (self.isopen)
        {
            "In the chest you see lots of girly clothes, red dresses,
            mini-skirts, high heels, some hats, pink frocks, and so on.
            Her underwear is particulary enticing. Most of it is lace
            and silk, and you even find some garter belts to hold up
            her silk stockings. However, there is nothing here you
            could put to use. ";
        }
        else
            "The standing chest is closed. ";
    }
;

desk: fixeditem, keyedLockable
    sdesc = "desk"
    noun = 'desk'
    location = games_room
    isopen = nil
    islocked = true
    mykey = silver_key
    ldesc =
    {
        if  (self.isopen)
            "The desk is open. ";
        else if  (self.islocked)
            "The desk is locked. ";
        else
            "The desk is closed. ";
    }
    doHint( actor ) =
    {
        if  (not( self.islocked ))
        {
            encrypt( 'There is no need for a hint here anymore. ' );
            abort;
        }
        switch (self.hint)
        {
            case 0:
                encrypt( 'You need a key to unlock the desk. ' );
                break;
            case 1:
                encrypt( 'Have you already played 21 with Kim? ' );
                break;
            case 2:
                encrypt( 'Kim has the key to the desk. She keeps some of her
                possible bets in it. ' );
                break;
            case 3:
                encrypt( 'Have you noted where Kim keeps the key? ' );
                break;
            case 4:
                encrypt( 'As soon as Kim is out of her clothes, you can search
                them to find the key. However, you don\'t really need to
                open the desk to solve the game, although it can be fun. ' );
                break;
            default:
                randomhint();
                break;
        }
        ++self.hint;
        abort;
    }
;

guest_closet: fixeditem, openable
    sdesc = "closet"
    noun = 'closet'
    location = guest_quarters
    isopen = nil
;

cupboard: fixeditem, openable
    sdesc = "cupboard"
    noun = 'cupboards' 'cupboard'
    location = kitchen
    isopen = nil
;

oven: fixeditem, openable
    sdesc = "oven"
    adesc = "an oven"
    noun = 'oven'
    adjective = 'large'
    location = kitchen
    isopen = nil
;

refrigerator: fixeditem, openable
    sdesc = "refrigerator"
    noun = 'refrigerator' 'fridge'
    location = kitchen
    isopen = nil
    ldesc =
    {
        if  (self.isopen)
        {
            "In the refrigerator you see lots of food and drink. You don't
            know what you can do with all of that, so you just leave it. ";
        }
        else
            "It's closed. ";
    }
;

cooker: fixeditem, surface
    sdesc = "gas cooker"
    noun = 'cooker'
    adjective = 'gas'
    location = kitchen
;

shelves: fixeditem, surface
    sdesc = "shelf"
    noun = 'shelves' 'shelf'
    location = closet
;

guest_sink: fixeditem, container
    sdesc = "sink"
    noun = 'sink'
    location = guest_quarters
;

kitchen_sink: fixeditem, container
    sdesc = "sink"
    noun = 'sink'
    location = kitchen
;

box: item, container
    sdesc = "box"
    noun = 'box'
    maxbulk = 100
    location = outside
    ldesc =
        "This magic box is a present from the game designer. Treasure it
        always. "
;

pool: fixeditem, container
    sdesc = "pool"
    noun = 'pool' 'water'
    location = dead_end
    maxbulk = 100
    ldesc =
    {
        "The round pool is filled with dark, cold water. ";
        if  (fish.location = pool)
            "A large fish is swimming just under the surface. ";
        else
            "In the deepest part of the pool you discover a fish
            lying quietly on the bottom. ";
    }
;

bathroom_sink: fixeditem, container
    sdesc = "sink"
    noun = 'sink'
    location = bathroom
    ldesc =
        "The sink is fabricated from pink marble. ";
;

tub: fixeditem, container
    sdesc = "tub"
    noun = 'tub' 'bath'
    location = bathroom
    ldesc =
        "The bath is made out of white marble. "
    verDoUse( actor ) = {}
    doUse( actor ) =
    {
        "There is no water in the bath and the taps don't seem to work. ";
    }
;

fanny_clothes: fixeditem
    sdesc = "clothes"
    noun = 'clothes' 'belts' 'dresses' 'skirts' 'skirt' 'mini-skirt' 'heels' 'frocks' 'frock' 'underwear' 'stocking' 'belt' 'hats' 'hat' 'dress' 'garters' 'garter'
    location = fanny_chest
    ldesc =
        "You cannot use these clothes in the castle, leave them where they
        are. ";
;

dinner_table: surface, fixeditem
    sdesc = "dinner table"
    noun = 'table'
    adjective = 'dinner'
    location = dining_room
    ldesc =
        "The table is made from dark wood. It's very long, and stretches
        from the west end of the room to the east end. The surface is
        flat, but the supports have been sculpted into many figurines.
        You recognise them to be satyrs, with long, hard erections,
        chasing sexy, ample-bosomed nymphs. "
;

chair: chairitem
    sdesc = "chair"
    noun = 'chairs' 'chair'
    location = dining_room
    ldesc =
        "The chairs match the table. They are also made of dark wood,
        and the legs are sculpted like the table supports. "
;

living_chair: chairitem
    sdesc = "chair"
    noun = 'chairs' 'chair'
    location = living_room
    ldesc =
        "The chairs look very comfortable. ";
;

living_table: surface, fixeditem
    sdesc = "table"
    noun = 'table'
    location = living_room
    ldesc =
        "The table is small and low. ";
;

carpet: surface, fixeditem
    sdesc = "carpet"
    noun = 'carpet'
    location = living_room
    ldesc =
        "The carpet has a intricate and warm design. It depicts a hunt-scene.
        The hunters are obviously well-shaped men, who chase well-shaped
        women. "
    verDoMove( actor ) =
    {
        "You move the carpet, and you reveal... nothing. Not a sausage.
        Disappointed, you move the carpet back. ";
    }
;

ilsa_chest: fixeditem, openable
    sdesc = "wooden chest"
    noun = 'chest'
    adjective = 'wooden'
    location = ilsa_room
    isopen = nil
    ldesc =
    {
        if  (self.isopen)
        {
            "In the chest you see Ilsa's daily wear. If you have to describe
            it in three words, they would be leather, leather, leather. She
            has leather jackets, leather pants, leather hats, and even leather
            underwear (God, do I see a leather handkerchief there?). ";
        }
        else
            "The wooden chest is closed. ";
    }
;

living_cupboard: fixeditem, openable
    sdesc = "cupboard"
    noun = 'cupboard'
    location = living_room
    isopen = nil
    ldesc =
    {
        if  (self.isopen)
            "The cupboard is open. ";
        else
            "The wooden chest is closed. ";
    }
;

cabinet: fixeditem, openable
    sdesc = "cabinet"
    noun = 'cabinet'
    location = kim_room
    isopen = nil
    ldesc =
    {
        if  (self.isopen)
        {
            "The cabinet contains Kim's outfits. She is obviously a
            business woman, but one who doesn't neglect her feminine
            side. The are nice suits hanging in the cabinet, and
            matching high-heeled shoes below them. Her underwear is
            practical but still very beautiful. ";
        }
        else
            "The cabinet chest is closed. ";
    }
;

ilsa_clothes: fixeditem
    sdesc = "leather clothes"
    adesc = "leather clothes"
    noun = 'clothes' 'pants' 'underwear' 'jackets' 'jacket' 'hats' 'hat' 'outfits' 'outfit' 'handkerchief'
    adjective = 'leather'
    location = ilsa_chest
    ldesc =
        "There's nothing you could use the leather clothes for. "
;

kim_clothes: fixeditem
    sdesc = "Kim's clothes"
    adesc = "Kim's clothes"
    noun = 'clothes' 'underwear' 'outfits' 'shoes' 'shoe' 'outfit'
    location = cabinet
    ldesc =
        "There's nothing you could use Kim's clothes for. "
;

hole_in_floor: doorway
    sdesc = "oubliette"
    adesc = "an oubliette"
    noun = 'oubliette' 'hole'
    location = torture_chamber
    ldesc =
    {
        "The oubliette is a dark hole in the floor. It is used to
        get rid of prisoners who's sentence is death by starvation.
        You could go down into it, but it won't be so easy to get
        back up again. ";
    }
    verDoEnter( actor ) = {}
    doEnter( actor ) =
    {
        Me.moveInto( oubliette );
        "You jump down into the dark oubliette. ";
    }
    doHint( actor ) =
    {
        if  (glasses.location <> oubliette)
        {
            encrypt( 'There is no need for a hint here anymore. ' );
            abort;
        }
        switch (self.hint)
        {
            case 0:
                encrypt( 'You can go down to enter the oubliette. ' );
                break;
            case 1:
                encrypt( 'It is not so easy to get out of the oubliette.
                Have you already opened the closet door in the kitchen? ' );
                break;
            case 2:
                encrypt( 'If you have the rope, you might use it to create
                a way out of the oubliette. ' );
                break;
            case 3:
                encrypt( 'Tie the rope to the rack. Then you can climb out of the oubliette
                by the rope. ' );
                break;
            default:
                randomhint();
                break;
        }
        ++self.hint;
        abort;
    }
;

chandelier: fixeditem, lightsource
    sdesc = "chandelier"
    noun = 'chandeliers' 'chandelier' 'lamps' 'lamp'
    location = dining_room
    contentsVisible = nil
    contentsReachable = nil
    ldesc =
    {
        "The chandeliers are fastened high on the ceiling, and light the
        room in a gloomy glow. They are far too high up for you to reach
        them. ";
        if  (diamond.location = nil)
            "You spot something glittering on one of them. ";
    }
    verDoSpank( actor ) = {}
    doSpank( actor ) =
    {
        "You cannot reach the chandelier with your bare hands. ";
        if (whip.location = Me)
        {
            "Perhaps if you used something in your inventory to extend
            your arm with...";
        }
    }
    doHint( actor ) =
    {
        if  (diamond.location <> nil)
        {
            encrypt( 'There is no need for a hint here anymore. ' );
            abort;
        }
        switch (self.hint)
        {
            case 0:
                encrypt( 'Wait at least for three moves in the dining room. ' );
                break;
            case 1:
                encrypt( 'There is something hidden on it. You need to get that off. ' );
                break;
            case 2:
                encrypt( 'Try to hit the chandelier. ' );
                break;
            case 3:
                encrypt( 'You cannot reach the chandelier, but maybe you can use
                an object to get it in motion. ' );
                break;
            case 4:
                encrypt( 'Did you ever see Indiana Jones in action? ' );
                break;
            case 5:
                encrypt( 'Search Ilsa\'s room before you try to solve this puzzle. ' );
                break;
            case 6:
                encrypt( 'You can hit the chandelier with the whip. ' );
                break;
            default:
                randomhint();
                break;
        }
        ++self.hint;
        abort;
    }
;

sandwich: fooditem, betitem
    weight = 2
    bulk = 1
    sdesc = "sandwich"
    noun = 'sandwich' 'bread'
    location = picknick_table
    points = 1
    ldesc =
        "The sandwich consist of two pieces of bread with some cheese
        and pickled onions between them. "
    doEat( actor ) =
    {
        "It's a bit dry, but it gives you some strength. ";
        self.moveInto( box );
    }
    doPutIn( actor, io ) =
    {
        if  (io = pool)
        {
            "You drop the sandwich in the pool. With a splash it disappears
            beneath the surface. Immediately it's attacked by the large fish,
            which devours it like a Scotsman a haggis, and the fish
            then sinks down to the bottom of the pool, where it starts to
            digest in peace and quiet. It's probably safe now to reach into
            the pool. ";
            incscore( self.points );
            self.points := 0;
            fish.moveInto( dead_end );
            self.moveInto( box );
        }
        else
        {
            "Done. ";
            self.moveInto( io );
        }
    }
    doHint( actor ) =
    {
        switch (self.hint)
        {
            case 0:
                encrypt( 'You can eat the sandwich. ' );
                break;
            case 1:
                encrypt( 'Don\'t eat the sandwich until you get hungry. ' );
                break;
            case 2:
                encrypt( 'You\'ll never get hungry. ' );
                break;
            case 3:
                encrypt( 'If you find someone or something that is hungry,
                you may have found a use for the sandwich. ' );
                break;
            default:
                randomhint();
                break;
        }
        ++self.hint;
        abort;
    }
;

apple: fooditem, betitem
    weight = 2
    bulk = 1
    sdesc = "apple"
    adesc = "an apple"
    noun = 'apple'
    location = desk
    ldesc =
        "It looks like a very tasty apple. "
    doEat( actor ) =
    {
        "The apple tastes great. ";
        self.moveInto( box );
    }
    doHint( actor ) =
    {
        switch (self.hint)
        {
            case 0:
                encrypt( 'You can eat the apple. ' );
                break;
            case 1:
                encrypt( 'That\'s it. You can eat the apple. ' );
                break;
            case 2:
                encrypt( 'And nothing else. ' );
                break;
            case 3:
                encrypt( 'Really. ' );
                break;
            default:
                randomhint();
                break;
        }
        ++self.hint;
        abort;
    }
;

gold_piece: betitem
    weight = 1
    bulk = 1
    sdesc = "gold piece"
    noun = 'piece' 'money'
    adjective = 'gold'
    location = desk
    ldesc =
    {
        "It's a very shiny gold piece. ";
    }
    doHint( actor ) =
    {
        switch (self.hint)
        {
            case 0:
                encrypt( 'A gold piece might buy you something. ' );
                break;
            case 1:
                encrypt( 'You could try to buy sex from one of the
                girls. ' );
                break;
            case 2:
                encrypt( 'One gold piece is probably not nearly enough
                to bribe one of the girls into having sex with you,
                if she\'s not willing. ' );
                break;
            case 3:
                encrypt( 'Maybe you can buy something else, if not sex. ' );
                break;
            case 4:
                encrypt( 'There is nothing you can buy with the gold
                piece. It has no use in the game. ' );
                break;
            default:
                randomhint();
                break;
        }
        ++self.hint;
        abort;
    }
;

scarlet_herring: betitem, readable
    weight = 1
    bulk = 1
    sdesc = "scarlet herring"
    noun = 'herring'
    adjective = 'scarlet'
    location = cell
    ldesc =
    {
        "It's a scarlet herring. Looking close, you see a text in small letters
        printed on it, saying:
        \b"; version.sdesc; "\n"; version.tadsversion; "\bWeird. ";
    }
    doHint( actor ) =
    {
        switch (self.hint)
        {
            case 0:
                encrypt( 'Scarlet is a colour, very much the same as... ' );
                break;
            case 1:
                encrypt( 'Scarlet is red. ' );
                break;
            case 2:
                encrypt( 'Don\'t you know what a red herring is? ' );
                break;
            case 3:
                encrypt( 'I suggest you look it up in the dictionary. ' );
                break;
            default:
                randomhint();
                break;
        }
        ++self.hint;
        abort;
    }
;

diamond: betitem
    weight = 1
    bulk = 1
    sdesc = "diamond"
    noun = 'diamond' 'stone'
    location = nil
    ldesc =
        "It's a large, sparkling diamond. Some girls would consider it
        their best friend (instead of their husband's tool). "
    doHint( actor ) =
    {
        switch (self.hint)
        {
            case 0:
                encrypt( 'Is there someone who likes diamonds? ' );
                break;
            case 1:
                encrypt( 'Show the diamond to the girls. ' );
                break;
            case 2:
                encrypt( 'Kim loves diamonds. ' );
                break;
            case 3:
                encrypt( 'Kim would do a lot to get that diamond from you... ' );
                break;
            default:
                randomhint();
                break;
        }
        ++self.hint;
        abort;
    }
;

gate_key: keyItem
    weight = 1
    bulk = 1
    sdesc = "heavy key"
    noun = 'key'
    adjective = 'heavy'
    location = nil
    ldesc =
        "It's a large, heavy key. It should fit the front gates. "
;

cell_key: keyItem, hiddenItem, betitem
    weight = 1
    bulk = 1
    sdesc = "iron key"
    adesc = "an iron key"
    noun = 'key'
    adjective = 'iron'
    searchLoc = ilsa_boots
    location = nil
    ldesc =
        "It's a small, iron key. "
;

bedroom_key: keyItem, betitem
    weight = 1
    bulk = 1
    sdesc = "bronze key"
    noun = 'key'
    adjective = 'bronze'
    location = desk
    ldesc =
        "It's a small, bronze key. "
;

silver_key: keyItem, hiddenItem, betitem
    weight = 1
    bulk = 1
    sdesc = "silver key"
    noun = 'key'
    adjective = 'silver'
    searchLoc = kim_suit
    location = nil
    ldesc =
        "It's a small, silver key. "
;

pillow: fixeditem
    sdesc = "pillows"
    adesc = "pillows"
    noun = 'pillows' 'cushions' 'pillow' 'cushion'
    adjective = 'pink'
    location = fanny_bed
    ldesc =
        "The pillows are large and very, very soft. "
;

teddy_bear: betitem, searchHider
    weight = 1
    bulk = 3
    sdesc = "teddy bear"
    noun = 'teddy' 'bear' 'seams' 'seam'
    location = fanny_bed
    ldesc =
    {
        "The teddy bear is at least three feet high, and smiles at you
        in a very inate way. Upon closer examination, you feel that its
        seams are not entirely closed up. ";
        if  (vibrator.location = nil)
            "You feel something hard inside. ";
    }
    verDoOpen( actor ) =
    {
        "You don't immediately see how to open the teddy bear. Perhaps
        you should search it. ";
    }
    doHint( actor ) =
    {
        if  (vibrator.location <> self)
        {
            encrypt( 'There is no need for a hint here anymore. ' );
            abort;
        }
        switch (self.hint)
        {
            case 0:
                encrypt( 'Examine the bear. ' );
                break;
            case 1:
                encrypt( 'There is something hidden in it. ' );
                break;
            case 2:
                encrypt( 'Search the bear. ' );
                break;
            default:
                randomhint();
                break;
        }
        ++self.hint;
        abort;
    }
;

glasses: clothingItem, betitem
    weight = 1
    bulk = 1
    sdesc = "tinted glasses"
    adesc = "a pair of tinted glasses"
    noun = 'glasses'
    adjective = 'tinted'
    location = oubliette
    ldesc =
    {
        "These glasses seem to distort the world around you a bit
        as you look through them. ";
    }
    doHint( actor ) =
    {
        if  (glasses.isworn)
        {
            encrypt( 'There is no need for a hint here anymore. ' );
            abort;
        }
        switch (self.hint)
        {
            case 0:
                encrypt( 'Examine the glasses. ' );
                break;
            case 1:
                encrypt( 'Maybe you should wear them. ' );
                break;
            case 2:
                encrypt( 'Examine some things while wearing the glasses. ' );
                break;
            case 3:
                encrypt( 'Examine the girls while wearing the glasses. ' );
                break;
            case 4:
                encrypt( 'Examine girls wearing clothes while wearing the glasses. ' );
                break;
            case 5:
                encrypt( 'The glasses enable you to see through girl\'s clothes.
                However, that\'s not the only thing you can see through
                with them. ' );
                break;
            default:
                randomhint();
                break;
        }
        ++self.hint;
        abort;
    }
;

heavy_weight: betitem
    weight = 50
    bulk = 10
    sdesc = "very heavy weight"
    noun = 'weight'
    adjective = 'heavy'
    location = ilsa_room
    ldesc =
        "This is the only weight you could possibly carry. It's so tremendously
        heavy that you get the feeling your arms stretch a few inches just
        from carrying it. You get the uncanny feeling that Ilsa is a girl
        who juggles three of these weights in front of the mirror, while
        watching her taut, bulging muscles ripple under the skin of her oiled,
        naked body. "
    doHint( actor ) =
    {
        switch (self.hint)
        {
            case 0:
                encrypt( 'Lift the weight. ' );
                break;
            case 1:
                encrypt( 'It\'s VERY heavy. ' );
                break;
            case 2:
                encrypt( 'If you drop almost all your stuff, you can
                lift the weight. ' );
                break;
            case 3:
                encrypt( 'You can try to carry it somewhere else. ' );
                break;
            case 4:
                encrypt( 'Where would a heavy weight be useful? ' );
                break;
            case 5:
                encrypt( 'Beats me. The weight hasn\'t got any purpose in the game
                (except to annoy you, sorry). ' );
                break;
            default:
                randomhint();
                break;
        }
        ++self.hint;
        abort;
    }
;

lighter: betitem, lightsource
    weight = 1
    bulk = 1
    sdesc = "lighter"
    noun = 'lighter'
    stuff = 10
    max_stuff = 10
    location = startroom
    ldesc =
    {
        "It can be used to light things. That's why it's called a lighter,
        you know. ";
        if  (self.islit)
            "The lighter is burning with a small flame. ";
        else
            "The lighter is off. ";
        if  (self.stuff > 0)
        {
            "It holds enough gas to last "; say( self.stuff ); " more turn";
            if  (self.stuff <> 1)
                "s";
            ". ";
        }
        else
            "It seems to be totally out of gas. ";
    }
    verDoRecharge( actor ) =
    {
        if  (recharger.location <> Me)
            "You don't have a recharger. ";
    }
    doRecharge( actor ) =
    {
        "You refill the lighter. ";
        self.stuff := self.max_stuff;
    }
    verDoTurnon( actor ) =
    {
        if  (self.islit )
            "It's already on! ";
        else if  (self.location = pool)
            "The lighter cannot be turned on as long as it's under water. ";
    }
    doTurnon( actor ) =
    {
        if  (self.stuff > 0)
        {
            "The lighter is now on. ";
            self.islit := true;
        }
        else
            "The lighter seems to be empty. ";
    }
    verDoTurnoff( actor ) =
    {
        if  (not self.islit)
            "It's not on. ";
    }
    doTurnoff( actor ) =
    {
        "Okay, the lighter is now off. ";
        self.islit := nil;
    }
    doHint( actor ) =
    {
        if  (self.islit)
        {
            encrypt( 'There is no need for a hint here anymore. ' );
            abort;
        }
        switch (self.hint)
        {
            case 0:
                encrypt( 'You can light the lighter to provide light. ' );
                break;
            case 1:
                encrypt( 'If the lighter is out of fuel, it won\'t work. ' );
                break;
            case 2:
                encrypt( 'The lighter contains fuel for ten moves. You need to
                find another lightsource before the lighter goes out. ' );
                break;
            case 3:
                encrypt( 'The second, inexhaustible lightsource is found to
                the north of the T-junction. ' );
                break;
            default:
                randomhint();
                break;
        }
        ++self.hint;
        abort;
    }
;

plaque: readable, fixeditem
    sdesc = "bronze plaque"
    location = end_of_passage
    noun = 'plaque' 'lettering' 'writing'
    adjective = 'bronze'
    ldesc =
        "The bronze plaque is securely fastened to the wall. The text
        on it is well readable. "
    readdesc =
    {
        "The plaque says:\b*** Welcome to Moist ***\bThis game
        contains many scenes of an explicit sexual nature. If you don't
        care for such scenes, or if you're easily offended, just type
        'quit' on the command line and leave the game. If you want
        to stay, read further.\bThe object of the game is to escape
        from the caves you're now in. ";
        if  (global.earthquake > 0)
            "You won't be able to use the crack in the rock wall you
            used to enter (just wait and see!). ";
        else
            "The recent earthquake has blocked the crack in the rock
            face you used to enter. ";
        "You need to find another way out.\n";
        if  (not( large_grotto.isseen ))
            "You'll soon find";
        else
            "You've already been at";
        " the entrance to queen Morghana's castle, which is hewn out of
        these rocks. The second exit from the caves is found here, but
        only queen Morghana can help you with that. However, the queen
        will not help you until you've satisfied her. Of course,
        not just any man may approach the queen.\nYou need a
        recommendation from her three servant girls. They are a bit more
        easy to get to know. Each of them will recommend you to the queen
        when you've given her at least one orgasm.\nYou can stimulate
        (and destimulate) the girls in many ways. You can use your
        own body, or some of the tools you may find.\n
        If you're about to do something which may have an averse effect
        on a girl, you're sometimes asked if you're sure you want to do this.
        However, the fact that you're asked this does not mean that
        your action WILL have an averse effect. It may depend on the
        circumstances. If you want to play it safe, you can answer NO
        and try to stimulate her a bit more until she is ready. But you
        might want to see what happens if you continue.\n
        The excitement level of you and the girls will drop
        in time if not stimulated continuously. If the excitement rises beyond
        a certain level, and the right actions take place, the excited
        person will have an orgasm. If it is you, your excitement
        level will drop to zero and the excitement needed for the next
        orgasm will rise. This minimum level needed will decrease in time,
        however, when your stamina returns. If one of the girls has an orgasm,
        her excitement level drops to the point where she is quite aroused,
        and her needed level rises just a bit. The girls can have their
        orgasms in succession faster then you can. That's one of the
        advantages of being female, I'm afraid.\n
        And remember: It's not winning that counts...\b
        Enjoy your journey. ";
    }
;

pedestal: readable, fixeditem, surface
    sdesc = "pedestal"
    location = outside
    noun = 'pedestal' 'pillar' 'writing'
    ldesc =
        "The pedestal is made out of black marble. "
    readdesc =
        "\b*** Congratulations! ***\b
        You have freed yourself from the caves and the castle, which means
        you have won the game. Not only that, you've also had some
        pleasurable experiences, and gave some girls a good time besides.
        Take this recharger as a present. You can use it to recharge all
        the items which you could only use for a finite amount of moves,
        like the battery and the jelly. Besides, every object
        that was removed from the game you can find in the box you find
        here. So you now have the opportunity to re-enter the castle
        and try the things you didn't try before.
        If you like some suggestions of things to try, ask for hints
        about this pedestal. You might find the game has some surprises
        left for you.\n
        I hope you had a pleasant journey. Maybe we'll meet again in
        another adventure. And remember what Woody Allen once said:
        \"Sex is only dirty if it's done right.\" Thank you. "
    doHint( actor ) =
    {
        switch (self.hint)
        {
            case 0:
                encrypt( 'If you\'ve asked for all the hints on an
                object, a random hint appears. There are some fun
                things there. ' );
                break;
            case 1:
                encrypt( 'In the restroom, there\'s graffiti on the
                wall. Read it. Many times. ' );
                break;
            case 2:
                encrypt( 'Some one-word commands you might like to try:
                XYZZY, NI!, ZORK and ENIGMA. ' );
                break;
            case 3:
                encrypt( 'Give Kim the diamond after you\'ve given her
                an orgasm. ' );
                break;
            case 4:
                encrypt( 'Try to steal the milk from Fanny when she\'s
                carrying it. Or drink it. ' );
                break;
            case 5:
                encrypt( 'Did you try the pink and the blue potion
                yourself? Or feed it to one of the girls? ' );
                break;
            case 6:
                encrypt( 'Have you tried to use the rope to tie up the
                girls? The whip to spank them? ' );
                break;
            case 7:
                encrypt( 'Have you found the key to the desk in the
                Games room? Or the key to the cell? ' );
                break;
            case 8:
                encrypt( 'Each girl can be fucked in four spots. You
                might try to do the same thing to the plastic statue. ' );
                break;
            case 9:
                encrypt( 'There are two different ways to get Ilsa to
                have an orgasm. One is to fuck her when she\'s tied up.
                But you might try to reverse the roles by untying her.
                And remember that this scene can be played in many
                different ways, depending on your inventory and
                excitement level. ' );
                break;
            case 10:
                encrypt( 'You can enter the queen\'s bedroom with Kim\'s
                key. If she still has to get her first orgasm and isn\'t
                excited, you can get her to call Ilsa who\'ll lock you
                up in the cell. Try to escape. ' );
                break;
            case 11:
                encrypt( 'Very kinky: Have you tried to get one of the girls to
                eat the sperm you left on their bodies? ' );
                break;
            case 12:
                encrypt( 'You can get a reaction from Fanny by showing
                her the diamond, the pills, the wine, your private
                parts, a sexual toy, the rope or the whip. You can ask
                her about the diamond, your dick, the bible, the rope,
                the milk, the pills or the vibrator. ' );
                break;
            case 13:
                encrypt( 'You can get a reaction from Ilsa by showing
                her the diamond, the whip, a liquid or the jelly.
                You can ask her about the wine or the whip. ' );
                break;
            case 14:
                encrypt( 'You can get a reaction from Kim by showing
                her the diamond, the pills, the wine, your private
                parts, a sexual toy, the rope or the whip. You can ask
                her about the diamond, your dick, the silver key, the
                key to Morghana\'s bedroom, the rope or the pills. ' );
                break;
            case 15:
                encrypt( 'The game ends by walking west from here. But
                you might try to leave in another direction. ' );
                break;
            default:
                randomhint();
                break;
        }
        ++self.hint;
        abort;
    }
;

sign: readable, fixeditem
    sdesc = "small sign fastened on the wall"
    location = large_grotto
    noun = 'sign' 'lettering' 'writing'
    adjective = 'small'
    ldesc =
        "The small sign is securely fastened to the wall. There is
        some writing on it. "
    readdesc =
        "The sign says: \"Warning! This is an entrance to the realm
        of queen Morghana. Unauthorised passage is not allowed.\" "
;

scenes: readable, fixeditem
    sdesc = "lively scenes painted on the walls"
    location = large_grotto
    noun = 'scenes' 'scene' 'walls' 'wall'
    adjective = 'lively'
    ldesc =
        "The walls depict scenes of an erotic nature. There are
        many couples engaged in sexual congress, but there are also
        scenes of three- or moresomes. There is a group of girls
        depicted, fucking each other with strap-on dildo's.
        Another scene shows a woman with
        two men. One of the men sits on a chair, and the woman is sitting
        on his lap, with her back towards him, his massive penis
        penetrating her cunt, while she sucks the huge cock of the second
        man standing before her. This is quite exciting. "
;

bath_mirror: mirrorItem
    location = bathroom
;

fanny_mirror: mirrorItem
    location = fanny_room
;

ilsa_mirror: mirrorItem
    location = ilsa_room
;

kim_mirror: mirrorItem
    location = kim_room
;

fanny_bed: beditem
    location = fanny_room
    noun = 'bed'
    sdesc = "bed"
    ldesc =
        "Fanny's bed is soft and seems to be a great place to have fun in.
        It is covered with a sheet and lots of pillows. "
;

ilsa_bed: beditem
    location = ilsa_room
    noun = 'bed'
    sdesc = "bed"
    ldesc =
        "Ilsa's bed is very uncomfortable. It is covered with a white sheet. "
;

kim_bed: beditem
    location = kim_room
    noun = 'bed'
    sdesc = "bed"
    ldesc =
        "Kim's bed is simple, not too soft and not too hard. It is covered
        with a white, silk sheet. "
;

queen_bed: beditem
    location = bedroom
    noun = 'bed'
    sdesc = "bed"
    ldesc =
        "Morghana's bed is very, very large. Four bedposts surround it.
        It is covered with golden sheets, and is very soft. "
    verIoAttachTo( actor ) = {}
    ioAttachTo( actor, dobj ) =
    {
        if  (dobj <> Morghana)
        {
            "I don't know how to attach "; dobj.thedesc; " to the bed. ";
        }
        else if  (rope.location <> Me)
        {
            "You don't have the rope. ";
        }
        else if  (rope.location = Morghana)
        {
            "Morghana is already tied to the bed. ";
        }
        else
        {
            rope.ioTieWith( actor, Morghana );
        }
    }
;

guest_bed: beditem
    location = guest_quarters
    noun = 'bed'
    sdesc = "bed"
    ldesc =
        "It looks not too inviting. "
;

fanny_sheets: fixeditem
    sdesc = "sheet"
    noun = 'sheets' 'sheet'
    location = fanny_bed
;

kim_sheets: fixeditem
    sdesc = "sheet"
    noun = 'sheets' 'sheet'
    location = kim_bed
;

ilsa_sheets: fixeditem
    sdesc = "sheet"
    noun = 'sheets' 'sheet'
    location = ilsa_bed
;

queen_sheets: fixeditem
    sdesc = "sheet"
    noun = 'sheets' 'sheet'
    location = queen_bed
;

guest_sheets: fixeditem
    sdesc = "sheet"
    noun = 'sheets' 'sheet'
    location = guest_bed
;

sculpture: fixeditem
    sdesc = "sculpture"
    noun = 'sculptures' 'sculpture' 'statues' 'statue'
    location = gallery
    ldesc =
        "Almost all of the sculptures show human bodies. The bodies that
        are on their own are all well-formed and are shown in several
        stimulating poses: men with erections as large as baseball bats, and
        women with firm breasts the size of water melons, who would undoubtly
        topple over in real life. These statues only keep standing because of
        their large marble bases. The statues showing several people together
        place them locked in sexual embraces. Women are satisfying men
        with all of their orifices, and you wonder if the artists had
        models posing for them to make these statues, and if there really
        are male models which are so well-hung, and female models who
        can take tools of these sizes in their various openings. "
;

bedpost: fixeditem
    sdesc = "bedpost"
    noun = 'bedposts' 'posts' 'post' 'bedpost'
    location = bedroom
    ldesc =
        "The long bedposts on the corners of the bed carry the
        ceiling above the bed. On close examination, one of the
        bedposts seems to have a small button hidden on it. "
;

bedceiling: fixeditem
    sdesc = "ceiling"
    noun = 'ceiling'
    location = bedroom
    ldesc =
        "The ceiling above the bed is supported by four bedposts. "
;

fish: fixeditem
    sdesc = "large fish"
    noun = 'fish'
    location = pool
    ldesc =
    {
        if  (fish.location <> pool)
            "The fish rests in the deepest waters of the pool, digesting
            its latest meal. ";
        else
            "The fish is about two feet long, and has quite a large
            mouth filled with many small, sharp teeth. It swims around
            frantically, as if searching for something. ";
    }
    doHint( actor ) =
    {
        if  (fish.location <> pool)
        {
            encrypt( 'There is no need for a hint here anymore. ' );
            abort;
        }
        switch (self.hint)
        {
            case 0:
                encrypt( 'Have you already tried to take the tube? ' );
                break;
            case 1:
                encrypt( 'Doesn\'t the fish seem a bit hungry? ' );
                break;
            case 2:
                encrypt( 'Have you got something to feed the fish? ' );
                break;
            case 3:
                encrypt( 'Drop the sandwich in the pool. ' );
                break;
            default:
                randomhint();
                break;
        }
        ++self.hint;
        abort;
    }
;

rack: fixeditem, qcontainer, surface
    sdesc = "rack"
    noun = 'rack'
    location = torture_chamber
    ldesc =
    {
        "The rack is a table which is longer than a human body. There are
        clamps at the four corners, which can be used to tie someone on it on
        his or her back, with arms and legs stretched out. If you
        were attached to the table, you wouldn't be able to defend yourself
        against anything. ";
        if  (rope.location = rack)
            "There is a rope tied to the rack. ";
    }
    ioPutIn( actor, dobj ) =
    {
        "You cannot put anything in the rack. ";
        exit;
    }
    verIoAttachTo( actor ) = {}
    ioAttachTo( actor, dobj ) =
    {
        if  (dobj <> rope and dobj <> Ilsa)
        {
            "I don't know how to attach "; dobj.thedesc; " to the rack. ";
        }
        else if  (dobj = rope)
        {
            if  (rope.location = rack)
            {
                "It's already attached to the rack. ";
            }
            else
            {
                "You tie one end of the rope to the rack, and let the other end
                dangle down into the oubliette. ";
                rope.moveInto( self );
                oubliette_rope.moveInto( oubliette );
            }
        }
        else
        {
            if  (Ilsa.tied)
                "Ilsa is already tied to the rack. ";
            else if  (Ilsa.drugged <= 0)
                "You grab Ilsa by the arms, and try to push her towards the
                rack. She laughs, and shakes you off, like a pesky fly. ";
            else
            {
                "You grab the unconscious Ilsa under the arms, and pull her
                towards the rack. You lift her on it on her back. You use
                the manacles on the four corners of the rack to tie her hands
                and feet. She lies spreaded out, ready for anything. ";
                Ilsa.tied := true;
            }
        }
    }
    verDoUntie( actor ) =
    {
        if  (rope.location <> self)
            "The rope is not tied to the rack. ";
    }
    doUntie( actor ) =
    {
        "You untie the rope and haul it in. It drops on the floor. ";
        rope.moveInto( Me.location );
        oubliette_rope.moveInto( nil );
    }
    doHint( actor ) =
    {
        switch (self.hint)
        {
            case 0:
                encrypt( 'Examine it. ' );
                break;
            case 1:
                encrypt( 'You could tie someone down on it. ' );
                break;
            case 2:
                encrypt( 'You could try to tie Ilsa to the rack. ' );
                break;
            case 3:
                encrypt( 'Ilsa is much stronger than you are, and you
                won\'t be able to tie her to the rack as long as she can
                defend herself. ' );
                break;
            default:
                randomhint();
                break;
        }
        ++self.hint;
        abort;
    }
;

nw_windows: fixeditem
    sdesc = "small window"
    noun = 'windows' 'window'
    location = nw_tower
    adjective = 'small'
    ldesc =
    {
        "The windows are far too small to escape through. Through them,
        you view the outside world. You notice that the front of the castle
        is built against a rock. The rest of the castle seems to be within
        the rock. There are lush, green field stretching out in front of
        the castle. In the area just outside the gate to the castle, you
        spot some kind of pedestal. ";
    }
;

ne_windows: fixeditem
    sdesc = "small window"
    noun = 'windows' 'window'
    location = ne_tower
    adjective = 'small'
    ldesc =
    {
        "The windows are far too small to escape through. The view here
        is the same as the view through the windows in the north-west
        tower, so I suggest you go there to get a more full description. ";
    }
;

devices: fixeditem
    sdesc = "device"
    noun = 'devices' 'device'
    location = torture_chamber
    ldesc =
    {
        "You don't recognise most of the devices, but you wouldn't want to
        know them more intimately. ";
    }
;

pillars: fixeditem
    sdesc = "pillar"
    noun = 'pillars' 'pillar'
    location = entrance_hall
    ldesc =
        "The pillars are huge, and definitely have a certain phallic quality. "
;

utensils: fixeditem
    sdesc = "utensil"
    noun = 'utensils' 'utensil'
    location = kitchen
    adjective = 'kitchen'
    ldesc =
        "The kitchen utensils aren't of much use to you. "
;

toilet: fixeditem, container
    sdesc = "toilet"
    noun = 'toilet'
    location = restroom
    ldesc =
        "This is an ordinary toilet. There is some graffiti on the wall
        besides it, but nothing of real interest. "
    verDoUse( actor ) = {}
    doUse( actor ) =
    {
        "That's a relief. ";
    }
;

cord: fixeditem
    sdesc = "twisted cord"
    noun = 'cord'
    adjective = 'twisted'
    location = bedroom
    broken = nil
    ldesc =
        "The twisted cord hangs down from the ceiling in a corner. "
    verDoPull( actor ) =
    {
        if  (self.broken)
            "The bell mechanism is obviously broken. You hear nothing. ";
        else if  (milk.location <> nil)
        {
            "%You% pull%s% the cord. You hear something rattling in the
            wall, and the cord suddenly hangs a bit lower. There is no
            sound of a bell to be heard. ";
            self.broken := true;
        }
    }
    doPull( actor ) =
    {
        "You hear a bell ring somewhere. ";
        if  (Fanny.serving > 0)
            "Morghana says, \"I've called out for milk a few moments
            ago.\" ";
        else
            "\"A good idea,\" Morghana says. \"I could use some milk.\" ";
        global.servecounter := 0;
        Fanny.serving := 1;
        milk.moveInto( nil );
    }
;

button: fixeditem
    sdesc = "hidden button"
    noun = 'button'
    adjective = 'hidden'
    location = bedroom
    ldesc =
        "The button is hidden in the carvings on one of the bedposts. "
    verDoPush( actor ) = {}
    doPush( actor ) =
    {
        "You press the button, and a light click sounds. You take a
        step back, and suddenly you feel the ground open up under your
        feet. You tumble down, and end up in the cellar. ";
        Me.moveInto( cellar_entrance );
    }
;

shower: fixeditem
    sdesc = "shower"
    noun = 'shower'
    location = restroom
    ldesc =
        "This is an ordinary shower. "
    verDoUse( actor ) = {}
    doUse( actor ) =
    {
        "You stand under the shower, and open the tap. A small stream of
        water trickles down on you. This is not what you would call
        a good shower. ";
    }
;

game_carpet: fixeditem, surface
    sdesc = "carpet"
    noun = 'carpet'
    location = games_room
    ldesc =
        "The carpet has a dark red color. ";
;

painting: fixeditem
    sdesc = "painting"
    noun = 'paintings' 'painting' 'pictures' 'picture'
    location = gallery
    ldesc =
        "The paintings depict scenes ranging from high erotica to vulgar
        scenes which would be found in the most filthy kind of X-rated
        magazines (Yeah!). In fact, the vulgar ones are by far in the majority. You see
        SM scenes involving leather, ropes and several kinds of
        apparatus, animal sex and gang rapes. Ah well, you don't know
        much about art, but you know what you like. "
;

bell: fixeditem
    sdesc = "bell"
    noun = 'bell'
    adjective = 'brass'
    location = kitchen
    ldesc =
        "The brass bell is fastened high on the wall. "
    verDoRing( actor ) =
    {
        "There is no way %you% can ring the bell. It's not done from
        this room. ";
    }
;

rubble: fixeditem
    sdesc = "rubble"
    noun = 'rubble' 'debris'
    location = nil
    ldesc =
        "The rubble fills the crack in the rock face. "
    verDoMove( actor ) =
    {
        "There's far too much rubble, and it is much too heavy. You
        won't be able to enter the caves now, so why don't you restart? ";
    }
;

rubble2: fixeditem
    sdesc = "rubble"
    noun = 'rubble' 'debris'
    location = nil
    ldesc =
        "The rubble fills the crack in the rock face. It leaves a very
        small opening which lets light into the room, but which isn't
        big enough to get through. "
    verDoMove( actor ) =
    {
        "You can't move the rubble. You won't be able to leave the
        caves this way. ";
    }
;

torch: betitem, lightsource
    sdesc = "torch"
    noun = 'torch'
    weight = 3
    bulk = 1
    points = 1
    location = end_of_passage
    ldesc =
    {
        "It's a piece of wood covered with fat at one end. It can
        burn for a long time. ";
        if  (self.islit)
            "The torch is burning with a smoky flame. ";
        else
            "At the moment the torch is not burning. ";
    }
    verDoTurnon( actor ) =
    {
        if  (self.islit )
            "It's already burning! ";
        else if  (self.location = pool)
            "The torch won't burn as long as it's under water! ";
    }
    doTurnon( actor ) =
    {
        if  (lighter.location = Me and lighter.islit)
        {
            "You light the torch with your lighter. It starts to burn with
            a smoky flame. ";
            self.islit := true;
            incscore( self.points );
            self.points := 0;
        }
        else if  (lighter.location = Me)
            "Your lighter is not on. ";
        else
            "You don't have anything to light the torch with. ";
    }
    verDoTurnoff( actor ) =
    {
        if  (not self.islit)
            "It's not burning. ";
    }
    doTurnoff( actor ) =
    {
        "Okay, the torch is now extinguished. ";
        self.islit := nil;
    }
    doHint( actor ) =
    {
        if  (self.islit)
        {
            encrypt( 'There is no need for a hint here anymore. ' );
            abort;
        }
        switch (self.hint)
        {
            case 0:
                encrypt( 'Have you already tried to light the torch? ' );
                break;
            case 1:
                encrypt( 'Is the lighter still on? ' );
                break;
            case 2:
                encrypt( 'Try to light the torch. If the lighter is still on,
                this works. ' );
                break;
            default:
                randomhint();
                break;
        }
        ++self.hint;
        abort;
    }
;

toothbrush: betitem, container
    weight = 1
    bulk = 1
    activated = nil
    sdesc = "electrical toothbrush"
    adesc = "an electrical toothbrush"
    noun = 'toothbrush' 'brush'
    adjective = 'electrical'
    location = bathroom_sink
    ldesc =
    {
        "The toothbrush has a wide handle, which is used to store
        a battery to power it. ";
        if  (battery.location = self)
        {
            if  (self.activated)
                "The toothbrush is turned on. ";
            else
                "The toothbrush contains a battery, but is not turned
                on at the moment. ";
        }
        else
            "The toothbrush is turned off at the moment. It does not
            contain a battery. ";
    }
    ioPutIn( actor, dobj ) =
    {
        if  (dobj <> battery)
        {
            "You can't put "; dobj.thedesc; " into the toothbrush. ";
        }
        else
            pass ioPutIn;
    }
    Grab( obj ) =
    {
            if  (obj = battery)
                self.activated := nil;
    }
    verDoTurnon( actor ) =
    {
        if  (self.activated)
            "It's already turned on! ";
    }
    doTurnon( actor ) =
    {
        if  (battery.location = self)
        {
            if  (battery.stuff > 0)
            {
                "You turn the toothbrush on. ";
                self.activated := true;
            }
            else
                "The battery seems to be empty. ";
        }
        else
            "The toothbrush won't turn on without a battery. ";
    }
    verDoTurnoff( actor ) =
    {
        if  (not( self.activated ))
            "It's not on. ";
    }
    doTurnoff( actor ) =
    {
        "Okay, it is now turned off. ";
        self.activated := nil;
    }
    doHint( actor ) =
    {
        switch (self.hint)
        {
            case 0:
                encrypt( 'Does the toothbrush work? ' );
                break;
            case 1:
                encrypt( 'It has a power-source. ' );
                break;
            case 2:
                encrypt( 'You don\'t need the toothbrush, but you do need
                its power-source. ' );
                break;
            default:
                randomhint();
                break;
        }
        ++self.hint;
        abort;
    }
;

books: readable, fixeditem
    sdesc = "erotic books"
    adesc = "some erotic books"
    number = 0
    location = library
    noun = 'books' 'literature' 'bookcases' 'bookcase'
    adjective = 'erotic'
    thedesc = "some erotic literature"
    ldesc =
        "Hundreds of books are placed in bookcases along the walls. The
        cover illustrations depict scenes which suggest the contents
        are erotic. "
    readdesc =
    {
        self.number += 1;
        switch (self.number)
        {
        	// These texts (except for the last one, which is supposed to be a hint),
        	//	have been taken from pornographic stories which have been
        	// distributed over the Internet and through BBSs.
            case 1:
                "You open a book called \"3 Ways\":\n
                ...Debbie started using her thumb on my clit, making it hard for
                me to lay still and concentrate on John. Just as I was on the
                verge of coming, Debbie stopped her thumb and fingers. I moaned
                in frustration. Then I felt John's cock start to swell and
                stiffen. John moaned and I pulled back, letting him aim
                his cock. \"Open your mouth slut!\" Debbie commanded and
                I did, just in time to feel his sperm gush against my tongue
                and face. John spurted again, drenching my face with his hot
                sperm... ";
                break;
            case 2:
                "You open a book called \"First Time\" by someone called
                Les Brian:\n
                ...She started rocking on my cock, squeezing her ass cheeks.
                Her breath started to come ragged and she slipped one finger to
                her pussy. \"Doug,\" she whispered, \"do it, fuck my ass.\"
                I started rocking in time to her own rhythm. God, she was
                tight. I could almost not move anyway, and when she squeezed,
                it nearly stopped me cold. Her finger twirled around her pussy
                and her rocking started to get more spasmodic. \"Come,\" she
                whispered, \"oh come in my ass.\"... ";
                break;
            case 3:
                "You pick a book called \"Suzi Q's Party Game\" by someone
                who calls himself John Carter:\n
                ...The whole group has seemingly climbed on you. The cock in
                your mouth is pumping with abandon. The cock in your cunt is
                pumping away, but with some difficulty. The one in your ass is
                still penetrating you, but its owner seems to be getting most
                of his stimulation from your heaves in reaction to the others
                on you. The two mouths on your breasts alternate between teasing
                you and stimulating you as hard as you can take it. You are
                glad for the blindfold in a way. The extra stimulation would
                only be a distraction. Someone takes your hand and puts it in
                their cunt and begins rubbing off on your fingers, using them
                like a dildo. You are so overwhelmed by all this, you can only
                react. It is as if you have become an object, losing your will.
                The cock in your mouth begins to pulse. Seconds later a milky
                stream spurts down your throat. You try to take it all, but
                some drips down your cheek... ";
                break;
            case 4:
                "You flap the pages from a book called \"The Rape\":\n
                ...His spontaneous actions were amazing. He would withdraw his
                elephantine cock until it was nearly out of my vagina, pause
                imperceptibly on the brink, so to speak, and then fiercely
                drive that stupendous, rock-hard pole deep, deep into my body.
                Each stroke would send exquisite tingling sensations coursing
                through my taunt body as my lust-bloated vaginal lining was
                impudently propelled aside by that magnificent monster. Then
                he would crash to a stop with an animal grunt from him and a
                sharp cry from me. The latter obviously stimulated his lusty
                zeal. Frantically, he would begin to withdraw again, and
                then plunge right back with more fervour. Over and over. With
                each stroke his heavy testicles would bounce against my rear
                with such a force I was sure that it must hurt, but he never
                showed it... ";
                break;
            case 5:
                "You idly thumb through a book called \"The Bar\":\n
                ...The cock in her mouth leaked out more cum and she quickly
                forgot why it was there in the first place. She sucked harder,
                drawing her cheeks in, and really liked the taste and feel of
                it in her mouth. Her pussy and ass clenched tightly around the
                cocks buried in them and she felt a new level of excitement
                shake her. Whatever the men were doing, she wanted them to
                keep it up. The sensations they gave her were great and she
                wanted more... ";
                break;
            case 6:
                "This book is called \"Cum Drinkers\":\n
                ...As he finished pulling the last dregs of his load out and
                dripping them into the cup, Kate leaned forward on impulse and
                popped the tip of his shaft in her mouth, feeling the last jet
                pulse across her tongue. She noisily slurped the cock shaft into
                her mouth then pulled back, letting it fall from between her
                lips with a wet smack. \"That's for being such a good shot, and
                not sperming all over a helpless lady's pretty face, my boy.\"
                she grinned up at him. He blushed and stuffed his cock back into
                his trousers, obviously not exactly at ease in this situation.
                As Kate shifted her weight, one of the other men began to grunt
                and groan. Just as she turned her head to check the status, his
                cock jumped and a gout of semen flew out. Kate ducked her head
                quickly to the side, almost hearing the white bullet whiz past
                her hair. She yelled \"NO! DOWN, DOWN!\" and quickly, but
                without spilling any, moved the cup to the front of his pants.
                He pushed his shaft downward and away from him. Another jet
                leapt out, this time impacting solidly on Kate's left tit,
                splashing into tiny drops and drooling down the curve of her
                bosom. 'FUCK!' she thought, 'he's blowing all over me!'... ";
                break;
            case 7:
                "You drool over the pages of a book called \"Charity\":\n
                ...With two fingers still inside and pumping her cunt, I used
                my thumb to probe her clitoris. I rolled the flat part of my
                thumb around and around her clit. Never quite touching except
                for an occasional quick brush against it. Her clit was hard and erect,
                it was almost begging to be touched. I pressed my thumb down
                on to it, then flicked it from side to side. Apparently, that
                was it, Hot Puss started calling out \"Yes! Yes!\" and I could
                feel her pussy contracting around my fingers. At that moment,
                I felt like my whole body exploded and great gobs of cum
                sprayed out of my cock! Hot Puss swallowed every drop... ";
                break;
            case 8:
                "An old book with the title page ripped off:\n
                ...\"Fuck me harder!\" she was yelling again. \"I going to
                come,\" I replied. And she started meeting my cock with such
                force that she was smashing my balls against my thighs. I
                started pumping my hot come in her ass like crazy. I thought I
                would go soft but I guess the pain she was inflicting on my
                balls was keeping me hard. \"Keep on fucking me you bastard!\"
                With my load in her ass things were getting very lubed and
                very sticky. I was like a piston and I kept on till come
                leaked out of her red, raw ass and my cock could not take it
                anymore... ";
                break;
            case 9:
                "You pick up a book called \"Deep Massage\":\n
                ...Then you feel him enter your hot, yearning pussy. Suddenly,
                he thrusts hard: once, twice, three times. Then you feel him
                pushing and pounding and shooting his hot sperm deep inside you.
                You go crazy and explode with orgasm after orgasm, earthquake
                after earthquake, right along with him. You feel your cum
                pouring out, mixing with his hot sperm. It seems to go on
                forever, in slow motion. He spurts, you spurt. He pulses, you
                contract around his cock. He draws back, you try to suck him
                back in like a vacuum cleaner. He thrusts forward, you squeeze
                him and spurt at the same time. Over and over. You can feel
                the warm hose gushing, his hot cock gushing, and your pussy
                gushing, forever... ";
                break;
            case 10:
                "A novel called \"Tag Team\":\n
                ...When the Marker appeared, Debbie had Karla's head face down
                in her lap, her arms up under Karla's shoulders. Karla,
                struggling, her ass in the air, legs spread, was showing the
                Marker lots of pink wetness in a thick black bush. \"He's here
                for you, honey,\" Debbie laughed, breathless, enjoying the sight
                of his erection. \"And he's got a beauty of a cock. How do you
                want it?\" \"Oh, God,\" Karla moaned. \"Let him screw my
                brains out.\" The Marker smiled, taking down his pants, a
                muscular pair of thighs visible now as he knelt down behind
                Karla, took her by the hips and aimed his cock. Karla gasped
                when he entered her, then shook as he fucked her from behind,
                both of them moaning. \"I took one out,\" Debbie announced in
                the walkie-talkie... ";
                break;
            case 11:
                "This book is called \"Strip Poker\":\n
                ...I took my two cards off the table, and examined my hand.
                I could hardly hide my excitement. I had gambled for three
                of a kind, but I got a full house! This was my chance. I
                looked at the man across the table, who's eyes were wandering
                over my bare tits, and said, \"I would like to raise the
                stakes a little. If you win this round, I've lost my panties
                and I sit here completely naked, and the game is over, right?\"
                \"Right,\" he said. \"But, if you're willing to... let me win
                back all of my clothes with this game, I will bet...\" I
                hesitated for a moment. \"I will bet... my pussy.\" \"You
                mean I can...\" he started. \"Yes,\" I said, \"If you win,
                you may do with my pussy what you like.\" He smiled, and
                said, \"If you're THAT sure, I propose something else. I will
                bet all of your clothes, AND the photographs, if you will
                bet... your ass.\" I flushed. He wanted my ass. Nobody had had
                my ass before. But I was sure to win, and then I would have
                the photographs, and I could LEAVE. \"All right,\" I said,
                and immediately followed with, \"I'll see you.\" I opened
                my cards, and looked him right in the eyes. He smiled, and
                slowly put his cards on the table. He had four jacks. I had
                lost. \"But...\" I started. He stood up, and said in a
                harsh voice, \"All right, bitch. Drop your panties and bend
                over!\"... ";
                break;
            case 14:
                "What do you want? Do you want to read all those books again?
                All right, I'll let you start over at the beginning. ";
                self.number := 0;
                break;
            default:
                "Haven't you had enough, already? You have some adventuring
                to do, instead of reading about it! ";
                break;
        }
    }
;

whip: betitem
    weight = 3
    bulk = 2
    location = ilsa_chest
    sdesc = "sturdy whip"
    noun = 'whip' 'lash'
    adjective = 'sturdy'
    points = 1
    verIoSpankWith( actor ) = {}
    ioSpankWith( actor, dobj ) =
    {
        if  (dobj = fanny_ass or dobj = Fanny)
        {
            if  (Fanny.excitement < 20)
            {
                local yesno;
                "Wow. Fanny is not really into SM, so she should be quite
                aroused to enjoy that. Do you still want to do it?
                (YES or NO) > ";
                yesno := yorn();
                "\b";
                if  (yesno <> 1)
                {
                    "You decide not to use the whip on her right now. ";
                    return;
                }
            }
            "You slap Fanny across the ass with the whip. ";
            if  (Fanny.excitement < 20)
            {
                "\"Aiii!\" she cries out. \"Stop that, you fool!\" ";
                Fanny.excitement -= 10;
            }
            else
            {
                "It leaves a red streak across her buttocks, but in
                her excitement she seems to enjoy it. She cries out. ";
                if  (Fanny.excitement > 30)
                    "\"Punish me! I'm a naughty girl! Let me have it!\" ";
                Fanny.excitement += 5;
            }
        }
        else if  (dobj = kim_ass or dobj = Kim)
        {
            if  (not( Kim.obedience ))
            {
                if (Kim.lost <> nil)
                {
                    "\"Hey, I said you could use my <<Kim.lost.sdesc>>,
                    not that you could whip it. There must be something more
                    fun that you can think of.\" ";
                    return;
                }
                "You try to hit Kim with the whip, but she evades your
                moves, and kicks you in the happy sacks. You bend over,
                feeling violently ill. ";
                if  (Me.excitement > 15)
                {
                    "Your dick immediately becomes soft again. ";
                    Me.excitement := 0;
                }
                return;
            }
            else if  (Kim.excitement < 30)
            {
                local yesno;
                "Kim is not really into SM, so she should be quite
                aroused to enjoy that. Do you still want to do it?
                (YES or NO) > ";
                yesno := yorn();
                "\b";
                if  (yesno <> 1)
                {
                    "You decide not to use the whip on her right now. ";
                    return;
                }
            }
            "You slap Kim across the ass with the whip. ";
            if  (Kim.excitement < 30)
            {
                if (rope.location = Kim)
                    "Kim starts to curse and tries to wriggle out of the rope,
                    but to no avail. ";
                else
                {
                    "Kim jumps at you, and gives you a swift kick in the
                    groin. You back off. ";
                    Me.excitement -= 10;
                }
                Kim.excitement -= 10;
            }
            else
            {
                "\"Yes!\" she shouts. \"Make me your slave! Hit my
                ass!\" ";
                Kim.excitement += 5;
            }
        }
        else if  (dobj = ilsa_ass or dobj = Ilsa)
        {
            if  (Ilsa.drugged > 0)
                "You smack the whip against Ilsa's buttocks. It leaves a
                red streak, but she doesn't wake up. ";
            else if  (Ilsa.tied)
            {
                "You smack the whip against Ilsa's bottom. She grinds her
                teeth, and tries to wrestle from the table, but to no
                avail. You do it once more. Ilsa looks at you, sweat on her
                brow. In her eyes you see something gleaming that looks
                like... excitement. It seems to arouse her to be in
                such a humiliating position. ";
                Ilsa.excitement += 3;
            }
            else
            {
                "You swing the whip in the direction of Ilsa's bottom.
                Ilsa steps aside, and grabs the whip in her right hand.
                It swings around her wrist, but her leather gloves seem
                to enable her to withstand the pain. \"You have to get
                up earlier to try that, you fool.\" she says. She pulls
                hard, and you let go of the whip. She takes hold of it
                and approaches you menacingly. You try to walk away, but
                Ilsa cracks the whip, and you feel a stinging pain on
                your bottom. Again she hits you, and again. It hurts
                terrible! ";
                if  (Me.excitement > 15)
                {
                    "Your dick sinks down on your balls. ";
                    Me.excitement := 0;
                }
                "You run from the room. You hear Ilsa laughing behind
                your back. ";
                self.moveInto( torture_chamber );
                Me.moveInto( nw_corner );
            }
        }
        else if  (dobj = morg_ass or dobj = Morghana)
        {
            if  (Morghana.excitement < 25)
            {
                local yesno;
                "I would advise you to postpone these rough actions till
                she's a little more excited. Do you wish to continue?
                (YES or NO) > ";
                yesno := yorn();
                "\b";
                if  (yesno <> 1)
                {
                    "You decide not to use the whip on her right now. ";
                    return;
                }
            }
            "You slap Morghana across the ass with the whip. ";
            if  (Morghana.excitement < 25)
            {
                "She cries out. ";
                morghana_gets_ilsa();
            }
            else
            {
                "It leaves a red streak across her soft, pink buttocks, but
                in her excitement she seems to enjoy it. ";
                Morghana.excitement += 3;
            }
        }
        else if  (dobj = chandelier)
        {
            "You crack the whip in the direction of the chandelier. You
            hit it, and it starts to swing. ";
            if  (diamond.location = nil)
            {
                incscore( self.points );
                self.points := 0;
                diamond.moveInto( dining_room );
                "A sparkling stone falls down. ";
            }
        }
        else
        {
            "It's no use hitting "; dobj.thedesc; " with "; self.thedesc; ". ";
        }
    }
    doHint( actor ) =
    {
        switch (self.hint)
        {
            case 0:
                encrypt( 'In some very kinky games, a whip can be used
                as a sex-toy. ' );
                break;
            case 1:
                encrypt( 'If a girl is far enough aroused, she might
                even enjoy you using the whip to spank her. ' );
                break;
            case 2:
                encrypt( 'The whip is not only intended for SM games.
                You also need it for a puzzle. ' );
                break;
            default:
                randomhint();
                break;
        }
        ++self.hint;
        abort;
    }
;

book: readable, betitem
    weight = 3
    bulk = 1
    sdesc = "copy of the Kama Sutra"
    location = library
    noun = 'book' 'copy' 'sutra' 'kamasutra'
    adjective = 'kama'
    ldesc =
        "The book describes a number of sexual positions. Most of them
        look too acrobatic for you. This version contains some extra
        information on the last page. "
    readdesc =
    {
        "The last page of the book contains some interesting information.
        It says:\nYour excitement level is now "; say( Me.excitement );
        ". You need to get at least to level "; say( Me.excitement_needed );
        " to be able to have an orgasm. You have had "; say( Me.orgasms );
        " orgasm";
        if  (Me.orgasms <> 1)
            "s";
        " now. ";
        if  (Fanny.isseen)
        {
            "\nFanny's excitement level is now "; say( Fanny.excitement );
            ". She needs to get at least to level ";
            say( Fanny.excitement_needed );
            " to be able to have an orgasm. She has had ";
            say( Fanny.orgasms ); " orgasm";
            if  (Fanny.orgasms <> 1)
                "s";
            " now. ";
        }
        if  (Kim.isseen)
        {
            "\nKim's excitement level is now "; say( Kim.excitement );
            ". She needs to get at least to level ";
            say( Kim.excitement_needed );
            " to be able to have an orgasm. She has had ";
            say( Kim.orgasms ); " orgasm";
            if  (Kim.orgasms <> 1)
                "s";
            " now. ";
        }
        if  (Ilsa.isseen)
        {
            "\nIlsa's excitement level is now "; say( Ilsa.excitement );
            ". She needs to get at least to level ";
            say( Ilsa.excitement_needed );
            " to be able to have an orgasm. She has had ";
            say( Ilsa.orgasms ); " orgasm";
            if  (Ilsa.orgasms <> 1)
                "s";
            " now. ";
        }
        if  (Morghana.isseen)
        {
            "\nMorghana's excitement level is now "; say( Morghana.excitement );
            ". She needs to get at least to level ";
            say( Morghana.excitement_needed );
            " to be able to have an orgasm. She has had ";
            say( Morghana.orgasms ); " orgasm";
            if  (Morghana.orgasms <> 1)
                "s";
            " now. ";
        }
        "\n";
    }
    doHint( actor ) =
    {
        switch (self.hint)
        {
            case 0:
                encrypt( 'Read it. ' );
                break;
            case 1:
                encrypt( 'Isn\'t that information interesting? ' );
                break;
            case 2:
                encrypt( 'When you have met a girl, her statistics are
                added to the book. You can use it to keep track of
                your own and their state of arousal. ' );
                break;
            default:
                randomhint();
                break;
        }
        ++self.hint;
        abort;
    }
;

red_wine: container, alcoholitem, betitem
    maxbulk = 1
    weight = 2
    bulk = 1
    location = wine_cellar
    sdesc = "bottle of red wine"
    noun = 'bottle' 'wine'
    adjective = 'red'
    ldesc =
        "It's a 1992 red bordeaux. "
    doHint( actor ) =
    {
        switch (self.hint)
        {
            case 0:
                encrypt( 'You can drink it. ' );
                break;
            case 1:
                encrypt( 'Have you met someone who likes alcohol? ' );
                break;
            case 2:
                encrypt( 'You need at least one of the bottles of wine
                to solve a puzzle. ' );
                break;
            default:
                randomhint();
                break;
        }
        ++self.hint;
        abort;
    }
;

mineral_water: container, drinkable, betitem
    maxbulk = 1
    weight = 2
    bulk = 1
    stuff = 1
    max_stuff = 1
    drugged = nil
    location = refrigerator
    sdesc = "bottle of mineral water"
    noun = 'bottle' 'water'
    adjective = 'mineral'
    ldesc =
        "It's said to be healthy. Beuh. "
    verDoDrink( actor ) =
    {
        if  (actor <> Me)
        {
            caps(); "%you% %are% not thirsty. ";
        }
    }
    doDrink( actor ) =
    {
        caps(); "%you% gulp%s% the water down, and throw the empty
        bottle aside. It's very refreshing. ";
        self.moveInto( box );
    }
    doHint( actor ) =
    {
        switch (self.hint)
        {
            case 0:
                encrypt( 'You can drink it. ' );
                break;
            case 1:
                encrypt( 'Have you met someone who likes mineral water? ' );
                break;
            case 2:
                encrypt( 'Offer it to the girls. You might get a hint. ' );
                break;
            default:
                randomhint();
                break;
        }
        ++self.hint;
        abort;
    }
;

white_wine: container, alcoholitem, betitem
    maxbulk = 1
    weight = 2
    bulk = 1
    location = wine_cellar
    sdesc = "bottle of white wine"
    noun = 'bottle' 'wine'
    adjective = 'white'
    ldesc =
        "It's a 1993 white bordeaux. "
    doHint( actor ) =
    {
        switch (self.hint)
        {
            case 0:
                encrypt( 'You can drink it. ' );
                break;
            case 1:
                encrypt( 'Have you met someone who likes alcohol? ' );
                break;
            case 2:
                encrypt( 'You need at least one of the bottles of wine
                to solve a puzzle. ' );
                break;
            default:
                randomhint();
                break;
        }
        ++self.hint;
        abort;
    }
;

jelly: readable, betitem
    weight = 2
    bulk = 1
    sdesc = "tube"
    noun = 'tube' 'lubrication' 'jelly' 'writing'
    location = pool
    stuff = 7
    max_stuff = 7
    ldesc =
    {
        "It's a small tube of lubrication jelly. There is some
        writing on the tube. ";
        if  (self.stuff > 0)
        {
            "It contains enough jelly for about ";
            say( self.stuff ); " treatment";
            if  (self.stuff <> 1)
                "s";
            ". ";
        }
        else
            "The tube is empty. ";
    }
    readdesc =
        "On the tube it says: \"Simply LUBRICATE an item to get it more
        slippery.\" "
    verDoRecharge( actor ) =
    {
        if  (recharger.location <> Me)
            "You don't have a recharger. ";
    }
    doRecharge( actor ) =
    {
        "You refill the jelly in the tube. ";
        self.stuff := self.max_stuff;
    }
    doHint( actor ) =
    {
        switch (self.hint)
        {
            case 0:
                encrypt( 'Read the tube. ' );
                break;
            case 1:
                encrypt( 'You can lubricate things with it. ' );
                break;
            case 2:
                encrypt( 'Certain kinds of penetration are easier
                when slippery... ' );
                break;
            case 3:
                encrypt( 'There are lots of things you can lubricate in
                the game. ' );
                break;
            case 4:
                encrypt( 'You can use the jelly during sex games. ' );
                break;
            case 5:
                encrypt( 'You need the jelly to solve two puzzles. Make
                sure you keep at least two doses for that. The remaining
                doses can be used as you wish. ' );
                break;
            default:
                randomhint();
                break;
        }
        ++self.hint;
        abort;
    }
;

vibrator: container, lubeitem, betitem, hiddenItem
    weight = 2
    bulk = 1
    activated = nil
    sdesc = "battery-powered vibrator"
    noun = 'vibrator'
    location = nil
    searchLoc = teddy_bear
    ldesc =
    {
        "The vibrator is a smooth shaft of about 7 inches long.
        It is not too thick, but it derives its stimulatory
        power from the fact that it can vibrate (hence the name
        \"vibrator\") when it's powered. ";
        if  (battery.location = self)
        {
            if  (self.activated)
                "The vibrator is turned on at the moment, and
                is vibrating with a buzzing sound. ";
            else
                "The vibrator contains a battery, but is not turned
                on at the moment. ";
        }
        else
            "The vibrator is turned off at the moment. It does not
            contain a battery. ";
        if  (self.location = fanny_ass or self.location = fanny_pussy or
            self.location = kim_ass or self.location = kim_pussy or
            self.location = ilsa_ass or self.location = ilsa_pussy or
            self.location = morg_ass or self.location = morg_pussy or
            self.location = statue_ass or self.location = statue_pussy)
        {
            "The vibrator is deeply inserted in "; self.location.thedesc;
            ". ";
        }
    }
    ioPutIn( actor, dobj ) =
    {
        if  (dobj <> battery)
        {
            "You can't put "; dobj.thedesc; " into the vibrator. ";
        }
        else
            pass ioPutIn;
    }
    Grab( obj ) =
    {
            if  (obj = battery)
                self.activated := nil;
    }
    verDoPush( actor ) =
    {
        if  (self.location <> fanny_ass and self.location <> fanny_pussy and
            self.location <> kim_ass and self.location <> kim_pussy and
            self.location <> ilsa_ass and self.location <> ilsa_pussy and
            self.location <> morg_ass and self.location <> morg_pussy and
            self.location <> statue_ass and self.location <> statue_pussy)
            "Pushing the vibrator has no effect. ";
    }
    doPush( actor ) =
    {
        "If you would push the vibrator even further up ";
        self.location.thedesc; ", you wouldn't be able to get it out again. ";
    }
    verDoTurnon( actor ) =
    {
        if  (self.activated)
            "It's already turned on! ";
    }
    doTurnon( actor ) =
    {
        if  (battery.location = self)
        {
            if  (battery.stuff > 0)
            {
                "The vibrator is turned on. It starts buzzing with the
                sound of a nest of killer bees. ";
                self.activated := true;
            }
            else
                "The battery seems to be empty. ";
        }
        else
            "The vibrator won't turn on without a battery. ";
    }
    verDoTurnoff( actor ) =
    {
        if  (not( self.activated ))
            "It's not on. ";
    }
    doTurnoff( actor ) =
    {
        "Okay, the vibrator is now turned off. ";
        self.activated := nil;
    }
    doHint( actor ) =
    {
        switch (self.hint)
        {
            case 0:
                encrypt( 'It\'s a vibrator! Don\'t you know what a
                vibrator is? ' );
                break;
            case 1:
                encrypt( 'It\'s a sex-toy. ' );
                break;
            case 2:
                encrypt( 'Maybe you need it for a puzzle? ' );
                break;
            case 3:
                encrypt( 'Do you already have the battery? ' );
                break;
            case 4:
                encrypt( 'The vibrator will only work with the battery. ' );
                break;
            case 5:
                encrypt( 'You\'ll find a battery with another battery-driven
                tool. ' );
                break;
            case 6:
                encrypt( 'You\'ll need the vibrator near the end of the
                game. Save some of the battery\'s energy for that time. ' );
                break;
            default:
                randomhint();
                break;
        }
        ++self.hint;
        abort;
    }
;

graffiti: fixeditem
    sdesc = "graffiti"
    adesc = "graffiti"
    noun = 'graffiti'
    location = restroom
    count = 1
    ldesc =
        "Obviously the servants have scribbled their inner thoughts
        on the wall. "
    verDoRead( actor ) = {}
    doRead( actor ) =
    {
        switch (self.count)
        {
            case 1:
                "A hard man is good to find. ";
                break;
            case 2:
                "A cucumber is better than a man, because a cucumber never
                lets you sleep on the wet spot. ";
                break;
            case 3:
                "A husband is living proof that a woman can take a joke. ";
                break;
            case 4:
                "If you smoke after sex, you're doing it too fast. ";
                break;
            case 5:
                "Oral sex is just a matter of taste. ";
                break;
            case 6:
                "Macho does not prove mucho. ";
                break;
            case 7:
                "(You can just stop reading: there are NO hints
                between the graffiti.) ";
                break;
            case 8:
                "No woman should imitate a man. Men are not worth it. ";
                break;
            case 9:
                "As usual there is a great woman behind every idiot. ";
                break;
            case 10:
                "Women have their faults\nMen have only two:\n
                Everything they say,\nEverything they do. ";
                break;
            case 11:
                "Men play the game; women know the score. ";
                break;
            case 12:
                "A woman is a woman until the day she dies, but a man
                is only a man as long as he can. ";
                break;
            case 13:
                "Anal erotics? My butt! ";
                break;
            case 14:
                "(Really! Believe me! There are NO HINTS here!) ";
                break;
            case 15:
                "9 out of 10 dentists recommend oral sex. ";
                break;
            case 16:
                "A woman's work is never done (by men). ";
                break;
            case 17:
                "Oral sex is tops! ";
                break;
            case 18:
                "Anal sex is bottoms! ";
                break;
            case 19:
                "The more I see of men, the more I like dogs. ";
                break;
            case 20:
                "One often sees a smart man with a stupid woman, but
                one never sees a smart woman with a stupid man. ";
                break;
            case 21:
                "(Forget it. NO HINTS, I said.) ";
                break;
            case 22:
                "A woman without a man is like a fish without a bicycle. ";
                break;
            case 23:
                "Anyone can have the key to the executive's restroom, but
                once a woman gets inside, what is there? A lavatory. ";
                break;
            case 24:
                "Women still remember the first kiss when men have forgotten
                the last. ";
                break;
            case 25:
                "Equal bytes for women! ";
                break;
            case 26:
                "Sex is like snow, you never know how many inches you're
                going to get and how long it's going to last. ";
                break;
            case 27:
                "As soon as Adam had a chance, he laid the blame on women. ";
                break;
            case 28:
                "(All right. All right. Since you're so persistent, I'll
                give you a hint. But just one! You need at least two
                doses of the jelly to solve puzzles, and you should keep the
                pink potion until it's absolutely necessary to use it. And
                don't let the battery run out before you've met the queen.
                Well, technically that's more than one hint, but there you
                go. And now stop reading the graffiti, please. I'm out of
                ideas, and these really were the last hints.) ";
                break;
            case 29:
                "(I said, stop reading the graffiti.) ";
                break;
            case 30:
                "(Can't you read?) ";
                break;
            case 31:
                "(Look, I don't see what's so difficult about this.) ";
                break;
            case 32:
                "(THERE ARE NO MORE HINTS!) ";
                break;
            case 33:
                "(SOD OFF!) ";
                break;
            case 34:
                "(Blimey, I give up...) ";
                break;
            default:
                "(...) ";
                break;
        }
        ++self.count;
        "\n";
    }
;

/*
;	This function is used to encrypt the hints.
*/
encrypt: function( str )
{
    local i;
    local c;
    local s;
    local d;
    local t;

    if  (global.debugon or not( global.enigmaon ))
        s := str;
    else
    {
        d := 'abcdefghijklmnopqrstuvwxyzaABCDEFGHIJKLMNOPQRSTUVWXYZA';
        s := '';

        for (i:=1; i<=length( str ); ++i)
        {
            c := substr( str, i, 1 );
            t := find( d, c );
            if  (t = nil)
                s := s + c;
            else
                s := s + substr( d, t+1, 1 );
        }
    }

    say( s );
}

/*
;	This function gives a random hint. In the first edition of Moist, I
;	gave encrypted hints with objects, and when you had seen the last
;	hint, that last hint was repeated again and again. Since the last
;	hint often gave away the puzzle, I thought it would be easy for 
;	people just to ask for all the hints without decrypting them, and
;	when they saw a hint repeated over and over again, the could
;	simply decrypt THAT hint. Now, after the last hint has been shown,
;	one of these random hints will be shown.
*/
randomhint: function()
{
    ++global.randhint;
    if  (global.randhint > 36)
        global.randhint := 1;

    switch (global.randhint)
    {
        case 1:
            encrypt( 'Nobody expects the Spanish Inquisition! ' );
            break;
        case 2:
            encrypt( 'There\'s a difference between philosophy and a
            bumper sticker. ' );
            break;
        case 3:
            encrypt( 'If Abraham Lincoln were alive today, he would
            be desperately clawing at the inside of his coffin. ' );
            break;
        case 4:
            encrypt( 'No, mr.\ Worf. We will NOT play "Another one bites
            the dust" every time you shoot down a Romulan Warbird. ' );
            break;
        case 5:
            encrypt( 'Monsieur, it would take a miracle to get you
            out of Casablanca. ' );
            break;
        case 6:
            encrypt( 'Speed Kills! Use Windows. ' );
            break;
        case 7:
            encrypt( 'The louder he talked of his honor the faster we
            counted our spoons. ' );
            break;
        case 8:
            encrypt( 'Miss, if you lost your virginity, can I have the
            box it came in? ' );
            break;
        case 9:
            encrypt( 'Don\'t get annoyed when your neighbour plays his
            hi-fi at two o\'clock in the morning. Call him at four and
            tell him how much you enjoyed it. ' );
            break;
        case 10:
            encrypt( 'I didn\'t believe in reincarnation the last time,
            either. ' );
            break;
        case 11:
            encrypt( 'If you want to clear your system out, sit on a
            piece of cheese and swallow a mouse. ' );
            break;
        case 12:
            encrypt( 'Wealth is not his who has it, but his who enjoys it. ' );
            break;
        case 13:
            encrypt( 'It was a bold man who first ate an oyster! ' );
            break;
        case 14:
            encrypt( 'It\'s hard to fly with eagles when you work with
            turkeys. ' );
            break;
        case 15:
            encrypt( 'Black holes were created when God divided by zero. ' );
            break;
        case 16:
            encrypt( 'A banana is not in fact a fruit, but a very large
            herb. Amazing. ' );
            break;
        case 17:
            encrypt( 'My son has taken up meditation. At least it\'s better
            than sitting doing nothing. ' );
            break;
        case 18:
            encrypt( 'Dogs crawl under Gates, software under Windows. ' );
            break;
        case 19:
            encrypt( 'Money can\'t buy friends, but you can get a better
            class of enemy. ' );
            break;
        case 20:
            encrypt( 'Superstition brings bad luck. ' );
            break;
        case 21:
            encrypt( 'Why do we never see a headline \'Psychic Wins
            Lottery\'? ' );
            break;
        case 22:
            encrypt( 'Captain, why not give the Borg Windows 95? ' );
            break;
        case 23:
            encrypt( 'Decorating tip #4: To make a dark room look
            brighter, try turning on the electrical lights. ' );
            break;
        case 24:
            encrypt( 'Don\'t confuse me with facts, my mind is already
            made up! ' );
            break;
        case 25:
            encrypt( 'You can\'t win \'em all, but you can sure lose \'em all. ' );
            break;
        case 26:
            encrypt( 'To remove crow\'s feet completely, hit them hard on
            the toes with a claw hammer. ' );
            break;
        case 27:
            encrypt( 'Just for once, wouldn\'t you like to see a smoker get
            deathly ill from the odour of your cologne? ' );
            break;
        case 28:
            encrypt( 'If God did exist, religion wouldn\'t be necessary. ' );
            break;
        case 29:
            encrypt( 'There IS intelligent life on Earth, but I\'m just
            visiting. ' );
            break;
        case 30:
            encrypt( 'Does history show any occassion when the majority
            was actually right? ' );
            break;
        case 31:
            encrypt( 'Fuck me if I\'m wrong, but is your name Debbie? ' );
            break;
        case 32:
            encrypt( 'Any clod can have the facts, but having an opinion is
            an art. ' );
            break;
        case 33:
            encrypt( 'If you tell a joke in the forest but nobody laughs,
            was it a joke? ' );
            break;
        case 34:
            encrypt( 'I\'d rather have a bottle in front of me than a
            frontal lobotomy. ' );
            break;
        case 35:
            encrypt( 'I\'m not under the alkafluence of inkahol that some
            thinkle peep I am. It\'s just that the drunker I sit here, the
            longer I get. ' );
            break;
        case 36:
            encrypt( 'And now a word for dog lovers. Kinky. ' );
            break;
        default:
            encrypt( 'There are no more hints. ' );
            break;
    }
}

