/* FIRST THINGS FIRST - classes.t
/*  Copyright (c) 1996, 1997, 1999, 2000 by J. Robinson Wheeler. All Rights Reserved. */

/*
 *			****	NEW ITEM AND CLASS DEFINITIONS		****
 */

/*	staticItem: class
 *
 *	Static items are fixed items, only the verDoTake says "It's fixed in place. "
 *	instead, and the item will be parsed during a "get all" command.
 */
class staticItem: fixeditem
	isfixed = nil
	stationary = true
	adesc = 
	{
		if ( self.isThem )
			"some <<self.sdesc>>";
		else
			"a <<self.sdesc>>";
	}
	verDoTake ( actor ) =
	{
		"\^<<self.itisdesc>> fixed in place. ";
	}
	verDoDrop( actor ) = 
	{
		if ( not self.isIn( Me ) )
			"You aren't carrying <<self.itobjdesc>>. ";
	}
	doDrop( actor ) =
	{
		"[BUG! <<self.sdesc>> shouldn't be in player's inventory] \b";
		pass doDrop;
	}
;

/*	block: class
 *
 *	This is a new class of object, similar to the "decoration" class in ADV.T, but
 *	isn't as fancy. Basically it just makes sure to say "I see nothing special about
 *	the ______. " when the player examines such an object. It's used to make items
 *	described in the room ldesc available to the parser.
*/
class block: staticItem
	stationary = true
	ldesc = 
	{
		"I see nothing special about <<self.thedesc>>. ";
	}
	
	verDoCheckWith( actor, io ) = 
	{
		"\^<<self.itnomdesc>> <<self.isdesc>> merely decorative, but not a 
		red herring. ";
	}
;

/*	Same as above, only the item will not show up in "get all" listings.
 */
class fixedBlock: block
	isfixed = true
;

class unimportantItem: fixedBlock
	unimportantMsg = "\^<<self.thatdesc>> <<self.isntdesc>> important. "
	ldesc = { self.unimportantMsg; }
	dobjGen(a, v, i, p) =
	{
		if ( v != askVerb && v != tellVerb && v != inspectVerb &&
			 v != whereIsVerb && v != checkVerb && v != powVerb )
		{
			self.unimportantMsg;
			exit;
		}
	}
	iobjGen(a, v, d, p) = { self.dobjGen(a, v, d, p); }
	verDoCheckWith( actor, io ) = 
	{
		"\^<<self.itnomdesc>> <<self.isdesc>> merely decorative, but not a 
		red herring. ";
	}
;

class locationDesc: unimportantItem
	thedesc = "this location"
	ldesc = { self.location.lookAround( true ); }
	noun = 'here' 
	adjective = 'location' 'room' 'area' 'environs' 'environment' 'locale'
	unimportantMsg = "You don't need to refer to <<self.thedesc>> like that. "
	verDoWhereIs( actor ) = { "You're standing inside it. "; }
;


/*	A bookItem is an item that can be read or consulted.
 */
class bookItem: readable, openable
	isBook = true
	isopen = nil
	contentsVisible = { return true; }
	contentsReachable = { return true; }
	maxbulk = 1
	validTopicList = []
		
	verIoPutIn( actor ) =
	{
		"\^<<self.thedesc>> isn't something that can hold items. ";
	}
	
	doOpen( actor ) = 
	{
		inherited.doOpen( actor );
		"\b"; self.readdesc;
	}
	verDoLookin( actor ) = {}
	doLookin( actor ) = 
	{
		if ( not self.isopen )
		{
			"(first opening <<self.thedesc>>)\b";
			self.isopen := true;
		}
		"\b"; self.readdesc;
	}
	
	verDoAskAbout( actor, io ) = {}
	doAskAbout( actor, io ) =
	{
		self.doConsultAbout( actor, io );
	}
	
	verDoConsultAbout( actor, io ) = {}
	doConsultAbout( actor, io ) =
	{
		switch( io )
		{
			"\^<<self.thedesc>> contains no information about that subject. ";
		}
	}
	verIoLookupIn( actor ) = {}
	ioLookupIn( actor, dobj ) = { self.doConsultAbout( actor, dobj ); }
;

class libraryBookItem: bookItem
	plural = 'books'
	doSellTo( actor, io ) =
	{
		"The merchant says, \"Say, this is a library book. I can't buy a 
		library book from you.\" ";
		return( true );
	}
	verDoDrawOnWith( actor, io ) = 
	{
		"\^<<self.thedesc>> doesn't belong to you. You should return it
		in good condition. ";
	}
	verIoDrawOn( actor ) = 
	{
		"\^<<self.thedesc>> doesn't belong to you. You should return it
		in good condition. ";
	}
;

class buyable: item
	isListed = nil
	myMerchant = nil
	startLoc = nil
	cost = 0
	
	verDoTake( actor ) =
	{
		if ( not self.boughtOnce && not actor.islit )
		{
			"%You% have to buy "; self.thedesc; ". ";
		}
		else if ( self.isIn( actor ) )
		{
			"%You% already %have% "; self.thedesc; "! ";
		}
		else self.verifyRemove( actor );
	}
	
	verDoBuyFrom( actor, io ) =
	{
		if ( io = self.myMerchant )
			self.verDoBuy( actor );
		else
			"\^<<io.thedesc>> isn't selling <<self.thatdesc>>. ";
	}
	doBuyFrom( actor, io ) =
	{
		self.doBuy( actor );
	}
	
	verDoBuy( actor ) =
	{
		if ( self.boughtOnce = true )
		{
			"You already bought <<self.adesc>>. ";
		}
	}
	doBuy( actor ) =
	{
		if ( global.money >= self.cost )
		{
			self.boughtOnce := true;
			playerCash.value -= self.cost;
			global.money := playerCash.value;
			
			if ( playerCash.value = 0 )
				playerCash.moveInto( nil );
			
			self.moveInto( actor );
			self.isListed := true;			// listed normally from now on
			return( true );
		}
		else if ( global.money > 0 )
			"Don't waste <<self.myMerchant.thedesc>>'s time. You don't have 
			enough money. ";
		else
			"Don't waste <<self.myMerchant.thedesc>>'s time. You don't have 
			any money. ";
		return( nil );
	}
	askingAboutMe( who ) =
	{
		if ( who = antiqueMerchant )
		{
			if ( self.boughtOnce ) 
				"She says, \"You bought that already.\" ";
			if ( self.salesPitch ) self.salesPitch;
			else
				"The merchant says, \"It's a lovely piece.\" ";
			return( true );
		}
		else pass askingAboutMe;
	}
;

class sellable: item
	sellToComment = ""
	sellValue = 0
	
	verDoSell( actor ) = {}
	doSell( actor ) = { askio( toPrep ); }
	
	doSellTo( actor, io ) =
	{
		local yesno, temploc;
		
		if ( self.location = nil || topLocation( self ) != antiqueStore ) {
			"The merchant says, \"I can't tell you whether I'd be interested in 
			buying that unless I can see <<self.isThem ? "them" : "it">> for 
			myself.\" ";
			return( nil );
		}
		
		temploc := nil;
		
		"The merchant says, \""; self.sellToComment;
		
		"I'll give you $<<self.sellValue>> for it. Deal?\" \b>>";
		
		yesno := yorn();
		
		if ( yesno = 1 )
		{
			"The merchant tucks <<self.thedesc>> away into a back room, 
			then returns and hands you the money. \b
			
			The merchant says, \"All righty. Here you are. Thank you.\" ";
			
			self.sold := true;
			self.moveInto( nil );
			if ( playerCash.location != nil ) 
			{
				temploc := playerCash.location;
				playerCash.moveInto( Me );
			}
			handleMoneyTrade( playerCash, self.sellValue );
			if ( temploc != nil )
			{
				if ( temploc.deepIsIn( antiqueStore ) )
				{
					playerCash.moveInto( temploc );
					if ( temploc != Me )
						"\bYou put the money into <<temploc.thedesc>> along
						with the rest of it. ";
				}
				else
					"\bYou somehow gather all of your money together
					along with the new cash.\b
					[It is now in your hands, and not where you last
					left it. Presto!]";
			}
		}
		else
		{
			"The mechant says, \"Well, whatever. Have a nice day.\" ";
		}
		return( true );
	}
	askingAboutMe( who ) =
	{
		if ( who = antiqueMerchant )
		{
			if ( self.sold )
				"The antique merchant says, \"It is rather nice, 
				for an old <<self.sdesc>>.\" ";
			if ( topLocation( self ) != who.location ) {
				"She says, \"I can't tell you whether I'd be interested
				in buying it unless I see it for myself.\" ";
			}
			else 
				self.doSellTo( Me, who );
			return( true );
		}
		else pass askingAboutMe;
	}
;

class antiqueItem: buyable
	isListed = true
	myMerchant = antiqueMerchant
	startLoc = antiques
	sellValue = 0
	cost = 0
	salesPitch = "The merchant says, \"Ah yes. That's quite a good <<self.sdesc>>.\" "
	
	doBuy( actor ) =
	{
		if ( global.money >= self.cost )
		{
			local yesno;
			
			"The merchant says, \"$<<self.cost>> for it. Deal?\" \b>";
			
			yesno := yorn();
		
			if ( yesno = 1 )
			{
				"The merchant says, \"All righty. Here you are. Thank you.\" ";
				
				self.boughtOnce := true;
				playerCash.value -= self.cost;
				global.money := playerCash.value;
				
				if ( playerCash.value = 0 )
					playerCash.moveInto( nil );
				
				self.moveInto( actor );
				self.isListed := true;			// listed normally from now on
				return( true );
			}
			else
			{
				"The mechant says, \"Well, whatever. Have a nice day.\" ";
			}
			return( true );
		}
		else if ( global.money > 0 )
			"Don't waste <<self.myMerchant.thedesc>>'s time. You don't have 
			enough money. ";
		else
			"Don't waste <<self.myMerchant.thedesc>>'s time. You don't have 
			any money. ";
		return( nil );
	}
	verDoSell( actor ) = 
	{
		if ( not self.boughtOnce )
			"You can't sell something you don't even own yet! ";
	}
	doSell( actor ) = { askio( toPrep ); }
	
	verDoSellTo( actor, io ) = 
	{
		if ( not self.boughtOnce )
			"You can't sell something you don't even own yet! ";
	}
	doSellTo( actor, io ) =
	{
		if ( self.boughtOnce )
			"The merchant says, \"You do realize this is <<self.thedesc>> that I 
			just sold to you, don't you?\" \b";
		else
			"The merchant gives you a funny look. ";
		return( nil );
	}
	
	leaving( actor ) = 
	{
		return( self.boughtOnce );
	}
	
	askingAboutMe( who ) =
	{
		if ( who = antiqueMerchant )
		{
			if ( self.location = nil )
				"She says, \"It's a lovely <<self.sdesc>>.\" ";
			self.doSellTo( Me, who );
			return( true );
		}
		else pass askingAboutMe;
	}
;

class seeThruItem: seethruItem
	verDoLookin( actor ) = {}
	doLookin( actor ) = { self.thrudesc; }
;

/*	houseWindow items are what they seem: decoration objects to give the
 *	exterior of the house some windows that can't be opened, pried with 
 *	a crowbar, broken, or attacked.
*/
class houseWindow: fixedBlock, seeThruItem
	sdesc = "windows"
	isHouseWindow = true
	thrudesc = "The windows are closed and locked from the inside, with the 
			blinds closed. "
	noun = 'window'
	plural = 'windows'
	isThem = true
	adjective = 'front'
	
	verDoOpen( actor ) = 
	{
		"You can't open the windows from the outside. ";
		self.thrudesc;
	}
	verDoBreak( actor ) = { "You aren't very interested in risking getting
		cut on broken glass, or in paying to replace a broken window. "; }
	verDoAttackWith( actor, obj ) = { "You aren't inclined to risk getting
		cut on broken glass, or to have to replace a broken window. "; }
	verDoEnter( actor ) = { "The windows are closed and locked from the inside, 
		with the blinds closed. "; }
;

class FhouseWindow: houseWindow
	ldesc = "The windows are closed and locked from the inside, with the 
			blinds closed. Many of them are broken. "
;

class unimportantWindow: unimportantItem, seeThruItem
	thrudesc = { self.ldesc; }
	verDoBreak( actor ) = { "You aren't inclined to risk getting cut on
		broken glass. "; }
	verDoAttackWith( actor, obj ) = { "You aren't inclined to risk getting
		cut on broken glass. "; }
	dobjGen(a, v, i, p) =
	{
		if ( v != askVerb && v != tellVerb && v != inspectVerb &&
			v != whereIsVerb && v != lookInVerb && v != lookThruVerb &&
			v != breakVerb && v != attackVerb )
		{
			"\^<<self.thatdesc>> <<self.isntdesc>> important.";
			exit;
		}
	}
;

modify movableActor
	verGrab( item ) =
	{
		if ( !global.wizard ) 
			"\^<<self.thedesc>> <<self.isdesc>> <<item.isworn ? "wearing" : 
			"carrying">> <<item.thedesc>> and won't let %youm% have <<item.itobjdesc>>. ";
	}
;

modify keyedLockable
	ioTurnIn( actor, dobj ) =
	{
		if ( dobj = mykey )
		{
			if ( self.islocked )
				self.doUnlockWith( actor, dobj );
			else
				self.doLockWith( actor, dobj );
		}
		else
			"\^<<dobj.itnomdesc>> <<dobj.doesdesc>>n't fit the lock. ";
	}
;

modify keyItem
	verDoTurn( actor ) = {}
	doTurn( actor ) = { askio( inPrep ); }
	
	verDoTurnIn( actor, io ) = {}
	
	verIoStartWith( actor ) = {}
	
	verIoOpenWith(actor) = {}
	ioOpenWith( actor, dobj ) =
	{
		dobj.doUnlockWith( actor, self );
	}
;

class doubleKeyedLockable: keyedLockable
	mykey( keyObj ) = 
	{
		if ( keyObj = self.mykey1 || keyObj = self.mykey2 )
			return( true );
		return( nil );
	}
	verDoOpen( actor ) = {}
	doOpen( actor ) =
	{
		if ( self.islocked )
		{
			if ( !( mykey1.deepIsIn( Me ) || mykey2.deepIsIn( Me ) ) )
			{
				"\^<<self.itisdesc>> locked. ";
			}
			else
			{
				if ( mykey1.deepIsIn( Me ) && mykey2.deepIsIn( Me ) )
				{
					askio( withPrep );
				}
				else if ( mykey1.deepIsIn( Me ) )
				{
					"(with <<mykey1.thedesc>>)\n";
					deepGrab( mykey1 );
					self.doUnlockWith( actor, mykey1 );
				}
				else
				{
					"(with <<mykey2.thedesc>>)\n";
					deepGrab( mykey2 );
					self.doUnlockWith( actor, mykey2 );
				}
			}
		}
		else pass doOpen;
	}
	
	doLockWith( actor, io ) =
	{
		if ( self.isopen )
		{
			"%You% can't lock <<self.thedesc>> when <<
			self.itisdesc>> open. ";
		}
		else if ( self.mykey( io ) )
		{
			"Locked. ";
			self.islocked := true;
		}
		else
			"\^<<io.itnomdesc>> <<io.doesdesc>>n't fit the lock. ";
	}
	verDoUnlockWith(actor, io) =
	{
		if ( not self.islocked )
			"\^<<self.itisdesc>> not locked! ";
	}
	doUnlockWith( actor, io ) =
	{
		if ( self.mykey( io ) )
		{
			"Unlocked. ";
			self.islocked := nil;
		}
		else
			"\^<<io.itnomdesc>> <<io.doesdesc>>n't fit the lock. ";
	}
;


/*	class: pencilitem
 *	This new class includes any object that can be used to write or draw with.
 *	Mainly, it's a normal item with the flag "ispencil" set to true.
*/
class pencilItem: priseItem
	ldesc = 
	{
		if ( self.chewedOn )
			"It sports a set of teeth marks where you've chewed it. ";
	}
	adjective = 'tooth' 'teeth' 'marks'
	plural = 'pencils'
	ispencil = true
	
	verIoDrawOnWith( actor ) = {}
	ioDrawOnWith( actor, dobj ) =
	{
		"The pencil is too blunt to draw much of a line on <<dobj.thedesc>>. ";
	}
	
	verDoBite( actor ) = {}
	doBite( actor ) =
	{
		if ( not self.chewedOn )
		{
			"You chew on the pencil, leaving teeth marks. ";
			self.chewedOn := true;
		}
		else
			"You chew on the pencil, leaving more teeth marks. ";
	}
	
	ioPryWith( actor, dobj ) = 	
	{
		"The pencil isn't a good tool for prying. It will break if
		you do that. ";
	}
;

modify doorway
	doKnock( actor ) =
	{
		"You knock on <<self.thedesc>>. There is no response. ";
	}
	verDoOpenWith( actor, io ) = {}
;

/*	class: garageDoorItem
 *	GarageDoorItems are basically like doors, only they cannot be opened by hand.
 *	They are not locked per se, but you need to push a garage door opener button
 *	in order to activate them.
*/
class garageDoorItem: doorway
	doOpen( actor ) =
	{
		"The garage door refuses to open. ";
	}
	doClose( actor ) =
	{
		"The garage door refuses to close. ";
	}
	ldesc =
	{
		if ( self.isopen )
			"It's open. ";
		else
			"It's closed. ";
	}
	verDoLift( actor ) = { self.verDoOpen( actor ); }
	doLift( actor ) = { self.doOpen( actor ); }
;

modify buttonitem
	adjective = 'buttton'
;

/*	class: garageOpenerItem
 *	This type of item is a button that will control a garageDoorItem, using garageState()
 *	to handle the action.
*/
class garageOpenerItem: buttonitem
	sdesc = "opener button"
	adesc = "an opener button"
	adjective = 'garage' 'door' 'opener'
	bulk = 0
	
	doPush ( actor ) =
	{
		"You push the <<self.sdesc>>. Click. ";
		if ( Me.location = northOfHouse )
			garageState( garageDoor1, true );
		else if ( Me.location = driveway )
			garageState( garageDoor1, nil );
		else if ( Me.location = inGarage )
			garageState( garageDoor2, true );
		else
			"Nothing happens. ";
	}
;

class secretDoorWall: staticItem
	isSecret = true
	sdesc = "wall"
	ldesc = 
	{
		if ( self.myDoor.location = nil )
		{
			"You always thought that the wall on this side of the house would make a 
			great place to hide a secret door. Again, you are reminded of your lack 
			of foresight. If there were a door here, you could get in that way. ";
		}
		else
		{
			"You always thought that the wall on this side of the house would make a 
			great place to hide a secret door. Perhaps the architect came through. ";
		}
	}
	noun = 'wall' 
	adjective = 'house'
	noAutoOpen = true
	
	verDoOpen( actor ) =
	{
		if ( self.myDoor.location = nil )
			"I don't know how to open <<self.thedesc>>. ";
	}
	doOpen( actor ) =
	{
		self.myDoor.doOpen( actor );
	}
	
	verDoKnock( actor ) =
	{
		if ( self.myDoor.isopen )
			"You knock on <<self.thedesc>>. Nothing happens, because
			the secret door is already open. ";
	}
	doKnock( actor ) =
	{
		if ( self.mySwitch.steppedOn )
		{
			"You hear a weight dropping, and a couple of clicks. The
			secret door springs magically open wide, revealing a 
			darkened entrance. ";
			self.myDoor.isopen := true;
		}
		else
		{
			"You knock on the wall. It sounds <<self.myDoor.location ?
			"hollow" : "solid">>. ";
		}
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Yeah, sometimes south-facing walls don't have 
				windows or doors because they get most of the direct sunlight.
				I guess it would be kind of cool to have a secret passage in
				from there.\" ";
				return( true );
			case Architect:
				if ( not blueprint.secretpassage )
					"He says, \"Hm, yes, the south-facing wall is rather bland
					and featureless. It's deliberate, though.\" ";
				else
					"He says, \"The south-facing wall will be rather bland and
					featureless to the unsuspecting eye. But that's where the
					secret door will be hidden! Ooh, this is going to be fun.\" ";
				return( true);
			default: 
				return( nil );
		}
	}
;

class secretDoorItem: doorway
	isSecret = true
	sdesc = "secret door"
	ldesc = 
	{
		if ( self.isopen )
			"It's open. ";
		else
			"You can't see it. It must be closed. ";
	}
	noun = 'door' 'passage'
	adjective = 'secret'
	isopen = nil
	noAutoOpen = true
	location = nil
	
	doOpen( actor ) =
	{
		"You can't find <<self.thedesc>> to open it. There must be some 
		kind of secret switch. ";
	}
	verDoDrawOn( actor, io ) = {}
	
	doKnock( actor ) =
	{
		if ( self.isopen )
			"You knock on <<self.thedesc>>. Nothing happens, because
			it's already open. ";
		else if ( self.mySwitch.steppedOn )
			self.myWall.doKnock( actor );
	}
	doClose( actor ) =
	{
		"You close the secret door. It vanishes from sight, and you hear
		springs and tumblers ratcheting back into place. ";
		
		self.setIsopen( nil );
		self.mySwitch.steppedOn := nil;
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Secret doors. Cool. Not sure how you'd find
				one if it were really secret. I guess you have to poke around,
				feel the walls, turn over rocks, pull levers, see if anything
				in the area does something.\" ";
				return( true );
			case Laura:
				"Laura says, \"Wow. I've always thought secret doors were a 
			 	fun idea. Of course, part of why they're fun is that no one
				but you knows how to find them! But if you don't know how to
				find it and it's your own, you're kind of in a pickle. Unless
				it's actually supposed to be kind of obvious. Like, whoever
				designed the mechanism, if you could talk to that person...\" ";
				return( true );
			case Architect:
				if ( blueprint.secretpassage = nil )
					"He seems lost in thought for a moment. \"What are you talking 
					about?\"  Perhaps you should take it upon yourself to pencil it 
					in for him. ";
				else
					"He beams. \"I'm glad I thought of it.\"  He points at the 
					blueprint. \"It will be here, on the south side of your house.
					The door will open by means of a secret switch in the ground. 
					Step on the switch, knock on the wall, and the door will open!\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

class secretSwitchItem: fixedBlock
	isSecret = true
	sdesc = "secret switch"
	ldesc = 
	{
		if ( secretSwitch.found )
			"It looks amazingly like nothing in particular at all. ";
		else
			"You can't see anything that looks like a secret switch
			around here. ";
	}
	noun = 'switch'
	adjective = 'secret'
	location = nil
	steppedOn = nil
	
	verDoStandon( actor ) =
	{
		if ( self.steppedOn )
			"Nothing happens. ";
	}
	doStandon( actor ) =
	{
		"You put your foot onto the secret switch. It moves under your
		weight, and you hear some kind of tumbler shift inside the wall. ";
		self.steppedOn := true;
	}
	
	verDoFind( actor ) = 
	{
		if ( secretSwitch.found )
			"You have already found the secret switch and remember 
			where it is. ";
	}
	doFind( actor ) =
	{
		if ( secretSwitch.askedArchitectAbout )
			theFloor.discoverSwitch( secretSwitch );
		else
			"You aren't quite sure where you might need to look. ";
	}
	
	dobjGen(a, v, i, p) =
	{
		if ( not secretSwitch.found && v != askVerb && v != tellVerb && 
			v != inspectVerb && v != findVerb && v != drawOnVerb )
		{
			"You can't see where it is. ";
			exit;
		}
	}
	iobjGen(a, v, d, p) = { self.dobjGen( a, v, d, p); }
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Secret doors. Cool. Not sure how you'd find
				one if it were really secret. I guess you have to poke around,
				feel the walls, turn over rocks, pull levers, see if anything
				in the area does something.\" ";
				return( true );
			case Laura:
				"Laura says, \"Wow. I've always thought secret doors were a 
			 	fun idea. Of course, part of why they're fun is that no one
				but you knows how to find them! Maybe you could ask whoever 
				designed the mechanism.\" ";
				return( true );
			case Architect:
				if ( blueprint.secretpassage )
				{
					"He says, \"The secret switch will be hidden on the ground
					next to the wall. Step on the switch, knock on the wall, and 
					the door will open!\" ";
					
					secretSwitch.askedArchitectAbout := true;
					return( true );
				}
				else return( nil );
			default: 
				return( nil );
		}
	}
;

modify theFloor
	sdesc = "<<self.location.indoors ? "floor" : "ground">>"
	adesc = { self.thedesc; }
	ldesc = { self.location.floorDesc; }
	
	verDoDigWith( actor, io ) = 
	{
		if ( self.location.indoors )
			"You can't dig into the floor here. ";
		else
			"The ground is too hard for digging here. ";
	}
	
	verDoStandon( actor ) = {}
	doStandon( actor ) =
	{
		if ( actor.location.location )
			actor.location.doUnboard( actor );
		else
			"You are already standing on <<self.thedesc>>. ";
	}
	
	verDoSearch( actor ) = {}
	doSearch( actor ) = 
	{
		switch( Me.location )
		{
			case southOfHouse:
				if ( secretDoor.location )
				{
					if ( secretSwitch.found )
						"You find nothing else of interest. ";
					else
						self.discoverSwitch( secretSwitch );
				}
				else
					"%You% find nothing of interest. "; 
				break;
			case FsouthOfHouse:
				if ( FsecretDoor.location )
				{
					if ( FsecretSwitch.found )
						"You find nothing else of interest. ";
					else
						self.discoverSwitch( FsecretSwitch );
				}
				else
					"%You% find nothing of interest. "; 
				break;
			case NFsouthOfHouse:
				if ( NFsecretDoor.location )
				{
					if ( NFsecretSwitch.found )
						"You find nothing else of interest. ";
					else
						self.discoverSwitch( NFsecretSwitch );
				}
				else
					"%You% find nothing of interest. "; 
				break;
			case FmasterBedroom:
				if ( FmasterBedroomSecretDoor.location )
				{
					if ( FmasterBedroomSecretSwitch.found )
						"You find nothing else of interest. ";
					else
						self.discoverSwitch( FmasterBedroomSecretSwitch );
				}
				else
					"%You% find nothing of interest. "; 
				break;
			default: "%You% find nothing of interest. "; break;
		}
	}
	
	discoverSwitch( theSecretSwitch ) =
	{
		"You search along <<self.thedesc>> near the base of the wall. After
		a few passes, your hand moves across a flat area, about four inches
		across. It has been colored and textured to look like <<self.thedesc>>, 
		but it feels different to the touch. This must be the switch. ";
		
		secretSwitch.found := true;
		FsecretSwitch.found := true;
		NFsecretSwitch.found := true;
		
		switch ( global.timeLoc )
		{
			case 3: setit( secretSwitch ); break;
			case 4: setit( FsecretSwitch ); 
					if ( future.state < 3 ) 
						"It escaped being destroyed in the fire, but 
						there's no chance the rest of the mechanism for
						opening the door is intact. ";
					break;
			case 5: setit( NFsecretSwitch ); break;
		}
	}
;

class socketItem: fixedBlock
	sdesc = "socket"
	noun = 'socket'
	adjective = 'outlet'
	hasJuice = true
	
	verIoPlugIn( actor ) = {}
	ioPlugIn( actor, dobj ) =
	{
		local appliance;
		
		if ( isclass( dobj, pluggable ) )
			appliance := dobj;
		else if ( isclass( dobj, plugItem ) )
			appliance := dobj.myOwner;
		else
		{
			"That isn't something you can plug into <<self.thedesc>>. ";
			return;
		}
		
		if ( appliance.deepIsIn( Me ) )
		{
			"\n(first dropping <<appliance.thedesc>>) \b";
			appliance.moveInto( self.location );
		}
		
		"Okay, you plug <<appliance.thedesc>> into <<self.thedesc>>. ";
		appliance.myPlug.pluggedIn := self;
	}
	
	verIoUnplugFrom( actor ) = {}
	ioUnplugFrom( actor, dobj ) =
	{
		local appliance;
		
		if ( isclass( dobj, pluggable ) )
			appliance := dobj;
		else if ( isclass( dobj, plugItem ) )
			appliance := dobj.myOwner;
		else 
		{
			"That isn't something you can unplug from <<self.thedesc>>. ";
			return;
		}
		appliance.doUnplug( actor );
	}
;

dummyPlug: item
	sdesc = "[BUG]"
;

class pluggable: item
	myPlug = dummyPlug
		
	verDoSwitch( actor ) = { self.verDoTurnon( actor ); }
	doSwitch( actor ) = { self.doTurnon( actor ); }
	
	verDoTake( actor ) = 
	{
		if ( self.myPlug.pluggedIn )
			"You'll have to unplug it from <<self.myPlug.pluggedIn.thedesc>> first. ";
	}
	verDoTurnon( actor ) = 
	{
		if ( self.isActive )
			"\^<<self.itisdesc>> already on. ";
		else if ( self.myPlug.pluggedIn = nil )
			"You'll have to plug it in first. ";
		else if ( not self.myPlug.pluggedIn.hasJuice )
			"There doesn't seem to be any electricity working here. ";
	}
	verDoTurnoff( actor ) =
	{
		if ( not self.isActive )
			"\^<<self.itisdesc>> already turned off. ";
	}
	doTurnoff( actor ) =
	{
		"Okay, <<self.itisdesc>> now turned off. ";
		self.isActive := nil;
	}
	verDoUnplugFrom( actor, io ) = { self.doUnplug( actor ); }
	verDoUnplug( actor ) =
	{
		if ( self.myPlug.pluggedIn = nil )
			"\^<<self.thedesc>> isn't plugged into anything at the moment. ";
	}
	doUnplug( actor ) = 
	{
		"You unplug <<self.thedesc>> from <<self.myPlug.pluggedIn.thedesc>>. ";		
		if ( self.isActive )
			self.doTurnoff( actor );
		self.myPlug.pluggedIn := nil;
	}
	verDoPlugIn( actor, io ) = 
	{
		if ( self.myPlug.pluggedIn )
			"\^<<self.thedesc>> is already plugged 
			into <<self.myPlug.pluggedIn.thedesc>>. ";
	}
;

dummyOwner: item
	sdesc = "[BUG]"
;

class plugItem: fixedBlock
	ldesc = 
	{
		"\^<<self.thedesc>> is ";
		if ( self.pluggedIn )
			"plugged into <<self.pluggedIn.thedesc>>. ";
		else 
			"dangling from the back of <<self.myOwner.thedesc>>. ";
	}
	noun = 'cord'
	myOwner = dummyOwner
	
	verDoTake( actor ) =
	{
		"\^<<self.thedesc>> is attached to <<self.myOwner.thedesc>> and 
		can't be removed. ";
	}
	
	verDoPull( actor ) = { self.verDoUnplug( actor ); }
	doPull( actor ) = { self.doUnplug( actor ); }
	
	verDoUnplugFrom( actor, io ) = { self.doUnplug( actor ); }
	verDoUnplug( actor ) =
	{
		if ( self.pluggedIn = nil )
			"\^<<self.thedesc>> isn't plugged into anything at the moment. ";
	}
	doUnplug( actor ) = 
	{
		"You unplug <<self.thedesc>> from <<self.pluggedIn.thedesc>>. ";		
		if ( self.myOwner.isActive )
			self.myOwner.doTurnoff( actor );
		self.pluggedIn := nil;
	}
	verDoPlugIn( actor, io ) = 
	{
		if ( self.pluggedIn )
			"\^<<self.thedesc>> is already plugged into <<self.pluggedIn.thedesc>>. ";
	}
;

modify chairitem
	canReachContents = true
;

/********************************* Time Machine objects **************************/

/*	This is the machine that makes the game the game it is. All of the fancy code
 *	to make it move is actually below, in the timeButton object. The heat setting
 *	is used to add both a detail and the solution to a puzzle:  the machine heats
 *	up during a jump, and takes a number of turns to cool off. Items placed on top
 *	of the machine or in the compartment are heated as well.
*/
class timeMachineItem: staticItem
	isListed = true
	sdesc = "time machine"
	ldesc =
	{
	 	"It's a large contraption that's about the size and shape of an engine block, 
		and made of solid metal. It sits on a platform that is welded firmly to the 
		machine itself. On the front is a knob and a large red button. On the back 
		side of it is a hinged compartment. There is a label on the knob. ";
		
		if ( self.heat > 0 )
		{
			if ( self.heat > 5 )
				"\bThe time machine pings and clicks as the metal cools down. ";
			"You feel heat radiating from the machine. ";
		}
		else {
			"The time machine has cooled off. ";
		}
		
		if ( itemcnt( platform.contents ) )
		{
			"On "; platform.thedesc; " %you% see%s% "; 
			listcont( platform ); ". ";
		}
	}
	location = nil
	noun = 'machine'
	adjective = 'time'
	heat = 0
	coolDesc = "cool to the touch"
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"What do I think about the idea of time machines?
				Well, I guess I think it's a cool idea. I mean, you'd like to
				think you could travel back and forth, go to whatever time you
				want. I'd love to go to the future, you know? See how well I'm
				doing. I bet I'm rich from owning this place, big house. I could
				see what my wife and kids will look like. Maybe I'd know what 
				girl to marry that way! Or which one not to!\" He laughs and
				winks at you. ";
				return( true );
			case Laura:
				"Laura says, \"Okay, that's getting way outside where I'm
				comfortable talking. Sorry.\" ";
				return( true );
			case Architect:
				"He says, \"Hah.\" ";
				return( true );
			case antiqueMerchant:
				"She says, \"Ha! That'll be the day. Besides, if it's a 
				time machine, how can you tell whether it's an antique or
				not? I'd prefer to stick with real world items.\" ";
			default: 
				return( nil );
		}
	}
	tellAboutMe( who ) =
	{
		switch( who )
		{
			case Fred:
				if ( self.isSeen )
				{
				 	"Fred says, \"Aw, now you're pulling my leg, right? A time 
				 	machine? Out in the woods? I don't believe it. I mean, 
					you'd have to show me some proof.\" He regards you with
					comical suspicion. ";
					
					self.toldFredAbout := true;
				}
				else
					"Fred says, \"You seem to know a lot about time machines
					from all those books you read. Tell you what -- if you
					come across one, come back and tell me about it. I'd love
					to see it!\" He bursts into a hearty laugh. ";
				return( true );
			default:
				return( nil );
		}
	}
;

/*	The alert bulb is basically just here to function as a boolean operator, its
 *	flash property. If nil, the time jump is otherwise valid. If true, the
 *	printTimeMessage() function declares that the machine has a limited range.
 *
 *	The alert bulb will flash in this way if the player tries to go farther than
 *	20 years into the past or 20 years into the future from the present in which 
 *	the game starts.
*/
class alertLightItem: fixeditem
	sdesc = "alert bulb"
	adesc = { "an "; self.sdesc; }
	location = timeMachine
	noun = 'bulb'
	adjective = 'alert'
	flash = nil
;

/*	Just to be annoying, you have to stand on this platform in order to travel along
 *	with the time machine. Otherwise, it vanishes and leaves you stranded.
 *	The reachable items are defined as all the objects associated with the time
 *	machine, because you have to be able to reach all of them from this nested room.
 *
 *	We only want the player standing on the platform, not sitting, so commands to
 *	sit are translated automatically into commands to stand, and handled from there.
 */
class platformItem: chairitem, rodroom
	sdesc = "time machine platform"
	adesc = { self.thedesc; }
	ldesc = 
	{
		"It's just big enough for an adult to stand on. ";
		
		if ( itemcnt( self.contents ) )
		{
			"On "; self.thedesc; " %you% see%s% ";
			listcont( self ); ". ";
		}
		else
		{
			"There's nothing on "; self.thedesc; ". ";
		}
	}
	noun = 'platform'
	location = nil
	outOfPrep = "off of"
	statusPrep = "on"
	isdroploc = true
	canReachContents = true
	
	roomAction( actor, v, dobj, prep, io ) =
	{
		if ( dobj = mazeFoliage && v != inspectVerb )
		{
			"You can't reach that from <<self.thedesc>>. ";
			exit;
		}
		else
			inherited.roomAction( actor, v, dobj, prep, io );
	}

	rodDesc = 
	{
		"The electromagnetic fields generated by the time machine after a jump 
		seem to be interfering with the divining wand. You might want to get off 
		and look at it again. ";
	}
	
	verDoSiton( actor ) = { self.verDoStandon( actor ); }
	doSiton( actor ) = { self.doStandon( actor ); }
	verDoJumpOn( actor ) = { self.verDoStandon( actor ); }
	doJumpOn( actor ) = { self.doStandon( actor ); }
	verDoEnter( actor ) = { self.verDoStandon( actor ); }
	doEnter( actor ) = { self.doStandon( actor ); }
	
	verDoStandon( actor ) = 
	{
		if ( actor.location = self )
			"You are already standing on the platform. ";
	}
	doStandon( actor ) =
	{
		"Okay, %you're% now standing on "; self.thedesc; ". ";
		actor.travelTo( self );
		
		timeButton.onPlatform := true;					// you have to stand on the
														// platform to travel
		if ( not self.stoodOnPlatformOnce )
		{
			incscore( 5 );
			global.scoreCard[4] := 1;
			self.stoodOnPlatformOnce := true;
		}
	}
	
	doUnboard( actor ) =
	{
		"Okay, %you're% no longer on "; self.thedesc; ". ";
		self.leaveRoom( actor );
		actor.moveInto( self.location );
		timeButton.onPlatform := nil;					// reset platform flag
	}
;

/*	This is a standard dial item. I wanted to have the settings be, instead of 
 *	numeric values 1 through 5, the settings which are read below on the label.
 *	However, I didn't know how to make the code parse "-20" or "+10" as a valid
 *	entry.
 *
 *	The dial is separate in the room because setting its location to timeMachine
 *	seemed to interfere with how it worked. That bug may no longer be active, but
 *	I'm not taking any chances.
 */
class timeKnobItem: dialItem
	sdesc = "knob"
	adesc = { self.thedesc; }
	noun = 'knob' 'dial'
	location = nil
	maxsetting = 5
	setting = 1
;

/*	Because it's complicated to make the dial display this information, this dummy
 *	readable object was created.
 */
class dialLabelItem: readable, fixeditem
	sdesc = "label"
	ldesc = "It reads:  -20, -10, 0, +10, +20. "
	noun = 'label'
	location = timeMachine
;

/*	The timeButton is pushed to activate the time machine and make it perform a jump.
 *	The doPush action makes sure the player is on the platform. If not, the machine
 *	is moved away. If so, newTime() is used to set the new global.timeLoc value.
 *	This new value is used to timeJump() the machine and the player to the new 
 *	location. Fortunately, the machine moves in time, not in space, so there are
 *	only five valid new locations. Can you imagine the complications if the player
 *	were able to carry around a portable time machine?
 */
class timeButtonItem: buttonitem
	sdesc = "large red button"
	adjective = 'large' 'red'
	location = timeMachine
	onPlatform = nil
	
	doPush ( actor ) =
	{
		local newTimeLoc, newJumpLoc;
		
		if ( not self.pushedOnce )
			self.pushedOnce := true;
		
		"You push the big red button. Click!\b";
		
		if ( timeMachine.heat = 0 ) 			// if the machine is cooled off
		{
			newTimeLoc := newTime( timeKnob.setting );
			switch ( newTimeLoc )
			{
				case 1:
					newJumpLoc := FPclearing;			// Far Past
					break;
				case 2:
					newJumpLoc := Pclearing;			// Past
					break;
				case 3:
					newJumpLoc := clearing;				// Present
					break;
				case 4:
					newJumpLoc := Fclearing;			// Future
					break;
				case 5:
					if ( newFuture.isHere )
						newJumpLoc := NFclearing;		// New Future
					else
						newJumpLoc := FFclearing;		// Far Future
					break;
			}						// end switch()
			if ( self.onPlatform )			// if we're standing on the platform
	  		{
				global.timeLoc := newTimeLoc;
				timeJump( actor, newJumpLoc );
			}
	   		else					// if we're not on the platform
	   		{
				if ( timeKnob.setting = 3 )
				{
					"Nothing happens. ";
				}
				else
				{
					"The machine vibrates and heats up like a toaster oven. A 
					blinding light envelops the machine, and it vanishes in a 
					fancy puff of smoke, leaving only the smell of ozone behind. ";
					
					if ( Fred.location = Me.location )
					{
						"\bFred blinks. \"Um. It's gone off without us.\" ";
					}
					
					moveTimeMachine( newJumpLoc );	// we might be able to find it again
				}
			}
		}														
		else												// if machine is still hot
		{
			if ( timeManual.readOnce )			// have we read the manual yet?
			{
		  		"Nothing seems to happen. You recall that the time machine manual 
				specified that the machine has a fail-safe to keep its parts from 
				fusing. You have to let it cool off before it will let you make 
				another jump. ";
			}
			else
			{
		  		"Nothing seems to happen. I wonder why. ";
			}
		}
	}									// end doPush
;

class compartmentItem: openable, fixeditem
	isopen = nil
	sdesc = "hinged compartment"
	ldesc = 
	{
		if ( self.heat > 6 )
			"You notice that a lot of heat is coming out of <<self.thedesc>>. ";
		pass ldesc;
	}
	adesc = { self.thedesc; }
	noun = 'compartment'
	adjective = 'hinged'
	location = timeMachine
	maxbulk = 2
	heat = 0
	
	doOpen( actor ) =
	{
		if ( self.heat > 6 )
			"A wave of heat comes out of the compartment. ";
		pass doOpen;
	}
;


/************************** end of time machine objects *****************************/

class NPC: Actor
	isNPC = true
	adesc = { self.sdesc; }
	thedesc = { self.sdesc; }
	actorDesc = 
	{
		"\^<<self.adesc>> is here. ";
	}
	ldesc = 
	{
		self.ldescF; " ";
		if ( length( self.contents ) )
		{
			"\^<<self.fmtYou>> is carrying "; listcont( self ); ". ";
		}
	}
	listenDesc =
	{
		if (  self.isHer  )
			return( 'She isn\'t saying anything at the moment. ' );
		else
			( 'He isn\'t saying anything at the moment. ' );
	}
	whoAmI = "You don't know who <<self.fmtYou>> is. "
	ldescF = { self.whoAmI; }
	addressMe = "[bug]"		// Some NPCs use a different term of address.
	sayHello = "\n\^<<self.thedesc>> says, \"Hello.\" "
	talkAboutMyself = 
	{
		"\n\^<<self.thedesc>> says, \"I'm not sure what to tell 
		you about myself.\" ";
	}
	sayMyJob = { "You'd best not pose such a rude question so directly. "; }
	sayWhoAmI = { "\n\^<<self.thedesc>> says, \"You tell me.\" "; }
	buyCommand( dobj ) = { return( nil ); }
	giveItemToSomeone( item, someone ) =
	{
		if ( item.isIn( self ) )
			someone.ioGiveTo( self, item );
		else
			"\n\^<<self.thedesc>> says, \"I don't have <<item.adesc>> to
			give you, sorry.\" ";
	}
	knowWhereIsList = []
	sayWhereIs( it ) = 
	{
		"\n\^<<self.thedesc>> says, \"I don't know 
		where <<it.thedesc>> is, sorry.\" ";
	}
	wasTalkedTo = nil 							// was there conversation this turn?
	
	actorAction( v, d, p, i ) =
	{
		if ( Me.isIn( self.location ) )
		{
			if ( v = helloVerb )
			{
				if ( d = nil || d = self )
					self.sayHello;
				else if ( d = sailor )
					"\^<<self.thedesc>> wouldn't have anything to say to that. ";
				else
					"\^<<self.thedesc>> wouldn't know how to respond to that. ";
			}
			else if ( v = followVerb )
			{
				"\n\^<<self.thedesc>> doesn't appear interested in 
				following <<d.fmtYoum>>. ";
			}
			else if ( v = waitVerb )
			{
				self.doWait( Me );
			}
			else if ( v = laughVerb )
			{
				"I don't think <<self.thedesc>> is able to laugh on command. ";
			}
			else if ( v = singVerb || v = danceVerb )
			{
				"\^<<self.thedesc>> declines your invitation to perform. ";
			}
			else if ( v = smileVerb )
			{
				if ( d )
				{
					"\n\^<<self.thedesc>> smiles at ";
					if ( d = Me )
						"you. ";
					else
						"<<d.thedesc>>. ";
					d.doSmile( self );

				}
				else
					"\n\^<<self.thedesc>> smiles. ";
			}
			else if ( ( v = whoIsVerb ) or ( v = whatIsVerb ) )
				self.doAskAbout( Me, d );
			else if ( v = whereAmIVerb )
				"\n\^<<self.thedesc>> says, \"You're right 
				here.\" ";
			else if ( v = whereIsVerb )
			{
				if ( d )
				{
					if ( d = Me )
						"\n\^<<self.thedesc>> says, \"You're right 
						here.\" ";
					else if ( d = self )
						"\n\^<<self.thedesc>> looks at you quizzically. ";
					else if ( d.location = Me.location )
						"\n\^<<self.thedesc>> says, \"<<d.thedesc>> is
						right here.\" ";
					else if ( find( knowWhereIsList, d ) = nil )
					{
						"\n\^<<self.thedesc>> says, \"I don't know ";
						if ( d.isNPC )
							"who ";
						else "where ";
							"that is, sorry.\" ";
					}
					else if ( d.location = nil )
					{
						"\n\^<<self.thedesc>> says, \"I don't know 
						where <<d.thedesc>> is, sorry.\" ";
					}
					else
					{
						self.sayWhereIs( d );
					}
				}
				else
					"\n\^<<self.thedesc>> says, \"Where is who?\" ";
			}
			else if ( v = whoAreYouVerb )
			{
				self.talkAboutMyself;
			}
			else if ( v = whatAreYouVerb )
			{
				self.sayMyJob;
			}
			else if ( v = whoAmIVerb )
				self.doWhoAmI( Me );
			else if ( v = tellVerb )
			{
				if ( ( d = Me ) and ( p = aboutPrep ) )
					self.doAskAbout( d, i );
				else
					"\n\^<<self.thedesc>>> says, \"Tell <<d.thedesc>> <<p.sdesc>> <<i.
					sdesc>>...?\" ";
			}
			else if ( v = giveVerb )
			{
				self.giveItemToSomeone( d, i );
			}
			else if ( v = thankVerb ) 
			{
				self.responseToThanks;
			}
			else if ( v = loveVerb )
			{
				if ( d = You )
					d.doILoveYou( self );
				else if ( d = wrench )
					"\^<<self.thedesc>> says, \"I don't get it.\" ";
				else
					"What a weird thing to say to someone. ";
			}
			else if ( v = yesVerb || v = noVerb || v = maybeVerb )
			{
				if ( self.justAskedYesOrNoQuestion ) {
					self.justAskedYesOrNoQuestion := nil;
					self.yesOrNoAnswer( v );
				}
				else
					"\^<<self.thedesc>> says, \"Whatever you say.\" ";
			}
			else if ( v = xyzzyVerb || v = ploverVerb )
			{
				"\^<<self.thedesc>> wouldn't know about that. ";
			}
			else if ( v = tellVerb and d = Me and p = aboutPrep )
			{
				self.doAskAbout( d, i );
			}
			else if ( v = helpVerb || v = hintVerb )
			{
				local topic;
				topic := chooseTopic( self );
				
				"\^<<self.thedesc>> brings up the subject of <<topic.thedesc>>. \b";
				
				self.doAskAbout( Me, topic );
			}
			else if ( v = goodVerb )
			{
				"\^<<self.thedesc>> says, \"Thanks.\" ";
			}
			else if ( v = badVerb )
			{
				"\^<<self.thedesc>> says, \"Well, sorry.\" ";
			}
			else if ( v = buyVerb )
			{
				if ( !self.buyCommand( d ) )
					"\n\^<<self.thedesc>> doesn't appear interested. ";
			}
			else
				"\n\^<<self.thedesc>> doesn't appear interested. ";
		}
		else 
			"\n\^<<self.thedesc>> isn't here. ";
		exit;
	}
	yesOrNoAnswer = 
	{
		"\^<<self.thedesc>> probably meant that rhetorically. ";
	}
	ioGiveTo(actor, dobj) =
	{
		"\^<<self.thedesc>> rejects the offer. ";
	}
	verDoAskFor( actor, io ) = {}
	doAskFor( actor, io )= { self.actorAction( giveVerb, io, toPrep, Me ); }
	verDoConsultAbout( actor, io ) = { self.verDoAskAbout( actor, io ); }
	doConsultAbout( actor, io ) =
	{
		self.doAskAbout( actor, io );
	}
	ioConsultAbout( actor, dobj ) =
	{
		dobj.doAskAbout( actor, self );
	}
	verDoTellAbout( actor, iobj ) = {}
	doTellAbout( actor, iobj ) =
	{
		if ( not consultWords( iobj, self, 0 ) )	 // if it returns nil
			self.tellAboutDisavow( iobj );
		self.wasTalkedTo := true;
	}
	askedAboutList = []
	verDoAskAbout( actor, iobj ) = {}
	doAskAbout( actor, iobj ) =
	{
/*
		if ( consultWords( iobj, self, 1 ) )
			self.askedAboutList += iobj;
		else
			self.disavow( iobj );
*/
		if ( not consultWords( iobj, self, 1 ) )
			self.disavow( iobj );
		self.wasTalkedTo := true;
	}
	disavow( it ) =
	{
		switch( rand( 3 ) )
		{
			case 1:
				"\^<<self.thedesc>> says, \"I can't tell you anything 
				about <<it.thedesc>>.\" ";
				break;
			case 2:
				"\^<<self.thedesc>> says, \"I don't have any opinion 
				about <<it.thedesc>>.\" ";
				break;
			case 3:
				"\^<<self.thedesc>> says, \"I'm afraid you'll have to 
				ask someone else.\" ";
				break;
			default:
				"\^<<self.thedesc>> says, \"I'm afraid you'll have to 
				ask someone else.\" ";
				break;
		}
	}
	tellAboutDisavow( it ) =
	{
		switch( rand( 3 ) )
		{
			case 1:
				"You don't have anything important to tell <<self.thedesc>> about
				<<it.thatdesc>>. ";
				break;
			case 2:
				"You can't think of anything interesting to say 
				about <<it.thatdesc>>. ";
				break;
			case 3:
				"You tell <<self.thedesc>> what you know about <<it.thedesc>>, but
				it doesn't amount to much, and the conversation sort of ends there. ";
				break;
			default:
				"You tell <<self.thedesc>> about <<it.thedesc>>, 
				and <<self.fmtYou>> listens with polite but feigned interest. ";
				break;
		}
	}
	verDoAttack( actor ) = 
	{
		"Violence won't help. ";
	}
	verDoBite( actor ) = 
	{
		"I don't think <<self.thedesc>> would appreciate that. ";
	}
	verDoBlow( actor ) =
	{
		"Good heavens! This isn't that kind of story. ";
	}
	verDoBribe( actor ) =
	{
		"Bribing <<self.thedesc>> wouldn't get you anywhere. ";
	}
	verDoBribeWith( actor, io ) =
	{
		"Bribing <<self.thedesc>> wouldn't get you anywhere. ";
	}
	verDoBuy( actor ) =
	{
		"You can't buy and sell people! ";
	}
	verDoSell( actor ) =
	{
		"You can't buy and sell people! ";
	}
	verDoFollow( actor ) =
	{
		if ( self.location = actor.location )
			"But <<self.thedesc>> is right here! ";
	}
	verDoGood( actor ) =
	{
		"\^<<self.thedesc>> says, \"Thanks, I think.\" ";
	}
	verDoBad( actor ) = 
	{
		"\^<<self.thedesc>> says, \"Sorry, I think.\" ";
	}
	doHello( actor ) = { self.sayHello; }
	verDoHug( actor ) = {}
	doHug( actor ) = 
	{
		"\n\^<<self.thedesc>> is startled by your display of affection. ";
	}
	verDoLaughAt( actor ) = { "That would be very impolite. "; }
	verDoKill( actor ) = { "Really, now. "; }
	verDoKillWith( actor, io ) = {}
	verDoKick( actor ) =
	{
		"I'm sure <<self.thedesc>> would not appreciate that. ";
	}	
	verDoKiss( actor ) = {}
	doKiss( actor ) = 
	{
		"\n\^<<self.thedesc>> is startled by your display of affection. ";
	}
	verDoLick( actor ) = {}
	doLick( actor ) =
	{
		"That would be highly inappropriate. ";
	}
	verDoLookin( actor ) = 
	{
		"Looking inside people is not at all possible. ";
	}
	verDoPlayWith( actor ) =
	{
		"\^<<self.thedesc>> <<self.isntdesc>> <<self.isThem?"children":"a child">>. ";
	}
	verIoPlay_With( actor ) = {}
	verDoPlay_With( actor, io ) = 
	{
		"I don't know how to play <<self.thedesc>> with anything. ";
	}
	ioPlay_With( actor, dobj ) =
	{
		if ( dobj = gameOfCatch )
		{
			dobj.doPlay_With( actor, self );
		}
		else
			"I don't know how to play <<dobj.thedesc>> with <<self.thedesc>>. ";
	}
	verDoPoint( actor ) = 
	{
		"It's rude to point at people. ";
	}
	verDoRub( actor ) =
	{
		"I'm not sure <<self.thedesc>> wants to be rubbed by you. ";
	}
	verDoScratch( actor ) =
	{
		"\^<<self.thedesc>> is probably capable of scratching <<self.fmtYour>> own
		itches. ";
	}
	verDoSearch( actor ) =
	{
		"You'd better keep your hands to yourself. ";
	}
	verIoShowTo( actor ) = {}
	ioShowTo( actor, dobj ) =
	{
		if ( not consultWords( dobj, self, 1 ) )
			self.notImpressedMsg( dobj );
		self.wasTalkedTo := true;
	}
	notImpressedMsg( it ) = "\^<<self.thedesc>> <<self.isntdesc>> interested in looking at <<it.thedesc>>. "
	verDoSmile( actor ) = {}
	doSmile( actor ) =
	{
		"\^<<self.thedesc>> smiles back. ";
	}
	verDoTalkTo( actor ) = {}
	doTalkTo( actor ) = 
	{
		self.sayHello;
		
		if ( not global.playerTypedTalkToOnce )
		{
			"\b[To engage in conversation with characters in this story,
			use the verbs ASK and TELL.\b
			
			\t ASK [<<self.thedesc>>] ABOUT [subject] will prompt <<self.fmtYoum>> 
			to give you any opinion or information they have about the subject.\n
			\t TELL [<<self.thedesc>>] ABOUT [subject] will give <<self.fmtYoum>>
			the chance to react to any information that you might have about the
			subject that they may not know. If you don't have any special information
			about the subject, you will get the character's opinion about the topic
			as if you had ASKed a question. \b
			
			This message will appear only once. ]";
			global.playerTypedTalkToOnce := true;
		}
	}
	verDoTake( actor ) =
	{
		"You can't take <<self.thedesc>>. ";
	}
	doTake( actor ) = 
	{
		if ( self.followMe )
			"\^<<self.fmtYou>> is already following you. ";
		else self.followMsg;
	}
	verDoThank( actor ) = {}
	doThank( actor ) = {
		self.responseToThanks;
	}
	responseToThanks = 
	{
		"\^<<self.thedesc>> says, \"You're welcome.\" ";
	}
	verDoTickle( actor ) =
	{
		"I'm not sure <<self.thedesc>> would appreciate being tickled by you. ";
	}
	verDoTickleWith( actor, io ) =
	{
		"I'm not sure <<self.thedesc>> would enjoy being tickled 
		with <<io.thatdesc>>. ";
	}
	verDoTouch( actor ) = 
	{
		"\n\^<<self.thedesc>> isn't someone you should fondle. ";
	}
	verDoWait( actor ) = {}
	doWait( actor ) =
	{
		if ( self.outtaHere )
			self.stopMsg;
		else if ( not self.followMe )
			"\n\^<<self.fmtYou>> isn't going anywhere. ";
		else
			self.dropMsg;
	}
	doWhatIs( actor ) = 
	{
		self.whoAmI;
	}
	doWhoIs( actor ) = 
	{
		self.whoAmI;
	}
	verDoWhoAreYou( actor ) = {}
	doWhoAreYou( actor ) = 
	{
		self.talkAboutMyself;
	}
	verDoWhatAreYou( actor ) = {}
	doWhatAreYou( actor ) =
	{
		self.sayMyJob;
	}
	doWhoAmI( actor ) =
	{
		self.sayWhoAmI;
	}
	verDoYellAt( actor ) = {}
	doYellAt( actor ) =
	{
		"There's no need to vent your frustrations by yelling	at <<self.thedesc>>. ";
	}
	
	fmtYou = { if ( self.isHim ) "he"; else "she"; }
	fmtYour = { if ( self.isHim ) "his"; else "her"; }
	fmtYoure = { if ( self.isHim ) "he's"; else "she's"; }
	fmtYoum = { if ( self.isHim ) "him"; else "her"; }
	fmtYouve = { if ( self.isHim ) "he's"; else "she's"; }
	fmtS = "s"
	fmtEs = "es"
	fmtHave = "has"
	fmtDo = "does"
	fmtAre = "is"
	fmtMe = { self.thedesc; }
	itnomdesc =
	{
		if ( self.isHer )
			"she";
		else
			"he";
	}
	itobjdesc =
	{
		if ( self.isHer )
			"her";
		else
			"him";
	}
	itisdesc =
	{
		if ( self.isHer )
			"she's";
		else
			"he's";
	}
	itselfdesc =
	{
		if (  self.isHer  )
			"herself";
		else
			"himself";
	}
	thatdesc = { self.itobjdesc; }
;

/*	sandwichItem:
 *	
 *	There are two kinds of sandwiches, hot and cold. Both are declared of type
 *	sandwichItem, which is a regular item that starts out on the "menu," as a 
 *	convenience for coding (they needed to start somewhere in the sandwichShop
 *	that the parser would recognize as a starting place, yet also be a place
 *	that they could not be put back, once the player has bought one of them.
 *
 *	The heat value setting is for later in the game, when you try to give it to
 *	the architect. The isListed setting starts nil because we don't want the
 *	sandwiches to show up in the sandwichShop room description. However, once
 *	they are purchased, isListed is set to true so that they behave normally.
 */
class sandwichItem: buyable
	location = menu
	heat = 0
	isSandwich = true
	coolDesc = "cold"
	myMerchant = Fred
	startLoc = menu
		
	verDoSmell( actor ) = {}
	doSmell( actor ) =
	{
		"Mmmmmm!  Smells like "; self.adesc; ". ";
	}
	
	verDoTaste( actor ) = {}
	doTaste( actor ) =
	{
		"Mmmmmm! Tastes like "; self.adesc; ". ";
	}
	
	doPutIn( actor, io ) =
	{
		if ( io = compartment )
		{
			compartment.toaster := true;
		}
		self.moveInto( io );
		"Done. ";
	}
	
	doTakeOut( actor, io ) =
	{
		self.doTake( actor );
	}
	
	verDoEat( actor ) = 
	{
		if ( not self.isIn( Me ) )
			"You have to be holding <<self.thedesc>> before you can 
			eat it. ";
	}
	doEat( actor ) =
	{
		"You eat "; self.thedesc; ". ";
		self.moveInto( nil );
	}
	
	doThrow( actor ) = 
	{
		if ( Me.location = insideShed && Blackie.location = insideShed ) 
			insideShed.roomDrop( self );
		"There's no reason to throw a perfectly good sandwich. ";
	}
;

/*	Just a detail to make the game more fun, you get a paper napkin with whichever
 *	sandwich you buy. 															*/
class napkinItem: item
	isEquivalent = true
	bulk = 0
	sdesc = "paper napkin"
	noun = 'napkin'
	adjective = 'paper'
	location = nil
	
	verDoCheckWith( actor, io ) = 
	{
		"The napkin is merely decorative, but it's not a red herring. ";
	}
	verIoCleanWith( io ) = {}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Just remember to dispose of the napkin properly,
				and don't litter.\" ";
				return( true );
			case Laura:
				"Laura says, \"Yeah, nice napkin. Um, so, are you going to do
				any banking or are you just hanging around to chat? Of course,
				that's okay -- it's a little slow now. But I just don't have
				anything to say about napkins.\" ";
				return( true );
			case Architect:
				"He says nothing to you and goes back to work. ";
				return( true );
			default: 
				return( nil );
		}
	}
;

modify openable
	verDoOpenWith( actor, io ) = {}
	
	verDoEmpty( actor ) = 
	{
		if ( length( self.contents ) = 0 )
			"There is nothing in <<self.thedesc>>. ";
	}
	doEmpty( actor ) = 
	{
		if ( Me.location.isTreeRoom )
		{
			"You empty <<self.thedesc>>, and everything in it
			falls all the way down to the ground. ";
			while( length( self.contents ) > 0 )
			{
				if ( isclass( self.location, FtreeRoom ) )
					self.contents[1].moveInto( FsouthOfHouse );
				else
					self.contents[1].moveInto( southOfHouse );
			}
		}
		else 
		{
			if ( Me.location = platform || Me.location = platform2 )
			{
				"You empty <<self.thedesc>>, and everything in it
				spills onto the time machine platform. ";
			}
			else
			{
				"You empty <<self.thedesc>>, and everything in it
				spills onto the <<self.location.indoors?"floor":"ground">>. ";
			}
			while( length( self.contents ) > 0 )
			{
				self.contents[1].moveInto( Me.location );
			}
		}
	}
;

/* cartItem:
 * A cartItem can hold things and be moved around by the player. 
 */
class cartItem: qcontainer, fixeditem
	isListed = true
	maxbulk = 50
	verDoEmpty( actor ) = 
	{
		if ( length( self.contents ) = 0 )
			"There is nothing in <<self.thedesc>>. ";
	}
	doEmpty( actor ) = 
	{
		if ( Me.location.isTreeRoom )
		{
			"You empty <<self.thedesc>>, and everything in it
			falls all the way down to the ground. ";
			while( length( self.contents ) > 0 )
			{
				if ( isclass( self.location, FtreeRoom ) )
					self.contents[1].moveInto( FsouthOfHouse );
				else
					self.contents[1].moveInto( southOfHouse );
			}
		}
		else 
		{
			if ( Me.location = platform || Me.location = platform2 )
			{
				"You empty <<self.thedesc>>, and everything in it
				spills onto the time machine platform. ";
			}
			else
			{
				"You empty <<self.thedesc>>, and everything in it
				spills onto the <<self.location.indoors?"floor":"ground">>. ";
			}
			while( length( self.contents ) > 0 )
			{
				self.contents[1].moveInto( Me.location );
			}
		}
	}
	
	verDoPush( actor ) = 
	{
		"%You% seem able to push "; self.thedesc; " around with %you%. ";
	}
	
	verDoMove( actor ) =
	{
		"%You% seem able to move "; self.thedesc; " around with %you%. ";	
	}

	verDoMoveN( actor ) = {}
	verDoMoveS( actor ) = {}
	verDoMoveE( actor ) = {}
	verDoMoveW( actor ) = {}
	verDoMoveNE( actor ) = {}
	verDoMoveNW( actor ) = {}
	verDoMoveSE( actor ) = {}
	verDoMoveSW( actor ) = {}
	moveStr = [ 'to the north' 
			'northeast'
			'to the east'
			'southeast'
			'to the south'
			'southwest'
			'to the west'
			'northwest' ]
	doMoveN( actor ) = 
	{
		if ( actor.location.north )
		{
			cartMove( self, actor, actor.location.north, 1 );
		}
	}
	doMoveNE( actor ) = 
	{
		if ( actor.location.ne )
		{
			cartMove( self, actor, actor.location.ne, 2 );
		}
	}
	doMoveE( actor ) = 
	{
		if ( actor.location.east )
		{
			cartMove( self, actor, actor.location.east, 3 );
		}
	}
	doMoveSE( actor ) = 
	{
		if ( actor.location.se )
		{
			cartMove( self, actor, actor.location.se, 4 );
		}
	}
	doMoveS( actor ) = 
	{
		if ( actor.location.south )
		{
			cartMove( self, actor, actor.location.south, 5 );
		}
	}
	doMoveSW( actor ) = 
	{
		if ( actor.location.sw )
		{
			cartMove( self, actor, actor.location.sw, 6 );
		}
	}
	doMoveW( actor ) = 
	{
		if ( actor.location.west )
		{
			cartMove( self, actor, actor.location.west, 7 );
		}
	}
	doMoveNW( actor ) = 
	{
		if ( actor.location.nw )
		{
			cartMove( self, actor, actor.location.nw, 8 );
		}
	}
;

class miracleGrowItem: qcontainer
	isEquivalent = true						// five identical jugs
	bulk = 
	{
		if ( length( self.contents ) > 0 )
			return( 6 );
		else
			return( 1 );
	}
	sdesc = "full jug of miracle-grow"
	pluraldesc = "full jugs of miracle-grow"
	smellDesc = "It has the potent, organic tang of concentrated fertilizer. "
	noun = 'jug' 'gro' 'grow'
	plural = 'jugs'
	adjective = 'miracle-grow' 'miracle-gro' 'miracle' 'miracle-' 'full'
	isJug = true
	pourItem = nil
	emptyJug = nil
	
	verDoPour( actor ) = 
	{
		if ( self.pourItem = nil )
			"The jug is empty. ";
	}
	doPour( actor ) =
	{
		askio( onPrep );
	}
	
	doSynonym( 'Pour' ) = 'Empty'
	
	verDoPutIn( actor, io ) =
	{
            if ( isclass( io, container ) && !isclass( io, cartItem ) )
		{
			"\^<<self.thedesc>> is too big to fit in <<io.thedesc>>. ";
		}
	}
	verIoPutIn( actor ) = 
	{
		if ( self.pourItem )
			"The jug is full already. ";
		"You can't put that into the jug. ";
	}
	
	verDoPourIn( actor, io ) =
	{
		if ( self.pourItem = nil )
			"The jug is empty. ";
		else
			self.pourItem.verDoPourIn( actor, io );
	}
	
	verIoPourIn( actor ) = 
	{
		"That isn't important. ";
	}
	
	verDoFill( actor ) = 
	{
		"That isn't important. ";
	}
	verDoFillWith( actor, io ) = 
	{
		"That isn't important. ";
	}
		
	leaving( actor ) = 
	{
		if ( self.pourItem = nil )
			return( nil );
		if ( self.deepIsIn( Me ) )
			return( true );
		if ( self.location = nil )
		{
			"HEY! [BUG jug.location = nil and Me.leaveList]";
			return true;
		}
		return nil;
	}
	
	verDoTake( actor ) = 
	{
		if ( ( Blackie.location = insideShed ) && ( self.location = insideShed ) )
		{
			if ( !Blackie.pacified )
				"Oh, bother. As you might expect, the vicious dog snaps at 
				you as you reach for the jug. ";
		}
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Sounds like a good thing to pour on a freshly-planted
				acorn. But I'm just guessing.\" ";
				return( true );
			case Laura:
				"Laura says, \"Oh, that stuff is perfect for young plants and
				trees. They just gobble that stuff up.\" ";
				return( true );
			case Architect:
				"He says, \"That product is really something. I've seen it turn
				normally slow-growing plants into giant, towering fauna.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

class liquidItem: item
	isFertilizer = true
	isEquivalent = true
	sdesc = "thick liquid"
	adesc = "some thick liquid"
	ldesc = "The thick liquid is a deliberately unappetizing green color. "
	smellDesc = "It has the potent, organic tang of concentrated fertilizer. "
	noun = 'liquid' 'poison' 'fertilizer'
	adjective = 'thick' 'green' 'unappetizing' 'poisonous'
	jugItem = nil
	
	doTake( actor ) =
	{
		"You're better off leaving the thick liquid in the jugs, unless you're 
		planning on growing a garden. ";
	}
	
	verDoPutOn( actor, io ) = { self.verDoPourIn( actor, io ); }
	doPutOn( actor, io ) = { io.ioPourIn( actor, self ); }
	
	verDoPutIn( actor, io ) = { self.verDoPourIn( actor, io ); }
	
	verDoPourIn( actor, io ) =
	{
		if ( io != acornMound )
		{
			if ( !isclass( io, miracleGrowItem ) )
			{
				if ( io = sapling || io = tinyTree || io = tree )
					"The fertilizer probably won't help <<io.thedesc>> 
					very much. You should use it on the acorn. ";
				else if ( io = FtinyTree || io = Ftree )
					"\^<<self.thedesc>> is beyond help from fertilizers. ";
				else
					"You shouldn't pour <<self.thedesc>> onto <<io.thatdesc>>. ";
			}
		}
	}
	
	verDoPour( actor ) = {}
	doPour( actor ) =
	{
		askio( inPrep );
	}
	
	doSynonym( 'Pour' ) = 'Empty'
	
	verDoEat( actor ) =
	{
		caps(); self.thedesc; " is not intended for human consumption. ";
	}
	verDoDrink( actor ) =
	{
		"\^<<self.thedesc>> is not intended for human consumption. ";
	} 
;

class emptyJugItem: qcontainer
	isEquivalent = true						// five identical jugs
	bulk = 1
	sdesc = "empty jug"
	pluraldesc = "empty jugs of miracle-grow"
	adesc = "an <<self.sdesc>>"
	smellDesc = "It lingeringly smells like the fertilizer. "
	noun = 'jug' 'gro' 'grow'
	plural = 'jugs'
	adjective = 'miracle-grow' 'miracle-gro' 'miracle' 'miracle-' 'empty'
	isJug = true
	
	verDoPour( actor ) = 
	{
		"The jug is empty. ";
	}
	doSynonym( 'Pour' ) = 'Empty'
	
	verDoPutIn( actor, io ) =
	{
            if ( isclass( io, container ) && !isclass( io, cartItem ) )
		{
			"\^<<self.thedesc>> is too big to fit in <<io.thedesc>>. ";
		}
	}
	verIoPutIn( actor ) = 
	{
		"You can't put that into the jug. ";
	}
	
	verDoPourIn( actor, io ) =
	{
		"The jug is empty. ";
	}
	
	verIoPourIn( actor ) = 
	{
		"That isn't important. ";
	}
	
	verDoFill( actor ) = 
	{
		"That isn't important. ";
	}
	verDoFillWith( actor, io ) = 
	{
		"That isn't important. ";
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Sounds like a good thing to pour on a freshly-planted
				acorn. But I'm just guessing.\" ";
				return( true );
			case Laura:
				"Laura says, \"Oh, that stuff is perfect for young plants and
				trees. They just gobble that stuff up.\" ";
				return( true );
			case Architect:
				"He says, \"That product is really something. I've seen it turn
				normally slow-growing plants into giant, towering fauna.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

waterItem: block
	isWater = true
	
	verIoFillWith( actor ) = {}
	
	verDoDrink( actor ) =
	{
		"The water looks clear and clean, but that's no reason to take
		an unnecessary risk to your health. ";
	}
	
	verDoWadeIn( actor ) = {}
	doWadeIn( actor ) = 
	{
		"You wade into <<self.thedesc>> for a bit. It's refreshing. ";
	}
	
	verDoSwimIn( actor ) = 
	{
		"The water is not deep enough to swim in. ";
	}
	
	verIoPutIn( actor ) = 
	{
		"There's no sense in getting your possessions wet. ";
	}
	
	verDoEnter( actor ) = { self.verDoSwimIn( actor ); }
	
	verDoTake( actor ) =
	{
		"That isn't important. ";
	}
	
	verDoPour( actor ) =
	{
		"That isn't important. ";
	}
	
	verDoPourIn( actor ) =
	{
		"That isn't important. ";
	}
;


/*	The rope has two ends which can be tied. It is always controlled so that 
 *	tieItem1 is tied before tieItem2, and untied in reverse order.
 */
class ropeItem: item
	sdesc = 
	{
		"rope";
		if ( self.tieItem1 )
		{
			" (tied to "; self.tieItem1.adesc;
			if ( self.tieItem2 )
			{
				" and to "; self.tieItem2.adesc;
			}
			")";
		}
	}
	thedesc = "the rope"
	tieItem1 = nil
	tieItem2 = nil
	ldesc = 
	{
		"It's an ordinary rope. ";
		if ( self.tieItem1 )
		{
			"It's tied to "; self.tieItem1.adesc;
			if ( self.tieItem2 )
			{
				" and to "; self.tieItem2.adesc;
			}
			". ";
		}
	 }
		
	verDoTieTo( actor, io ) = 
	{
		if ( io = self )
		{
			"There's no point in tying the rope to itself. ";
		}
	}
	doTieTo( actor, io ) =
	{
		self.ioTieTo( actor, io );
	}

	verIoTieTo( actor ) = {}
	ioTieTo( actor, dobj ) = 
	{
		if ( self.tieItem1 = nil )
		{
			"You tie the rope to <<dobj.thedesc>>. ";
			self.tieItem1 := dobj;
		}
		else
		{
			if ( ( self.tieItem1 = dobj ) or ( self.tieItem2 = dobj ) )
			{
				"It's already tied to that. ";
			}
			else if ( self.tieItem2 = nil )
			{
				"You tie the other end to <<dobj.thedesc>>. ";
				self.tieItem2 := dobj;
			}
			else
			{
				"You'll have to untie something first. ";
			}
		}
	}
	
  	verDoUntie( actor ) = 
  	{
  		if ( ( self.tieItem1 = nil ) and ( self.tieItem2 = nil ) )
  			"The rope isn't tied to anything. ";
  	}
  	
  	disEngage( tied_obj ) =
  	{
  		if ( tied_obj = rope )
  		{
  			if ( self.tieItem2 )
  			{
  				"You untie the rope from "; self.tieItem2.thedesc; ". ";
  				self.tieItem2 := nil;
  			}
  			else
  			{
  			  	"You untie the rope from "; self.tieItem1.thedesc; ". ";
  				self.tieItem1 := nil;
  			}
		}
  		else
  		{
  			if ( self.tieItem1 = tied_obj )
  			{
  				"You untie the rope from "; self.tieItem1.thedesc; ".\n";
  				self.tieItem1 := self.tieItem2;
  				self.tieItem2 := nil;
   			}
  			else
  			{
   				if ( self.tieItem2 = tied_obj )
  				{
  					"You untie the rope from "; self.tieItem2.thedesc; ".\n";
  					self.tieItem2 := nil;
  				}
  				else
  				{
  					"The rope isn't tied to "; tied_obj.thedesc; ". ";
  				}
  			}
		}
	}

	verDoTake( actor ) = 
	{
		if ( self.tieItem2 )
			"You'll have to untie the rope first. ";
	}
	
	doTake( actor ) =
	{ 
		if ( ( self.tieItem1 != tireSwing ) and ( self.tieItem1 != nil ) ) 
		{
			"(first untying the rope from "; self.tieItem1.thedesc; ")\b";
			self.disEngage( self.tieItem1 );
		}
		pass doTake;
	}

	doDrop( actor ) =
	{
		if ( ( self.tieItem1 = Me ) or ( self.tieItem2 = Me ) )
		{
			"(first untying the rope from yourself)\b";
			self.disEngage( Me );
		}
		if ( ( self.tieItem1 = tire ) or ( self.tieItem2 = tire ) )
		{
			"(first untying the rope from the tire)\b";
			self.disEngage( tire );
		}
		actor.location.roomDrop( self );
	}
  
	verDoClimb( actor ) = { self.verDoClimbDown( actor ); }
	doClimb( actor ) = { self.doClimbDown( actor ); }
	
	verDoClimbDown( actor ) =
	{
		if ( self.tieItem1 = nil )
			"Climbing down the rope in its present configuration would
			get you nowhere. ";
	}
	doClimbDown( actor ) =
	{
		if ( rope.tieItem1 = brassPipe || rope.tieItem2 = brassPipe )
		{
			if ( tautRopeOutWindow.location = nil && 
				looseRopeOutWindow.location = nil )
			{
				"(first dropping the rope out the window)\n";
				atticWindow.ioThrowOut( actor, rope );
				"\b";
			}
			"You shimmy down the rope. After a few feet, your hands lose 
			their grip and you plummet. ";
			
			if ( tautRopeOutWindow.location = self )
			{
				"Fortunately, the tire breaks your fall.\b";
				Me.travelTo( dangling );
			}
			else
			{
				"The ground breaks your fall, and quite nearly your ankle.\b";
				Me.travelTo( southOfHouse );
			}
		}
		else
			"You're too high up to jump down from here. You'll have to
			find safe way to climb down to the ground. ";
	}
;

modify room
	listenDesc = 'You hear nothing unusual. '
	savedListenDesc = { return( self.listenDesc ); }
	smellDesc = "You smell nothing unusual. "
	lightDesc = "You see nothing special about the light here. "
	floorDesc = "It lies beneath you. "
	noexit = { "There is nowhere to go in that direction. "; return nil; }
	dispParagraph = "\b"
	dispBeginSdesc = "\b\("
	dispEndSdesc = "\)"
	dispBeginLdesc = "\n"
	dispEndLdesc = { self.xdesc; }
;

modify nestedroom
	statusRoot = "<<self.location.sdesc>>"
	lookAround( verbosity ) =
	{
		self.dispBeginSdesc;
		self.statusRoot;
		self.dispEndSdesc;
		" (<<self.statusPrep>> <<self.thedesc>>)";
		
		self.location.nrmLkAround( verbosity );
	}
;

class rodroom: room
	rodRoom = true
	rodPoint = "ground"
	rodDesc = 
	{
		"The divining wand vibrates, pulling to the "; self.rodPoint; ". ";
		return( true );
	}

	enterRoom( actor ) =	// sent to room as actor is entering it
	{
		self.lookAround( ( not self.isseen ) or global.verbose );
		
		if ( diviningRod.validRoomLoc = self )
		{
			if ( diviningRod.isIn( Me ) or diviningRod.isIn( Me.location ) )
			{
				"\b"; self.rodDesc;
			}
		}
		
		if ( self.islit )
		{
			if ( not self.isseen ) self.firstseen;
			self.isseen := true;
		}
	}
;

class mazeroom: rodroom
	isFoliageRoom = true
	sdesc = "In the forest"
	ldesc = "The woods surround you on all sides. You can hear the soft gurgling 
			of a stream nearby, but the foliage is so rich and dense that the 
			sound of it is dispersed. "
	xdesc = 
	{
		"The foliage is so rich and dense that you can barely keep 
		your bearings straight. ";
		
		if ( self.hackexit = nil )
			"Each direction looks the same as every other. ";
	}
	lightDesc = "Light streams prettily through the canopy of leaves above. "
	listenDesc = 'You hear the sound of a stream gurgling somewhere nearby. '
	hackexit = nil
	
	noexit =
	{
		"You get all turned around in the dense forest growth and seem to end up back 
		where you started. ";
		return( nil );
	}
	rodDir =
	{
		if ( self.hackexit )
		{
			"You pass through the hacked-open path. ";
			return( self.hackexit );
		}
		if ( diviningRod.isIn( Me ) )
		{
			"You almost lose your bearings again, but the divining wand seems to 
			pull you through. \b";
		}
		return( self.nextMaze );
	}
;

class hacked_path: fixedBlock, obstacle
	sdesc = "hacked path leading <<self.doordir>>"
	ldesc = "The path leads to the <<self.doordir>>. "
	noun = 'path'
	adjective = 'hacked' 'hacked-open'
	isfixed = nil
	isListed = true
	destination = 
	{
		"You follow the hacked-open path to the <<self.doordir>>. ";
		return( self.doordest );
	}
	verDoEnter( actor ) = { Me.travelTo( self.destination ); }
	verDoOpen( actor ) = { "It is already an open path. "; }
	verDoClose( actor ) = { "You can't close a hacked-open path. "; }
	verDoTake( actor ) = { "You can't take a hacked-open path. "; }
	verDoHackWith( actor, io ) =
	{
		"You have already hacked a path open here. ";
	}
;

class caveRoom: rodroom
	cave = true
	listenDesc = 'You hear the dripple of underground waters. '
	lightDesc = "The light is misty and subdued, but there is enough to see by. "
	smellDesc = "The room smells of wet limestone. "
	rodPoint = "water"
;

class treeRoom: room
	isTreeRoom = true
	roomDrop( obj ) =
	{
		"You drop <<obj.thedesc>>, and it clatters from branch to branch down
		to the ground. ";
		obj.moveInto( southOfHouse );
	}
	floorDesc = "The ground lies far beneath you. "
	roomAction(a, v, d, p, i) =
	{
		if ( v = throwVerb && d )
		{
			if ( i = nil )
				"You throw <<d.thedesc>>, and it clatters from branch to 
				branch down to the ground. ";
			else
			{
				if ( i = Me )
				{
					"You can't throw things <<p.sdesc>> yourself";
					if ( p = inPrep || p = outPrep )
						", whatever that means";
					". ";
				}
				else
					"You miss your target, and <<d.thedesc>> clatters 
					from branch to branch down to the ground. ";
			}
			d.moveInto( southOfHouse );
			exit;
		}
		else pass roomAction;
	}
;

class FtreeRoom: room
	isTreeRoom = true
	roomDrop( obj ) =
	{
		"You drop <<obj.thedesc>>, and it falls all the way down to the 
		ground. ";
		obj.moveInto( FsouthOfHouse );
	}
	in = { return( self.north ); }
	up = { return( self.north ); }
	out = { return( self.south ); }
	down = { return( self.south ); }
	floorDesc = 
	{
		"The ground lies vertiginously far beneath you. Best not to
		look at it. ";
	}
	roomAction(a, v, d, p, i) =
	{
		if ( v = throwVerb && d )
		{
			if ( i = nil )
				"You throw <<d.thedesc>>, and it falls all the way
				down to the ground. ";
			else
			{
				if ( i = Me )
				{
					"You can't throw things <<p.sdesc>> yourself";
					if ( p = inPrep || p = outPrep )
						", whatever that means";
					". ";
				}
				else
					"You miss your target, and <<d.thedesc>> falls
					all the way down to the ground. ";
			}
			d.moveInto( FsouthOfHouse );
			exit;
		}
		else pass roomAction;
	}
;

class VertigoRoom: FtreeRoom
	floorDesc = 
	{
		"You look at the ground, at the base of the tree, for the first time in 
		many minutes. You see nothing unusual, but vertigo overtakes you when 
		you see the great distance to the ground. Instinctively, you shut your 
		eyes to block out the sight, but as soon as you shut them your sense of
		equilibrium completely fails you. Are you slipping? You wrap your limbs
		completely around the tree again, unable to look, but you feel your 
		body sagging to one side, your weight rotating around the slickened
		bark of the tree. Panicking, you squeeze tighter and tighter, but you
		are unable to find friction enough to stop your movement. \b

		A sudden twang of reptile-brain fear opens your eyes and puts you 
		into full, unthinking panic. Your body has shifted, and you are 
		starting to fall off the tree. Your fingernails search for a hold,
		your legs clamp as if to snap the trunk in two, but you can't hang on
		much longer. ";
		
		Me.travelTo( hangingForDearLife );
	}
;

/* G_rooms have graffiti on the walls. */
class graffiti_room: room
	graffito = true
	indoors = true
	lightDesc = "The light here is muted and somber. "
;

modify underHider
	searchObj(actor, list) =
	{
		local found, dest, i, tot;
		
		/* see how much we get this time */
		if (self.serialSearch)
		{
			found := [] + car(list);
			list := cdr(list);
		}
		else
		{
			found := list;
			list := nil;
		}
		
		/* set it(them) to the found item(s) */
		if (length(found) = 1)
			setit(found[1]);	// only one item - set 'it'
		else
			setit(found);	   // multiple items - set 'them'
		
		/* figure destination */
		dest := actor;
		if (not self.autoTake)
			dest := dest.location;
		
		/* note what we found, and move it to destination */
		"%You% find%s% ";
		tot := length(found);
		i := 1;
		while (i <= tot)
		{
			found[i].underLoc := nil;
			found[i].adesc;
			if (i+1 < tot)
				", ";
			else if (i = 1 and tot = 2)
				" and ";
			else if (i+1 = tot and tot > 2)
				", and ";
			
			found[i].moveInto(dest);
			i := i + 1;
		}
		
		/* say what happened */
		if (self.autoTake)
			", which %you% take%s%. ";
		else
			"! ";
		
		if (list<>nil and length(list)=0)
			list := nil;
		return list;
	}
	serialSearch = nil			 /* find everything in one try by default */
	autoTake = true			   /* actor takes item when found by default */
;

nowhereRoom: room
	sdesc = "Nowhere room"
	ldesc = "Here are all the items that have no location property at the beginning
			of the game."
	firstseen =
	{
		local i, l;
		l := self.contents;
		for( i:=1; i<=length(l); i++)
		{
			l[i].isListed := true;
		}
	}
;

nowhereThing: fixedBlock
	sdesc = "nowhere finder"
	noun = 'nowhere'
	location = nowhereRoom
;
/*
modify item
	location = nowhereRoom
;
*/

modify fixeditem
	verDoTake( actor ) =
	{
		if ( not global.wizard ) 
			"You can't pick up <<self.thedesc>>. ";
	}
	verDoDrop( actor ) =
	{
		if ( not global.wizard ) 
			"You can't drop <<self.thedesc>>. ";
	}
;

modify thing
	isSeen = nil				// distinguish from room.isseen property
	deepIsIn( obj ) =				// removes contentsVisible check
	{
		local myloc;
		
		myloc := self.location;
		if ( myloc )
		{
			if ( myloc = obj )
				return true;
			return myloc.deepIsIn( obj );
		}
		return nil;
	}
	isVisible( vantage ) =
	{
		local loc;
		
		loc := self.location;
		
		if ( loc = nil )
		{
			self.isSeen := nil;
			return nil;
		}
		
		if ( vantage.location = self and self.contentsVisible )
		{
			self.isSeen := true;
			return true;
		}
		
		if ( loc = vantage )
		{
			self.isSeen := true;
			return true;
		}
		
		if ( loc.contentsVisible and loc.isVisible( vantage ) )
		{
			self.isSeen := true;
			return true;
		}
		
		if ( vantage.location <> nil and vantage.location.contentsVisible and
			self.isVisible( vantage.location ) )
		{
			self.isSeen := true;
			return true;
		}
		
		return nil;
	}
	notakeall = 
	{
		return( self.isIn( wheelbarrow ) );
	}
	thatdesc =
	{
		if (self.isThem)
			"those";
		else
			"that";
	}
	topicDesc = { self.thedesc; }
	smellDesc = "\^<<self.thedesc>> <<self.isThem ? "smell" : "smells">> 
			like <<self.adesc>>. "
	coolDesc = "cool"
	sayTemperature =
	{
		switch ( self.heat )
		{
			case 0:
			{
				self.coolDesc;
				break;
			}
			case 1:
			case 2:
			{
				"slightly warm";
				break;
			}
			case 3:
			case 4:
			{
				"warm";
				break;
			}
			case 5:
			case 6:
			{
				"very warm";
				break;
			}
			case 7:
			case 8:
			{
				"hot";
				break;
			}
			default:
			{
				"extremely hot";
				break;
			}
		}
	}
	
	verDoActLike( actor ) = { "You're not an especially good mimic. "; }
	
	verIoAskFor(actor)= {}
	ioAskFor( actor,dobj )=
	{
		dobj.doAskFor(actor,self);
	}
	
	askingAboutMe( who ) = { return( nil ); } 
	
	tellAboutMe( who ) = { return( nil ); } 
	
	verDoBad( actor ) =
	{
		"If you say so. ";
	}
	
	verDoBoard( actor ) = 
	{
		"I don't know how to board <<self.thatdesc>>. ";
	}
	
	verDoBite( actor ) =
	{
		"\^<<self.thedesc>> doesn't appear appetizing. ";
	}
	
	verDoBlow( actor ) =
	{
		"Blowing on <<self.thedesc>> doesn't do anything. ";
	}
	
	verDoBlowOn( actor ) =
	{
		"Blowing on <<self.thedesc>> doesn't do anything. ";
	}
	
	verIoBlowUp( actor ) =
	{
		"You can't blow anything up with that. ";
	}
	
	verDoBlowUp( actor, iobj ) = 
	{
		"You can't blow that up. ";
	}
	
	verDoBreak( actor ) = 
	{
		"There is no need to damage <<self.thedesc>>. ";
	}
	
	verDoBribe( actor ) =
	{
		"I don't know how to bribe <<self.thedesc>>. ";
	}
	
	verDoBribeWith( actor, io ) =
	{
		"I don't know how to bribe <<self.thedesc>>. ";
	}
	
	verIoBribeWith( actor ) =
	{
		"You can't bribe anyone with <<self.thatdesc>>. ";
	}
	
	verDoBuyFrom( actor, io ) = 
	{
		"\^<<io.thedesc>> isn't selling anything. ";
	}
	
	verDoBuy( actor ) =
	{
		"<<self.sdesc>>:\ That isn't something %you% can buy. ";
	}
	
	verDoCall( actor ) =
	{
		"I don't know how to call that. ";
	}
	
	verDoCallOn( actor, io ) = 
	{
		"I don't know how to call that. ";
	}
	verIoCallOn( actor ) = 
	{
		"I don't know how to call anything on that. ";
	}
	
	verDoCatch( actor ) = 
	{
		"I don't know how to catch <<self.thedesc>>. ";
	}
	
	verDoChange( actor ) = 
	{
		"There isn't any way to change that. ";
	}
	
	verDoCheckWith( actor, io ) = {}
	
	verIoCheckWith( actor ) =
	{
		"%You% can't check for red herrings without a Herring detector. ";
	}
	
	verDoClean( actor ) =
	{
		"\^<<self.thedesc>> <<isThem ? "look" :"looks">> a bit cleaner now. ";
	}
	verDoCleanWith(actor, io) = {}
	doCleanWith(actor, io) =
	{
		"\^<<self.thedesc>> <<isThem ? "look" :"looks">> a bit cleaner now. ";
	}
	verIoCleanWith( actor ) =
	{
		"That isn't something you can clean with. ";
	}
	
	verDoClimb( actor ) = 
	{
		"\^<<self.thedesc>> <<self.isdesc>> not suitable for climbing. ";
	}
	
	verDoClimbDown( actor ) =
	{
		"You can't climb down that. ";
	}
	
	verDoConsultAbout( actor, io ) = { self.verDoAskAbout( actor, io ); }
	doConsultAbout( actor, io ) = { self.doAskAbout( actor, io ); }
	
	verIoConsultAbout( actor ) = {}
	ioConsultAbout( actor, dobj ) = { dobj.doAskAbout( actor, self ); }
	
	verDoCount( actor ) = { "There isn't much point to that. "; }
	
	verDoDeposit( actor ) = 
	{
		"I don't know to deposit <<self.thedesc>>. ";
	}
	
	verIoDigWith( actor ) = 
	{
		"%You% can't dig with that. ";
	}
	
	verDoDigWith( actor, io ) = {}
	
	verDoDrawOn( actor, io ) = {}
	
	verDoDrawOnWith( actor, io ) = 
	{
		"There's no good surface on <<self.thedesc>>. ";
	}
	
	verIoDrawOn( actor ) = 
	{
		"There's no good way to draw on <<self.adesc>>. ";
	}
	
	verIoDrawOnWith( actor ) = 
	{
		"I don't know how to do that with <<self.adesc>>. ";
	}
	
	verDoEmpty( actor ) = { self.verDoClean( actor ); }
	doEmpty( actor ) = { self.doClean( actor ); }
	
	verDoExcreteIn( actor ) =
	{
		if ( self.location.indoors || isclass( self, NPC ) )
			"That would be more than a little inappropriate. ";
		else
			"You don't really have the urge. ";
	}
	
	verDoFill( actor ) =
	{
		"I don't know how to fill <<self.thatdesc>>. ";
	}
	
	verDoFillWith( actor, io ) =  
	{
		"I don't know how to fill <<self.thedesc>> with <<io.thatdesc>>. ";
	}
	
	verIoFillWith( actor ) = 
	{
		"You can't fill anything with <<self.thatdesc>>. ";
	}
	
	verDoFind( actor ) =
	{
		if ( self.isIn( Me ) )
			"You're holding <<self.itobjdesc>>. ";
		else
			"\^<<self.itisdesc>> right here. ";
	}
	
	verIoFixWith( actor ) = 
	{
		"That's not a tool you can use. ";
	}
	
	verDoFlush( actor ) =
	{
		"\^<<self.thatdesc>> <<self.isntdesc>> something you can flush. ";
	}
	
	verDoGood( actor ) =
	{
		"If you say so. ";
	}
	
	verDoHackWith( actor, iobj ) = {}
	verIoHackWith( actor ) = 
	{
		"\^<<self.adesc>> isn't a good tool for that. ";
	}
	
	verDoHello( actor ) =
	{
		if ( topLocation( Me ) != topLocation( self ) )
		{
			if ( self.isNPC )
				"I don't see <<self.fmtYoum>> here. ";
			else
				"I don't see any <<self.sdesc>> here. ";
		}
	}
	doHello( actor ) =
	{
		"You can't talk to <<self.thatdesc>>. ";
	}
	
	verDoInvestIn( actor ) =
	{
		"You can't invest in that. ";
	}
	
	verDoLaughAt( actor ) = 
	{
		"Your mocking sense of humor is somewhat uncalled for. ";
	}
	
	verDoLeapTo( actor ) =
	{
		"There's no sense in leaping to that. ";
	}
	
	verDoLick( actor ) = 
	{
		"That isn't something you need to taste. ";
	}
	
	verDoLift( actor ) = { self.verDoTake( actor ); }
	doLift( actor ) = { self.doTake( actor ); }
	
	verDoKick( actor ) =
	{
		"Kicking things is more likely to hurt your foot than help your
		situation. ";
	}
	
	verDoKill( actor ) =
	{
		"You shouldn't vent your frustrations on <<self.thedesc>>. ";
	}
	
	verDoKillWith( actor, io ) = 
	{
		"You can't kill things that aren't alive. (And you oughtn't
		kill things that are, to be honest.) ";
	}
	
	verIoKillWith( actor ) = {}
	ioKillWith( actor, dobj ) = 
	{
		"I had no idea you harbored such brutal thoughts. Really, now. ";
	}
	
	verDoKnock( actor ) =
	{
		"Knocking on <<self.thedesc>> has no effect. ";
	}
	
	verDoLetGo( actor ) = { self.verDoDrop( actor ); }
	doLetGo( actor ) = { self.doDrop( actor ); }
	
	verDoLookupIn( actor, io ) = { io.verDoConsultAbout( actor, self ); }
	
	verIoLookupIn( actor ) = 
	{
		"You can't look up anything in that. ";
	}
//	ioLookupIn( actor, dobj ) = { self.doConsultAbout( actor, dobj ); }
	
/*
	verDoLookupIn( actor ) = {}
	
	verIoLookupIn( actor, dobj ) = 
	{
		"You can't look up anything in that. ";
	}
*/
	
	verDoLove( actor ) = { "That's very sweet natured of you. "; }
	
	verDoLower( actor ) = { self.verDoDrop( actor ); }
	doLower( actor ) = { self.doDrop( actor ); }
	
	verDoMake( actor ) = 
	{
		"I don't understand what you want to make. ";
	}
	
	verDoOpenWith( actor, io ) = 
	{
		"I don't know how to open that. ";
	}
	
	verIoOpenWith( actor ) = 
	{
		"You can't open things with that. ";
	}
	
	verDoPay( actor ) = 
	{
		"I don't understand that sentence. ";
	}
	
	verDoPlayWith( actor ) =
	{
		"You play with <<self.thedesc>> for a few idle moments. ";
	}
	
	verIoPlay_With( actor ) = {}
	verDoPlay_With( actor, io ) = 
	{
		"I don't know how to play that with anything. ";
	}
	
	verDoPlover( actor ) =
	{
		"Nothing happens. ";
	}
	
	verDoPoint( actor ) = 
	{
		"You point at <<self.thedesc>>. ";
	}
	
	verDoPointAt( actor, io ) = 
	{
		if ( io != detector ) {
			if ( self.isfixed || self.stationary ) 
				"There's no way you can do that. ";
			else if ( self.deepIsIn( Me ) ) {
				if ( self.location = Me ) 
					"Okay, %you% point <<self.thedesc>> at <<io.thedesc>>. ";
				else 
					"You'll need to take <<self.thedesc>> out 
					of <<self.location.thedesc>> first. ";
			}
			else
				"You need to be holding <<self.thedesc>> before you
				can point it at anything. ";
		}
	}
	verIoPointAt( actor ) = {}
	
	verDoPoint_atWith( actor, io ) = {}
	verIoPoint_atWith( actor ) = {}
	ioPoint_atWith( actor, dobj ) =
	{
		"Okay, you point at <<dobj.thedesc>> with <<self.thedesc>>. ";
	}
	
	verIoPourIn( actor ) = 
	{
		"%You% can't pour into that. ";
	}
	
	verDoPow( actor ) =
	{
		if ( not global.wizard ) 
			"You have to be a wizard to do that. ";
	}
	
	verDoPutUnder( actor, io ) = {}
	
	verIoPutUnder( actor ) = 
	{
		"You can't put anything under that. ";
	}
	ioPutUnder( actor, dobj ) =
	{
		"I don't know how to put <<dobj.thedesc>> under that. ";
	}
	
	verDoPrayFor( actor ) = 
	{
		"I'm not sure what the point would be. ";
	}
	
	verDoPryWith( actor, io ) = {}
	
	verIoPryWith( actor ) = 
	{
		"That isn't something %you% can pry with. ";
	}
	
	verDoRelax( actor ) =
	{
		"I don't know how to relax <<self.thatdesc>>. ";
	}
	
	verDoRub( actor ) = 
	{
		"Rubbing <<self.thedesc>> has no useful effect. ";
	}
	
	verDoScratch( actor ) =
	{
		"\^<<self.thatdesc>> <<self.isntdesc>> something you need to scratch. ";
	}
	
	verDoSell( actor ) = 
	{
		if ( Me.location != antiqueStore )
			"I don't think anyone is in the market for that. ";
	}
	doSell( actor ) =
	{
		antiqueMerchant.ioSellTo( actor, self );
	}
	
	verDoSellTo( actor, io ) = {}
	doSellTo( actor, io ) = { return( nil ); }
	
	verIoSellTo( actor ) = 
	{
		"You can't sell anything to <<self.adesc>>. ";
	}
	ioSellTo( actor, dobj ) = 
	{
		dobj.doSellTo( actor, self );
	}
	
	verDoSmell( actor ) = 
	{
		self.smellDesc;
	}
	
	verDoSnarf( actor ) =
	{
		if ( not global.wizard ) 
			"You have to be a wizard to do that. ";
		else self.verDoTake( actor );
	}
	doSnarf( actor ) =
	{
		self.doTake( actor );
	}
	
	verDoSprayOn( actor, io ) = 
	{
		"You can't spray anything with <<self.thatdesc>>. ";
	}
	verIoSprayOn( actor ) = {}
	ioSprayOn( actor, dobj ) =
	{
		dobj.ioSprayWith( actor, self );
	}
	
	verDoSprayWith( actor, io ) = {}
	verIoSprayWith( actor ) = 
	{
		"You can't spray anything with <<self.thatdesc>>. ";
	}
	ioSprayWith( actor, dobj ) = 
	{
		dobj.doSprayWith( actor, self );
	}
	
	verDoStabWith( actor, io ) = 
	{
		"Violence isn't the answer to this one. ";
	}
	
	verIoStabWith( actor ) =
	{
		"You can't stab anything with <<self.thatdesc>>. ";
	}
	
	verDoStandUp( actor ) =
	{
		"I don't know how to stand <<self.thatdesc>> up. ";
	}
	
	verDoStartWith( actor, io ) = 
	{
		"I don't know how to start <<self.thedesc>>. ";
	}
	
	verIoStartWith( actor ) =
	{
		"I don't know how to start anything with <<self.thedesc>>. ";
	}
	
	verDoSwimIn( actor ) = 
	{
		"\^<<self.thatdesc>> <<self.isntdesc>> something you can swim in. ";
	}
	
	verDoSwing( actor ) = 
	{
		"I don't know how to swing on <<self.thedesc>>. ";
	}
	
	verDoTalkTo( actor ) =
	{
		"You can't talk to <<self.adesc>>. ";
	}
	
	verDoTaste( actor ) = 
	{
		"That isn't something you need to taste. ";
	}
	
	verDoThinkAbout( actor ) = 
	{
		"You think about <<self.thedesc>> for a while, ";
		
		if ( self.herring )
			"and you soon start to wonder if <<self.thedesc>> is really 
			useful for anything at all. ";
/*
		else if ( !self.isSeen )
			"but since you haven't even seen <<self.thatdesc>> yet, you 
			do so kind of abstractly. ";
*/
		else "but no penetrating new levels of understanding occur to you. ";
	}
	
	verDoThrowIn( actor, io ) = { self.verDoPutIn( actor, io ); }
	verIoThrowIn( actor ) = { self.verIoPutIn( actor ); }
	ioThrowIn( actor, dobj ) = { self.ioPutIn( actor, dobj ); }
	
	verDoThrowOut( actor, io ) = {}
	doThrowOut( actor, io ) = 
	{
		io.ioThrowOut( actor, self );
	}
	
	verIoThrowOut( actor ) = 
	{
		"I don't recommend throwing anything out of <<self.thedesc>>. ";
	}
	
	verDoTickle( actor ) = 
	{
		"You can't tickle <<self.thatdesc>>. ";
	}
	
	verDoTickleWith( actor, io ) =
	{
		"You don't need to tickle <<self.thatdesc>> with <<io.thedesc>>. ";
	}
	
	verIoTickleWith( actor ) = {}
	
	verDoTieTo( actor, io ) = {}
	doTieTo( actor, io ) = 
	{
		io.ioTieTo( actor, self );
	}
	
	verIoTieTo( actor ) = 
	{
		"I don't know how to tie "; self.adesc; " to anything. ";
	}
	ioTieTo( actor, dobj ) =
	{
		dobj.doTieTo( actor, self );
	}
	
	verDoTime( actor ) = { "I don't understand what you mean. "; }
	
	verDoTouch( actor ) = {}
	doTouch( actor ) = 
	{
		"\^<<self.thedesc>> <<self.isThem ? "feel " : "feels ">> ";
		
		if ( self.heat != nil )
			self.sayTemperature;
		else
			"like <<self.adesc>>";
		". ";
	}
	
	verDoTurnIn( actor, io ) =
	{
		"Turning <<self.thedesc>> doesn't have any effect. ";
	}
	
	verIoTurnIn( actor ) = {}
	ioTurnIn( actor, dobj ) =
	{
		"Turning <<dobj.thedesc>> doesn't have any effect. ";
	}
	
	verIoTypeOn( actor ) = 
	{
		"I don't know how to type anything on <<self.thatdesc>>. ";
	}
	
	verDoUntie( actor ) = { rope.verDoUntie( self ); }
	
	doUntie( actor ) = { rope.disEngage( self ); }
	
	verDoUse( actor ) =
	{
		"You'll have to be more specific about how you want to use
		<<self.thedesc>>. ";
	}
	
	verIoUseOn( actor ) = {}
	verIoUseWith( actor ) = {}
	verIoUseIn( actor ) = {}
	
	verDoUseOn( actor, io ) = { self.verDoUse( actor ); }
	verDoUseWith( actor, io ) = { self.verDoUse( actor ); }
	verDoUseIn( actor, io ) = { self.verDoUse( actor ); }
	
	ioUseOn( actor, dobj ) = { dobj.doUseOn( actor, self ); }
	ioUseWith( actor, dobj ) = { dobj.doUseWith( actor, self ); }
	ioUseIn( actor, dobj ) = { dobj.doUseIn( actor, self ); }
	
	verDoWadeIn( actor ) = 
	{
		"I don't know how to wade in <<self.thatdesc>>. ";
	}
	
	verDoWaitFor( actor ) =
	{
		if ( self.location = Me.location )
			"But <<self.thedesc>> is right here! ";
	}
	doWaitFor( actor ) =
	{
		"Time passes... ";
	}
	
	verDoWalk( actor ) =
	{
		"If I could walk that way, I wouldn't need <<self.thedesc>>. ";
	}
	
	verDoWaylay( ator ) =
	{
		"Waylaying isn't the answer to this one. ";
	}
	verDoWhatIs( actor ) =
	{
		if ( not self.isSeen )
			"You haven't seen <<self.thatdesc>> yet. ";
	}
	doWhatIs( actor ) =
	{
		"\^<<self.itisdesc>> <<self.adesc>>. Sorry, I know that 
			isn't very helpful. ";
		if ( self.isIn( actor.location ) )
			"You might try examining it instead. ";
	}
	verDoWhereIs( actor ) =
	{
		if ( not self.isSeen )
			"You haven't seen <<self.thatdesc>> yet. ";
	}
	doWhereIs( actor ) =
	{
		if ( actor = self )
			self.location.lookAround( nil );
		else if ( actor.isCarrying( self ) )
			"You're holding it. ";
		else if ( self.isIn( actor.location ) )
			"\^<<self.thedesc>> is right here. ";
		else if ( self.location = stuckLimbo )
			"You dropped it down the drainpipe. ";
		else if ( self.isSeen )
			"\^<<self.location.sdesc>>. ";
		else if ( self.location && self.location.isseen )
			"You might look here: <<self.location.thedesc>>. ";
		else
			"You don't know where <<self.thatdesc>> <<self.isdesc>>. ";
	}
	verDoWhoIs( actor ) =
	{
		if ( not self.isSeen )
			"You haven't seen <<self.thatdesc>> yet. ";
	}
	doWhoIs( actor ) =
	{
		"\^<<self.adesc>> is a 'what' not a 'who.' ";
	}
	verDoWhoAreYou( actor ) = 
	{
		"I think you must be losing it. \^<<self.thedesc>> cannot answer questions. ";
	}
	verDoWhatAreYou( actor ) = 
	{
		"I think you must be losing it. \^<<self.thedesc>> cannot answer questions. ";
	}
	verDoWhoAmI( actor ) =
	{
		"I think you must be losing it. ";
	}
	
	verDoXyzzy( actor ) =
	{
		"Nothing happens. ";
	}
	
	verDoYellAt( actor ) = 
	{
		"You scream at <<self.thedesc>> for a while. The stress must be 
		getting to you. ";
	}
	
	verDoYellFor( actor ) =
	{
		if ( self.location = Me.location )
			"\^<<self.thedesc>> is right here. There's no need to yell. ";
		else
			"%Your% throat is a bit sore now. ";
	}
	
	verDoZapTo( actor, io ) = {}
	
	verIoZapTo( actor ) = 
	{
		if ( not actor.islit )
			"Hey! You don't have wizard powers! ";
	}
	ioZapTo( actor, dobj ) =
	{
		"Zap! \^<<dobj.sdesc>> disappears! ";
		if ( self.location )
			dobj.moveInto( self.location ); 
		else
			dobj.moveInto( nil );
	} 
;

class throwable: item
	getSlobbery = 
	{
		self.slobbery := true;
		addword( self, &adjective, 'saliva');
		addword( self, &adjective, 'slobber');
		addword( self, &adjective, 'slobbery');
	}
	verDoCatch( actor ) =
	{
		"Someone would have to throw you <<self.thedesc>> for you to catch it. ";
	}
	
	doThrow( actor ) = 
	{						
		local curloc, thrownLoc, foo;
		
		curloc := actor.location;
		
		"%You% throw%s% <<self.thedesc>>. ";
		
		if ( isclass( curloc, treeRoom ) )
			curloc := southOfHouse;
		else if ( isclass( curloc, FtreeRoom ) )
			curloc := FsouthOfHouse;
		
		switch( curloc )
		{
			case diggingSpot:
				"It bounces on the sloping ground and starts to roll
				away, but is stopped by the thick grasses in the woods. ";
				thrownLoc := FPwoods;
				break;
			case PsouthOfHouse:
				"It bounces on the sloping ground and starts to roll
				away, but is stopped by the thick grasses in the woods. ";
				thrownLoc := Fwoods;
				break;
			case southOfHouse: 
				"It bounces on the sloping ground and starts to roll
				away, gaining momentum as it goes. ";
				thrownLoc := clearing;
				break;
			case FsouthOfHouse:
				"It bounces on the sloping ground and starts to roll
				away, gaining momentum as it goes. ";
				thrownLoc := Fclearing;
				break;
			case northRoof:
			case southRoof:
				foo := _rand( 4 );
				switch( foo )
				{
					case 1:
						"It sails off the roof to the north, and
						bounces into the driveway. ";
						thrownLoc := driveway;
						break;
					case 2:
						"It hits the front driveway, bouncing and
						rolling up the street. ";
						thrownLoc := bend;
						break;
					case 3:
						"It hits the sloping ground at the south of
						the house, and begins rolling away through
						the woods. ";
						thrownLoc := clearing;
						break;
					case 4:
						"It sails off the roof into the back yard,
						bouncing a number of times before coming to
						rest. ";
						thrownLoc := behindHouse;
						break;
				}
				break;
			case FnorthRoof:
			case FsouthRoof:
				foo := _rand( 4 );
				switch( foo )
				{
					case 1:
						"It sails off the roof to the north, and
						bounces into the driveway. ";
						thrownLoc := Fdriveway;
						break;
					case 2:
						"It hits the front driveway, bouncing and
						rolling up the street. ";
						thrownLoc := Fsidewalk;
						break;
					case 3:
						"It hits the sloping ground at the south of
						the house, and begins rolling away towards
						the clearing. ";
						thrownLoc := Fclearing;
						break;
					case 4:
						"It sails off the roof into the back yard,
						bouncing a number of times before coming to
						rest. ";
						thrownLoc := FbehindHouse;
						break;
				}
				break;
			case platform:
				"It lands nearby. ";
				thrownLoc := Me.location.location;
				break;
			case insideShed:
				"\^<<Blackie.thedesc>> tears off after <<self.itobjdesc>>! You hear his 
				playful barking disappear into the woods. ";
				
				self.getSlobbery;
				Blackie.retrieveItem := self;
				Blackie.moveInto( nil );
				thrownLoc := nil;
				notify( Blackie, &retrieveThrowable, 0 );
				break;
			default:
				"It lands nearby. ";
				thrownLoc := Me.location;
				break;
		}
		self.moveInto( thrownLoc );
	}
	
	doThrowAt( actor, io ) = { self.doThrowTo( actor, io ); }
	doThrowTo( actor, io ) =
	{
		switch( io )
		{
			case Fred:
				deepGrab( self );
				"Fred catches <<self.thedesc>> and says, \"Whoop! Think 
				fast!\"\ as he tosses it back to you. ";
				break;
			case Blackie:
				deepGrab( self );
				"You fling <<self.thedesc>>";
				if ( topLocation( Blackie ) = insideShed ) 
					" out of the shed. ";
				else
					" as hard as you can. ";
				"\^<<io.thedesc>> tears 
				off after <<self.itobjdesc>>! You hear his playful barking disappear 
				into the woods. ";
				
				self.getSlobbery;
				Blackie.retrieveItem := self;
				Blackie.moveInto( nil );
				notify( Blackie, &retrieveThrowable, 0 );
				break;
			case youngMan:
				deepGrab( self );
				"The young man catches <<self.thedesc>> and, smiling, tosses it
				back to you. ";
				break;
			case FFred:
				"\^<<FFred.thedesc>> grumbles, \"Geddoudahere with that. I'm not
				a dog.\" ";
				break;
			case Laura:
			case FLaura:
			case FFLaura:
			case Architect:
			case workers:
			case securityGuard:
			case squirrel:
				"\^<<io.thedesc>> <<io.isntdesc>> interested
				in playing catch with you right now. ";
				break;
			case suspiciousSuits: 
				"You would rather not alert them to your presence. ";
				break;
			case frontOfHouseWindows:
				"\^<<self.thedesc>> bounces off the wall next to the window and
				back down to the ground. ";
				self.moveInto( Me.location );
				break;
			case trunkRoomAtticOpening:
			case gapingHoleInSouthRoof:
				"\^<<self.thedesc>> sails into the ragged opening and
				disappears, with a thunking noise, inside. ";
				self.moveInto( Fattic );
				break;
			default:
				if ( isclass( Me.location, treeRoom ) )
				{
					"\^<<self.thedesc>> bounces off <<io.thedesc>>. 
					It falls to the sloping ground, bounces again, and 
					rolls away, gaining momentum as it goes. ";
					self.moveInto( clearing );
				}
				else if ( isclass( Me.location, FtreeRoom ) )
				{
					"\^<<self.thedesc>> bounces off <<io.thedesc>>. 
					It hits the sloping ground, bounces again, and rolls
					away, gaining momentum as it goes. ";
					self.moveInto( Fclearing );
				}
				else
				{
					"\^<<self.thedesc>> bounces off <<io.thedesc>> and
					lands nearby. ";
					self.moveInto( Me.location );
				}
				break;
		}
	}
;

/*	treasure: item
 *
 *	This is an item that scores points when picked up, and are added to
 *	the scoreCard under miscellaneous points.
 *
 *	When a treasure is taken for the first time, we'll add the object's 
 *	"takevalue" to the overall score using the incscore routine.
 */
class treasure: item
	istreasure = true
	takevalue = 5	   		// default point value when object is taken
	hasScored = nil
	
	doTake( actor ) =
	{
		if ( not self.hasScored )	   	// have we scored yet?
		{
			incscore( self.takevalue ); 	// add our "takevalue" to the score
			self.hasScored := true;	 	// note that we have scored
			global.scoreCard[27] += self.takevalue;
		}
		
		pass doTake;			// continue with the normal doTake from "item"
	}
;

class moneyItem: item
	sdesc = { "some money (<<self.countMoney>>)"; }
	adesc = { self.sdesc; }
	thedesc = { "the "; self.countMoney; }
	ldesc = 
	{
		if ( self.deepIsIn( Me ) )
			"Money: You have <<self.countMoney>>. ";
		else
			"I see nothing special about <<self.thedesc>>. ";
	}
	countMoney =
	{
		if ( self.value > 0 )
		{
			sayPrefixCount( self.value );
			"<<value = 1 ? " dollar" : " dollars">>";
		}
		else
			"no money";
	}
	smellDesc = "Mmmmm, smells like money. "
	noun = 'money'
	adjective = 'bills' 'bill' 'dollar' 'dollars' 'cash' 'loot' 'pelf' 'lucre'
			'mammon' 'geld' 'gelt' 'coins' 'coin' 'dough' 'scratch' 'sawbuck'
			'c-note' 'notes' 'ones' 'tens' 'fives' 'twenties' 'wad' 'wads'
	value = 0
	isThem = { return( self.value > 1 ); }
	bulk = 
	{ 
		if ( self.value <= 1000 )
			return( 1 );
		if ( self.value <= 2000 )
			return( 2 );
		if ( self.value <= 3000 )
			return( 3 );
		if ( self.value <= 4000 )
			return( 4 );
		if ( self.value <= 5000 )
			return( 5 );
		if ( self.value <= 6000 )
			return( 6 );
		if ( self.value <= 7000 )
			return( 7 );
		if ( self.value <= 8000 )
			return( 8 );
		if ( self.value <= 9000 )
			return( 9 );
		if ( self.value <= 10000 )
			return( 10 );
		return( 11 );
	}
	verDoDeposit( actor ) = 
	{
		if ( Me.location != inTheBank )
			"You need to go to the bank to do that. ";
	}
	doDeposit( actor ) = { deposit.doMake( actor ); }
	verDoDepositIn( actor, io ) = 
	{
		if ( io != account )
			"You need a bank account to deposit the money into. "; 
	}
	
	verIoBribeWith( actor ) = {}
	ioBribeWith( actor, dobj ) = { dobj.doBribeWith( actor, self ); }
	
	doTake( actor ) =
	{
		if ( self.isIn( Me ) || self.deepIsIn( topLocation( Me ) ) ) {
			inherited.doTake( actor );
			if ( self.location = Me ) {
				global.money += self.value;
			}
		}
		else
		{
			handleMoneyTrade( self, self.value );
			"Taken. ";
		}
	}
	doDrop( actor ) =
	{
		local oldLoc;
		oldLoc := self.location;
		
		inherited.doDrop( actor );
		
		if ( self.location != oldLoc )
			global.money -= self.value;
	}
	
	doPutIn( actor, io ) =
	{
		local oldLoc;
		oldLoc := self.location;
		
		inherited.doPutIn( actor, io );
		
		if ( self.isIn( Me ) )
		{
			if ( oldLoc != Me && ( not oldLoc.isIn( Me ) ) )
				handleMoneyTrade( self, self.value );
		}
		else if ( ( oldLoc = Me || oldLoc.isIn( Me ) ) && 
			( self.location != oldLoc ) )
			global.money -= self.value;
	}
	
	askingAboutMe( who ) = 
	{
		switch( who )
		{
			case Fred:
				"Fred says, \"What do I look like, an economics professor?
				I just sell sandwiches.\" ";
				return( true );
			case Laura:
				if ( account.isopen )
					"Laura says, \"Did you want to deposit that? Because you'll
					have to see the teller about deposits.\" ";
				else
				{
					if ( self.value >= 100 )
						return( account.askingAboutMe( Laura ) );
					else
						"Laura says, \"That's not quite enough to open an account,
						I'm afraid.\" ";
				}
				return( true );
			case Architect:
				"He says, \"You've already paid me to work on this project,
				thank you. I wouldn't be here if you hadn't.\" ";
				return( true );
			default:
				return( nil );
		}
	}
;

class constructionSite: room
	constructionArea = true
	listenDesc = 
	{
		if ( not workers.onLunchBreak )
			return( workers.listenDesc );
		else pass listenDesc;
 	}
	smellDesc = "You smell <<workers.onLunchBreak ? "sawdust and hearty lunches" :
			"sawdust">> in the air. "
	enterRoom( actor ) = 
	{
		if ( actor = Me && not workers.onLunchBreak )
		{
			workers.numberOfDaemonsRunning++;
			if ( workers.numberOfDaemonsRunning < 3 )
				notify( workers, &actorDaemon, 0 );
		}
		pass enterRoom;
	}
;

class skyscraperRoom: room
	inSkyscraper = true
	indoors = true
	lightDesc = "The lighting is cool and flat, blanching all warmth from human
				skin. "
	listenDesc = 'You hear the soft roar of powerful air conditioning units. '
	smellDesc = "The air smells sterile, almost antiseptic. "
;

class elevatorRoom: skyscraperRoom
	elevatorLoc = true
;

class subBasementRoom: skyscraperRoom
	inSubBasement = true
	lightDesc = "Fluorescent lighting fixtures flicker overhead. "
	smellDesc = "The air is conditioned and cold, almost antiseptic smelling. "
;

class elevatorButtonItem: fixedBlock, buttonitem
	adesc = { "an <<self.sdesc>> button"; }
	thedesc = { self.sdesc; }
	location = inTheElevator
	noun = 'button' 
	adjective = 'floor'
	
	doPush( actor ) = 
	{
		"You push the <<self.sdesc>> button. ";
		
		if ( inTheElevator.outLoc = self.destination )
			"Nothing happens. ";
		else
		{
			"The elevator begins to move. After a smooth ride, it arrives 
			at <<self.destinationDesc>>. ";
			inTheElevator.outLoc := self.destination;
		}
	}
;

class transitionRoom: skyscraperRoom
/*	dispBeginLdesc = "\b"
	lookAround( verbosity ) =
	{
		self.dispBeginLdesc;
		self.ldesc;
		self.dispEndLdesc;
	}
*/
	firstseen = { Me.travelTo( self.nextLoc ); }
;


modify surface
	verDoLookin( actor ) = { self.verDoSearch( actor ); }
	doLookin( actor ) = { self.doSearch( actor ); }
;


/* priseItems can be used for prying things open */
class priseItem: item
	verDoUseOn( actor, io ) = {}
	doUseOn( actor, io ) = { self.ioPryWith( actor, io ); }
	verDoUseWith( actor, io ) = {}
	doUseWith( actor, io ) = { self.ioPryWith( actor, io ); }
	
	verIoOpenWith( actor ) = {}
	ioOpenWith( actor, dobj ) = { self.ioPryWith( actor, dobj ); }
	
	verIoPryWith( actor ) = {}
	ioPryWith( actor, dobj ) = 
	{
		"\^<<self.thedesc>> can't help you with that. ";
	}
;

/* diggingItems can be used to dig with */
class diggingItem: item
	verIoDigWith( actor ) = {}
	ioDigWith( actor, dobj ) = 
	{
		"Digging in <<dobj.thedesc>> won't accomplish anything. ";
	}
;

/* hackItems can be used to hack things with */
class hackItem: item
	verIoHackWith( actor ) = {}
	ioHackWith( actor, dobj ) = 
	{
		"\^<<self.thedesc>> isn't any good for that. ";
	}
	verIoHackDirWith( actor ) =
	{
		"You can only hack objects, not directions. ";
	}
	ioKillWith( actor, dobj ) = 
	{
		if ( dobj = squirrel )
			"The poor thing scampers out of the way, regarding you
			with great suspicion. However, squirrels have short 
			attention spans, so it goes back to its normal squirrely
			business moments later. ";
		else
			"Such violence is really inappropriate. ";
	}
;

/* Topics are used for NPC conversation */
class Topic: fixeditem
;

class stockItem: buyable, floatingItem
	isStock = true
	noun = 'stock'
	plural = 'stocks'
	isListed = nil
	myMerchant = PLaura
	location = { return( Me.location ); }
	startLoc = nil
	cost = 0
	shares = 0
	isOwned = nil
	
	verDoBuy( actor ) = 
	{
		if ( Me.location != self.myMerchant.location )
			"You can't buy that here. ";
		else if ( self.boughtOnce = true )
		{
			"You already bought <<self.adesc>>. ";
		}
	}
	doBuy( actor ) =
	{
		local totalWealth;
		
		totalWealth := global.money + account.P;
		
		if ( totalWealth = 0 )
			"Don't waste <<self.myMerchant.thedesc>>'s time. You don't have 
			any money. ";
		else if ( totalWealth < self.cost )
			"Don't waste <<self.myMerchant.thedesc>>'s time. You don't have 
			enough money. ";
		else
		{
			"Laura says, \"<<self.sdesc>>? Let's see.\" ";
			self.handleStockPurchase;
		}
	}
	
	handleStockPurchase =
	{
		local totalWealth;
		
		totalWealth := global.money + account.P;
		
		"Laura types for a moment on her computer. ";
		
		if ( self.isOwned ) 
		{
			"Laura says, \"Hang on, you're already a shareholder in <<self.sdesc>>. I
			really don't advise you to buy any more shares at this time.\" ";
			return;
		}
		else if ( self.cost <= account.P )
		{
			"\"Well, you seem to have enough money in your account now. I guess
			I was wrong about that. Still, I think investing what you have is the
			way to go.\" ";
			
			account.P -= self.cost;
			self.isOwned := true;
			
			"Laura says, \"Okay, you're all set. At <<self.sayPrice>>, you now 
			own <<self.shares>> shares of <<self.sdesc>> stock. Hope it helps 
			you out down the road.\" ";
		}
		else if ( self.cost <= totalWealth )
		{
			"\"You only have $<<account.P>> in your account right now. If you have
			more you can deposit, you should do that so that I can handle the 
			transfer electronically. The teller should help you with that. Then
			come back and talk to me about <<self.sdesc>>.\" ";
		}
		else 
		{
			"\"I hate to break it to you, but you're going to need five thousand
			dollars before I can make any investments for you. I wish I could help
			you come up with it, but I can't.\" ";
		}
	}
;



/******** END OF NEW CLASS DEFINITIONS ********/


/* eof */
