// VARIOUS OBJECTS

// Earth/Spaceship objects

hoe: vulnerable
	sdesc = "hoe"
	ldesc = "It looks like every other hoe you have seen."
	noun = 'hoe'
	location = f2
;

chest: openable, readable
	fragile = true
	vol = true
	isopen = nil
	maxbulk = 50
	sdesc = "small plastic chest"
	ldesc ="The chest is about one foot square.  There is some writing on its lid."
	readdesc = {
		if (translator.location = Me)
			"The writing on the chest is like nothing you have ever seen before.  Strangely though  
			you can understand it.  It reads:\bSuper Sturdy Transdimensional Chest.\n
			Guaranteed to last in any planetary environment.\nWARNING:\n
			\t\tPLACING ANY SORT OF CONTAINER IN THIS CHEST\n
			\t\tMAY RESULT IN A DIMENSIONAL IMPLOSION\n";
		else
			"The writing on the chest is nothing like you have every seen before.  You 
			cannot even begin to comprehend it.";
		}
	noun = 'chest'
	adjective = 'small' 'plastic'
	location = bedroom
	doOpen(actor) = {
		if (itemcnt(self.contents))
			{
			"Opening ";self.thedesc;" reveals ";listcont(self);". ";
			if((Me.location).onvenus) setdaemon (cvcount,nil);
			}
		else
			"Opened.";
		self.isopen := true;
		}
	doClose(actor) = {
		if(self.isopen)
		{
		"Closed. ";
		self.isopen := nil;
			if((Me.location).onvenus) 
			{
			remdaemon(cvcount,nil);
			if (rope.td and rope.location = chest) 
				{
				remdaemon(vropecount, nil);
				rope.td := nil;
				}
			}
		}
		else "The chest is already closed!";
		}
	ioPutIn(actor, dobj) ={
		if (dobj.iscontainer) {
			"You place <<dobj.thedesc>> in the chest and the chest starts to hum and distort 
			from within.  You gawk in disbelief as the chest implodes into nothing, ripping open a 
			tear in space.  Everything in the room flies into the vacuum beyond the tear, including 
			yourself.";
			die();
			}
		else pass ioPutIn;
		}
;

gloves: vulnerable, clothingItem
	sdesc = "pair of gloves"
	ldesc = "The gloves are made of a very thick material and appear to be made for someone with 
		six fingers.  Even so, it looks like the gloves can fit on your hands."
	noun = 'gloves'
	preposition = 'of'
	adjective = 'pair'
	location = chest
	isworn = nil
;

flyer: vulnerable, readable
	sdesc = "piece of yellow paper"
	ldesc = "The <<self.sdesc>> is slightly faded and has some writing on it."
	noun = 'paper'
	adjective = 'yellow'
	location = chest
	readdesc = {
		if (translator.location <> Me)
			"You can't understand the writing, much less read it.";
		else
			"\b\bTRJ5 Pressure Suit
			\bFeatures:\n\tProvides complete protection from pressures from 
			vacuum to several thousand atmospheres.\n\t
			Thermal protection from 0.75 to 2010 degrees Kelvin\n\t
			Suit provides various atmospheres which are continually regenerated 
			through the latest technology.\b
			One size fits all known humanoid lifeforms under ten feet in hight.\b
			Warning: Suit has been known to fail in the proximity of large 
			gravitational fields and space-time distortions.\b\tSatisfaction guaranteed or your money back.";
		}
;

flash: lightsource, vulnerable
	fragile = true
	islit = nil
	isactive = true
	sdesc = "flashlight"
	noun = 'flashlight' 'light'
	count = 0
	location = backpack
	donce = nil
	darktest = nil
	ldesc = {
		"It is your ordinary, run of the mill, guaranteed never to go out 
		disposable flashlight. ";
		if (self.islit)
		"Currently, the flashlight is lit.";
		else
		"Currently, the flashlight is off.";
		}
	verDoTurnon(actor) = {
		if (self.islit) {"The flashlight is already on!";}
		}
	doTurnon(actor) = {
		if (self.isactive) {
		"The flashlight is now on.";
		darkitem.darkcount := 0;
		if (not Me.location.islit){ self.darktest := true;}
		self.islit := true;
		setdaemon (flashcount, nil);
		if(self.darktest){"\b";
			actor.location.lookAround( true );
			self.darktest := nil;}
			}
		else
			{"The flashlight has run out of power.  I guess its guarantee wasn't all that 
			reliable.";
			exit;
			}
		}
	verDoTurnoff(actor) = {if(not self.islit) "The flashlight isn't on!";}
	doTurnoff(actor) = {
		"The flashlight is now off.";
		darkitem.darkcount := 0;
		self.islit := nil;
		remdaemon(flashcount, (flash.count));
		}
;

sandwich:fooditem, vulnerable
	sdesc = "peanut butter sandwich"
	ldesc = "The sandwich is a leftover from lunch."
	noun = 'sandwich'
	adjective = 'peanut' 'butter'
	location = backpack
;

backpack: vulnerable, openable, clothingItem
	sdesc = "backpack"
	ldesc = "It is just an ordinary backpack."
	noun = 'backpack' 'pack'
	location = Me
	isworn = true
	isopen = nil
;

translator: vulnerable
	fragile = true
	sdesc = "thin metal box"
	noun = 'box' 'translator'
	adjective = 'metal' 'thin'
	ldesc = "The box is about three inches long, half an inch thick and perfectly smooth. 
			You have no idea what it is used for or why that alien creature was holding it."
	location = dalien
	donce = nil
	doTake(actor) = {
		"When you pick up the box a flood of words in many languages fills your head.  Strangely, 
		you understand every word.";
		translator.moveInto(Me);
		}
;

suit: pressuresuit
	sdesc = "basic pressure suit"
	ldesc = "It is a standard looking pressure suit complete with built in gloves, boots and helmet.  
			There is a tiny panel on the right wrist of the suit."
	noun = 'suit'
	adjective = 'pressure' 'basic'
	location = closet
	isworn = nil
	H2atm = nil
	O2atm = nil
	NH4atm = true
	weight = 2
	bulk = 3
	doWear(actor) = {
		"You easily fit the pressure suit on which automatically adjusts to your size.  
		As the adjustments finish, a loud hiss emanates from the back of the suit as 
		it pressurizes with an atmosphere. ";
		if (not self.O2atm)
			if(self.H2atm) {
				"After a few moments you start to feel dizzy and the world 
				turns fuzzy.   You pass out.";
				die();}
			if(self.NH4atm) {
				"The pungent small of ammonia slowly fills the suit and you start to feel dizzy.  
				In a panic you try to remove the suit, but you pass out before you can do anything.";
				die();}
		else suit.isworn := true;
		}
;

tinypad: fixeditem, readable
	fragile = true
	vol = true
	sdesc = "tiny panel"
	ldesc = "The panel is just large enough to fit on your wrist.  There 
		is some writing on it as well."
	location = suit
	noun = 'panel'
	adjective = 'tiny' 'wrist'
	readdesc = {
		if(translator.location = Me)
			{
			"OXYGEN\t\tHYDROGEN\t\tAMMONIA\b";
				{
				if(suit.O2atm) "The first word is glowing slightly.";
				if(suit.H2atm) "The second word is glowing slightly.";
				if(suit.NH4atm) "The third word is glowing slightly.";
				}
			}
		else
			{
			"You cannot understand the writing but the ";
				{
				if(suit.O2atm) "first word is glowing slightly.";
				if(suit.H2atm) "second word is glowing slightly.";
				if(suit.NH4atm) "third word is glowing slightly.";
				}
			}
		}
;

firstword: touchitem, readable
	fragile = true
	vol = true
	sdesc = "first word"
	ldesc = {
		if(translator.location = Me) "It says\"OXYGEN.\"";
		else "You cannot understand <<self.thedesc>>.";
		}
	noun = 'word' 'oxygen'
	adjective = 'first'
	donce = nil
	location = tinypad
	doTouch(actor) ={
		if(suit.O2atm) "Nothing happens.";
		else
			{
			suit.H2atm := nil;
			suit.NH4atm := nil;
			suit.O2atm := true;
			"A slight hiss emanates from the wrist panel as you touch 
				the <<self.sdesc>>.";
			if(not self.donce)
				{
				incscore(5);				// 5 for setting proper atmosphere
				self.donce := true;
				}
			}
		}
;

secondword: touchitem, readable
	fragile = true
	vol = true
	sdesc = "second word"
	ldesc = {
		if(translator.location = Me) "It says\"HYDROGEN.\"";
		else "You cannot understand <<self.thedesc>>.";
		}
	noun = 'word' 'hydrogen'
	adjective = 'second'
	location = tinypad
	doTouch(actor) ={
		if(suit.H2atm) "Nothing happens.";
		else
			{
			suit.H2atm := true;
			suit.NH4atm := nil;
			suit.O2atm := nil;
			if (suit.isworn)
				{
				"A loud hiss fills the suit as it repressurizes with a new atmosphere.  You start to 
				fill more and more dizzy as the new atmosphere fills the suit.  You start to struggle 
				with the suit, trying to stop the flow of gas, but pass out before you accomplish anything 
				productive.";
				die();
				}
			else
			"A slight hiss emanates from the writs panel as you touch 
				the <<self.sdesc>>.";
			}
		}
;

thirdword: touchitem, readable
	fragile = true
	vol = true
	sdesc = "third word"
	ldesc = {
		if(translator.location = Me) "It says\"AMMONIA.\"";
		else "You cannot understand <<self.thedesc>>.";
		}
	noun = 'word' 'ammonia'
	adjective = 'third'
	location = tinypad
	doTouch(actor) ={
		if(suit.NH4atm) "Nothing happens.";
		else
			{
			suit.H2atm := nil;
			suit.NH4atm := true;
			suit.O2atm := nil;
			if (suit.isworn)
				{
				"A loud hiss fills the suit as it repressurizes with a new atmosphere.  You start to 
				fill more and more dizzy as the new atmosphere and the smell of cleaning 
				fluid fills the suit.  You start to struggle 
				with the suit, trying to stop the flow of gas, but pass out before you accomplish anything 
				productive.";
				die();
				}
			else
			"A slight hiss emanates from the writs panel as you touch 
				the <<self.sdesc>>.";
			}
		}
;

mattress: beditem
	sdesc = "mattress"
	ldesc = "The mattress is ten feet by four feet and is fastened firmly to the floor."
	noun = 'mattress' 'bed'
	location = bedroom
;

// Mars items

rope: item
	sdesc = {
				if (not rope.td)
					"twenty-foot rope";
				else
					{
					"twenty-foot rope (currently tied to <<rope.tieItem.adesc>>";
					if(Me.location = ledge or Me.location = ropeledge)
					" far up above)";
					else
					")";
				}				
		}
	islisted = {
			if(Me.location = ropeledge) return(nil);
			else
				return(true);
			}
	noun = 'rope'
	adjective = 'twenty-foot'
	location = dispvoid
	tieItem = nil
	td = nil
	vulner = true
	ldesc = {
			"The rope is red, made of a combination of ceramic and organic fibers
			 and is twenty feet in length. ";
			if (self.td)
				{
				"The rope is tied to "; rope.tieItem.adesc; 	
				{
				if (Me.location = ropeledge or Me.location = ledge)
				" far up above.";
				else
				". ";
				}
				}
				}
	verDoTieTo( actor, iobj ) =
		{
			if (self.tieItem )
			{
				"It's already tied to "; rope.tieItem.thedesc; "! ";
			}
		}
	doTieTo(actor, iobj) = {
		if(iobj.tieok)
			{
			"You tie the rope to <<iobj.thedesc>>.";
			rope.tieItem := iobj;
			rope.isfixed := true;
			rope.td := true;
			rope.vulner := nil;
			rope.moveInto(Me.location);
			}
		else
			{"You cannot tie the rope to <<iobj.thedesc>>.";}
		}
	verDoUntie(actor) = {
				if (not self.tieItem)
				{
				"The rope isn't tied to anything!";
				}
				}
	doUntie(actor) ={
			if (Me.location = (rope.tieItem).location)
				{
				"You untie the rope.";
				rope.moveInto(Me.location);
				rope.tieItem := nil;
				rope.isfixed := nil;
				rope.td := nil;
				rope.vulner := true;
				}
				else
				{
				if (rope.location <> Me.location)
				{
				"I don't see what you are talking about.";
				return(nil);
				}
				else
				{
				"You cannot untie the rope from here.";
				return(nil);
				}
				}
				}
	doTake( actor ) =
		{
			if (rope.tieItem)
			{
				"(Untying the rope first )\n";
				rope.tieItem := nil;
				rope.isfixed := nil;
				rope.td := nil;
				rope.vulner := true;
			}
			if(Me.location = ropeledge or Me.location = ledge)
			{
			"You cannot untie the rope from here.";
			return(nil);
			}
			else
			pass doTake;
		}
	verDoClimbdown(actor) = {}
	verDoClimbup(actor) = {}
	doClimbdown(actor) =
			{
			if (Me.location = ropeledge or Me.location = ledge)
				{
				"You cannot climb down any further.\b";
				return (nil);
				}
				if (Me.location = vcave)
					if (rope.tieItem = strock)
					{
					 self.doClimb(actor);
					}
					else
					{
					"It would help if the rope was tied to something before you tried climbing it.";
					return(nil);
					}
			}
	doClimbup(actor) =
			{
			if (Me.location=ropeledge or Me.location = ledge)
				{
				"You heave yourself up out of the pit.\b";
				Me.travelTo(vcave);
				rope.moveInto(vcave);
				}
				else
				{
				"How?";
				return(nil);
				}
			}
	verDoClimb( actor ) =
		{
			if (self.tieItem = nil)
			"It would help if the rope was tied to something before you tried to climb it.\b ";
		}
	doClimb(actor) =
				{
				if (Me.location = ropeledge or Me.location = ledge)
					{
					   self.doClimbup(actor);
					}	

				if (Me.location = vcave)
					{
					"You scramble down the rope.\b";
					Me.travelTo(ropeledge);
					rope.moveInto(ropeledge);
					}
				}
	verDoLetgo(actor) = {}
	doLetgo(actor) ={
				if (Me.location = ropeledge)
				{
				"Ok.  You let go of the rope and plummet to your death.";
				die();
				}
				else
				self.doDrop(actor);
				}
	verDoGeton(actor) ={}
	doGeton(actor) ={
				if (Me.location = ledge)
				{
				"You clamber onto the rope.\b";
				rope.moveInto(ropeledge);
				led.moveInto(ropeledge);
				Me.travelTo(ropeledge);
				}
				else
				{
				"How to propose to do that?";
				return(nil);
				}
				}
	verDoGetoff(actor) = {}
	doGetoff(actor) = {
				if (Me.location = ropeledge)
				{
				"You step on the ledge and let go of the rope.\b";
					Me.travelTo(ledge);
					led.moveInto(ledge);
					rope.moveInto(ledge);
				}
				else
				{
				"How to propose to do that?";
				return(nil);
				}
				}
	verDoGo(actor) ={}
	doGo(actor) = {
				if (Me.location = ledge)
				{
				"You grab the rope and are now hanging on the rope by the ledge.\b";
				Me.travelTo(ropeledge);
				rope.moveInto(ropeledge);
				led.moveInto(ropeledge);
				}
				else
				{
				"How do you propose to do that?";
				return(nil);
				}
				}	
;



clippers: vulnerable
	sdesc = "hedge clippers"
	ldesc = "The clippers looks to be in good shape except for the blades which are rusted 
			shut."
	noun = 'clippers'
	adjective = 'hedge'
	location = mars
;

icesuit: vowelItem, pressuresuit
	sdesc = "polar pressure suit"
	ldesc =" This pressure suit is thermally lined and has ice skates built into the feet."
	noun = 'suit'
	adjective = 'pressure' 'polar'
	location = dispvoid
	weight = 1
	bulk = 2
;

strengthpill: fooditem, vulnerable
	fragile = true
	sdesc = "single green and purple strength enhancement capsule"
	ldesc = "The capsule is colored acid green with a royal purple pattern (belch!).  
		It looks like something you would give to a horse."
	noun = 'capsule' 'pill' 'tablet'
	adjective = 'green and purple' 'strength' 'strength enhancement'
	bought = nil
	location = nil
	iseaten = nil
	doEat(actor) = {
		if(icesuit.isworn or suit.isworn)
			"You cannot eat the pill while wearing the pressure suit!";
		else
			{
			"You manage to swallow the pill (barely).  You feel warm bursts of energy rushing 
			through your body and your strength increases dramatically.  You feel like you can 
			lift anything!";
			self.iseaten := true;
			self.moveInto(dvoid);
			Me.maxweight := 50;
			Me.maxbulk := 20;
			setdaemon (pillcount, nil);
			}
	}
;

gplast: vulnerable, readable
	sdesc = "piece of green plastic"
	ldesc = "It seems the piece of green plastic has some writing on it."
	readdesc = "Insert Wankle rotary engine to fix dispenser drive for ambidextrous laser trinketer."
	noun = 'plastic'
	adjective = 'green' 'piece'
	preposition = 'of'
	location = nil
;

marsmid: vulnerable
	sdesc = "marsmid"
	ldesc = "The marsmid is about the size of a quarter, made of some weird coppery 
			material and has a picture of Mars stamped on both sides."
	noun = 'marsmid' 'coin'
	location = grate
;

// Mercury objects

roughiron: vowelItem, vulnerable
	fragile = true
	sdesc = "average looking rock"
	ldesc = {
		"It's a rock. ";
		if(suit.location = Me)
			"Hmmmmm... That's odd.... The rock must be slightly magnetic because the 
			small amounts of metal in your suit is being drawn towards the rock.";
		}
	noun = 'rock'
	adjective = 'magnetic' 'average' 'looking'
	location = mcove
	taken = nil
	doTake(actor) = {
		if(not self.taken)
			{
			incscore(5);		//5 for getting mercury rock
			self.taken := true;
			}
		pass doTake;
		}
;

//Charon objects

contsphere: item
	fragile = true
	vol = true
	sdesc = "black crystal ball"
	ldesc = "The black sphere is half a foot in diameter and made of some type of 
		crystal."
	noun = 'sphere' 'ball'
	adjective = 'crystal'
	location = schroom
	taken = nil
	doTake(actor) = {
		if (not self.taken)
			{incscore(10);			// 10 for ball
			self.taken := true;
			pass doTake;}
		else pass doTake;
	}
;

sphnote: item, readable
	sdesc = "rumpled note"
	ldesc = "INVENTORY:\b\t\t\t\t\t\t One (1) Chronoprogram Activator Sphere\n
		\t\t\t\t\t\t Ten (10) Pairs of Gravity Boots\n
		\t\t\t\t\t\t Three 93) Mining Lasers\n"
	noun = 'note' 'paper'
	adjective = 'rumpled'
	location = chwerehouse
;

slhammer: vulnerable, readable
	sdesc = "sledgehammer"
	ldesc = "The <<self.sdesc>> looks very heavy and very bulky.  There is some writing on its head."
	readdesc = "100% Modified Pb Alloy"
	noun = 'hammer' 'sledgehammer'
	bulk = 5
	weight = 5
	location = ncoll
	isham = true
	verIoAttackWith(actor)= {}
	ioAttackWith(actor, dobj)={
		if(dobj.location = Me)
				{"You cannot hit the <<dobj.sdesc>> while you are holding it!";
				exit;
				}
		if((Me.location).spsh) 
			{"The ship, sensing you violent action, opens a hole under you feet which 
			you fall into.  You slide along a shaft for a while before you are deposited in the ship's 
			garbage disposal where you are vaporized.";
			die();}
		if(dobj.fragle)
			{
			if(dobj.location = Me.location)
				{
				"With a macho grunt you haul off and smash the sledgehammer into the <<dobj.sdesc>>
				completely pulverizing it.";
				if(dobj.vol)
					{ "  Of course, the <<dobj.sdesc>> did not enjoy being destroyed and shows you 
					its appreciation by exploding.";
					die();}
				dobj.moveInto(dvoid);
				if (dobj.istreasure) incscore(-20);		//-20 for destroying treasure
				exit;
				}
			}
		if(dobj.hno)
			{
			"You hit the <<dobj.sdesc>> with the sledgehammer, but the blow has no 
				effect on it.";
			exit;
			}
		if(dobj = ice) 
			{"You manage to put a tiny dent in the ice sheet.";
			exit;}
		if(dobj = icestrip)
			{
			"The hammer comes down hard on the strip of ice and shatters it.";
			if(Me.location = strip) {"  Unfortunately, you were standing on it at the time.  As you 
				fall to your death you realize that might have not been the greatest idea after all."; die();}
			icestrip.moveInto(dvoid);
			e19.sheetlist := [e15 blk blk blk blk blk e18 e14];
			exit;
			}
		if(dobj = led) {
			if(Me.location = ropeledge) {"You try to swing the hammer to smash the ledge but you 
					loose your grip on the rope and plummet to your death."; die();}
			if(Me.location = ledge) {"The ledge crumbles under the force of the blow from the hammer.  
					Unfortunately, you were standing on the ledge at the time and fall to your death.";
					die();}
				}
		if(dobj = srubblerock) {if (Me.location = scoll) srubup();
										else {"You manage to chip off a piece of the rock.";
												exit;}
								}
		if(dobj = srubble) {srubup();}
		if(dobj = Me or isclass(dobj, bodyitem)) {"You manage to hit yourself in the head with the sledgehammer.  This 
			has the effect of cracking open your skull, caving in your head 
			and casing your brains to spill out onto the floor."; die();}
		if(dobj.pst) {"You haul off and smash the <<dobj.sdesc>> with the hammer.  Fred, does the like 
			to you in return."; die();}
		if(dobj.dmach) {"Little known to you, the Mars government recently passed a law making 
			it legal for all dispensing machines to defend themselves against vandalism.  As you attack 
			the <<dobj.sdesc>> a very large slot open up in the machine, through which many coils 
			emerge.  The coils grab and entangle you and pull you into the slot where you are ground 
			into fertilizer by the internal machinery.";
			die();
			}
		if(dobj = robparts) {"You destroy a few more of the robot parts.";exit;}
		if(dobj =trobparts) {"You smash the robots parts to dust."; trobparts.moveInto(nil);exit;}
		if(dobj = guardrobo) {"You haul off and smash the robot with the hammer.  The robot, thinking this 
				is a love-tap, shows you what it considers to be a real hit."; die();}
		if(dobj.pbuild) {"You a smash a window.  Satisfied?"; exit;}
		if(dobj = mvines or dobj = jungleplants) {"As you pull back to take a swing at the shrubbery, the vines lash out and 
			rip you apart"; die();}
		if(dobj = vcurtain) {"With an explosion of adrenalin you swing at the curtain of vines.  The 
			vines move to avoid your swing and grab your legs, tripping you.  As you try to get up 
			more vines circle around your body and pull you towards the curtain.  The sap on the plants 
			burn your flesh, but that is pleasant compared to what the vines do to you once you are 
			reeled in.";die();}
		if(dobj = labstuff) {"The equipment is smashed enough already."; exit;}
		if(dobj.hmol) {"The museum security system, sensing your impending violent action 
			focuses a disintegrator ray on you and you disintegrate."; die();}
		if(dobj=crystal)
			{
			"Not stopping to think, you swing the <<self.sdesc>> into the crystal.  The 
			crystal demonstrates to you that it did not appreciate the hit by exploding 
			and vaporizing you.";
			die();
			}
		if(dobj=mboulder)
			{
			if (mboulder.swiv = true)
			{
			if(mboulder.crack = 0)
				{
				"You swing the hammer repeatedly into the rock face chipping the rock.";
				mboulder.crack := mboulder.crack +1;
				exit;
				}
			if(mboulder.crack = 1)
				{
				"With fierce determination you swing the hammer into the rock face.  A large 
				crack forms vertically along the rock with the blow.";
				mboulder.crack := mboulder.crack +1;
				exit;
				}
			if(mboulder.crack = 2)
				{
				"Releasing a barbarian cry from your lungs, you swing the hammer once again.  The 
				blow lands firmly on the crack formed by the two previous blows, splitting the 
				huge boulder into two halves which land in the neighboring hot and cold regions of the planet.";
				mboulder.moveInto(void);
				smallstones.moveInto(void);
				mrubble.moveInto(southside);
				incscore(25);							// 25 for destroying boulder
				exit;
				}
			}
		else
			{
			"You firmly hit the boulder with the hammer with no visible effect.  The boulder is just to strong.";
			exit;
			}
		}
		else  "It's not very effective to attack <<dobj.thedesc>> with the sledgehammer.";
		}
		
;

// Pluto Objects
	
gadget: vulnerable, readable
	fragile = true
	sdesc = "silver wand"
	ldesc = "The silver wand is about four inches long, silver and very shiny.  There is some writing on it."
	noun = 'wand'
	adjective = 'silver' 'small' 'shiny'
	location = nil
	taken = nil
	readdesc = "\b\"FUNCTIONING SPIRE-PORT DETECTORS\"\b"
;

thingy: vulnerable
	sdesc = "card"
	ldesc = "It is about the size and thickness of a credit card, made of some type of 
		black metal and has a large letter 'E' carved into it."
	noun = 'card'
	location = nil
;

coin: vulnerable
	sdesc = "copper slug"
	ldesc = "The copper slug is about the size of a quarter and is completely featureless."
	noun = 'slug' 'coin'
	adjective = 'copper'
	location = eoftower
;

wrapper: vulnerable
	sdesc = "cellophane wrapper"
	ldesc = "The cellophane wrapper looks like it once covered some type of food.  You guess 
		it was cookies do the cookie crumbs stuck to the wrapper."
	noun = 'wrapper'
	adjective = 'cellophane'
	location = Y7
;

crumbs: decoration
	sdesc = "cookie crumbs"
	noun = 'crumbs'
	adjective = 'cookie'
	location = wrapper
;

cookies: fooditem, vulnerable
	fragile = true
	sdesc = "cookies"
	ldesc = "The cookies are your typical chocolate wafer cookies with cream in the center 
		type."
	noun = 'oreos' 'cookies'
	adjective = 'oreo' 'chocolate' 'wafer'
	location = nil
	taken = nil
;

bottle: item
	fragile = true
	sdesc = "glass bauble"
	ldesc = "The glass bottle is made out of tinted dark green glass.  Intricate carvings 
		cover most of the bauble."
	noun = 'bauble'
	adjective = 'glass' 'green'
	location = G11
	doBreak(actor) ={
		"The bauble shatters into many pieces.";
		self.moveInto(dvoid);
		bglass.moveInto(Me.location);
		}
;

botcarv: decoration
	sdesc = "intricate carvings"
	ldesc = "The <<self.sdesc>> are very complex and beautiful.  They appear to be 
		just ornamental."
	noun = 'carvings'
	adjective = 'intricate'
	location = bottle
;

bglass: item
	fragile = true
	sdesc = "bits of broken glass"
	noun = 'glass'
	adjective = 'broken' 'bits of'
	location = nil
;

dogskeleton: vulnerable
	fragile = true
	sdesc = "skeleton"
	ldesc = {
		"The skeleton was from some type of four legged animal, possibly a dog or a wolf.";
		if(dogcollar.location = self) " There is a collar around the skeleton's neck.";
		}
	noun = 'skeleton' 'pluto'
	adjective = 'dog'
	location = R7
	weight = 5
	bulk = 7
;

dogcollar: clothingItem, vulnerable
	sdesc = "dog collar"
	ldesc = "It is an ordinary looking dog collar with a tag attached to it."
	noun = 'collar'
	adjective = 'dog'
	location = dogskeleton
;

tag: readable, fixeditem, vulnerable
	sdesc = "dog tag"
	ldesc = "\b\tOWNER: M.M.\b"
	noun = 'tag'
	adjective = 'dog'
	location = dogcollar
;

dewar: container, vulnerable, readable
	sdesc = "metal cylinder"
	ldesc ="The metal cylinder is a foot long and has one open end.  Even though the walls of the cylinder look 
		quite think, the cylinder is very light.  Written on the side of the cylinder is the single 
		word \"Dewar.\""
	noun = 'cylinder' 'flask' 'thermos'
	adjective = 'metal' 'dewar'
	taken = nil
	location = Y3
	readdesc = "It says \"Dewar.\""
;

glowstick: item
	islamp = true
	islit = true
	noun = 'stick' 'glow'
	adjective = 'glow'
	sdesc = "glow stick"
	ldesc = "The glow stick is about half of a foot long and is emitting a cool green glow."
	location = deadend
;

wreng: vulnerable
	fragile = true
	sdesc = "Wankle rotary engine"
	ldesc = "The Wankle rotary engine is an odd looking device.  It is sort of ellipsoidal 
		with lots of things sticking in and out of it."
	noun = 'engine' 'gizmo'
	adjective = 'Wankle' 'rotary' 'weird'
	location = pedestal
;

rcry: item
	fragile = true
	iscrys = true
	sdesc = "red crystal"
	ldesc = "The crystal is red as blood and flawless."
	noun = 'crystal' 'gem'
	adjective = 'red'
	location = nil
;

ycry: item
	fragile = true
	iscrys = true
	sdesc = "yellow crystal"
	ldesc = "The crystal is yellow as pollen and flawless"
	noun = 'crystal' 'gem'
	adjective = 'yellow'
	location = nil
;

gcry: item
	fragile = true
	iscrys = true
	sdesc = "green crystal"
	ldesc = "The crystal is green as an emerald and flawless."
	noun = 'crystal' 'gem'
	adjective = 'green'
	location = nil
;

bcry: item
	fragile = true
	iscrys = true
	sdesc = "blue crystal"
	ldesc = "The crystal is blue as a sapphire and flawless."
	noun = 'crystal' 'gem'
	adjective = 'blue'
	location = nil
;

dplate: vowelItem, readable, vulnerable
	sdesc = "iron plate"
	ldesc = "It says:\n1 -- Pluto\n2 -- Zoltar\n3 -- Terra\n4 -- Mars\n5 -- Neptune\n
		6 -- Titan\n7 -- Neo-Trilliozaptiofilliocoozbilliarth"
	noun = 'plate'
	adjective = 'iron'
	location = B8
;

fchrcry: vulnerable
	fragile = true
	vol = true
	sdesc = "purple chronoprogram crystal"
	ldesc = "The <<self.sdesc>> is a purple one inch cube.  Looking close you see there is a fine 
		crack inside the heart of the crystal."
	noun = 'crystal' 'gem' 'cube'
	adjective = 'purple' 'chronoprogram' 'chrono' 'flawed' 'cracked'
	location = nil
	lethal = nil
	taken = nil
	doTake(actor) ={
		if(self.lethal)
			{
			"As you bend down to pick up the crystal a blue arc of energy surges out of it and strikes you 
			square in the chest, knocking the breath out of you.  You try to catch your breath but you can't 
			seem to be able to breathe.  When you look down at yourself, you realize the large hole in your 
			chest might have something to due with this.";
			die();
			}
		if(self.location = tower)
			{
			if(not self.taken)
			{
			"As you take the crystal a deep voice announces\b\"STEP DOWN FOR ACCESS TO 
			PROGRAMING FACILITIES\"\bA passage in the floor then opens at your feet.\b";
			tower.dopen := true;
			self.moveInto(Me);
			self.taken := true;
			incscore(10);				// 10 for access to device room
			}
			else pass doTake;
			}
	pass doTake;
		}
;

// Treasures

chrcry: item, vulnerable
	fragile = true
	vol = true
	sdesc = "black chronoprogram crystal"
	ldesc = "The <<self.sdesc>> is a black one inch cube."
	noun = 'crystal' 'gem' 'cube'
	adjective = 'black' 'chronoprogram' 'chrono'
	location = nil
	once = nil
	istreasure = true
	take = nil
	good = nil
	gootake = nil
	doTake(actor) = {
		if(not self.taken)
		{
		incscore(10);		// 10 for black cube
		self.taken := true;
		}
		if(self.good)
			if(not self.goodtake)
			{
			incscore(25);		// 25 for getting properly programed crystal
			self.goodtake := true;
			}
		pass doTake;
		}
;

pureiron: treasure, vulnerable
	sdesc = "piece of pure iron"
	ldesc = "It looks like very other piece of 100% pure iron you have ever seen."
	noun = 'iron' 'rock'
	adjective = 'pure' 'piece of'
	location = nil
	taken = nil
	doTake(actor) ={
		if(not self.taken)
			{
			incscore(25);			// 25 for iron
			self.taken := true;
			}
		pass doTake;
	}
;

neutron: treasure
	sdesc = "pebble of neutronium"
	ldesc = "The <<self.sdesc>> is very small, smooth and black."
	noun = 'pebble' 'neutronium'
	adjective = 'black' 'pebble'
	location = strip
	weight = 40
	taken = nil
	doTake(actor) = {
		"You grab the neutronium and are taken by surprise how much it weighs for something so 
		small.  ";
		if(strengthpill.iseaten)
			{
			local totbulk, totweight;
			totbulk := addbulk (actor.contents) + self.bulk;
			totweight := addweight(actor.contents);
			if(not actor.isCarrying(self)) totweight := totweight + self.weight;
			if (totweight > actor.maxweight) "In fact, you cannot even begin to lift it.";
			else if(totbulk > actor.maxbulk) "You've got your hands full.";
			else {
				self.moveInto(actor);
				"In fact, even with your enhanced strength you just manage to lift it.";
				if(not self.taken)
					{
					incscore(20);			// 20 for pebble
					self.taken := true;
					}
				}
			}
		else "In fact, you can't even lift it.";
		}
;

icechip: vowelItem,treasure, readable, vulnerable
	fragile = true
	chipcount = 0
	melt = nil
	dinonce = nil
	sdesc = "ice chip"
	ldesc = "The chip is only the size of your thumb nail and seems to be make of some type of 
			ice.  There is also some small writing on the chip."
	readdesc = "The tiny writing says:\bWARNING: DO NOT EXPOSE TO TEMPERATURES 
			ABOVE TEN DEGREES ABSOLUTE\b"
	noun = 'chip' 'microchip'
	adjective = 'ice'
	location = pillarpanel
	taken = nil
	doTake(actor) = {
		if(self.location = pillarpanel)
			"When you grab the chip from the panel the glow around the right 
				pillar silently shuts off.";
		setdaemon(chipmelt, nil);
		pass doTake;
		}
;

ambltr: vowelItem, treasure, vulnerable
	fragile = true
	sdesc = "ambidextrous laser trinketer"
	ldesc = "It look like an <<self.sdesc>>.  What ever that is."
	noun = 'trinketer'
	adjective = 'laser' 'ambidextrous'
	location = dispvoid
	taken = nil
	doTake(actor) = {
		if(not self.taken)
			{
			incscore(25);			// 25 for trinketer
			self.taken := true;
			}
		pass doTake;
		}
;

widget: treasure
	fragile = true
	sdesc = "left-handed widget"
	ldesc ={
		"The left-handed widget is very shiny and fairly light.  It has lots of curves, holes and ridges in it. 
		With regards to its function or purpose, you have no idea. ";
		if(not self.donce)
		{"Whatever it is, it must be very sturdy to have survived on Venus.";
		self.donce := true;}
		}
	donce = nil
	noun = 'widget'
	adjective = 'left-handed'
	location = ledge
	taken = nil
	doTake(actor) = {
		if(not self.taken)
			{incscore(25);			//25 for widget
			self.taken := true;
			}
		pass doTake;
		}
;

// body parts

class bodyitem: fixeditem, floatingItem
	locationOK = true
	isListed = nil
	location = Me.location
	ldesc = {
		"It's your <<self.sdesc>>, the same one you have had all your life.";
		}
	bpart = true
	verDoTake(actor) = {"How do you propose to do that?";}
	verDoDrop(actor) = {"Sorry, you are not a leper.";}
	verDoTakeOut(actor, io) = {self.verDoTake(actor);}
	verDoTakeOff(actor, io) = {self.verDoTake(actor);}
	verDoPutIn(actor, io) = {}
	doPutIn(actor, io) = {"You can't put your <<self.sdesc>> there.";}
	verDoMove(actor) = {"Ok, you move your <<self.sdesc>> around.";}
	verDoPutOn(actor, io) = {}
	doPutOn(actor, io) = {"You can't put your <<self.sdesc>> there.";}
;

finger: bodyitem
	sdesc = "finger"
	noun = 'finger'
	plural = 'fingers'
	adjective = 'pinky' 'index' 'middle' 'pointer'
;


thumb:bodyitem
	sdesc = "thumb"
	noun = 'thumb'
;

nose:bodyitem
	sdesc = "nose"
	noun = 'nose'
	verIoPutIn(actor) = {}
	ioPutIn(actor, dobj) = {
		if (dobj = finger) 
			{ "Step right up!  Pick a winner!!!"; exit;}
		if(isclass(dobj, bodyitem))
			{"How do you propose to do that?"; exit;}
		"You consider stiking <<dobj.thedesc>> up your nose, but reconsider at the last 
			moment.";
		}
;

eye:bodyitem
	sdesc = "eye"
	noun = 'eye'
	plural = 'eyes'
	verIoPutIn(actor) = {}
	ioPutIn(actor, dobj) = {
		"Don't do that!  You will poke out your eye!!!";
			}
;

ear:bodyitem
	sdesc = "ear"
	noun = 'ear'
	plural = 'ears'
	verIoPutIn(actor) = {}
	ioPutIn(actor, dobj) = {
		if(dobj = finger) 
			{
				"You look very silly with your finger in you ear.";
				exit;
			}
		if(dobj = elbow)
			{
			"Sorry you are not a contortionist.";
			exit;
			}
		"Remember what your mother said... \"Never put anything other than your elbow in your 
		ear.";
		}
;

elbow:bodyitem
	sdesc = "elbow"
	noun = 'elbow'
;

		

hand:bodyitem
	sdesc = "hand"
	noun = 'hand'
	adjective = 'right' 'left'
	plural = 'arms'
;

arm:bodyitem
	sdesc = "arm"
	noun = 'arm'
	adjective = 'right' 'left'
	plural = 'arms'
;

leg:bodyitem
	sdesc = "leg"
	noun = 'leg'
	adjective = 'right' 'left'
	plural = 'legs'
;

foot:bodyitem
	sdesc = "foot"
	noun = 'foot'
	adjective = 'left' 'right'
	plural = 'feet'
;

toe: bodyitem
	sdesc = "toe"
	noun = 'toe'
	plural = 'toes'
;


fist:bodyitem
	sdesc = "fist"
	noun = 'fist'
	plural = 'fists'
;
