#charset "us-ascii"

/*
 *  TADS 3 Library Extension: AutoSave (neutral messages for US-English).
 *  Version: August 31, 2005.
 *
 *  Copyright 2004-2005 by Michel Nizette.
 */

#include <tads.h>
#include <adv3.h>
#include <en_us.h>


/*
 *  Properties added to libMessage and defining game responses specific to the
 *  auto-save mechanism.  Every new property name begins with "autoSave_" to
 *  prevent collisions with other Library extensions.
 *
 *  English is not my native language, so don't hesitate to correct my English
 *  if you want, and feel free to add your own copyright notice to the
 *  beginning of this file to cover the changes!
 */
modify libMessages

  /*
   *  Begin a challenge change notification.  Typically, this displays an
   *  opening notification marker.
   */
  autoSave_beginChallengeReport =
    "<.notification>"

  /*
   *  Inform the player that the game doesn't guarantee winnability anymore
   *  from the next turn on, because a challenge is starting.
   */
  autoSave_challengeStarting =
    "The story has reached a challenging stage where {your} actions could
    have irrecoverable consequences. "

  /*
   *  Inform the player that a challenge is just ending so that the game state
   *  just reached is winnable, but that another challenge is immediately
   *  starting so that, from the next turn on, the game won't guarantee
   *  winnability anymore.
   */
  autoSave_challengeChanging =
    "The story has reached a point of temporary safety.  However, {your} next
    actions could still have irrecoverable consequences. "

  /*
   *  Inform the player that the game guarantees winnability from now on
   *  because the currently running challenge is just ending.
   */
  autoSave_challengeEnding =
    "The story has reached a period of respite where {your} actions are
    unlikely to have irrecoverable consequences. "

  /*
   *  Inform the player that, from the next turn on, they can restore the
   *  current position via the command RETRY.
   */
  autoSave_retryEnabled =
    "From the next turn on, you can type <<aHref('retry', 'RETRY',
    'Retry the current challenge')>> to restore the current
    position."

  /*
   *  Inform the player that, from now on, there is no point in using the
   *  command RETRY anymore, so that it becomes ineffective.
   */
  autoSave_retryDisabled =
    "From now on, the command RETRY is ineffective."

  /*
   *  Inform the player that, from the next turn on, they *should* have been
   *  allowed to restore the current position via the command RETRY, but that
   *  a (previously announced) I/O error prevents the mechanism from working.
   */
  autoSave_retryBroken =
    "Unfortunately, because of the file access error, the command RETRY cannot
    be used to restore the current position."

  /*
   *  Inform the player of the usage of the command RETRY HIDE.  prepend the
   *  message with appropriate output control markers, such as an
   *  end-of-notification marker followed by a beginning-of-notification
   *  marker, to separate this piece of information visually from the
   *  challenge change notification that just preceded.
   */
  autoSave_suggestReportsOff =
    "<./notification><.p><.notification>If you'd prefer not to be notified
    anymore about the beginning or end of challenges, type
    <<aHref('retry hide', 'RETRY HIDE', 'Disable challenge notifications')>>."

  /*
   *  End a challenge change notification.  Typically, this displays a closing
   *  notification marker.
   */
  autoSave_endChallengeReport =
    "<./notification> "

  /*
   *  Inform the player that an auto-save action attempted in the background
   *  failed.  The argument is the exception thrown.
   */
  autoSave_autoSaveFailed(exc)
  {
    if (exc.ofKind(SaveRestoreException))
    {
      /*
       *  The error occurred while the game was trying to save the position
       *  to a temporary file.
       */
      "<.notification>An error occurred in an attempt to save the current
      position to a temporary file.  Your computer might be running low on
      disk space, or the interpreter might not have the necessary
      permissions.<./notification><.p>";
    }
    else
    {
      /*
       *  The error occurred while the game was trying to copy the position
       *  from the temporary file to a byte array.
       */
      "<.notification>An attempt to read from a temporary file
      failed.<./notification><.p>";
    }
  }

  /*
   *  Ask confirmation that the player really wants to retry the current
   *  challenge.
   */
  autoSave_confirmRetry =
    "Do you really want to retry the current challenge?\ (<<aHref('Y', 'Y',
    'Confirm retry')>> is affirmative) >\ "

  /*
   *  Confirm that the command RETRY was cancelled.
   */
  autoSave_notRetrying =
    "<.parser>Continuing the story.<./parser> "

  /*
   *  Confirm that the command RETRY succeeded so that we're now retrying the
   *  challenge.
   */
  autoSave_retryOkay =
    "<.parser>Retrying.<./parser> "

  /*
   *  Inform the player that the command RETRY is ineffective because there is
   *  currently no running challenge to be retried.
   */
  autoSave_retryNoChallenge =
    "<.parser>There is currently no need to restore a previous
    position.<./parser> "

  /*
   *  Inform the player that the command RETRY is ineffective on this turn
   *  because the currently running challenge just started and there is so far
   *  nothing to be undone, but that the command RETRY will become effective
   *  from the next turn on.
   */
  autoSave_retryChallengeStarting =
    "<.parser>The command RETRY is ineffective on this turn, but you can use
    it later to restore the current position.<./parser> "

  /*
   *  Inform the player that the command RETRY *should* have worked, except
   *  that a past I/O error prevents the mechanism from working.
   */
  autoSave_retryUnavailable =
    "<.parser>The position cannot be restored because it could not be saved
    at the time.  You will have to resort to manually saved positions, if you
    have any available.<./parser> "

  /*
   *  Inform the player that the command RETRY couldn't proceed because the
   *  file safety level is too restrictive and the program doesn't have the
   *  permission to create a temporary file, but that the problem should be
   *  fixed if the player lowers the safety level.
   */
  autoSave_retryFileSafetyTooRestrictive =
    "<.parser>Failed: the creation of a temporary file was attempted, but the
    file safety level is too restrictive.  If your TADS interpreter allows it,
    modify the file safety settings so that the program is allowed to write to
    its directory, then reissue the command.<./parser> "

  /*
   *  Inform the player that the command RETRY *should* have worked, but
   *  failed because of an I/O error.
   */
  autoSave_retryFileException(exc)
  {
    if (exc.ofKind(SaveRestoreException))
    {
      /*
       *  The error occurred while the game tried to restore the game state
       *  from a temporary file.
       */
      "<.parser>Failed: the position could not be restored.<./parser> ";
    }
    else
    {
      /*
       *  The error occurred while the game tried to copy the game state from
       *  a byte array to a temporary file.
       */
      "<.parser>Failed: an error occurred in an attempt to create a temporary
      file.  Your computer might be running low on disk space, or the
      interpreter might not have the necessary permissions.<./parser> ";
    }
  }

  /*
   *  Acknowledge a modification in the way the player is to be notified about
   *  changes in challenge conditions.
   *
   *  reportsOn is true if notifications are enabled, nil if disabled.
   *  challengeRunning and challengeStarting indicate whether there is
   *  currently a running or a starting challenge.  challengeBroken indicates
   *  whether the command RETRY is able behave as it normally should; this
   *  flag is nil in every case except if a challenge is running and the
   *  position at the beginning of the challenge cannot be restored because of
   *  a past I/O error.
   */
  autoSave_acknowledgeRetryToggle(reportsOn, challengeRunning,
                                  challengeStarting, challengeBroken)
  {
    if (reportsOn)
    {
      /*
       *  Confirm that notifications are now enabled.
       */
      "<.parser>Notifications about the beginning or end of challenges are
      now enabled. ";
      /*
       *  Since the player marks their interest for challenge change
       *  notifications, recapitulate the current state for their convenience.
       */
      if (challengeBroken)
      {
        /*
         *  The position at the beginning of the challenge can't be restored
         *  because of a past I/O error -- report it.
         */
        "A challenge is currently going on.  However, because of a past file
        access error, the command RETRY cannot be used to restore the position
        at the beginning of the challenge. ";
      }
      else if (challengeStarting)
      {
        /*
         *  A challenge has just begun, so that the player can use the command
         *  RETRY from the next turn on -- report it.
         */
        "A challenge has just begun.  From the next turn on, you can type
        <<aHref('retry', 'RETRY', 'Retry the current challenge')>> to restore
        the current position. ";
      }
      else if (challengeRunning)
      {
        /*
         *  A challenge is currently running, so that the player can use
         *  the command RETRY -- report it.
         */
        "A challenge is currently going on.  you can type <<aHref('retry',
        'RETRY', 'Retry the current challenge')>> to restore the position at
        the beginning of the challenge. ";
      }
      else
      {
        /*
         *  No challenge is currently running, so that the player can't use
         *  the command RETRY -- report it.
         */
        "No challenge is currently going on, so the command RETRY is
        ineffective. ";
      }
      /*
       *  Explain how to disable notifications.
       */
      "To disable challenge notifications, type <<aHref('retry hide',
      'RETRY HIDE', 'Disable challenge notifications')>>.<./parser> ";
    }
    else
    {
      /*
       *  Confirm that notifications are now disabled.  Tell the player how
       *  to enable notifications.
       */
      "<.parser>Notifications about the beginning or end of challenges are
      now disabled.  Note that the command <<aHref('retry', 'RETRY',
      'Retry the current challenge')>> remains effective during challenges,
      and can be used to restore the story to a safe position.  To enable
      challenge notifications, type <<aHref('retry show', 'RETRY SHOW',
      'Enable challenge notifications')>>.<./parser> ";
    }
  }
;
