fairway: room
  sdesc = { if (self.seen) "18th Fairway"; else "Golf Course"; }
  ldesc = {
    if (!self.seen) {
      self.seen := true;
      "You're on the golf course with the general manager of the New England 
      Patriots. The meeting is going well, so far, but your mind is really 
      with Charlise, who is now nine months pregnant and due any day now. Funnily
      enough, even in your semi-distracted state, this is the first team you've 
      made progress with. It's a good fit -- they see you as a local boy who 
      can be trusted, and they have some serious defensive issues they could 
      solve with Pittman. The Patriots are picking twenty-third, and have a 
      history of not being overly concerned with drafting or signing guys 
      with...\ well, with some question marks. Katzenmoyer, Peter, Meggett, 
      Mowatt -- it's not exactly like quarterback Donny Osmond handing off to 
      halfback Marie. If you can just convince them to meet Tavarian...\ then, 
      provided he just acts like himself, he's at least got the opportunity to 
      charm them. Maybe they don't take him in the first round, but even if he 
      is taken in the second or third it would be a great day for him, 
      *considering* and all, and a major success for yourself.\b
      Dan Fonda, the general manager of the Patriots, is here with you. He's up
      two strokes on you, but is heading for a triple-bogey on this hole. 
      The other two guys in the foursome -- director of 
      Player Development Terry O'Hare and current player Bucky Johnson, are a 
      dozen strokes behind you two. You can probably get it into the cup in two 
      strokes from here, and win the match outright. Or, should you slice, hook 
      or just outright shank it, you'll ensure that Fonda wins. He seems earnest 
      and sincere, and the kind of guy who wouldn't catch on if you let him 
      win. But then, he might be the kind of guy who doesn't respect someone 
      who can't <q>beat</q> him on the greens. Just which you're not sure of, yet. ";
      self.count := 0;
      setdaemon(golfShotDaemon, nil);
    }
    else
      "You're on the fairway for the 18th hole at the extremely exclusive 
      Keros Summer Country Club. The course is a Nicklaus-sculpted wonder 
      filled with gorgeous rolling hills, tranquilly azure water hazards 
      and an assortment of vegetation that would have given jealous 
      pause to the Ancient Babylonians. ";
  }
  listendesc = "Just the occasional chirp of the birds, and Bucky's cell phone. "
;

// Used in case player refuses to hit the ball in a timely fashion...
golfShotDaemon: function(parm)
{
  if (fairway.count++ = 5) 
    "\b<q>Hey Kieron,</q> says Dan, <q>it's your shot.</q> ";
  if (fairway.count = 10 or fairway.count = 30 or fairway.count = 50)
    "\bDan, Bucky and Terry stare at you intently, wondering what's taking so long. ";
  if (fairway.count = 20)
    "\b<q>The sun is gonna set!</q>\ quips Bucky, <q>Time to hit the ball!</q> ";
}

// Needed so that all instances of hit ball works, regardless of where the ball is.
hiddenGolfBall: item
  sdesc = { "<<golfBall.sdesc>>"; }
  isListed = nil
  verDoShank(actor) = {}
  doShank(actor) = { golfBall.doShank(actor); }
  verDoHook(actor) = {}
  doHook(actor) = { golfBall.doHook(actor); }
  verDoSlice(actor) = {}
  doSlice(actor) = { golfBall.doSlice(actor); }
  verDoAttack(actor) = {}
  doAttack(actor) = {
    golfClub.practice := true;  // don't practice swing
    golfClub.doSwing(actor);
  }
  verDoAttackWith(actor, dobj) = {}
  doAttackWith(actor, dobj) = {
    golfClub.practice := true;  // don't practice swing
    golfClub.doSwing(actor);
  }
  verDoDrop(actor) = { "You don't have the golf ball. "; }
;

golfCourse: fixeditem
  sdesc = "Keros Summer Country Club"
  noun = 'course' 'keros' 'country club' 'keros summer country club'
  adjective = 'golf' 
  location = fairway
  ldesc = "The Keros Summer Country Club is a pretty nice course -- you definitely would
          not have had an opportunity to play here if you weren't part of this foursome. 
          Not that they are really particular about who joins the club, it's just that
          it's virtually prohibitively expensive. "
  takedesc = "The <<self.noun>> <<self.isdesc>> firmly attached. "
;

golfBall: item
  sdesc = "golf ball"
  noun = 'ball' 'titleist' 'shot'
  adjective = 'golf'
  location = fairway
  isListed = {
    if (!self.seen) {
      self.seen := true;        // don't display first time in
      return nil;
    }
    else
      return true;              // listed in room/inventory displays
  }
  ldesc = "Titleist, #3. "
  verDoTake(actor) = { "You already have a pretty good lie, no need to move <<self.thedesc>>. "; }
  verDoMove(actor) = { "You already have a pretty good lie, no need to move <<self.thedesc>>. "; }
  verDoPull(actor) = { "You already have a pretty good lie, no need to move <<self.thedesc>>. "; }
  verDoPush(actor) = { "You already have a pretty good lie, no need to move <<self.thedesc>>. "; }
  verDoShank(actor) = {}
  doShank(actor) = { badShot('Shank'); }
  verDoHook(actor) = {}
  doHook(actor) = { badShot('Hook'); }
  verDoSlice(actor) = {}
  doSlice(actor) = { badShot('Slice'); }
  verDoAttack(actor) = {}
  doAttack(actor) = {
    golfClub.practice := true;  // don't practice swing
    golfClub.doSwing(actor);
  }
  verDoAttackWith(actor, dobj) = {}
  doAttackWith(actor, dobj) = {
    golfClub.practice := true;  // don't practice swing
    golfClub.doSwing(actor);
  }
  verDoEat(actor) = { "It's too crunchy to make a decent meal. "; }
  verDoThrowAt(actor, dobj) = { "Easy there, Happy Gilmore. "; }

;

// Giving the game away to Dan.
badShot: function(shotType)
{
  local temp;
  if (!golfClub.isIn(Me)) 
    "(first picking up <<golfClub.thedesc>>)\n";
  "You decide to try to stroke the ego of the general manager and really knock the ball 
  stupid. <<shotType>> city. It travels into an out-of-play area, and really, took more 
  skill to launch it the way you did than it would have if you had hit it straight. \b
  You concede victory to Dan, hoping that it will soften him up for negotiations later.\b ";
  temp := substr(shotType, 1, 1);
  endGolf(temp); // send H or S
}
;

endGolf: function(WinLose)
{
  golfBag.moveInto(Me);
  danFonda.moveInto(parkingLot);
  golfClub.moveInto(nil);
  hiddenGolfBall.moveInto(nil);
  remdaemon(golfShotDaemon, nil);
  setdaemon(danDaemon, nil );
  if (global.turnsofar < 20)                // if not past 12:05 already.
    settimesys( '12:04 p.m.', 1, 2001, 10, 01 );
  Me.travelTo(parkingLot);
// Used in baby scene, third level of the chess board.  Save (W)inner.  Other option is (H)ook or (S)lice/(S)hank.
  game.handle := fopen('pc1.glf', 'w'); 
  fwrite(game.handle, WinLose);
  fclose(game.handle);
}

golfClub: item
  sdesc = "pitching wedge"
  noun = 'wedge' 'club'
  adjective = 'pitching' 'golf'
  ldesc = {
    "Your pitching wedge. True, sturdy, and faithful. You had messed around with
    graphite clubs before, and still use them occasionally, but when the
    pressure's on, you want Old Faithful at your side. ";
  }
  verDoSwing(actor) = {}
  doSwing(actor) = {
    if (!self.isIn(Me)) {
      "(first picking up <<self.thedesc>>)\n";
      self.moveInto(Me);
    }
    if (!self.practice) {
      self.practice := true;
      "You take a few practice swings with the club. You remember that if you just
      decide to hit the ball straight, you're going to win this thing. If you
      decide to intentionally hook, slice, or shank it, then you can give the
      win to Dan. ";
    }
    else {
      "You swing the club, and sure enough, your aim is sweet. You land the ball onto the green
      and manage to sink it in on the next putt. \b
      <q>Good work,</q> beams Dan. <q>It's been a long time since I've had any competition, especially
      playing with these two clowns,</q> he gestures over to Terry and Bucky. \b
      <q>Yeah, you watch out, Fonda, I get this kink out of my swing and I'm all over you,</q> says Bucky.\b
      <q>You had eight mulligans, Bucky,</q> says Dan. <q>You've been discarding more balls than the guy
      who does the neutering over at the local vet.</q>\b
      <q>Ouch,</q> says Terry. Ouch, indeed.\b ";
      endGolf('W');
    }
  }
  verIoAttackWith(actor) = {}
  ioAttackWith(actor, dobj) = {
    if (dobj = golfBall) {
      self.doSwing(actor);
    }
    else {
      "<q>What are you, crazy?</q>\ says <<dobj.thedesc>>. The three of them proceed to give you
      a crippling beat-down. \b
      Perhaps next time, instead of attacking the management of the New England Patriots,
      you should attempt to bury the brain trust of an organization with a little less
      angst, like the Chicago Cubs or the Boston Freaking Red Sox.\b ";
      golfBag.moveInto(Me);
      golfClub.moveInto(nil);
      if (Me.location = clubHouseBooth)
        Me.noClubHouse := true;
      else
        Me.noEat := true;                         // don't go into clubhouse if done on golf course
      remdaemon(golfShotDaemon, nil);
      Me.travelTo(parkingLot);
    }
  }
;

holeDistant: distantItem
  sdesc = "18th hole"
  noun = 'hole'
  adjective = '18th'
  location = fairway
  ldesc = "It's a ways off. "
;

greenDistant: distantItem
  sdesc = "18th green"
  noun = 'green'
  adjective = '18th'
  location = fairway
  ldesc = "Pristine, vibrant, lush. They do a good job maintaining the greens here. "
;

flagDistant: distantItem
  sdesc = "18th flag"
  noun = 'flag'
  adjective = '18th'
  location = fairway
  ldesc = "You can barely see the flag from here. "
;

golfBagDistant: distantItem
  sdesc = "golf bag"
  noun = 'bag'
  adjective = 'golf'
  location = fairway
  ldesc = "Your golf bag holds your clubs, and a few other essential items like
          tees and whatnot. "
  verDoTake(actor) = { "You have already chosen your club. "; }
;

golfCartDistant: distantItem
  sdesc = "golf cart"
  noun = 'cart'
  adjective = 'golf'
  location = fairway
  ldesc = "Bucky took off the restrictor for the golf cart and has been cruising along
          at ridiculous speeds all afternoon. He had been trying to get it airborne
          on the last hole. "
  verDoRide(actor) = { "This is the last hole, though! "; }
;

cartPathItem: fixeditem
  sdesc = "cart path"
  noun = 'path'
  adjective = 'cart'
  ldesc = { "The cart path just leads to the different holes. "; }
  location = fairway
  verDoFollow(actor) = { "In due time. "; }
  takedesc = "It's firmly attached to the earth. "
;

fairwayItem: fixeditem
  sdesc = "fairway"
  noun = 'fairway'
  ldesc = { fairway.ldesc; }
  location = fairway
  takedesc = "It's firmly attached to the earth. "
;

hills: decoration
  sdesc = "rolling hills"
  noun = 'hills'
  adjective = 'rolling'
  location = fairway
  ldesc = "They look soft and serene. "
  isThem = true
;

waterHazzards: decoration
  sdesc = "water hazards"
  noun = 'hazards'
  adjective = 'water'
  location = fairway
  ldesc = "The water hazards aren't important. Well, maybe to Bucky, who's put thirty dollars worth of 
          golf balls into them today. "
  isThem = true
;

vegetation: decoration
  sdesc = "vegetation"
  noun = 'vegetation'
  location = fairway
  ldesc = "The <<self.sdesc>> <<self.isntdesc>> important. "
;

courseTrees: decoration
  sdesc = "trees"
  noun = 'trees' 'tree' 'pines' 'birches' 'pine' 'birch'
  location = fairway
  ldesc = "You're not much of a horticulturist, but they look like...\ pines? Or birches.
          Or something. "
  isThem = true
;

sandtrap: decoration
  sdesc = "sand trap"
  noun = 'trap'
  adjective = 'sand'
  ldesc = "The <<self.sdesc>> <<self.isntdesc>> important. "
;

// Dan will wait for you to answer for three turns -- then he leaves on his own.
danDaemon: function(parm)
{
  if (danFonda.waitCnt++ = 3) {
    "\b<q>Tell you what,</q> says Dan, <q>I'm going over to the club house -- meet us 
    there for lunch.</q>\b Dan then heads south, over toward the club house. ";
    remdaemon(danDaemon, nil);
    danFonda.moveInto(nil);
    danFonda.waitingYes := nil;
    Me.conversingWith := nil;
  }   
}

danFonda: Actor
  location = fairway
  sdesc = "Dan"
  noun = 'fonda' 'man'
  adjective = 'dan'
  takedesc = "I don't think Dan would appreciate that. "
  ldesc = {
    "Dan Fonda is a former cornerback who worked his way into the NFL by putting in
    hard time in every league he could find until he could get a look -- the XFL,
    the Canadian Football League, Arena ball, and some Soviet Prison Conference that
    he doesn't talk about that much. A few years past his playing days, he's kept
    himself in excellent physical shape, and seems to have stepped right out of an
    old 'Dockers' commercial. You suspect that he's receptive to bringing in a 
    player like Tavarian, who has a few strikes against him, because he's had to 
    scrape his way to the top himself. ";
    if (!self.seen) {
      self.seen := true;
      "\bHe flashes you an impossibly bright enameled smile. ";
    }
  }
  adesc = { self.sdesc; }
  thedesc = { self.sdesc; }
  isHim = true
  actorDesc = {
    if (!self.seen)
      self.seen := true;                // don't display when game starts up
    else if (Me.location = parkingLot and !self.lotSeen)
      self.lotSeen := true;             // don't display first time in lot
    else {                                                                  
      if (!self.seenGM) {
        self.seenGM := true;            // only display GM line once
        "Dan Fonda, the Patriots GM, is here. ";
      }
      else
        "Dan is here. ";
    }
  }
  waitCnt = 0
  verDoSearch(actor) = { "<q>Hey!</q>\ he protests, moving away from you. "; }
  verDoHug(actor) = { "Your show of affection could alter negotiations -- negatively! "; }
  verDoKiss(actor) = {"Your show of affection could alter negotiations -- negatively! "; }
  doSynonym('Search') = 'Lookin'
  actorAction(v, d, p, i) = {
    if (v.isTravelVerb) {
      "<q>I'm not going anywhere right now.</q> ";
      exit;
    }
    switch(v) {
      case noVerb:
      case yesVerb:
      case helloVerb:
        break;
      case wearVerb:
        "<q>I'm comfortable with what I'm already wearing.</q> ";
        exit;
      default:
        "<q>You love telling people what to do, huh?</q>\ he says, half joking. ";
        exit;
    }
  }  
  verDoTellAbout(actor, io) = { self.verDoAskAbout(actor, io); }
  doTellAbout(actor, io) = { 
    "You wonder what <<self.sdesc>> has to say instead, so you ask him about it.\b";
    self.doAskAbout(actor, io); 
  }
  verDoAskFor(actor, io) = { self.disavow; }
  doAskFor(actor, io) = { self.doAskAbout(actor, io); }
  disavow = ""
  dontKnow = {
    local msg := [
      '<q>I don\'t know much about that,</q> says '
      '<q>I don\'t really know,</q> states '
      '<q>You probably know as much as I do,</q> quips '
      '<q>Were you talking to me?</q>\ questions '
      '<q>Sorry, not my area of expertise,</q> exclaims '
      '<q>Um... Did you say something?</q>\ asks '
      'A shrug is all you get from '
    ];
    say(msg[rand(length(msg))]);
  }
  askWord(word, lst) = {
    switch(substr(word, 1, 7)) {
      case 'me':
      case 'myself':
      case 'kieron':
        if (Me.location = fairway)
          "<q>Now, now, don't choke here, Kieron,</q> Dan says in a friendly tone. ";
        else 
          "<q>I'm glad we are able to get together like this,</q> he quips, <q>So many
          agents we meet seem to think that Jay Mohr's role in <i>Jerry Maguire</i> 
          was some kind of how-to guide.</q> ";
        return true;
        break;
      case 'tavaria':
      case 'pittman':
        if (Me.location = parkingLot)
          "<q>Yes, exactly. Let's head over to the clubhouse and talk about him. I have
          a few questions, naturally, that perhaps you can set my mind at ease regarding.</q> ";
        else {
          if (!self.talkedPittman or terry.waitingYes) {
            "<q>Helluva talent, he is. A lot of question marks, but I think we may be able
            to work around them.</q> ";
            self.talkedPittman := true;
          }
          else {
            "You pause briefly and then decide to tell Dan about Pittman";
            if (!Me.ordered)
              ", but Dan skirts the issue for now and is more concerned with what's on the menu. ";
            else {
              ". ";
              self.doTalkTo(Actor);
            }
          }
        }
        return true;
        break;
      case 'golf':
        if (Me.location = fairway)
          "<q>I believe it was Walt Whitman who said that golf was 'a good walk spoiled.'</q>\b
          <q>No, it was Mark Twain, dumbass,</q> says Bucky.\b
          <q>Really?</q>\b <q>Yeah. We covered that at Syracuse in English Lit when I was a freshman,
          an' that was back when I was still going to class.</q> "          ;
        else if (Me.won)
            "<q>Great shot, Kieron.  The best man won -- today!</q>\ he says with a wry smile. ";
        else
          "<q>God, I was just fortunate that the last shot of mine there ended 
          up so close to the green. Bucky making choking noises like he had 
          swallowed a pound of bad pork wasn't exactly helping.</q> ";
        return true;
        break;
      case 'patriot':
      case 'pats':
      case 'new eng':
        "<q>I don't know that anyone is going to be able to unseat those cocky punks over
        in New Orleans, but I like our chances better than anyone else in the AFC this
        season.</q> ";
        return true;
        break;
      case 'draft':
        "<q>It's where you can really mold your team and create a legacy. Unless you're in
        Arizona, where it's just some made-for-tv event that forces you to get up early
        for two days in the off-season.</q> ";
        return true;
        break;
      case 'footbal':
        "<q>Hmm,</q> says Dan, <q>What in particular do you mean?</q> ";
        return true;
        break;
      case 'neon':
        "<q>I think I'm going to get an older one for my kid,</q> says Dan. <q>Although I think it
        would build some character if he started out on a Chevette like his old man did
        at his age.</q> ";
        return true;
        break;
      case 'hummer':
      case 'humvee':
        "<q>Kids today,</q> says Dan with a sigh. ";
        return true;
        break;
      case 'club':
      case 'house':
        "<q>Yes, exactly. Let's head over to the clubhouse and talk about Pittman. I have
        a few questions, naturally, that perhaps you can set my mind at ease regarding.</q> ";
        self.skipHouse := true;
        return true;
        break;        
      default:
        dontKnow; "<<self.sdesc>>. ";
        return nil;
      }
  }
  doAskAbout(actor, iobj) = {
    switch(iobj) {
      case himself:
        "Dan doesn't like talking about himself. He's kind of humble. ";
        break;
      case terry:
        "<q>Don't listen to anything he says and don't believe his lies. They will only serve
        to confuse and frustrate you.</q> ";
        break;
      case bucky:
        "<q>If he played cornerback the way he plays golf, I wouldn't let him near one
        of those electronic football games with the magnetic guys who go around
        in circles.</q> ";
        break;
      default:
        /* we didn't find anything special; use the default behavior */
        inherited.doAskAbout(actor, iobj);
    }
  }
  doHello = { 
    if (!self.helloSaid) {
      "<q>Hello,</q>\ he says. ";
      self.helloSaid := true;
    }
    else
      "\^<<self.sdesc>> smiles at you, probably wondering why you 
      insist on repeating a greeting. ";
  }
  verDoTurnon(actor) = { "I'm sure you can think of something else to do, no? 
                         Besides, why would you want to alienate <<self.sdesc>>. "; }
  verDoAttack(actor) = { if (Me.location = parkingLot) "You resist the urge. "; }
  doAttack(actor) = { golfClub.ioAttackWith(actor, self); }
  verDoAttackWith(actor, iobj) = { if (Me.location = parkingLot) "You resist the urge. "; }
  doAttackWith(actor, iobj) = { self.doAttack(actor); }
  doListenTo(actor) = { "\^<<self.sdesc>> isn't making much noise right now. "; }
  ioSynonym('GiveTo') = 'ShowTo'
  ioGiveTo(actor, dobj) = { "<q>You can keep that,</q> quips <<self.sdesc>>. "; }
  verDoTalkTo(actor) = {}
  doTalkTo(actor) = { 
    switch (self.location) {
      case fairway:
        if (!self.fairwayTalk) {
          self.fairwayTalk := true;
          "<q>Well, well, Mister Scott. I guess it all comes down to this.</q> Dan gives you
          a friendly elbow in the ribs and says, <q>Don't choke, now.</q> ";
        }
        else
          "Now is the time for action, not words, so you concentrate on the shot. ";
        break;
      case parkingLot:
        "<q>Are you sure you don't want to come by the club house with us?</q> asks Dan.
         <q>If you can, why not hang around for a bit? We can talk business.</q> ";
        break;
      default:
        if (!Me.ordered)
          hintReadMenu(self);
        else {
          if (!terry.waitingYes) {
            "<q>I can assure you that he's changed. Not completely, not 100%, but he 
            is making strides. Did you know that his girlfriend is due, any day now? 
            It's true -- he's going to be a father. I've found that when given some 
            responsibility, and surrounded by the kind of people who expect him to 
            act like a reasonable adult, he becomes a different guy completely.</q>\b
            <q>Hey, now,</q> says Terry, returning from the bathroom, <q>your wife is 
            expecting any day now as well, isn't that right, Kieron?</q> ";
            terry.moveInto(clubHouseBooth);
            terry.waitingYes := true;
            Me.conversingWith := true;
          }
          else
            "Dan hints around that Terry is still waiting for an answer to his last question. ";
        }
        break;
    }
  }
  answerYes = { 
    if (self.waitingYes) {
     "\b<q>Great!</q>\ says Dan, <q>I'm going over to the club house -- meet us 
      there for lunch.</q>\b Dan then heads south, over toward the club house. ";
      remdaemon(danDaemon, nil);
      self.moveInto(nil);
      self.waitingYes := nil;
      Me.conversingWith := nil;
    }
    else
      "\^<<self.thedesc>> smiles. "; }
  answerNo =  { 
    if (self.waitingYes) {
      "\b<q>Oh, okay.  Well, if you change your mind, we'll be in the club house,</q> says Dan.\b
      He then heads south, over toward the club house. ";
      remdaemon(danDaemon, nil);
      self.moveInto(nil);
      self.waitingYes := nil;
      Me.conversingWith := nil;
    }
    else
      "\^<<self.thedesc>> didn't hear you. ";
  }
;

hintReadMenu: function(actor)
{
  switch(rand(5)) {
    case 1:
      "<q>Have you decided what you're going to order?</q>\ asks <<actor.sdesc>>. ";
      break;
    case 2:
      "<q>Have you even looked at the menu yet?</q>\ asks <<actor.sdesc>>, <q>I'm ready
      to eat!</q> ";
      break;
    case 3:
      "<q>I wonder what the specials are today,</q>\ says <<actor.sdesc>>. ";
      break;
    case 4:
      "<q>Why don't you take a peek at the menu so that our waitress can place our order,</q>\ says <<actor.sdesc>>. ";
      break;
    case 5:
      "<q>I'm probably going to order the ribs,</q>\ says <<actor.sdesc>>, <q>though I'll probably
      change my mind when the time comes.</q> ";
      break;
  }
}

himself: fixeditem
    noun = 'himself'
;

askAboutTopics: item
  noun = 'tavarian' 'pittman' 'draft' 'patriots' 'new england' 'pats' 'neon' 'football'
;

terry: Actor
  location = fairway
  sdesc = "Terry"
  noun = 'terry' 'o\'hare' 'man'
  takedesc = "I don't think <<self.sdesc>> would appreciate that. "
  ldesc = {
    "Terry O'Hare is the Director of Pro Player Development for New England, 
    but those credentials hardly enter your mind when you look at him. 
    He's enormously overweight -- easily 450 pounds packed onto his six-foot 
    frame.  O'Hare is the first guy to bring up his monstrous size, however, 
    and his self-depreciating sense of humor has made the meeting fun, as 
    well as productive. ";
    if (self.location = fairway)
      "Just be sure not to poke him with a tee, or else he's 
      likely to go hurtling about the greens with a hissing sound. ";
  }
  adesc = { self.sdesc; }
  thedesc = { self.sdesc; }
  isHim = true
  actorDesc = {
    if (!self.seen)
      self.seen := true;                // don't display when game starts up
    else {                                                                  
      if (!self.seenGM) {
        self.seenGM := true;            // only display GM line once
      "Terry O'Hare, the Patriot's Director of Player Development, is here. ";
      }
      else
      "Terry is here. ";
    }
  }
  verDoSearch(actor) = { "<q>Hey!</q>\ he protests, moving away from you. "; }
  verDoHug(actor) = {"Your show of affection could alter negotiations -- negatively! "; }
  verDoKiss(actor) = {"Your show of affection could alter negotiations -- negatively! "; }
  doSynonym('Search') = 'Lookin'
  actorAction(v, d, p, i) = {
    if (v.isTravelVerb) {
      "<q>I'm not going anywhere right now.</q> ";
      exit;
    }
    switch(v) {
      case noVerb:
      case yesVerb:
      case helloVerb:
        break;
      case wearVerb:
        "<q>I'm comfortable with what I'm already wearing.</q> ";
        exit;
      default:
        "<q>Since when are you the boss?</q>\ he questions, almost smirking. ";
        exit;
    }
  }  
  verDoTellAbout(actor, io) = { self.verDoAskAbout(actor, io); }
  doTellAbout(actor, io) = { 
    "You wonder what <<self.sdesc>> has to say instead, so you ask him about it.\b";
    self.doAskAbout(actor, io); 
  }
  verDoAskFor(actor, io) = { self.disavow; }
  doAskFor(actor, io) = { self.doAskAbout(actor, io); }
  disavow = ""
  dontKnow = {
    local msg := [
      '<q>I don\'t know much about that,</q> says '
      '<q>I don\'t really know,</q> states '
      '<q>You probably know as much as I do,</q> quips '
      '<q>Were you talking to me?</q>\ questions '
      '<q>Sorry, not my area of expertise,</q> exclaims '
      '<q>Um... Did you say something?</q>\ asks '
      'A shrug is all you get from '
    ];
    say(msg[rand(length(msg))]);
  }
  askWord(word, lst) = {
    switch(substr(word, 1, 7)) {
      case 'me':
      case 'myself':
      case 'kieron':
        if (Me.location = fairway)
          "<q>Beat this cocky sonnuvabeeyatch down, Kieron,</q> says Terry. ";
        else
          "<q>You need to give me some golf lessons,</q> says Terry. ";
        return true;
        break;
      case 'tavaria':
      case 'pittman':
        "<q>Well,</q> says Terry, <q>if he doesn't get taken in the NFL draft he still has
        an outstanding career ahead of him as a kind of gruesome puppeteer.</q> ";
        return true;
        break;
      case 'golf':
        "<q>One thing about keeping our first round picks, instead of making questionable
        trades like the previous organization did for chuds like Bill Bellichick, is that
        I get plenty more chances to work on my game.</q> ";
        return true;
        break;
      case 'patriot':
      case 'pats':
      case 'new eng':
       "<q>We should be in good shape this year, if we can address our defensive line
        properly. God, what I'd do to get another Julius Adams.</q> ";
        return true;
        break;
      case 'draft':
        "<q>Hopefully we can get our guys and improve our team.</q> ";
        return true;
        break;
      case 'house':
        return true;  // cheesy way to fix ask about club house
        break;        
      default:
        dontKnow; "<<self.sdesc>>. ";
        return nil;
      }
  }
  doAskAbout(actor, iobj) = {
    switch(iobj) {
      case himself:
        "Dan doesn't like talking about himself. He's kind of humble. ";
        break;
      case danFonda:
        if (Me.location = fairway)
          "<q>School this mouthy second stringer, willya?</q> ";
        else
          "He looks over at Dan, anticipating your conversation with him. ";
        break;
      case bucky:
        "<q>He is clinically insane.</q> ";
        break;
      default:
        /* we didn't find anything special; use the default behavior */
        inherited.doAskAbout(actor, iobj);
    }
  }
  doHello = { 
    if (!self.helloSaid) {
      "<q>Hello,</q>\ he says. ";
      self.helloSaid := true;
    }
    else
      "\^<<self.sdesc>> smiles at you, probably wondering why you 
      insist on repeating a greeting. ";
  }
  verDoTurnon(actor) = { "I'm sure you can think of something else to do, no? 
                         Besides, why would you want to alienate <<self.sdesc>>. "; }
  verDoAttack(actor) = { }
  doAttack(actor) = { golfClub.ioAttackWith(actor, self); }
  verDoAttackWith(actor, iobj) = { }
  doAttackWith(actor, iobj) = { self.doAttack(actor); }
  doListenTo(actor) = { "\^<<self.sdesc>> isn't making much noise right now. "; }
  ioSynonym('GiveTo') = 'ShowTo'
  ioGiveTo(actor, dobj) = { "<q>You can keep that,</q> quips <<self.sdesc>>. "; }
  answerYes = { 
    if (self.waitingYes) {
      "You look over at Terry and nod yes. \b";
      self.doTalkTo(Me);
    }
    else
      "\^<<self.thedesc>> smiles. "; }
  answerNo =  { 
    if (self.waitingYes) {
      "You look over at Terry and think about saying no, but end up nodding yes. \b";
      self.doTalkTo(Me);
    }
    else
      "\^<<self.thedesc>> didn't hear you. "; }
  verDoTalkTo(actor) = {}
  doTalkTo(actor) = { 
    switch (self.location) {
      case fairway:
        if (!self.fairwayTalk) {
          self.fairwayTalk := true;
          "<q>Just be sure to make this shot count,</q> he says. ";
        }
        else
          "Now is the time for action, not words, so you concentrate on the shot. ";
        break;
      default:
        if (!Me.ordered)
          hintReadMenu(self);
        else {
          "<q>Actually, she is. Our first, as a matter of fact.</q> You can't hide 
          the joy from spreading across your face. It's infectious. The meals come, 
          and the three of them relate stories about their children, and what it 
          was like when they had the first one. You manage to create an atmosphere 
          of good cheer, and seeing how most sports agents are truckling leeches, 
          devoid of any real shreds of personality, you manage to impress upon 
          these guys that negotiations -- with you -- will be fun, optimistic, 
          and fair.\b After lunch, the three of them shake your hand, and you have 
          a good feeling that your client will be drafted -- probably in the 
          second round -- by New England.\b
          You leave the club house and enter the parking lot. Sharing this good news with 
          Charlise is going to be a lot of fun.\b ";
          menu.moveInto(nil);
          glass.moveInto(nil);
          Me.eaten := true;
          Me.travelTo(parkingLot); 
          self.waitingYes := nil;
          self.conversingWith := nil;
          remdaemon(waitingFoodDaemon,nil);
        }
        break;
    }
  }
;

bucky: Actor
  location = fairway
  sdesc = "Bucky"
  noun = 'bucky' 'johnson' 'man' 'buck'
  takedesc = "I don't think <<self.sdesc>> would appreciate that. "
  ldesc = {
    "Bucky was the NFL rookie of the year last season, and a former team-mate 
    of Tavarian. ";
    if (self.location = fairway)
      "He's having a blast, which is good, because he shot a 62 on the first 
      nine holes. ";
    else
      "He's rather quiet after imploding on the back nine -- he ended up 
      shooting 133...... ";
    "He's been pulling for the team to take Tavarian so 
    that he could be reunited with his college friend. He's also, as a 
    cornerback himself, aware of how many interceptions he's likely to 
    get when quarterbacks are desperately throwing the football away so 
    that they are not ground into a greasy bit of turf smear. ";
  }
  adesc = { self.sdesc; }
  thedesc = { self.sdesc; }
  isHim = true
  actorDesc = {
    if (!self.seen)
      self.seen := true;                // don't display when game starts up
    else {                                                                  
      if (!self.seenGM) {
        self.seenGM := true;            // only display GM line once
      "Bucky Johnson, a Patriots cornerback, is here. ";
      }
      else
      "Bucky is here. ";
    }
  }
  verDoSearch(actor) = { "<q>Hey!</q>\ he protests, moving away from you. "; }
  verDoHug(actor) = {"Your show of affection could alter negotiations -- negatively! "; }
  verDoKiss(actor) = {"Your show of affection could alter negotiations -- negatively! "; }
  doSynonym('Search') = 'Lookin'
  actorAction(v, d, p, i) = {
    if (v.isTravelVerb) {
      "<q>I'm not going anywhere right now.</q> ";
      exit;
    }
    switch(v) {
      case noVerb:
      case yesVerb:
      case helloVerb:
        break;
      case wearVerb:
        "<q>I'm comfortable with what I'm already wearing.</q> ";
        exit;
      default:
        "<q>Nobody tells me what to do!</q>\ he replies, full of sarcasm. ";
        exit;
    }
  }  
  verDoTellAbout(actor, io) = { self.verDoAskAbout(actor, io); }
  doTellAbout(actor, io) = { 
    "You wonder what <<self.sdesc>> has to say instead, so you ask him about it.\b";
    self.doAskAbout(actor, io); 
  }
  verDoAskFor(actor, io) = { self.disavow; }
  doAskFor(actor, io) = { self.doAskAbout(actor, io); }
  disavow = ""
  dontKnow = {
    local msg := [
      '<q>I don\'t know much about that,</q> says '
      '<q>I don\'t really know,</q> states '
      '<q>You probably know as much as I do,</q> quips '
      '<q>Were you talking to me?</q>\ questions '
      '<q>Sorry, not my area of expertise,</q> exclaims '
      '<q>Um... Did you say something?</q>\ asks '
      'A shrug is all you get from '
    ];
    say(msg[rand(length(msg))]);
  }
  askWord(word, lst) = {
    switch(substr(word, 1, 7)) {
      case 'me':
      case 'myself':
      case 'kieron':
        "<q>We got to get you out over to the Liquor Hole Blue Tavern, man!</q> ";
        return true;
        break;
      case 'tavaria':
      case 'pittman':
        "<q>He's my boy!</q> He goes over to Dan. <q>We gotta draft my boy!</q> ";
        return true;
        break;
      case 'golf':
        "<q>I'm better at the Atari version than in real life.</q> ";
        return true;
        break;
      case 'patriot':
      case 'pats':
      case 'new eng':
        "<q>We're gonna represent, that's for DAMN sure!</q> ";
        return true;
        break;
      case 'draft':
        "<q>We get my boy Pittman in here, and I'm lookin' at a 15 pick season! I'll be gravy-training
        like there's no tomorrow! Pittman's my boy, yeah, my boy!</q> ";
        return true;
        break;
      case 'house':
        return true;  // cheesy way to fix ask about club house
        break;        
      default:
        dontKnow; "<<self.sdesc>>. ";
        return nil;
      }
  }
  doAskAbout(actor, iobj) = {
    switch(iobj) {
      case himself:
        "<q>I am da man!</q> ";
        break;
      case terry:
        "<q>He does alright managing the contracts of some of the scrubs and camp bodies on the team.
        But I took him to the cleaners. I am STILL laughing all the way to the bank.</q>/b
        Actually, you happen to know the details of Bucky's deal, and he is hideously underpaid.
        You feel that you could have got him a much larger signing bonus and not had so much
        of the deal back-loaded. Ah, well. ";
        break;
      case danFonda:
        "<q>Taught me everything I know about playing the position. Except for my horrific moves
        after I spring a pick and take it in for a score. Gonna get me a music video out of
        that, I am!</q> ";
        break;
      default:
        /* we didn't find anything special; use the default behavior */
        inherited.doAskAbout(actor, iobj);
    }
  }
  doHello = { 
    if (!self.helloSaid) {
      "<q>Hello,</q>\ he says. ";
      self.helloSaid := true;
    }
    else
      "\^<<self.sdesc>> smiles at you, probably wondering why you 
      insist on repeating a greeting. ";
  }
  verDoTurnon(actor) = { "I'm sure you can think of something else to do, no? 
                         Besides, why would you want to alienate <<self.sdesc>>. "; }
  verDoAttack(actor) = { }
  doAttack(actor) = { golfClub.ioAttackWith(actor, self); }
  verDoAttackWith(actor, iobj) = { }
  doAttackWith(actor, iobj) = { self.doAttack(actor); }
  doListenTo(actor) = { "\^<<self.sdesc>> isn't making much noise right now. "; }
  ioSynonym('GiveTo') = 'ShowTo'
  ioGiveTo(actor, dobj) = { "<q>You can keep that,</q> quips <<self.sdesc>>. "; }
  verDoTalkTo(actor) = {}
  doTalkTo(actor) = { 
    switch (self.location) {
      case fairway:
        if (!self.fairwayTalk) {
          self.fairwayTalk := true;
          "<q>You got the pitching wedge out, then? Yeah? Wait, what?</q> ";
        }
        else
          "Now is the time for action, not words, so you concentrate on the shot. ";
        break;
      default:
        if (!Me.ordered)
          hintReadMenu(self);
        else
          "You make some small talk with Bucky, and the conversation quickly ends. ";
        break;
    }
  }
;

parkingLot: room
  sdesc = "Country Club Parking Lot"
  ldesc = { 
    if (!self.seen) {
      self.seen := true;
      "Finding your car in the parking lot isn't extremely difficult -- as 
      it's not a Lexus, Porsche or BMW, 99% of the cars are eliminated right 
      away. Of the two remaining cars, the jet-black Hummer with a woofer 
      completely taking up all available space past the front seats belongs 
      to Bucky, and the 95 Neon is yours. (Hey, at least it's the two door 
      version with the big engine, and not some wood-grained station wagon 
      that would garner nothing but looks of disdain and sympathy from the 
      other golfers.) You head over toward it in order to put your clubs away. ";
      if (!Me.noEat) {                   // don't do if we HIT dan, etc...
        "\b<q>Say, Kieron,</q> says Dan, <q>Why don't you come over to the club house 
        with us.  We could talk some things over regarding Pittman and the draft.</q> ";
        danFonda.waitingYes := true;
        Me.conversingWith := true;
      }
    }
    else
      "This is the parking lot to the Keros Country Club. It looks like it has
      rained here earlier today -- there are puddles of water scattered about
      and the air has a misty quality to it. To the south is the club house itself. ";
  }
  south = {
    if (Me.noClubHouse)
      "After that last incident in the club house, you dare not go back. ";
    else if (Me.noEat) 
      "You saw Dan, Terry and Bucky head to the clubhouse after your brain freeze,
      so you decide to not tempt fate. ";
    else if (Me.ordered)
      "You've spent enough time there, you should be heading home to your wife. ";
    else if (golfBag.isIn(Me)) 
      "Club house rules won't allow you to bring your golf bag inside. ";
    else {
      "\nYou join Dan, Terry, and Bucky for a quick lunch at the clubhouse,
      to hopefully completely sell the idea of them drafting Tavarian 
      before parting ways. The four of you get a booth in back, out of 
      the direct sunlight that illuminates most of the tables. \b";
      remdaemon(danDaemon, nil);
      danFonda.moveInto(clubHouseBooth);
      terry.moveInto(clubHouseBooth);
      bucky.moveInto(clubHouseBooth);
      "<b>Club House, in the booth</b>\n <<clubHouse.ldesc>>\n";
      Me.travelTo(clubHouseBooth);
    }
  }
  in = {
    setit(neonItem2);    
    if (golfBag.isIn(Me)) {
      "You can't enter your car while carrying your clubs! ";
      return nil;
    }
    else
      if (neonItem.isLocked) {
        neonItem.isLocked := nil;
        "(you first unlock the car)\n";
      }
      if (neonDoorOut.isopen) {
        "You enter the car and close the door behind you.\b";
        neonDoorOut.isopen := nil;
      }
      else
        "You open the car door and get in.\b";
      return inNeon;
  }
;

puddles: decoration
  sdesc = "puddles"
  noun = 'puddles' 'puddle'
  location = parkingLot
  ldesc = "The <<self.sdesc>> <<self.isntdesc>> important. "
  isThem = true
;

parkinglot: fixeditem
  sdesc = "parking lot"
  noun = 'lot'
  adjective = 'parking'
  location = parkingLot
  ldesc = "The <<self.sdesc>> <<self.isntdesc>> important. "
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached to the earth. "
;

lexus: fixeditem
  sdesc = "Lexus"
  noun = 'lexus'
  location = parkingLot
  ldesc = "There are quite a few of them here. One of them has a golfball-sized
          crack in the windshield. "
  takedesc = "The <<self.sdesc>> <<self.isdesc>> real heavy. "
;

porsche: fixeditem
  sdesc = "Porsche"
  noun = 'porsche'
  location = parkingLot
  ldesc = "All manner and styles of Porsches are here at the country club.
           Even the caddies own 914s. "
  takedesc = "The <<self.sdesc>> <<self.isdesc>> real heavy. "
;

bmw: fixeditem
  sdesc = "BMW"
  noun = 'bmw'
  location = parkingLot
  ldesc = "There are quite a few of them here. One of them has a license plate
          that says <q>68 INT</q> -- short for sixty-eight interceptions. That must be Dan's. "
  takedesc = "The <<self.sdesc>> <<self.isdesc>> real heavy. "
;

hummer: fixeditem
  sdesc = "Hummer"
  noun = 'hummer' 'humvee'
  location = parkingLot
  ldesc = "It's almost a law -- get drafted in the first round, get yourself
          a HumVee. Certainly, Bucky supports such legislation. "
  takedesc = "The <<self.sdesc>> <<self.isdesc>> real heavy.  "
;

woofer: decoration
  sdesc = "woofer"
  noun = 'woofer'
  adjective = 'sub'
  location = hummer
  ldesc = "The woofer is larger than your first refrigerator. Getting too close
          to it while it's turned on will only guarantee a cacophony of sonic pain! "
;

neonItem: fixeditem, container
  sdesc = "your car"
  adesc = "your car"
  thedesc = "your car"
  noun = 'car' 'vehicle' 'auto' 'automobile'
  adjective = 'neon'
  isListed = {
    if (!self.seen) {
      self.seen := true;        // don't display first time in
      return nil;
    }
    else
      return true;              // listed in room/inventory displays
  }
  location = parkingLot 
  ldesc = "Your Neon has served you well -- no headgasket problems yet. The interior
          is a little noisy, but overcome with its decent stereo system. "
  verDoEnter(actor) = { self.verDoBoard(actor); }
  doEnter(actor) = { self.doBoard(actor); }
  verDoBoard(actor) = {    
    if (golfBag.isIn(Me)) {
      "You can't enter your car while carrying your clubs! ";
      return nil;
    }
    if (self.location = garage)
      "But you just got here! ";
  }
  doBoard(actor) = { 
    if (self.isLocked) {
      self.isLocked := nil;
      "(you first unlock the car)\n";
    }
    if (neonDoorOut.isopen) {
      "You enter the car and close the door behind you.\b";
      neonDoorOut.isopen := nil;
    }
    else
      "You open the car door and get in.\b";
    setit(neonItem2);    
    actor.travelTo (inNeon); 
  }
  verDoAttack(actor) = { "Violence isn't the answer. "; }
  verDoOpen(actor) = { neonTrunk.verDoOpen(actor); }
  doOpen(actor) = { 
    "You open the trunk. ";
    neonTrunk.isopen := true;
  }
  verDoClose(actor) = { neonTrunk.verDoClose(actor); }
  doClose(actor) = { 
    "You close the trunk. ";
    neonTrunk.isopen := nil;
  }
  isLocked = nil
  verDoLock(actor) = { if (self.isLocked) "The car is already locked. "; }
  doLock(actor) = {
    self.isLocked := true;
    "You lock up your car. ";
  }
  verDoUnlock(actor) = { if (!self.isLocked) "The car is not locked. "; }
  doUnlock(actor) = {
    self.isLocked := nil;
    "Done. ";
  }
  verDoSearch(actor) = { "You can't search your car standing in the parking lot. "; }
  verDoLookunder(actor) = {}
  doLookunder(actor) = {
    if (!self.seen) {
      "You gasp ...\ it actually *is* leaking a bit of oil. 
      Hopefully it's just a bad seal. ";
      self.seen := true;
      oilspot.moveInto(parkingLot);
    }
    else
      "You find nothing, apart from a small oil spot. ";
  }
  verDoPush(actor) = {"You can't push your car. "; }
  verDoPull(actor) = {"You can't pull your car. "; }
  verDoMove(actor) = {"You can't move your car. "; }
  verIoPutIn(actor) = { }
  ioPutIn(actor, dobj) = {
    if (dobj = golfBag) {
      if (!neonTrunk.isopen)
        "You swing around to the back of your car and pop the trunk. ";
      "You place your golf bag in the car and promptly shut the trunk. ";
      golfBag.moveInto(neonTrunk);
    }
    else
      "Your car has enough clutter, no need to add to it. "; 
  }
  verDoLookin(actor) = {}
  doLookin(actor) = {
    "In your car you see lots of clutter";
    if (itemcnt(inNeon.contents) > 0) {
      " and ";
      listcont(inNeon);
    }
    ". ";
  }
  verDoDrive(actor) = { "You're not in your car. "; }
  verDoStart(actor) = { "You're not in your car. "; }
;

neonTrunk: openable, fixeditem
  sdesc = "trunk"
  noun = 'trunk'
  location = neonItem
  ldesc = {
    "The Neon's trunk is currently ";
    if (self.isopen) "open. "; else "closed. ";
  }
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached. "
  isopen = nil
  isListed = nil
  verDoOpen(actor) = {
    if (golfBag.location = self)
      "There is no need to open the trunk again.  Your clubs are safe and Charlise is
      probably waiting for you... ";
  }
  verDoBoard(actor) = {
    if (!self.isopen)
      "The trunk is closed. ";
    else
      "This isn't a Joe Pesci film. ";
  }
;

oilspot: decoration
  noun = 'oil' 'spot'
  adjective = 'grease' 'slick'
  sdesc = "oil spot"
;

inNeon: room
  sdesc = "Inside your car"
  ldesc = {
    "Chrysler did some good work with the early model Neons -- although there isn't 
    much room in the backseats, and the dash, save for your built-in cell phone, is kind of spartan, it's 
    plenty comfortable and extremely responsive. Overall, it kind of moves like a slot car. ";
  }
  out = {
    if (neonItem2.started)
      "Always trying to get yourself on Fox's 'World's Most Suicidal Drivers,'
      aren't you Kieron?";
    else
      return parkingLot;
  }
  listendesc = {
    if (!neonItem2.started)
      "You don't hear anything unusual. ";
    else
      "The radio keeps talking about world news and the backed up traffic. ";
  }
  noexit = { "You aren't going anywhere until you get out of your car. "; }
;

dashboard: fixeditem
  sdesc = "dash board"
  noun = 'board'
  adjective = 'dash'
  location = inNeon
  ldesc = "Not a whole lot to it, really. "
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached. "
;

carRadio: fixeditem
  sdesc = "radio"
  noun = 'radio'
  location = inNeon
  ldesc = "The <<self.sdesc>> <<self.isntdesc>> important. "
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached to the dashboard. "
  verDoTurnon(actor) = {
    if (!neonItem2.started)
      "The car hasn't been started. ";
    else
      "The radio is already on. ";
  }
  verDoTurnoff(actor) = {
    if (!neonItem2.started)
      "The radio is not on. ";
    else
      "You decide to listen to the current traffic report. ";
  }  
  verDoListenTo(actor) = {
    if (!neonItem2.started)
      "The radio is not on. ";
    else
      "The radio keeps talking about world news and the backed up traffic. ";
  }
;

carHorn: fixeditem
  sdesc = "horn"
  noun = 'horn'
  location = inNeon
  ldesc = "The <<self.sdesc>> <<self.isntdesc>> important. "
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached. "
  verDoHonk(actor) = {
    if (!neonItem2.started)
      "You shock some guy who is golfing a little ways away into totally shanking his shot. ";
    else
      "Bostonians in all directions give you the finger out of habit. ";
  }
  verDoAttack(actor) = { self.verDoHonk(actor); }
;

backSeats: fixeditem
  sdesc = "seats"
  noun = 'seats' 'seat' 'backseats' 'backseat'
  adjective = 'back' 'front'
  location = inNeon
  ldesc = "They don't look like they're the kind of backseats 
          that would come out very easily. "
  takedesc = "Kind of pointless. (Plus, there's not that much spring to them.) "
  isThem = true
;

neonItem2: fixeditem
  sdesc = "your car"
  adesc = "your car"
  thedesc = "your car"
  noun = 'car' 'vehicle' 'auto' 'automobile'
  adjective = 'neon'
  location = inNeon
  ldesc = {
     "You're inside your Neon. ";
  }
  verDoUnboard( actor ) = {}
  doUnboard( actor ) = { 
    if (self.started)
      "Always trying to get yourself on Fox's 'World's Most Suicidal Drivers,'
      aren't you Kieron?";
    else
      Me.travelTo(parkingLot); 
  }
  verDoStart(actor) = { 
    if (self.started)
      "The car is already running. ";
  }
  doStart(actor) = {
    if (!Me.eaten) {
      if (danFonda.location = nil)
        "Before starting the car, you decide to run over to the club house and tell Dan
        that you can't stay for lunch.\b";
      else {
        remdaemon(danDaemon, nil);
        "You shake Dan's hand before driving off. \b";
      }
      "<q>Dan,</q> you say, <q>I'd love to be able to stay and chat. Thing is, my wife is due any
      moment now. I've really got to drop by and check up real quick, in case something
      happened and she was unable to reach me with the phone. It's odd -- she should have
      called by now. Tell you what, though, why don't I meet you and Terry for a couple beers 
      tonight, provided she doesn't go into labor? I've got a presentation I can give
      that will explain just why I honestly believe that Tavarian has shaped up, and what
      he can do for your club.</q> \b
      <q>No problem,</q> says Dan. <q>You've got my number, right? Sounds like a plan.</q>\b
      You've actually got no presentation in mind, but you pretty much know what you want
      to say -- it's just a matter of turning it into a format that Microsoft Powerpoint
      can understand. But hey, living life on the edge like this is what being an agent
      is all about.\b";
      if (golfBag.location = parkingLot and danFonda.location = parkingLot) {
        "<q>What about this?</q>\ asks Dan, pointing to your golf bag on the ground.\b
        <q>Oops, I'm so concerned about Charlise, I totally forgot about that.</q>\b
        You pop the trunk and Dan puts them away for you.  You thank him for the kind deed
        and he walks toward the club house.\b";
        danFonda.moveInto(nil);
        golfBag.moveInto(neonTrunk);
      }
      else if (danFonda.location = nil)
        "You say good-bye to both Terry and Bucky and head back toward your car.\b";
    }
    "You place the key into the ignition and give it a turn -- the car fires up 
    without a problem. (You get a wistful, longing glance from the guy next to 
    you trying to start his MGB, but ignore it.) \b Your favorite radio station 
    is apparently in the middle of an eight-minute marathon of Third Party 
    Microsoft Certification commercials, so you change over to NPR.\b ";
    self.started := true;
    self.count := 1;
    setdaemon(driveDaemon, nil );
    self.skipBlank := true;
    self.driveDaemonStarted := true;
    self.skipIntro := true;
    "Turning out of the country club and heading home, things are pretty 
    slow-going. As it turns out, according to the radio, somebody snapped 
    today and is waving a gun at people a few dozen miles down the freeway. ";
    trafficJam.moveInto(inNeon);
  }
  isLocked = nil
  verDoLock(actor) = { if (self.isLocked) "The car is already locked. "; }
  doLock(actor) = {
    self.isLocked := true;
    "You lock up your car. ";
  }
  verDoUnlock(actor) = { if (!self.isLocked) "The car is not locked. "; }
  doUnlock(actor) = {
    self.isLocked := nil;
    "Done. ";
  }
  verIoPutIn(actor) = {"Your car has enough clutter, no need to add to it. "; }
  verDoAttack(actor) = { "Violence isn't the answer. "; }
  verDoLookin(actor) = {}
  doLookin(actor) = {
    "You see lots of clutter";
    if (itemcnt(inNeon.contents) > 0) {
      " and ";
      listcont(inNeon);
    }
    ". ";
  }
  verDoDrive(actor) = {}
  doDrive(actor) = {
    if (!self.started) {
      self.doStart(actor);
      if (!self.skipBlank)
        "\b";
    }
    if (!self.driveDaemonStarted) {
      self.count := 0;
      setdaemon(driveDaemon, nil );
      self.driveDaemonStarted := true;
    }
    if (self.count = 0) {
      self.skipIntro := true;
      self.count++;
      "Turning out of the country club and heading home, things are pretty 
      slow-going. As it turns out, according to the radio, somebody snapped 
      today and is waving a gun at people a few dozen miles down the freeway. ";
      trafficJam.moveInto(inNeon);
    }
    else
      self.skipBlank := true;
  }
  verDoSearch(actor) = { "There's nothing special in your car. "; }
;

phoneItem: fixeditem
  sdesc = "wife"
  noun = 'home' 'wife' 'charlise'
  location = inNeon
  verDoCall(actor) = {}
  doCall(actor) = { makeCall(); }
  verDoDial(actor) = {}
  doDial(actor) = { makeCall(); }
  verDoEnter(actor) = {} // go home tried
  doEnter(actor) = { neonItem2.doDrive(actor); }
  verDoDrive(actor) = {} // drive home tried
  doDrive(actor) = { neonItem2.doDrive(actor); }
;

phonePoliceItem: fixeditem
  sdesc = "police"
  noun = 'police' 'cops'
  location = inNeon
  verDoCall(actor) = {}
  doCall(actor) = { 
    if (self.called) 
      "The police have had enough of you, and have put you on callblock. ";
    else {
      "You give the police a call, to see what the holdup is. You don't get much
      out of the call before they terminate it, but apparently there really is a
      guy with a gun out there. This city needs some superheroes or something,
      if it's taking regular policemen this long to get a lone gunman out of
      the highway. ";
      self.called := true;
    }
  }
  verDoDial(actor) = {}
  doDial(actor) = { self.doCall(actor); }
;
  
carPhone: item
  sdesc = "phone"
  noun = 'phone' 'telephone' 'cell'
  location = inNeon
  isListed = nil
  ldesc = "The phone is just about what you would expect. "
  doTake(actor) = { 
    if (!Me.calledHome) 
      "You reach for the phone so you can call home and check on Charlise.\b";
    makeCall(); 
  }
  verDoUse(actor) = {}
  doUse(actor) = { makeCall(); }
  verDoDial(actor) = {}
  doDial(actor) = { makeCall(); }
  verDoAnswer(actor) = { "But the phone isn't ringing. "; }
  verDoHangup(actor) = { "But the phone isn't off the hook. "; }
  verDoListenTo(actor) = { "The phone is rather quiet right now. "; }
;

makeCall: function
{
  if (Me.calledHome) {
    "Well, you've already called home and years of teenage dating has conditioned
    you to not call too often, lest you be catapulted into the undesirable
    category of <q>stalker.</q> ";
    return;
  }
  "The phone rings eight times and the answering machine picks up. Usually the 
  both of you leave a rather detailed message for one another when leaving 
  the house, so she's probably napping or something. ";
  if (neonItem2.started)
    "\bA police cruiser goes screaming past you in the breakdown lane. ";
  Me.calledHome := true;
}

driveDaemon: function(parm)
{
  if (neonItem2.skipIntro) {                            // PC typed DRIVE first
    neonItem2.skipIntro := nil;
    return;
  }
  if (neonItem2.skipBlank)
    neonItem2.skipBlank := nil;
  else
    "\b";
    
  switch (neonItem2.count++) {
    case 0:
      "Turning out of the country club and heading home, things are pretty 
      slow-going. As it turns out, according to the radio, somebody snapped 
      today and is waving a gun at people a few dozen miles down the freeway. ";
      trafficJam.moveInto(inNeon);
      break;                  
    case 1:
      "\bThe traffic is still something awful up ahead. ";
      break;                  
    case 2:
      "You try to drive, but can't get very far because of the backlog of cars. ";
      if (golfBag.location = parkingLot)
        "\b<q>Damn!</q>\ you exclaim.  You just remembered that you left your golf
        clubs in the parking lot.  You don't have time to go back and get them, so
        you give Keros Summer Country Club a call.  You hang up somewhat relieved --
        they'll put them aside for you.  What a time to get absent-minded. ";
      break;                  
    case 3:
      "Hm...\ looks like the congestion of cars is starting to thin a little...\b
      It probably wouldn't be a bad idea to call Charlise and let her know you're
      going to be a little late. She might have heard about the lunatic on the 
      highway and might be, rightfully so, a bit concerned. ";
      break;                  
    case 4:
      "The traffic jam has almost completely dispersed. ";
      trafficJam.moveInto(nil);
      break;                  
    case 5:
      "You put the car into gear and drive home.\b
      You pull into the garage, close the garage door and get out of the car.\b ";
      remdaemon(driveDaemon, nil );
      setdaemon(dryerDaemon, nil );
      Me.travelTo (garage); 
      neonItem.moveInto(garage);
      break;                  
  }
}

trafficJam: fixeditem
  sdesc = "traffic jam"
  noun = 'jam' 'congestion' 'highway' 'backlog' 'freeway'
  adjective = 'traffic'
  ldesc = "It's plain ugly. "
;


neonDoorOut: lockableDoorway
  sdesc = "car door"
  noun = 'door'
  adjective = 'car'
  location = parkingLot
  doordest = inNeon
  otherside = neonDoorIn
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached. "
;

neonDoorIn: lockableDoorway
  sdesc = "car door"
  noun = 'door'
  adjective = 'car'
  location = inNeon
  doordest = parkingLot
  otherside = neonDoorOut
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached. "
;

golfBag: item
  sdesc = "golf bag"
  noun = 'bag' 'clubs'
  adjective = 'golf'
  ldesc = { "It's a long, tanned leather bag that you put your clubs into. "; }
  doPutIn(actor, io) = {
    if (io = neonTrunk) {
      "You put the clubs away and then shut the trunk. ";
      self.moveInto(neonTrunk);
      neonTrunk.isopen := nil;
    }
    else
      pass doPutIn;
  }
  verDoLookin(actor) = { "Apart from your clubs, you find nothing of interest. "; }
  verDoOpen(actor) = { "Apart from your clubs, you find nothing of interest. "; }
;

clubHouseDistant: distantItem
  sdesc = "club house"
  noun = 'house'
  adjective = 'club'
  location = parkingLot
  verDoEnter(actor) = {}
  doEnter(actor) = {
    parkingLot.south;
  }
  ldesc = "The club house is off to the south a couple hundred yards. You've never
          been in it before. "
;

clubHouse: room
  sdesc = "Club House"
  noun = 'house'
  adjective = 'club'
  ldesc = {
    "The club house has a warm feel to it without going overboard -- there
    is an unlit fireplace in one corner, and collection of champagne glasses
    hanging upside-down near the bar. ";
    if (self.seen) {
      "The ";
      if (terry.location = nil) "three"; else "four";
      " of you are huddled around the booth. ";
    }
    else {
      "\bThere is a menu here. ";
      menu.moveInto(clubHouse);
      self.seen := true;
      self.count := 0;
      setdaemon(waitingFoodDaemon,nil);
    }
  }
;

// Daemon used to prod PC into ordering food.
waitingFoodDaemon: function(parm)
{
  switch(clubHouse.count++) {
    case 5:
      if (!menu.seen) {
        "\b<q>Say Kieron,</q> quips Dan, <q>why don't you take a peek at the menu.  They have
        good food here.</q> ";
      }
      else
        "\bTerry and Bucky engage in small talk -- it ends quickly. ";
      break;
    case 10:
      if (!menu.seen) {
        "\b<q>I'm starvin',</q> blurts Bucky. <q>Kieron, you should decide what you want to order soon.</q> ";
      }
      else
        "\bTerry and Bucky swap college stories. ";      
      break;
    case 15:
      if (!menu.seen) {
        "\b<q>If you weren't hungry, Kieron,</q> says Terry, <q>you should have just gone home!</q> \b
        He laughs, but you don't think he meant it as a joke. ";
      }
      else
        "\bDan looks bored. ";      
      break;
    case 20:
    case 30:
    case 50:
      "\bThe silence is deafening. ";
      break;
    case 25:
      if (!menu.seen) {
        "\b<q>If you don't read that menu and decide on your lunch,</q> chuckles Bucky, <q>they're gonna
        run out of food!</q> ";
      }
      else {
        if (Me.ordered)
          "\bThe waitress swings by and mentions that the food should be out in a while. ";
        "\bDan looks at you, probably wondering why Pittman's agent isn't <i>talking</i> to him. ";
      }
      break;
  }
}

bathroom: fixeditem
  sdesc = "bathroom"
  noun = 'bathroom' 'toilet'
  location = clubHouse
  ldesc = {
    if (terry.location = nil)
      "When you drink as much as Terry does, there's two real effects:\ You'll give up a first round pick for
      a coach like Belichick, and you're always taking off to go the bathroom. ";
    else
      "You can't seem to locate it from here. Not a real big problem, as you don't feel the urge. ";
  }
  verDoBoard(actor) = { "You don't have the urge. "; }
  verDoEnter(actor) = { "You don't have the urge. "; }
;


clubHouseBooth: chairitem
  sdesc = "booth"
  noun = 'booth' 'table'
  location = clubHouse
  ldesc = { 
    "It seats all of you quite comfortably -- it might be different if some of
    the guys were offensive linemen, but luckily (in this situation) that's
    not the case. ";
  }
  out = { "Knowing that you need to talk with Dan about Pittman, you decide to stay a bit longer. "; }
  verDoUnboard(actor) = { "Knowing that you need to talk with Dan about Pittman, you decide to stay a bit longer. "; }  reachable = { return(self.location.contents); }
  genericHint = true
;

tables: decoration
  sdesc = "tables"
  noun = 'tables'
  location = clubHouse
  ldesc = "The <<self.sdesc>> <<self.isntdesc>> important. "
  isThem = true
;

clubHouseItem: fixeditem
  sdesc = "club house"
  noun = 'house'
  adjective = 'club'
  ldesc = { clubHouse.ldesc; }
  location = clubHouse
  takedesc = "It's firmly attached. "
;

fireplaceClub: fixeditem
  sdesc = "fireplace"
  noun = 'fireplace'
  adjective = 'brick'
  location = clubHouse
  ldesc = "It's a pretty sharp-looking brick fireplace, currently unlit. "
  takedesc = "It's firmly attached to the club house. "
  verDoLookin(actor) = { "The fireplace is empty. "; }
  verDoLight(actor) = { "Easy there, St.\ John Allerdyce. "; }
;

glasses: decoration
  sdesc = "champagne glasses"
  noun = 'glasses'
  adjective = 'champagne'
  location = clubHouse
  ldesc = "They kind of look like the ones you had at your wedding. Bucky has 
          demonstrated that they are, in fact, the kind that make a noise when 
          you spin a finger around the edge of one. (Over and over again, actually.) "
  isThem = true
;

bar: fixeditem
  sdesc = "bar"
  noun = 'bar'
  location = clubHouse
  ldesc = "The bar is home to a cathedral of lies -- players having just got off the green
          that couldn't accurately tell you the birthdays of their children are describing
          their mishaps and shanks with the kind of precision and detail you'd see in a 
          Sergio Aragons or Alex Ross drawing. "
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached. "
  verDoBoard(actor) = { 
    "Charlise once told you that she got up on a bar and started dancing when she was 
    a sophomore at Central Hill, but it took an entire bowl of gin on her 115 pound
    frame as a catalyst. As much as you'd apparently like to duplicate this 
    performance on the most important day in your career so far...\ there's just
    not enough available gin. ";
  }
;

menu: item
  sdesc = "menu"
  noun = 'menu'
  ldesc = { 
    "While several of the entrees are not described in a manner fit for basic human 
    consumption, there are a few that do look good. The veal for $19, the shrimp 
    scampi for $15, the three cheese lasagna for $16 and the New York Strip 
    Steak for $23 all look quite tempting. ";
    if (!self.seen) {
      "\b A waitress walks by and places glasses of water on the table for 
      everyone. Terry orders a plate of ribs, Dan has the Caesar's Salad, and 
      Bucky orders a steak, medium rare. He flashes an eager grin to the waitress 
      after completing his order and you see that he has the initials <q>B</q> and <q>J</q> 
      engraved in gold into his two front teeth.  Kids, today. \b The waitress 
      gives you an expectant look and is ready to take your order. ";
      self.seen := true;
      glass.moveInto(clubHouseBooth);
      waitress.moveInto(clubHouseBooth);
    }
  }
  verDoRead(actor) = {}
  doRead(actor) = { self.ldesc; }
;

glass: item
  sdesc = "glass of water"
  noun = 'water'
  adjective = 'glass'
  ldesc = { "It's an ordinary glass of water, good ol' Boston tap. "; }
  verDoDrink(actor) = { "You take a sip of water. "; }
;

waitress: Actor
  sdesc = "waitress"
  noun = 'waitress'
  takedesc = "I don't think she would appreciate that. "
  isHer = true
  ldesc = {
    "She is about 5'6\", medium build and complexion and has the look and confidence
    of a pro. ";
  }
  isHim = nil
  actorDesc = {
    if (!self.seen)
      self.seen := true;
    else {
      "The waitress ";
      "is here. ";
    }
  }
  verDoSearch(actor) = { "<q>Hey!</q>\ she protests, moving away from you. "; }
  verDoHug(actor) = {"Kieron, come on now! And you with a pregnant wife at home! "; }
  verDoKiss(actor) = {"Kieron, come on now! And you with a pregnant wife at home! "; }
  doSynonym('Search') = 'Lookin'
  actorAction(v, d, p, i) = {
    if (v.isTravelVerb) {
      "<q>I'm not going anywhere right now.</q> ";
      exit;
    }
    switch(v) {
      case noVerb:
      case yesVerb:
      case helloVerb:
        break;
      case wearVerb:
        "<q>I'm comfortable with what I'm already wearing.</q> ";
        exit;
      default:
        "The waitress ignores you and waits for your lunch order. ";
        exit;
    }
  }  
  verDoTellAbout(actor, io) = { self.verDoAskAbout(actor, io); }
  doTellAbout(actor, io) = { 
    "You wonder what <<self.thedesc>> has to say instead, so you ask him about it.\b";
    self.doAskAbout(actor, io); 
  }
  verDoAskFor(actor, io) = { self.disavow; }
  doAskFor(actor, io) = { self.doAskAbout(actor, io); }
  disavow = ""
  dontKnow = {
    local msg := [
      '<q>I don\'t know much about that,</q> says '
      '<q>I don\'t really know,</q> states '
      '<q>You probably know as much as I do,</q> quips '
      '<q>Were you talking to me?</q>\ questions '
      '<q>Sorry, not my area of expertise,</q> exclaims '
      '<q>Um... Did you say something?</q>\ asks '
      'A shrug is all you get from '
    ];
    say(msg[rand(length(msg))]);
  }
  askWord(word, lst) = {
    switch(substr(word, 1, 7)) {
      case 'special':
      case 'salad':
      case 'ribs':
      case 'lasagna':
      case 'steak':
      case 'shrimp':
      case 'veal':
        "<q>All of our food items are delicious, including the <<word>>,</q> replies the waitress. ";
        return true;
        break;
      case 'menu':
        "<q>All of the menu items are cooked to order,</q> quips the waitress. ";
        return true;
        break;
      case 'club':
        "<q>I like it,</q> replies the waitress. ";
        return true;  // cheesy way to fix ask about club house
        break;        
      case 'house':
        return true;  // cheesy way to fix ask about club house
        break;        
      default:
        dontKnow; "<<self.sdesc>>. ";
        return nil;
      }
  }
  doAskAbout(actor, iobj) = {
    inherited.doAskAbout(actor, iobj);
  }
  doHello = { 
    if (!self.helloSaid) {
      "<q>Hello,</q>\ she says. ";
      self.helloSaid := true;
    }
    else
      "\^<<self.sdesc>> smiles at you, probably wondering why you 
      insist on repeating a greeting. ";
  }
  verDoTurnon(actor) = { "I'm sure you can think of something else to do, no? 
                         Besides, why would you want to alienate <<self.sdesc>>. "; }
  verDoAttack(actor) = { }
  doAttack(actor) = { "She'd kick your ass in a heartbeat. "; }
  verDoAttackWith(actor, iobj) = { }
  doAttackWith(actor, iobj) = { self.doAttack(actor); }
  doListenTo(actor) = { "\^<<self.sdesc>> isn't making much noise right now. "; }
  ioSynonym('GiveTo') = 'ShowTo'
  ioGiveTo(actor, dobj) = {
    switch(dobj) {
      case menu:
        "She takes the menu and waits for your order. ";
        menu.moveInto(self);
        break;
      default:
        "<q>You can keep that,</q> quips the waitress. ";
        break;
    }
  }
  verDoTalkTo(actor) = {}
  doTalkTo(actor) = { "You try and engage in small talk, but it's clear that she's busy and just wants your
                      lunch order. "; }
;

waitressItems: item
  sdesc = "topic of the moment"
  noun = 'herself' 'club house'
;

class orderItem: fixeditem
  adjective = 'meal' 'dinner' 'food' 'grub'
  ldesc = {
    if (Me.ordered)
      "I don't see any <<self.sdesc>> here. ";
    else
      "You can order <<self.thedesc>> from the menu. ";
  }
  isListed = nil
  location = clubHouseBooth
  doSynonym('Order') = 'Choose'
  verDoOrder(actor) = {
    if (Me.ordered)
      "You already ordered, though, Kieron. ";
  }
  doOrder(actor) = {
    if (Me.ordered)
      "You already ordered, though, Kieron. ";
    else if (!menu.seen)
      "You should wait until the waitress arrives. ";
    else {
      "<q>You bet,</q> she says. \b The waitress leaves toward the bar.\b
      <q>Well,</q> says Dan, <q>There's no debating Pittman's talent. That much I 
      think we're all in agreement over. \b ";
      if (danFonda.talkedPittman)
        "I think that we can justify taking him in the second round, but ";
      else
        "But ";
      "is he going to be a serious off-the-field problem? 
      That's what worries us, Kieron. It could be all 
      our asses if he pulls another one of those... well, if he -- </q>\b
      Bucky finishes a long draught of the icewater. <q>Pulls a McCarthy?</q>\ he 
      interjects helpfully.\b <q>What?</q>\ says Dan.\b
      <q>You know. Grabs another human head and starts a vaudeville act with it.</q>\b
      <q>Well, yes,</q> says Dan. <q>If we took him -- well, we'd need to be 
      assured that behavior like that is all in the past.</q>\b
      Terry excuses himself and heads toward the bathroom. ";
      terry.moveInto(nil);
      Me.ordered := true;
      waitress.moveInto(nil);
    }
  }
  verDoEat(actor) = {
    if (!Me.ordered)
      "Before you can eat you need to order your meal. ";
    else
      "You can eat when the food arrives. "; 
  }
  verDoTake(actor) = {}
  doTake(actor) = { self.doOrder(actor); }
;

lasagna: orderItem
  sdesc = "three cheese lasagna"
  noun = 'lasagna'
  adjective = 'three' 'cheese'
;

veal: orderItem
  sdesc = "veal"
  noun = 'veal'
;

steak: orderItem
  sdesc = "New York strip steak"
  noun = 'steak'
  adjective = 'new' 'york' 'strip'
;

shrimp: orderItem
  sdesc = "shrimp scampi"
  noun = 'scampi'
  adjective = 'shrimp'
;

ribs: orderItem
  sdesc = "ribs"
  noun = 'ribs'
  isThem = true
;

salad: orderItem
  sdesc = "Caesar's salad"
  noun = 'salad'
  adjective = 'caesar\'s' 'caesar'
;

special: orderItem
  sdesc = "special"
  noun = 'special'
;

tools: decoration
  sdesc = "tools and equipment"
  noun = 'equipment'
  adjective = 'tools'
  location = garage
  ldesc = "The <<self.sdesc>> <<self.isntdesc>> important. "
  isThem = true
;

garage: room
  sdesc = "Garage"
  ldesc = {
    "You are in your garage.  It's technically a two-car garage, but as you
    only have one automobile, you've got a lot of floorspace designated for
    various tools and around-the-house equipment. To the east is the laundry room door.  
    The garage door has been closed behind you. ";
    if (!self.seen) {
      "\bYou hear a buzzing sound coming from the laundry room. ";
      self.seen := true;
      if (global.turnsofar < 68)                // if not past 1:08 already.
        settimesys( '1:08 p.m.', 1, 2001, 10, 01 );
    }
  }
  south = { "You've been away long enough, time to find Charlise... "; }
  genericHint = true
  in = laundryDoor
  east = (self.in)
  inHouse = true
;

garageDoor: fixeditem
  sdesc = "garage door"
  noun = 'door'
  adjective = 'garage'
  location = garage
  ldesc = "The garage door is closed. "
  isListed = nil
  verDoOpen(actor) = { "But you just got in. "; }
  verDoClose(actor) = { "The door is already closed. "; }
  verDoBreak(actor) = { "You lack the strength. "; }
  verDoAttack(actor) = { "It doesn't budge. "; }
  verDoLookunder(actor) = { "Nothing there. "; }
;

laundryDoor: doorway
  noun = 'door' 'room'
  adjective = 'laundry'
  sdesc = "laundry door"
  location = garage
  doordest = laundryRoom
  otherside = laundryDoor2
;

laundryDoor2: doorway
  noun = 'door'
  adjective = 'laundry'
  sdesc = "laundry door"
  location = laundryRoom
  doordest = garage
  otherside = laundryDoor
;

laundryRoom: room
  sdesc = "Laundry room"
  ldesc = { 
    if (!self.seen) {
      self.seen := true;
      "Sometimes, when you've started to take for granted what an absolute treasure 
      you have as a wife, she goes and pulls a stunt like this and raises the bar. 
      Even though her water could break at any moment now, she still managed to haul
      down a few of those bulky sweaters you like lounging about in from the top of 
      your closet, and place them into the dryer. After all, warm equals sanitary, 
      safe, and clean. Bringing down one of them is considerate, sure. But four or 
      five? So you can pick one out specifically? That's above and beyond the call 
      of duty, alright. ";
      setdaemon(dogDaemon, nil );
    }
    else
      "You're within your Laundry Room -- it's a close-quartered little thing that 
      links your house's hallway, which is to the north, with the garage. 
      There's a washer and dryer here. ";
  }
  north = hallwayDoor
  west = laundryDoor2
  out = (self.west)
  in = (self.north)
  genericHint = true
  inHouse = true
  listendesc = "You hear your dog, Watson, barking occasionally. "
;

hallwayDoor: doorway
  noun = 'door'
  adjective = 'hallway' 'hall'
  sdesc = "hallway door"
  location = laundryRoom
  doordest = hallway
  otherside = hallwayDoor2
;

hallwayDoor2: doorway
  noun = 'door'
  adjective = 'hallway' 'hall'
  sdesc = "hallway door"
  location = hallway
  doordest = laundryRoom
  otherside = hallwayDoor
;

sweaters: fixeditem
  sdesc = "sweaters"
  noun = 'sweaters' 'sweater'
  location = laundryRoom
  ldesc = "The sweaters are in the dryer. "
  takedesc = { dryer.doOpen(Me); }
  isThem = true
;

dryer: fixeditem, surface
  sdesc = "dryer"
  noun = 'dryer'
  location = laundryRoom
  ldesc = {
    if (self.off)
      "Old Faithful indeed; you've had this dryer for five or six years yourself, and it
      was certainly not state of the art when you bought it new. You've had to replace
      the heating element once, but aside from that, it's been solid for you. ";
    else {
      "You can see four or five sweaters within it. ";
      if (!self.seenAlarm) {
        self.seenAlarm := true;
        "\bThe dryer's alarm goes off. Hunh...\ looks like they've been done for a while now. 
        The dryer alarm goes off every five minutes. Charlise must have gone straight 
        to bed. Well, bless her heart. ";
      }
    }
  }
  verDoTurnoff(actor) = { if (self.off) "The dryer is already off. "; }
  doTurnoff(actor) = {
    "You open and turn off the dryer, and place the sweaters on top of it. ";
    turnOffDryer();
  }
  verDoOpen(actor) = { if (self.off) "There is nothing in the dryer. "; }
  doOpen(actor) = {
    "You open and turn off the dryer, and place the sweaters on top of it. ";
    turnOffDryer();
  }
  verDoClose(actor) = { "The dryer is already closed. "; }
  verDoTurnon(actor) = { 
    if (self.off) 
      "Now, now, there's a national energy crisis. Be kind.  ";
    else
      "The dryer is already on. "; 
  }
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached. "
  verIoPutIn(actor) = { "Only wet clothes should go in the dryer. "; }
  verDoBoard(actor) = { "You can't get on top of the <<self.sdesc>>. "; }
  verDoLookin(actor) = {
    if (self.off)
      "There is nothing in the dryer. ";
    else
      "You see several sweaters in the dryer. ";
  }
  count = 0
;

turnOffDryer: function
{
  dryer.off := true;
  auntSweater.moveInto(dryer);
  RedSoxJersey.moveInto(dryer);
  UCONNsweatshirt.moveInto(dryer);
  scottishKnit.moveInto(dryer);
  woolSweater.moveInto(dryer);
  remdaemon(dryerDaemon, nil );
  sweaters.moveInto(nil);
}

dryerDaemon: function(parm)
{
  if (dryer.count++ < 8) return;                // do every 7 minutes
  if (!dryer.heard) {
    "\bYou hear the dryer buzzing. ";
    dryer.heard := true;
  }
  else
    "\bThe dryer buzzes again. ";
  dryer.count := 0;
}

auntSweater: item
  sdesc = "knitted sweater"
  noun = 'sweater'
  adjective = 'knitted' 'aunt\'s' 'aunt'
  ldesc = "You'd always suspected that your weren't your aunt's favorite, and this 
          crimson-and-fluorescent oversized monstrosity she gave to you two 
          Christmases ago was the smoking gun as to why. "
  verDoWear(actor) = { "You put it on and quickly remove it -- you're a bit warm after being
                       in the sun all day. "; }
  plural = 'sweaters'
;

RedSoxJersey: item
  sdesc = "Red Sox jersey"
  noun = 'jersey' 'sweater'
  adjective = 'red' 'sox' 'mvp' 'nomar' '#5'
  ldesc = "#5 NOMAR! MVP!"
  verDoWear(actor) = { "You put it on and quickly remove it -- you're a bit warm after being
                       in the sun all day. "; }
  plural = 'sweaters'
;

UCONNsweatshirt: item
  sdesc = "UCONN sweatshirt"
  noun = 'sweatshirt' 'sweater'
  adjective = 'uconn'
  ldesc = "It was a gift from a few years ago when they were doing that
          inexplicable 'The Team That Makes You Go Hmm' slogan phase.  You're no scholar,
          but neither a stranger to lore and letters.  But you can perceive no sense
          there as to why *that* was their slogan. "
  verDoWear(actor) = { "You put it on and quickly remove it -- you're a bit warm after being
                       in the sun all day. "; }
  plural = 'sweaters'
;

scottishKnit: item
  sdesc = "Scottish knit"
  noun = 'knit' 'sweater'
  adjective = 'scottish'
  ldesc = "This was a gift from Charlise when she went visiting her ancestors in 
          Glasgow a few years back. It's really held up well over the years, and 
          you get all sentimental thinking of what a great value it was just by looking at it. "
  verDoWear(actor) = { "You put it on and quickly remove it -- you're a bit warm after being
                       in the sun all day. "; }
  plural = 'sweaters'
;

woolSweater: item
  sdesc = "wool sweater"
  noun = 'sweater'
  adjective = 'wool'
  ldesc = "Okay, you don't wear this out in public much, but 
          Charlise digs it, so what can you do. "
  verDoWear(actor) = { "You put it on and quickly remove it -- you're a bit warm after being
                       in the sun all day. "; }
  plural = 'sweaters'
;

garageItem: fixeditem
  sdesc = "garage"
  noun = 'garage'
  ldesc = { garage.ldesc; }
  location = garage
  takedesc = "It's firmly attached to the house. "
;

washer: fixeditem, surface
  sdesc = "washing machine"
  noun = 'washer' 'machine'
  adjective = 'washing'
  location = laundryRoom
  ldesc = {
    "It's a pretty new one -- your previous one was the one you've had since college
    and did that 'walking' thing that all old washers tend to do. It creeped out
    the dog (heck, it creeped you out as well) so it had to go. ";
  }
  isopen = nil
  verDoTurnoff(actor) = { "The <<self.sdesc>> is already off. "; }
  verDoOpen(actor) = { if (self.isopen) "It's already open. "; }
  doOpen(actor) = { 
    "Done. ";
    self.isopen := true;
  }
  verDoClose(actor) = { if (!self.isopen) "It's already closed. "; }
  doClose(actor) = { 
    "Done. ";
    self.isopen := nil;
  }
  verDoTurnon(actor) = { "Embarrassingly enough, you're not quite sure how to do that with the new model.
                         This information probably doesn't need to be relayed to your wife anytime soon. "; }
  verIoPutIn(actor) = { "Washing clothes that were just dried would be a bad idea to begin 
                        with, Kieron, but you really just came home to check on your wife. "; }
  verDoBoard(actor) = { "You can't get on top of the <<self.sdesc>>. "; }
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached. "
  verDoLookin(actor) = { "There is nothing in the washing machine. "; }
;

dog: Actor
  sdesc = "beagle"
  name = 'watson'
  noun = 'dog' 'doggy' 'beagle' 'watson'
  isHim = true
  ldesc = { "Watson is a faithful and handsome young beagle, with brown eyes and tan and white fur. "; }
  actorDesc = {
    "Your beagle is here, puttering around";
    if (self.location = livingRoom)
      " near the couch. ";
    else
      ". ";
  }
  actorAction(v, d, p, i) = {
    switch(v) {
      case standVerb:
        "The beagle stands up on his hind legs for a few moments";
        break;
      case sitVerb:
        "The dog sits down for a moment";
        break;
      case lieVerb:
        "The beagle lies down for a moment";
        break;
      default:
        "The beagle looks at you for a moment";
        break;
     }
     ", then goes back to his sniffing duties. ";
     exit;
  }
  verDoPet(actor) = { }
  verDoAttack(actor) = { }
  doAttack(actor) = { "Trying to dissuade Watson that he's anything other than the bestest boy
                      on the entire planet is futile: he's too fast for your attempted kicks
                      and presumes you are playing. "; }
  verDoAttackWith(actor, iobj) = { }
  doAttackWith(actor, iobj) = { self.doAttack(actor); }
  doPet(actor) = {
    "The beagle wags his tail at you happily, and returns to his puttering around. ";
  }
  disavow = "The beagle cocks his head at you. "
  takedesc = "You pick up the beagle and pat him on the head a couple 
             of times.  He licks your face and then you gently put him down. "
  verDoKiss(actor) = { "Affection, all the way around. "; }
  verDoHug(actor) = { "Affection, all the way around. "; }
  verDoTalkTo(actor) = { "The beagle cocks his head at you. "; }
  count = 0
;

dogDaemon: function(parm)
{
  if (Me.location = kitchen and dog.location <> kitchen) {
    "\bWatson enters the kitchen sheepishly. ";  
    dog.moveInto(Me.location);
    return;
  }

  if (hallwayDoor.isopen and dog.location = nil) {
    "\bYour dog Watson runs to your feet. ";
    dog.moveInto(Me.location);
    return;
  }
  if ((Me.location = hallway and dog.location = laundryRoom) or
     (Me.location = hallway2 and dog.location = hallway)) {
    "\bWatson runs past your feet down the hallway and disappears into the living
    room, barking and yelping for your attention. ";
    dog.moveInto(livingRoom);
    return;
  }
  if (dog.count++ < 3) return;                  // do every 3 minutes
  if (Me.location = laundryRoom and dog.location = nil)
    if (rand(2) = rand(2)) "\bYour dog scratches at the hallway door. ";
  else if (Me.location = dog.location)
    "\bWatson whines at your feet. ";
  else
    "\bYou hear your dog Watson barking in another room. ";
  dog.count := 0;
}

hallway: room
  sdesc = "Hallway"
  ldesc = {
    "A few pictures line the hallway, but it's otherwise sparse. Your living room, 
    kitchen, and bedrooms are further down the hall to the north. ";
  }
  south = hallwayDoor2
  north = hallway2
  inHouse = true
;

pictures: decoration
  sdesc = "pictures"
  noun = 'pictures' 'picture'
  location = hallway
  ldesc = "Charlise has a knack for decorating, they complement the hallway nicely. "
  isThem = true
;

hallway2: room
  sdesc = "Hallway"
  ldesc = "You're about halfway down your hallway. To the west is your living room. 
          The bedrooms and kitchen are further north, down the hall. "
  south = hallway
  north = {
    "You start down the hallway and Watson goes berserk, barking from the living room.  You dash back toward
    the living room to see what's the matter...\b ";
    Me.travelTo(livingRoom);
  }
  west = livingRoom
  inHouse = true
;

kieronPhone: item
  sdesc = "phone"
  noun = 'phone' 'telephone'
  location = livingRoom
  ldesc = "The phone is just about what you would expect. "
  doTake(actor) = { self.doDial(actor); }
  verDoUse(actor) = {}
  doUse(actor) = { self.doDial(actor ); }
  verDoDial(actor) = {}
  doDial(actor) = { 
    if (ambulanceItem.called)
      "You already called for help. ";
    else
      ambulanceItem.doCall(actor);
  }
  isListed = nil
  verDoAnswer(actor) = { "But the phone isn't ringing. "; }
  verDoHangup(actor) = { "But the phone isn't off the hook. "; }
  verDoListenTo(actor) = { "But the phone isn't ringing. "; }
;

livingRoom: room
  sdesc = "Living Room"
  ldesc = {
    if (!self.seen) {
      "You enter your living room and automatically take a whiff of the room's
      scent -- the smell of your new leather couch isn't so new that you don't 
      notice it yet. It cost you almost the entire commission you made when you 
      got Artero Gueterrez a six-month minor league contract with the Toledo 
      Mud Hens, but both you and Charlise had earmarked this one for years. 
      (Good kid, that Artero, but couldn't hit a curveball in an airless vacuum.) \b
      The room is laid out with the couch in front of your television and stereo 
      speakers. A couple of Charlise's frescos hang from the walls, and you've 
      started to add stucco to the ceiling. A couple of your golfing trophies adorn 
      the shelves near the phone, and a signed Garciaparra bat is also hanging up, encased in a 
      plastic preservation shell. \b Watson's over in front of the couch, sniffing and snorting
      at something.\b Your main front window has a 
      long crack running through it. \b The auxiliary window to the right of 
      that one is completely shattered. Glass from it has sprayed out onto your 
      floor, definitely smashed from something or somebody on the outside. ";
      self.seen := true;
    }
    else
      "Something -- a baseball, a rock, a human fist -- tried getting into your 
      house earlier. Glass is strewn all about your floor from your (former) 
      right front window. \b Exits lead north to your kitchen and east to the hallway. ";
  }
  east = {
    if (ambulanceItem.called) {
      "As you turn and head toward the hallway, you catch a glimpse of your wife on
      the kitchen floor.  You immediately dash into the kitchen. \b";
      return kitchen;
    }
    else
      return hallway2;
  }
  out = (self.east)
  north = kitchen
  genericHint = true
  inHouse = true
;

livingRoomItem: fixeditem
  sdesc = "Living Room"
  noun = 'room'
  adjective = 'living'
  location = hallway2
  ldesc = "The <<self.sdesc>> is to the west. "
  verDoEnter(actor) = { self.verDoBoard(actor); }
  doEnter(actor) = { self.doBoard(actor); }
  verDoBoard(actor) = {}    
  doBoard(actor) = { 
      "You stroll into the living room.\b";
    actor.travelTo (livingRoom); 
  }
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached to the house. "
;

livingWindow: fixeditem
  sdesc = "main front window"
  noun = 'window'
  adjective = 'main' 'front'
  ldesc = "Your main front window has a long crack running through it. "
  location = livingRoom
  takedesc = "The window is fixed in place. "
  doSynonym('Lookin') = 'Lookthru' 'LookOut'
  verDoLookin(actor) = {}
  doLookin(actor) = {
    "You press your nose to the window. You're on the corner of your track, and just really
    see over toward your neighbors. Some weird guys who are up at all hours, but they never
    blast their stereos or cause much of an audile disturbance, really. ";
  }
  verDoBreak(actor) = { "Somebody beat you to it, Kieron. "; }
  verDoOpen(actor) = { "There is no need to open the window, besides, the police may eventually
                       want them undisturbed. "; }
  verDoClose(actor) = { "The main window is already closed. "; }                       
;

windowCrack: fixeditem
  sdesc = "crack"
  noun = 'crack'
  adjective = 'long'
  ldesc = "It's a long separation in the main window of your living room. "
  location = livingWindow
  takedesc = "The crack? C'mon now, crack kills. "
;

auxiliaryWindow: fixeditem
  sdesc = "auxiliary window"
  noun = 'window'
  adjective = 'auxiliary' 'auxilliary'
  ldesc = "The auxiliary window has been smashed into bits and shards. Whoever wanted that broken
          wasn't messing around. "
  location = livingRoom
  takedesc = "There is nothing to take but the casing. "
  doSynonym('Lookin') = 'Lookthru' 'LookOut'
  verDoLookin(actor) = {}
  doLookin(actor) = { livingWindow.doLooin(actor); }
  verDoBreak(actor) = { "It's already smashed to pieces. "; }
  verDoOpen(actor) = { "There is nothing to open. "; }
  verDoClose(actor) = { "That's a bit optimistic. "; }
;

brokenGlass: fixeditem
  noun = 'glass' 'piece' 'pieces'
  adjective = 'broken' 'shard' 'shards'
  sdesc = "shards of broken glass"
  ldesc = "The shards of glass are almost everywhere. "
  location = livingRoom
  takedesc = "That would hurt, though. "
  verDoClean(actor) = { "You try to organize the glass into little piles, but decide to stop 
                        -- you can rent a shop-vac later and clean it up that way. "; }
;    

bat: item
  noun = 'bat'
  adjective = 'slugger' 'louisville'
  sdesc = "your bat"
  adesc = "your bat"
  thedesc = "your bat"
  ldesc = "It's your favorite Louisville Slugger. "
  location = livingRoom
  isListed = nil
  doSynonym('Swing') = 'Use'
  verDoSwing(actor) = {}
  doSwing(actor) = {
    "You take a practice swing with the bat. ";
  }
  verIoAttackWith(actor) = {}
  ioAttackWith(actor, dobj) = {
    if (dobj = dog)
      "Nah. Watson's a good boy. ";
    else if (dobj = wife)
      "You decline, and only partially because your favorite Red Sox player of all-time is
      Nomar Garciaparra, not Wil Cordero. ";
    else
      "You really shouldn't hit <<dobj.thedesc>> with the bat. ";
  }
  doThrowOut(actor, io) = { self.doThrowAt(actor, io); }
  doThrowThru(actor, io) = { self.doThrowAt(actor, io); }
  doThrowAt(actor, io) = { 
    "Throwing the bat at <<io.thedesc>> is blah blah.. ";
  }
  doTake(actor) = {
    if (!self.isListed) {
      self.isListed := true;
      "You punch through the shell that the bat is in and wield it. If some 
      jerk is skulking about your house you're going to go .372-21-96 on 
      somebody's face -- and not over the course of a season either, more 
      like five minutes of concentrated red-raged beating.\b
      <q>Charlise!</q>\ you yell. No answer. ";
    }
    else
      "Taken. ";
    self.moveInto(Me);
  }
;

couch: chairitem
  sdesc = "couch"
  noun = 'couch' 'sofa'
  adjective = 'black' 'leather'
  location = livingRoom
  ldesc = {
    "After years of sitting and sleeping on a second-hand couch that your older
    brother gave you from his college years, you were happy to have this nice leather one. ";
    if (!baseball.found)
      "There are claw marks in the carpet near the edge of the sofa -- it appears as if Watson
      has been trying to get at something. ";
  }
  outOfPrep = "off of"
  statusPrep = "on"
  verDoStandon(actor) = { "That would serve no purpose. "; }
  verDoLookunder(actor) = { if (baseball.found) "You find nothing else under the couch. "; }
  doLookunder(actor) = {
    baseball.found := true;
    baseball.moveInto(Me);
    "You find a baseball, which you promptly pick up. ";
  }
  takedesc = "It took two movers to get it in here, and you do not possess the strength of two movers. "
  inHouse = true
;

carpet: decoration
  sdesc = "carpet"
  noun = 'carpet' 'rug'
  adjective = 'hunter' 'green'
  location = livingRoom
  ldesc = "It's hunter green and in good shape, save for the shattered glass and claw marks near the sofa. "
;

clawMarks: decoration
  sdesc = "claw marks"
  noun = 'marks'
  adjective = 'claw'
  location = carpet
  ldesc = "The claw marks lead under the couch. "
  isThem = true
;

baseball: item, readable
  sdesc = "baseball"
  noun = 'baseball' 'ball'
  ldesc = { 
    "It's not one of yours...\ it's apparently what was thrown through your front
    window. There's some writing on it, in a flowery cursive text, not completely
    unlike an autograph. ";
  }
  readdesc = "Upon closer inspection, it's not an autograph at all. You make out the words,
             slowly, but it says:\b NO TIME TO SQUEAL KIERON\n"
;

autograph: decoration, readable
  sdesc = "autograph"
  noun = 'text' 'writing' 'autograph'
  adjective = 'flowery' 'cursive'
  location = baseball
  ldesc = { baseball.readdesc; }
  readdesc = { baseball.readdesc; }
;

TV: fixeditem
  sdesc = "television"
  noun = 'tv' 'television'
  location = livingRoom 
  ldesc = {
    "It's a nice Zenith. No, really. ";
  }
  verDoTurnon(actor) = { "Done. "; }
  verDoTurnoff(actor) = { "Done. "; }
  verDoWatch(actor) = { "You've sort of given up watching daytime tv for lent, except for 
                        the fact that it's not just for lent and you're not catholic. "; }
  takedesc = "The television is too heavy to lift. It may be a new Zenith, but it's still a Zenith. "
;

stereo: fixeditem
  sdesc = "stereo"
  noun = 'speakers'
  adjective = 'stereo'
  location = livingRoom 
  ldesc = {
    "Your stereo system has a bit of broken glass on it, but is otherwise unharmed. ";
  }
  verDoTurnon(actor) = { "As you go to play with your stereo, 
                         it occurs to you that your wife may be in peril. "; }
  verDoTurnoff(actor) = { "It's already off. "; }
  verDoListenTo(actor) = { "It's not on. "; }
  takedesc = "The stereo system is too heavy to lift. "
;

frescos: decoration
  sdesc = "frescos"
  noun = 'fresco' 'frescos'
  ldesc = "They are paintings that Charlise did. One is a sunset, another is one that she did in the
          desert when the two of you took a trip out to Vegas and the other one is of an eggplant 
          that was commissioned and paid for by  weird guy for his friend Snam, apparently, but 
          he never came back to pick it up. "
  location = livingRoom
  isThem = true
;

stucko: decoration
  sdesc = "stucko"
  noun = 'stucko'
  ldesc = "Your parent's house had it while you were growing up, so you had it done to your house
          for the nostalgia value. "
  location = livingRoom
;

shelves: fixeditem
  sdesc = "shelves"
  noun = 'shelves' 'shelf'
  ldesc = "The shelves have some trophies on them. "
  location = livingRoom
  isThem = true
  takedesc = "No chance. "
;

trophies: fixeditem
  sdesc = 'golf trophies'
  noun = 'trophy' 'trophies'
  adjective = 'golf'
  location = shelves
  ldesc = "They are just some awards that you won for golfing a couple years back. "
  isThem = true
  takedesc = "You decide to let them be. "
;

kitchen: room
  sdesc = "Kitchen"
  ldesc = {
    "Pots, pans, chairs, tables -- ";
    if (!self.seen) {
      self.seen := true;
      "and your wife laid out on the floor, not moving, in a puddle of...\ something. ";
    }
    else
      "but none of that matters right now. ";
  }
  noexit = { 
    if (!ambulanceItem.called)
      "You don't want to leave her like this. ";
    else
      "The ambulance should be here in a second, though. "; 
  }
  genericHint = true
  inHouse = true
;

kitchenItem: fixeditem
  sdesc = "Kitchen"
  noun = 'kitchen'
  location = livingRoom
  ldesc = "The <<self.sdesc>> is to the north. "
  verDoEnter(actor) = { self.verDoBoard(actor); }
  doEnter(actor) = { self.doBoard(actor); }
  verDoBoard(actor) = {}    
  doBoard(actor) = { 
      "You make your way into the kitchen.\b";
    actor.travelTo (kitchen);
    "\bCharlise is here, unconscious or asleep on the floor. ";     
  }
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached to the house. "
;

kitchenItems: decoration
  sdesc = "kitchen items"
  noun = 'pots' 'pans' 'chairs' 'tables' 'items'
  location = kitchen
  ldesc = "The various <<self.sdesc>> <<self.isntdesc>> important, 
          considering your wife is not doing too well right now. "
  isThem = true
;

counter: fixeditem
  sdesc = "counter"
  noun = 'counter'
  location = kitchen
  ldesc = {
    if (wife.cleaned)
      "There is nothing special about the counter. ";
    else 
      "Her hair is stuck to the side of the counter, near some dried-up blood. ";
  }
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached. "
  verDoClean(actor) = { if (wife.cleaned) "There is no more blood to clean. ";}
  doClean(actor) = { paste.doClean(actor); }
  verDoWash(actor) = { if (wife.cleaned) "There is no more blood to clean. ";}
  doWash(actor) = { paste.doClean(actor); }
;

gotoLDR: function
{
  local itemRem, thisItem;
  itemRem := parserGetMe().contents;
  while (car(itemRem)) {
    thisItem := car(itemRem);
    thisItem.moveInto(nil);
    itemRem := cdr(itemRem);
  }
  morePrompt();                           // wait for any key
  remdaemon(dryerDaemon, nil );
  remdaemon(arriveDaemon, nil );
  setdaemon(nurseDaemon, nil );
  wife.moveInto(bed);
  Me.travelTo(LDR);
}

wife: Actor
  sdesc = "Charlise"
  name = 'charlise'
  noun = 'charlise' 'wife' 'head'
  answerYes = { 
    if (self.cleaned)
      "\^<<self.thedesc>> gives you a confused look. ";
    else
      "She doesn't respond. ";
  }
  touchdesc = { 
    if (self.cleaned)
      "\^<<self.thedesc>> responds with a smile. ";
    else
      "She doesn't respond. ";
  }
  answerNo = { 
    if (self.cleaned)
      "\^<<self.thedesc>> gives you a confused look. ";
    else
      "She doesn't respond. ";
  }
  verDoHelp(actor) = { if (wife.cleaned) "There is no more blood to clean. ";}
  doHelp(actor) = { paste.doClean(actor); }
  verDoWash(actor) = { if (wife.cleaned) "There is no more blood to clean. ";}
  doWash(actor) = { paste.doClean(actor); }
  verDoClean(actor) = { if (self.cleaned) "There is no more blood to clean. "; }
  doClean(actor) = { paste.doClean(actor); }
  verDoTake(actor) = {}
  doTake(actor) = {
    if (self.location = kitchen) {
      if (!self.cleaned) {
        "You hesitate, not knowing what's wrong with her. That, and her hair mixed with blood 
        is somewhat stuck to the counter. ";
        exit;
      }
      "You pick her up and carry her outside the house. The ambulance 
      comes quickly and whisks you both away.\b ";
      gotoLDR();
    }
    else
      "You should leave her be. ";
  }  
  verDoWake(actor) = { 
    if (self.cleaned) 
      "She is already awake. "; 
    else
      "You try and gently wake her -- no response. ";
  }
  verDoShake(actor) = { "That probably wouldn't be a good idea. "; }
  verDoPush(actor) = { "That would just be mean. "; }
  verDoPull(actor) = { "That would just be mean. "; }
  verDoMove(actor) = {}
  doMove(actor) = { self.doTake(actor); }
  isHer = true
  location = kitchen
  ldesc = {
    if (self.location = kitchen) {
      if (!self.cleaned) {
        "She's breathing. ";
        if (!self.inspectedYet) {
          self.inspectedYet := true;
          "You try to wake her up, gently. You go to move her head away from the side 
          of the counter and notice her hair stuck to it in some kind of paste or something. ";
        }
        else
          "You try to wake her up, gently again -- she doesn't respond. ";
      }    
      else
        "Charlise is your wife, and she is nine months pregnant. She is quite disoriented
        after her fall, and isn't responding very well to stimulus right now. ";
    }
    else if (self.location = bed) {
      "Charlise still seems to be unfocused and distant. ";
    }
    else
      "She is being operated on, and it looks like she has been knocked out cold. ";
  }
  adesc = { "your wife"; }
  thedesc = { self.adesc; }
  isHim = nil
  actorDesc = {
    if (!self.seen)
      self.seen := true;
    else if (self.location = kitchen) {
      if (!self.cleaned)
        "Charlise is here, unconscious or asleep on the floor. ";
      else
        "Charlise is here, still woozy from the fall. ";
    }
    else if (self.location = bed) {
      "Charlise description in LDR room (in bed). ";
    }
  }
  verDoHug(actor) = {
    if (actor.location = OR)
      "You edge close and try to hug her, briefly. ";
    else
      "It's difficult to get your arms around her, but you do the best you can. ";
  }
  verDoKiss(actor) = {}
  doKiss(actor) = {
    if (actor.location = OR)
      "You edge up toward Charlise and give her a kiss on the forehead. She's been
      given enough drugs so that she doesn't even stir. ";
    else if (Me.location = kitchen)
      "You plant a kiss on her forehead. ";
    else
      "You kiss her on the forehead, and try to comfort her a bit. It seems to work, she looks up with one of
      her patented angelic smiles. "; 
  }
  doSynonym('Search') = 'Lookin'
  actorAction(v, d, p, i) = {
    if (v.isTravelVerb and location = OR) {
      "<q>Sure, let me click my heels together...\ just give me a moment.</q> 
      Her eyes almost roll right out of her head.  ";
      exit;
    }
    switch(v) {
      case noVerb:
      case yesVerb:
      case helloVerb:
        break;
      default:
        if ((Me.location = kitchen and !self.cleaned) or (Me.location = OR)) {
          "She's unconscious. ";
          exit;
        }
        switch(rand(3)) {
          case 1:
            "<q>Oof,</q> says Charlise, <q>Wait, why am I listening to you anyway?</q> ";
            break;
          case 2:
            "<q>Thanks for the advice, honey, I'm sure that it would be quite useful to 
            Bizarro-Charlise in the Bizarro Birthing Dimension.</q> ";
            break;
          case 3:
            if (nurse.location = Me.location)
              "<q>Go find something to do,</q> scolds the nurse. ";
            else
              "\^<<self.sdesc>> raises an eyebrow and doesn't respond. ";
            break;
        }
        exit;
    }
  }  
  verDoTellAbout(actor, io) = { self.verDoAskAbout(actor, io); }
  doTellAbout(actor, io) = { 
    if (Me.location = kitchen) {
      if (!self.cleaned)
        "She's unconscious. ";
      else
        "She's still woozy. ";
      return nil;
    }
    else {
      "You wonder what <<self.thedesc>> has to say instead, so you ask her about it.\b";
      self.doAskAbout(actor, io); 
    }
  }
  verDoAskFor(actor, io) = { self.disavow; }
  doAskFor(actor, io) = { self.doAskAbout(actor, io); }
  disavow = ""
  dontKnow = {
    local msg := [
      '<q>I don\'t know much about that,</q> says '
      '<q>I don\'t really know,</q> states '
      '<q>You probably know as much as I do,</q> quips '
      '<q>Were you talking to me?</q>\ questions '
      '<q>Sorry, not my area of expertise,</q> exclaims '
      '<q>Um... Did you say something?</q>\ asks '
      'A shrug is all you get from '
    ];
    say(msg[rand(length(msg))]);
  }
  askWord(word, lst) = {
    if (Me.location = kitchen) {
      if (!self.cleaned)
        "She's unconscious. ";
      else
        "She's still woozy. ";
      return nil;
    }
    if (Me.location = OR) {
      "Charlise is not in any condition to talk to anyone. ";
      return nil;
    }
    switch(substr(word, 1, 7)) {
      case 'baby':
      case 'daughte':
      case 'son':
        "<q>She's not kicking or anything,</q> says Charlise. ";
        return true;
        break;
      case 'herself':
        "<q>I'm really nervous, Kieron. Are you holding up okay?</q> You nod, 
        more of a display of inner strength than anything else. ";
        return true;
        break;
      default:
        dontKnow; "<<self.sdesc>>. ";
        return nil;
      }
  }
  doHello = { 
    if (Me.location = kitchen) {
      if (!self.cleaned)
        "She's unconscious. ";
      else
        "She's still woozy. ";
      return nil;
    }
    if (!self.helloSaid) {
      "<q>Hi <<Me.sdesc>>,</q>\ she says. ";
      self.helloSaid := true;
    }
    else
      "\^<<self.sdesc>> smiles at you, probably wondering why you 
      insist on repeating a greeting. ";
  }
  verDoTurnon(actor) = { "I'm sure you can think of something else to do, no? 
                         Besides, why would you want to alienate <<self.sdesc>>. "; }
  verDoAttack(actor) = { }
  doAttack(actor) = { 
    "Attack?! Your sweet-pea??! "; 
    Me.conversingWith := true;
    Me.yesCnt := 0;
    setdaemon(wifeYesDaemon, nil);
  }
  verDoAttackWith(actor, iobj) = { }
  doAttackWith(actor, iobj) = { self.doAttack(actor); }
  doListenTo(actor) = { "\^<<self.sdesc>> isn't making much noise right now. "; }
  ioSynonym('GiveTo') = 'ShowTo'
  ioGiveTo(actor, dobj) = { "You have better things to do. "; }
  talkCountKitchen = 0
  talkCountLDR = 0
  verDoTalkTo(actor) = {}
  doTalkTo(actor) = { 
    if (self.location = kitchen and self.cleaned) {
      switch(self.talkCountKitchen++) {
        case 0: 
          "<q>Are you okay? Honey?</q> You don't want to shake her or anything -- but 
          if you have to, is that okay? Maybe, though? You can't remember what 
          you're supposed to do if this comes up, even though that girl from the 
          breathing classes covered this.\b
          Charlise doesn't really respond -- she's still groggy from the fall.  "; 
          break;
        case 1:
          "<q>Are you okay? What happened?</q>\b
          Charlise struggles a bit to remember. <q>Watson was barking at 
          something... I was in the bedroom, I just came out... \b
          I don't know what happened, I think I slipped or something, what did 
          he... oh, God...</q>\b
          <q>Look,</q> you say, <q>look, I'll get you to a hospital. Just hold up for 
          a bit.</q> You remember the broken glass. <q>There's nobody else here, is 
          there?</q>\b 
          <q>I don't -- what? Someone else?</q>\b
          <q>Watson,</q> you start -- you don't know exactly what you're going to 
          tell him, but it doesn't matter anyway, as he just flips out and starts 
          running around the house in <q>attack</q> mode. ";
          break;
        default:
          "She doesn't respond. ";
      }
    }
    else if (self.location = bed) {
      switch(self.talkCountLDR++) {
        case 0: 
          "<q>Hey, chin up, kid</q> you say. She gives you a questioning look, something 
          that effectively says <i>Why are you talking to me like you're coaching a tee-ball team?</i> ";
          break;
        case 1:
          "<q>Look, I'll give your parents and your sister a call after this,</q> you say. 
          <q>Is your sister still living in Colorado?</q> \b
          <q>I think she just recently moved toward the desert,</q> says Charlise. ";
          break;
        case 2:
          "<q>I think someone was trying to break in,</q> you say.\b
          <q>Is that why...\ Watson was barking so loudly?</q>
          <q>Yes. I'm guessing that what happened was that he scared whoever it was off.</q>";        
          break;
        default:
          "You make some small talk and let her know how much you love her. ";
      }
    }
    else {
      "Charlise is not in any condition to talk to anyone. ";
    }
  }
;

wifeYesDaemon: function(parm)
{
  if (Me.yesCnt++ = 1) {
    Me.conversingWith := nil;
    remdaemon(wifeYesDaemon, nil);
  }
} 

liquid: fixeditem
  sdesc = "liquid"
  noun = 'liquid' 'urine' 'pee' 'puddle'
  adjective = 'watson\'s'
  location = kitchen
  ldesc = "Well, you've had overwhelming experience with the scent of Watson's 
          messes when trying to housebreak him -- this is definitely his handiwork.\b
          Watson kind of creeps around the outside 'limit' of the kitchen, not 
          getting too close to the puddle he made. "
  takedesc = "Well, it's a liquid, and liquid in the form of dog urine at that, so it's probably
             best untaken. "
  verDoClean(actor) = {}
  doClean(actor) = {
    "You mop up the mess as best you can. ";
    self.moveInto(nil);
    self.cleaned := true;
  }
;
  
paste: fixeditem
  sdesc = "paste"
  noun = 'paste' 'blood' 'hair'
  location = wife
  ldesc = "It's blood from the side of her head. "
  takedesc = "It's too sticky. "
  verDoWash(actor) = { if (wife.cleaned) "There is no more blood to clean. ";}
  doWash(actor) = { paste.doClean(actor); }
  verDoClean(actor) = { if (wife.cleaned) "There is no more blood to clean. ";}
  doClean(actor) = {
    "You clear her hair away from the side of the counter. It looks like you 
    might have pulled a little too hard, though, because the pain wakes her up.\b
    <q>Ow!</q>\ says Charlise. ";
    if (!ambulanceItem.called) {
      "\bNot leaving anything to chance, you run into the living room and dial 911, asking for 
      an ambulance -- you then sprint back to be with your wife. ";
      ambulanceItem.called := true;
    }
    self.moveInto(nil);
    wife.cleaned := true;        
    self.count := 0;
    if (!self.started) {                                // calling ambulance starts this too
      self.started := true;
      setdaemon(arriveDaemon,nil);                   // 7 turns before ambulance arrives
    } 
  }
;

arriveDaemon: function(parm)
{
  if (paste.count > 0 and (Me.location = livingRoom or Me.location = couch)) {
    "\bAs you survey the room, you catch a glimpse of your wife's body lying on the kitchen floor.  You 
    immediately run toward her.\b ";
    Me.travelTo(kitchen);
    return;
  }
  if (paste.count > 0 and Me.location <> kitchen) return;
  if (paste.count++ > 6) {
    "\bYou carefully pick up Charlise and carry her outside the house. The ambulance 
    comes quickly and whisks you both away.\b ";
    gotoLDR();
  }
}

ambulanceItem: fixeditem, floatingItem
  sdesc = "ambulance"
  noun = 'ambulance' '911' 'police' 'help' 'hospital'
  location = { if (Me.location.inHouse) return Me.location; }
  verDoCall(actor) = { 
    if (self.called) 
      "You already called for help. "; 
    if (Me.location <> kitchen and Me.location <> livingRoom and Me.location <> couch)
      "You see no phone here. ";
  }
  doCall(actor) = { 
    if (Me.location = kitchen)
      "You dash into the living room and call for help.  You promptly scurry back into the 
      kitchen to be with Charlise. ";
    else
      "You dial 911 and call for help. ";
    self.called := true;
    paste.count := -7;
    paste.started := true;
    setdaemon(arriveDaemon,nil);                   // 15 turns before ambulance arrives
  }
  verDoDial(actor) = { self.verDoCall(actor); }
  doDial(actor) = { self.doCall(actor); }
  verDoCallFor(actor) = { self.verDoCall(actor); }
  doCallFor(actor) = { self.doCall(actor); }
;

LDR: room
  sdesc = "LDR Room"
  ldesc = {
    "The LDR "; if (!self.seen) "(labor, deliver, recovery) ";
    "Room is a warm, yet somewhat generic, 
    setting designed to provide for the comfort of each patient, newborn, and 
    family member throughout the birthing process. The decor is straight out 
    of Disney Corp's idea of pregnant bliss: azure walls covered with the 
    occasional sunflower, well-polished teak furniture, an antique rocking 
    chair. The fetal monitor and other assorted scanning equipment seem almost 
    out of place here. ";
    if (!self.seen) {
      self.seen := true;
      "\b<q>What happened?</q>\ you ask Charlise.\b
      Charlise struggles for a bit to remember. <q>Watson was barking at 
      something... I was in the bedroom... I don't know what happened, I think I 
      slipped or something...\ oh, God, Kieron, this doesn't feel right at all...</q> ";
      if (global.turnsofar < 102)                // if not past 1:41 already.
        settimesys( '1:41 p.m.', 1, 2001, 10, 01 );
    }
  }
  noexit = { "Now's not the right time for that. "; }
;

babyFake: fixeditem
  sdesc = "baby"
  noun = 'baby'
  location = wife
  ldesc = "You can't see the baby from here. "
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached to your wife. "
  verDoAttack(actor) = { "You chicken out at the last moment. "; }
;

bed: beditem
  sdesc = "stretcher"
  ldesc = "The bed is up about three or four feet from the floor.  Charlise is currently on it. "
  noun = 'bed'
  outOfPrep = "off of"
  statusPrep = "on"
  location = LDR
  reachable = { return( self.location.contents + Me); }
  verDoBoard(actor) = { "There's barely enough room for Charlise. "; }
;

LDRitem: fixeditem
  sdesc = "LDR Room"
  noun = 'room'
  adjective = 'LDR'
  ldesc = { room.ldesc; }
  location = LDR
  takedesc = "It's firmly attached. "
;

decor: fixeditem
  sdesc = "decor"
  noun = 'decor'
  location = LDR
  ldesc = "It's a little too happy and optimistic for the moment, actually. "
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached. "
;

LDRfurniture: fixeditem
  sdesc = "furniture"
  noun = 'furniture'
  adjective = 'teak'
  location = LDR
  ldesc = "There is a dresser here where you're allowed to keep some personal items,
          but it's something that you haven't taken advantage of. "
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached. "
;

LDRdresser: fixeditem
  sdesc = "dresser"
  noun = 'dresser'
  location = LDR
  ldesc = "The <<self.sdesc>> <<self.isntdesc>> important. "
  takedesc = "The <<self.sdesc>> <<self.isdesc>> is too heavy. "
  verDoOpen(actor) = { "You have better things to do. "; }
  verDoClose(actor) = { "It's not open. "; }
;

rockingChair: chairitem
  sdesc = "chair"
  ldesc = "Your antique radar isn't particularly well-developed, but this looks like
           something you could have silently worried away the Great Depression with. "
  noun = 'chair'
  adjective = 'wooden' 'antique' 'rocking'
  outOfPrep = "off of"
  statusPrep = {
    if (Me.location = self and self.sitting)
      "sitting on";
    else if (Me.location = self and !self.sitting)
      "standing on";
    else
      "on";
  }
  location = LDR
  doUnboard(actor) = {
    self.sitting := nil;
    inherited.doUnboard(actor);
  }
  doSynonym('Unboard') = 'Getdown' 'Jump'
  verDoBoard(actor) = { self.verDoSiton(actor); }
  doBoard(actor) = { self.doSiton(actor); }
  verDoSiton(actor) = {
    if (actor.location = self and self.sitting) {
      "%You're% already on "; self.thedesc; "! ";
    }
  }
  doSiton(actor) = {
    self.sitting := true;
    pass doSiton;
  }
  doSynonym('Standon') = 'Climbon' 'Climb' 'StepOn'
  verDoStandon(actor) = {
    if (Me.location = self and !self.sitting)
      "You're already standing on the chair. ";
  }
  doStandon(actor) = {
    if (self.sitting)
      "You get up from your sitting position and stand up on the chair. ";
    else {
      "You climb up onto the chair. ";
    }
    self.sitting := nil;
    actor.moveInto(self);
  }
  out = { "You're not going anywhere until you get off of the chair. "; }
  verDoTake(actor) = "It may crumble apart if you try to take it. You're just not sure. "
;   

fetalMonitor: fixeditem
  sdesc = "fetal monitor"
  noun = 'monitor'
  adjective = 'fetal'
  location = LDR
  ldesc = "It looks like a 17\" monitor running some kind of proprietary birthing software. "
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached. "
  verDoTurnoff(actor) = { "Even if you did it would have little effect:\ this 
                          monitor has undergone severe burn-in. "; }
  verDoTurnon(actor) = { "You're not sure where the on/off switch is. Judging by the 
                         obvious monitor burn-in, neither is anyone else. "; }
;

nurse: Actor
  sdesc = "nurse"
  name = 'nurse'
  noun = 'nurse'
  takedesc = "I don't think she would appreciate that. "
  isHer = true
  ldesc = "She looks to be in her mid-twenties and has dark hair and brown eyes beneath
          circular, Lennon-esque frames. "
  location = LDR
  isHim = nil
  actorDesc = { if (self.actorDescOK) "The nurse is here. "; }
  verDoSearch(actor) = { "<q>Hey!</q>\ she protests, moving away from you. "; }
  verDoHug(actor) = {"You briefly consider hugging the nurse and getting quite close with her, 
                     but decide against it:\ you're not that kind of guy. "; }
  verDoKiss(actor) = {"You save up an image to use at a later date for your dreams. "; }
  doSynonym('Search') = 'Lookin'
  actorAction(v, d, p, i) = {
    if (v.isTravelVerb) {
      "<q>I'm not going anywhere right now.</q> ";
      exit;
    }
    switch(v) {
      case noVerb:
      case yesVerb:
      case helloVerb:
        break;
      case wearVerb:
        "<q>I'm comfortable with what I'm already wearing.</q> ";
        exit;
      default:
        "\^<<self.thedesc>> briefly glances up at you, but doesn't respond. ";
        exit;
    }
  }  
  verDoTellAbout(actor, io) = { self.verDoAskAbout(actor, io); }
  doTellAbout(actor, io) = { 
    "You wonder what <<self.thedesc>> has to say instead, so you ask him about it.\b";
    self.doAskAbout(actor, io); 
  }
  verDoAskFor(actor, io) = { self.disavow; }
  doAskFor(actor, io) = { self.doAskAbout(actor, io); }
  disavow = ""
  dontKnow = {
    local msg := [
      '<q>I don\'t know much about that,</q> says '
      '<q>I don\'t really know,</q> states '
      '<q>You probably know as much as I do,</q> quips '
      '<q>Were you talking to me?</q>\ questions '
      '<q>Sorry, not my area of expertise,</q> exclaims '
      '<q>Um... Did you say something?</q>\ asks '
      'A shrug is all you get from '
    ];
    say(msg[rand(length(msg))]);
  }
  askWord(word, lst) = {
    switch(substr(word, 1, 7)) {
      case 'baby':
        if (Me.location = LDR)
          "<q>I'm...\ still checking...</q> she says, between glances at the monitor. ";
        else
          "The nurse seems distracted by the birthing procedure, but you don't get any indication
          that the baby is doing well. ";
        return true;
        break;
      case 'herself':
        "A shrug is all you get from the nurse. ";
        return true;
        break;
      case 'doctor':
      case 'doc':
        if (Me.location = LDR)      
          "<q>He's one of the best,</q> she says. <q>He'll be able to get to the bottom of this.</q> ";
        else
          "<q>Zip it,</q> says the nurse. ";
        return true;
        break;
      case 'chair':
      case 'rocking':
        "<q>Feel free to sit yourself down, Mr.\ Scott -- it's quite comfortable,</q> says the nurse. ";
        return true;
        break;
      case 'hospita':
        "The nurse doesn't seem to have any kind of take on the hospital. ";
        return true;
        break;
      case 'strip':
      case 'monitor':
      case 'reading':
        "<q>I don't like these results,</q> she says, staring intently at it. ";
        return true;
        break;
      case 'pregnan':
        "<q>I've never been, myself,</q> she says, while scanning the monitor. <q>I just haven't met Mr.\ Right.</q> ";
        return true;
        break;
      case 'charlis':
      case 'wife':
        if (Me.location = LDR)
          "<q>I don't like these results,</q> she says, going back and forth from the monitor to Charlise. ";
        else
          "<q>You probably know as much as I do,</q> quips the nurse. ";
        return true;
        break;
      case 'me':
      case 'kieron':
        "<q>Are you okay?</q>\ she says. ";
        return true;
        break;
      case 'belly':
      case 'band':
        "<q>Standard procedure.</q>\ she says. ";
        return true;
        break;
      case 'blood':
      case 'pressur':
      case 'blood p':
        if (self.count < 7)
          "<q>I'll be checking it a minute,</q> replies the nurse. ";
        else 
          "<q>One sixty over ninety,</q> she replies. <q>It's a bit high.</q> ";
        return true;
        break;
      case 'heart':
      case 'pulse':
      case 'rate':
      case 'heart r':
        if (self.count < 7)
          "<q>I'll be examining her in a sec,</q> she replies. ";
        else 
          "<q>Ninety-four beats a minute,<q> replies the nurse. <q>She's a bit stressed.</q> ";
        return true;
        break;
      case 'temp':
      case 'tempera':
        if (self.count < 9)
          "<q>I'll get to that shortly,</q> replies the nurse. ";
        else 
          "<q>Ninety-eight point six,</q> she replies.  <q>Normal temp.</q> ";
        return true;
        break;
      default:
        dontKnow; "<<self.thedesc>>. ";
        return nil;
      }
  }
  doAskAbout(actor, iobj) = {
    inherited.doAskAbout(actor, iobj);
  }
  doHello = { 
    if (!self.helloSaid) {
      "<q>Hello,</q>\ she says. ";
      self.helloSaid := true;
    }
    else
      "\^<<self.thedesc>> smiles at you, probably wondering why you 
      insist on repeating a greeting. ";
  }
  verDoTurnon(actor) = { "I'm sure you can think of something else to do, no? 
                         Besides, why would you want to alienate <<self.sdesc>>. "; }
  verDoAttack(actor) = { }
  doAttack(actor) = { "<q>Knock it off,</q> says the nurse, <q>I know judo and if you keep it up 
                      you'll be on one of these beds in more pain than your wife.</q> "; }
  verDoAttackWith(actor, iobj) = { }
  doAttackWith(actor, iobj) = { self.doAttack(actor); }
  doListenTo(actor) = { "\^<<self.thedesc>> isn't making much noise right now. "; }
  ioSynonym('GiveTo') = 'ShowTo'
  ioGiveTo(actor, dobj) = { "You have better things to do. "; }
  count = 0
  talkCountLDR = 0
  talkCountOR = 0
  verDoTalkTo(actor) = {}
  doTalkTo(actor) = { 
    if (self.location = LDR) {
      switch(self.talkCountLDR++) {
        case 0: 
          "<q>What's up -- is she going to be okay, is the baby -- </q>\b
          <q>Just one sec,</q> she says, <q>I'll find out in just a bit.</q>\b";
          if (!fetalMonitor.hookedUp) {
            "The nurse begins hooking up the various monitors to Charlise. ";
            fetalMonitor.hookedUp := true;
          }
          else
            "The nurse studies the fetal monitor screen. ";
          break;
        case 1:
          "<q>What's going on?</q>\ you say to her. \b
          <q>I need the doctor over here to take a look at this, but I don't 
          like what I see over here.</q> She points to one of the monitors. 
          <q>She fell down?</q>\ she asks.\b
          <q>Yeah, she hit her head on the counter on the way down... is 
          the baby...\ is there something wrong?</q>\b
          <q>No,</q> she says, <q>but I'm not getting strong readings off this thing.</q> ";
//          CharliseToOR(); MJS use this for test purposes
          break;
        default:
          "She appears rather busy, so you bide your time. ";
      }
    }
    else {
      switch(self.talkCountOR++) {
        case 0: 
          "<q>I just want to know what's going on,</q> you say to the nurse.\b
          <q>The doctor is attempting a c-section. Stand over  there, and be quiet, 
          please,</q> says the nurse. <q>As soon as we know something, we'll let you know.</q> ";
          break;
        case 1:
          "<q>We're not getting many life signs from the baby,</q> says the nurse. ";
          break;
        case 2:
          "<q>I'm not sure what it is, right yet,</q> she says. ";
          break;
        default:
          "The nurse is too focused to talk right now. ";
      }
    }
  }
;

nurseItems1: item
  sdesc = "doctor"
  noun = 'doctor' 'doc'
;
nurseItems2: item
  sdesc = "pregnancy"
  noun = 'pregnancy'
;
nurseItems3: item
  sdesc = "pulse"
  noun = 'pulse' 'rate' 'heart rate'
  adjective = 'heart'
;
nurseItems4: item
  sdesc = "blood pressure"
  noun = 'pressure' 'blood pressure'
  adjective = 'blood'
;
nurseItems5: item
  sdesc = "temperature"
  noun = 'temperature' 'temp'
;

intercom: fixeditem
  sdesc = "intercom"
  noun = 'intercom' 'box'
  adjective = 'smallish'
  location = LDR
  ldesc = "The intercom is a smallish box that is used as a means of paging other staff members.  The
          only notable feature is a small black button. "
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached. "
  verDoTurnon(actor) = { self.verDoUse(actor); }
  verDoPage(actor) = { self.verDoUse(actor); }
  verDoUse(actor) = { 
    switch (rand(3)) {
      case 1:
        "You really don't have anyone to contact, so you end up paging a <q>Mr.\ Heywood Jablowme.</q>\b
        The nurse scowls at you. ";
        break;
      case 2:
        "You really don't have anyone to contact, so you end up paging a <q>Ms.\ Anita Hanjob.</q>\b
        The nurse scowls at you. ";
        break;
      case 3:
        "You really don't have anyone to contact, so you end up paging a <q>Mr.\ Bill Buckner.</q>
        The nurse doesn't really scowl at you, but you're likely to get your clock cleaned 
        when you set foot outside the LDR room by some rogue Red Sox fan. ";
        break;
    }
  }
;

intercomButton: buttonitem
  sdesc = "black button"
  adjective = 'black' 'small'
  location = intercom
  ldesc = "The <<self.sdesc>> is used to activate the intercom. "
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached to the intercom. "
  verDoPush(actor) = { intercom.verDoUse(actor); }
  verDoUse(actor) = { intercom.verDoUse(actor); }
  verDoTurnon(actor) = { intercom.verDoUse(actor); }
;

strip: fixeditem
  sdesc = "monitor strip"
  noun = 'strip' 'reading' 'readings'
  adjective = 'monitor'
  ldesc = "It's a fetal heart beat tracing; you can't make heads or tails out of it. "
;

bellyBand: fixeditem
  sdesc = "belly band"
  noun = 'band'
  adjective = 'belly'
  ldesc = "The belly band is wrapped around your wife's belly. "
  takedesc = "You decide to leave it be. "
;

nurseDaemon: function(parm)
{
  "\b";
  switch(nurse.count++) {
    case 0: 
      "The nurse arrives from the hall. ";
      nurse.actorDescOK := true;
      break;
    case 1:
      "The nurse introduces herself and begins checking on your wife. ";
// Don't capture input since, well, we're not processing it... Maybe in a later version (yeah, right)
//    Me.captureKieronLDR := true;
      break;
    case 2:
      "The nurse puts a belly band on your wife. ";
      bellyBand.moveInto(wife);
      break;
    case 3:
      if (!fetalMonitor.hookedUp) {
        fetalMonitor.hookedUp := true;
        "The nurse begins hooking up the various monitors to Charlise. ";
      }
      else
        "The nurse patiently waits for the fetal monitor to give a reading. ";
      break;
    case 4:
      "The nurse is reviewing the monitor strip. ";
      strip.moveInto(nurse);
      break;
    case 5:
      "The nurse is studying the fetal monitor with a concerned look. ";
      break;
    case 6:
      "The nurse's face goes white. She moves over toward the intercom. \b
      <q>Paging Dr.\ McKinney, I need you in LDR 14 STAT, paging Dr.\ McKinney, 
      LDR 14 STAT!</q> ";
      break;
    case 7:
      "The nurse takes your wife's blood pressure and checks her heart rate. ";
      break;
    case 8:
      "The nurse continues to study the fetal monitor strip. ";
      break;
    case 9:
      "The nurse takes your wife's temperature. ";
      break;
    case 10:
// We're not storing commands
//      fclose(game.handle);
      CharliseToOR();
//      CharliseToOR(); MJS rem above line out to keep put...
      break;
  }
}     

CharliseToOR: function
{
  "The doctor arrives from the hall. He takes a look at the monitors, and 
  does a very poor job of attempting to conceal an expression of horror. \b
  <q>Let's get her over to the operating room,</q> he says.\b ";
  morePrompt();                           // wait for any key
  wife.moveInto(OR);
  nurse.moveInto(OR);
  Me.travelTo(ORhallway);
  remdaemon(nurseDaemon, nil);
  Me.janitorCnt := 0;
  setdaemon(janitorDaemon, nil);
}

ORhallway: room
  sdesc = "Outside the Operating Room"
  ldesc = {
    if (!self.seen) {
      "Charlise was brought into the Operating Room, but you were told to 
      stay outside. You're not sure if she's okay, if the baby is okay, 
      or what is going on in there, but you have to find out. ";
      Me.captureKieronLDR := nil;
      self.seen := true;
    }
    else {
      "The OR Hall is a big, empty room with aqua tiles and a bench to sit upon. There
      is a door that leads into the operating room itself.  To the right of the long 
      metal bench is an intercom. ";
      if (orderly.location = self)
        "The orderly won't let you in, though. ";
    }
  }
  noexit = { "You feel compelled to stay as close to Charlise as possible. "; }
  east = {
    if (orderly.location = self)
      "The orderly blocks your path. "; 
    else
      return ORdoor;
  }
  in = (self.east)
  genericHint = true
;

bench: chairitem
  sdesc = "bench"
  noun = 'bench'
  adjective = 'metal'
  location = ORhallway
  ldesc = { 
    "It's a long metal bench. ";
    if (orderly.location = ORhallway)
      "An orderly currently occupies one end of it. ";
  }
  reachable = { return(self.location.contents); }
  genericHint = true
;

ORhallwayItem: fixeditem
  sdesc = "OR Hallway"
  noun = 'hallway'
  adjective = 'OR'
  ldesc = { ORhallway.ldesc; }
  location = ORhallway
  takedesc = "It's firmly attached to the hospital. "
;

nearORItem: fixeditem
  sdesc = "Operating Room"
  noun = 'room' 'OR'
  adjective = 'operating'
  location = ORhallway
  ldesc = "The <<self.sdesc>> is to the east. "
  verDoEnter(actor) = { self.verDoBoard(actor); }
  doEnter(actor) = { self.doBoard(actor); }
  verDoBoard(actor) = {}
  doBoard(actor) = {
    if (orderly.location = self.location)
      "The orderly blocks your path. "; 
    else {
      "You make your way into the Operating Room.\b";
      actor.travelTo(OR);
    }
  }
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached to the hospital. "
;

ORdoor: doorway
  sdesc = "OR door"
  noun = 'door'
  adjective = 'OR'
  location = ORhallway
  doordest = OR
  otherside = ORdoor2
  verDoEnter(actor) = {
    if (orderly.location = self.location)
      "The orderly blocks your path. "; 
  }
  doOpen(actor) = {
    if (orderly.location = ORhallway)
      "<q>I can't let you in, sir,</q> he says. ";
    else
      inherited.doOpen(actor);
  }
;

ORdoor2: doorway
  sdesc = "OR door"
  noun = 'door'
  adjective = 'OR'
  location = OR
  doordest = ORhallway
  otherside = ORdoor
  doOpen(actor) = { "Leave her like this? "; }
;

ORintercom: fixeditem
  sdesc = "intercom"
  noun = 'intercom' 'box'
  adjective = 'smallish'
  location = ORhallway
  ldesc = "The intercom is a smallish box that is used as a means of paging other staff members. The
          only notable feature is a small black button. "
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached to the wall. "
  verDoTurnon(actor) = {}
  doTurnon(actor) = { self.doUse(actor); }
  verDoPage(actor) = {}
  doPage(actor) = { self.doUse(actor); }
  verDoUse(actor) = {}
  doUse(actor) = {
    if (!orderly.nameKnown)
      "As you go to use it, the orderly looks up at you and you make
      believe you're doing something else. ";
    else {
      if (!orderly.lastNameKnown)
        "You know the orderly's first name, and you take a look at his nametag in hopes of getting his
        last one. It works -- looks like his name is Jimmy Rogers. You steal away for a moment, and speak
        into the intercom and hope that the orderly doesn't notice. ";
      else
        "You speak into the intercom and hope that the orderly doesn't notice. ";
      "\b<q>James Rogers, please report to LDR 14, James Rogers, to LDR 14.</q>
      \b<q>Whoops,</q> says the orderly. <q>I'll be right back.</q> ";
      orderly.moveInto(nil);
    }
  }
;

ORintercomButton: buttonitem
  sdesc = "black button"
  adjective = 'black' 'small'
  location = ORintercom
  ldesc = "The <<self.sdesc>> is used to activate the intercom. "
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached to the intercom. "
  doPush(actor) = { ORintercom.doUse(actor); }
  verDoUse(actor) = {}
  doUse(actor) = { ORintercom.doUse(actor); }
  verDoTurnon(actor) = {}
  doTurnon(actor) = { ORintercom.doUse(actor); }
;

orderlyNameTag: item
  sdesc = "nametag"
  noun = 'nametag'
  location = orderly
  ldesc = {
    "His name tag simply says <q>ROGERS</q> and it looks like he has been with this hospital for one year. ";
    orderly.lastNameKnown := true;
  }
  verDoRead(actor) = { self.ldesc; }
  isListed = nil
  isworn = true
;

janitor: item
  noun = 'janitor'
;

orderly: Actor
  sdesc = "orderly"
  adesc = "an orderly"
  noun = 'orderly' 'rogers' 'himself'
  adjective = 'jim' 'jimmy'
  takedesc = "I don't think he would appreciate that. "
  ldesc = {
    "He is a friendly chap, determined to not let you pass him. 
    The word <q>ROGERS</q> is on his nametag. ";
    self.lastNameKnown := true;
  }
  verDoPage(actor) = {}
  doPage(actor) = { ORintercom.doUse(actor); }
  verDoCall(actor) = {}
  doCall(actor) = { ORintercom.doUse(actor); }
  location = ORhallway
  isHim = true
  actorDesc = { "There is an orderly here, sitting at the end of a long metal bench. "; }
  verDoSearch(actor) = { "<q>Hey!</q>\ he snaps, can you do that again? "; }
  verDoHug(actor) = {"The orderly gropes you. "; }
  verDoKiss(actor) = {"The orderly returns your kiss with passion and longing. "; }
  doSynonym('Search') = 'Lookin'
  actorAction(v, d, p, i) = {
    if (v.isTravelVerb) {
      "<q>I'm not going anywhere right now.</q> ";
      exit;
    }
    switch(v) {
      case noVerb:
      case yesVerb:
      case helloVerb:
        break;
      case wearVerb:
        "<q>I'm comfortable with what I'm already wearing.</q> ";
        exit;
      default:
        "<q>You're not the boss of me,</q> he retorts. ";
        exit;
    }
  }  
  verDoTellAbout(actor, io) = { self.verDoAskAbout(actor, io); }
  doTellAbout(actor, io) = { 
    "You wonder what <<self.thedesc>> has to say instead, so you ask him about it.\b";
    self.doAskAbout(actor, io); 
  }
  verDoAskFor(actor, io) = { self.disavow; }
  doAskFor(actor, io) = { self.doAskAbout(actor, io); }
  disavow = ""
  dontKnow = {
    local msg := [
      '<q>I don\'t know much about that,</q> says '
      '<q>I don\'t really know,</q> states '
      '<q>You probably know as much as I do,</q> quips '
      '<q>Were you talking to me?</q>\ questions '
      '<q>Sorry, not my area of expertise,</q> exclaims '
      '<q>Um... Did you say something?</q>\ asks '
      'A shrug is all you get from '
    ];
    say(msg[rand(length(msg))]);
  }
  askWord(word, lst) = {
    switch(substr(word, 1, 7)) {
      case 'himself':
      case 'jimmy':
      case 'orderly':
        "<q>Ah... I'm just this guy,</q> he says. ";
        return true;
        break;
      case 'interco':
        "<q>It's what we used to page someone,</q> says the orderly. ";
        return true;
        break;
      case 'hospita':
        "<q>It's nice enough. It doesn't smell like concentrated urine, like the 
        last one I worked at,</q> says the orderly. ";
        return true;
        break;
      case 'mess':
      case 'highway':
        "<q>Some whacko tied up traffic for hours -- been all over the news, </q> he replies. ";
        return true;
        break;
      case 'unabomb':
        "<q>Heh... I'm telling ya,</q> he says, <q>could be his twin...</q> ";
        return true;
        break;
      case 'jimmy':
      case 'orderly':
        "<q>Ah... I'm just this guy,</q> he says. ";
        return true;
        break;
      case 'janitor':
      case 'man':
        if (!orderly.nameKnown)
          "<q>Haven't seem him around,</q> he responds. ";
        else
        "<q>There's just something about that guy. He looks like the Unabomber,</q> says the orderly. ";
        return true;
        break;
      case 'childre':
      case 'daughte':
      case 'son':
      case 'kids':
      case 'kid':
        "<q>Not yet,</q> he replies, now wondering why you're curious about
        his personal life. ";
        return true;
        break;
      default:
        dontKnow; "<<self.thedesc>>. ";
        return nil;
      }
  }
  doHello = { 
    if (!self.helloSaid) {
      "<q>Hello,</q>\ he says. ";
      self.helloSaid := true;
    }
    else
      "\^<<self.thedesc>> smiles at you, probably wondering why you 
      insist on repeating a greeting. ";
  }
  verDoTurnon(actor) = { "I'm sure you can think of something else to do, no? 
                         Besides, why would you want to alienate <<self.sdesc>>. "; }
  verDoAttack(actor) = { }
  doAttack(actor) = { "The orderly punches you back, and then lets the confrontation drop. "; }
  verDoAttackWith(actor, iobj) = { }
  doAttackWith(actor, iobj) = { self.doAttack(actor); }
  doListenTo(actor) = { "\^<<self.thedesc>> isn't making much noise right now. "; }
  ioSynonym('GiveTo') = 'ShowTo'
  ioGiveTo(actor, dobj) = { "You have better things to do. "; }
  verDoPush(actor) = { "<q>Hey!,</q>\ says the orderly, <q>Knock it off, man!</q> "; }
  verDoPull(actor) = { "He pushes you back. "; }
  verDoMove(actor) = { "He swats your hand away. "; }
  count = 0
  talkCount = 0
  verDoTalkTo(actor) = {}
  doTalkTo(actor) = { 
    switch(self.talkCount++) {
      case 0: 
        "<q>Hey, look man... that's my wife in there. Can't you let me in?</q>\b
        The orderly shakes his head in the negative. <q>I'm sorry -- can't do it.</q> ";
        break;
      case 1:
        "<q>I'll be sure to let you know when it's okay for you to go in,</q> says the orderly. ";
        break;
      default:
        "You try and engage in some small talk, but fail miserably. ";
    }
  }
;

orderlyItems: item
  sdesc = "Orderly topics"
  noun = 'mess' 'highway' 'unabomber'
;

janitorDaemon: function(parm)
{
  if (Me.janitorCnt++ < 6) return;
  "\bA janitor arrives from the hall. He goes over toward the intercom  
  and speaks something into it. \b  As he heads down the hallway, he stops
  to chat with the orderly.\b 
  <q>Hey, Jimmy,</q> says the janitor. <q>How are you?</q>\b
  <q>Good, good,</q> says the orderly.  <q>I think I finally have this flu beat. And you?</q>\b
  <q>Oh... just dandy. Nice weather we're having, isn't it?</q> says the janitor.\b
  <q>Yes, quite comfortable,</q> agrees the orderly. <q>Unseasonably warm, even.</q>\b
  <q>Did you hear about that mess on the highway?</q>\ asks the janitor.\b
  <q>Actually, I did. Weird for someone just to lose it that way, wouldn't you say?</q>\b
  The orderly lets out a low whistle. \b
  The conversation subsides and the janitor continues down the hallway,
  disappearing into a utility closet. ";
  orderly.nameKnown := true;
  remdaemon(janitorDaemon, nil);
}     

OR: room
  sdesc = "Operating Room"
  ldesc = {
    "The Operating Room is fairly dark, save for the operating table 
    illuminated by the strong lights that Charlise is on. There is a 
    doctor and nurse here working by her table. ";
    if (!self.seen) {
      "\b<q>How did he get in here?</q> asks the nurse.  ";
      nurse.actorDescOK := nil;
      Me.ORkieronCnt := 0;
      setdaemon(ORkieronDaemon,nil);
      self.seen := true;
    }
  }
  out = { "After fighting so hard to get in, you don't want to leave just yet. "; }
  west = (self.out)
  genericHint = true
;

ORitem: fixeditem
  sdesc = "OR"
  noun = 'OR'
  ldesc = { OR.ldesc; }
  location = OR
  takedesc = "It's firmly attached to the hospital. "
;

ORtable: beditem
  sdesc = "OR table"
  ldesc = "The OR table is about three or four feet off the ground, and right next to a slew of medical
          equipment. Charlise is currently on it. "
  noun = 'table'
  adjective = 'OR'
  outOfPrep = "off of"
  statusPrep = "on"
  location = OR
  verDoBoard(actor) = { "There's barely enough room for Charlise. "; }
;

ORequipment: decoration
  sdesc = "equipment"
  noun = 'equipment'
  location = OR
  ldesc = "The <<self.sdesc>> <<self.isntdesc>> important. "
;


ORlights: fixeditem
  sdesc = "lights"
  noun = 'light' 'lights'
  adjective = 'bright'
  location = OR
  ldesc = "The <<self.sdesc>> <<self.isntdesc>> important. "
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached. "
  isThem = true
  verDoTurnon(actor) = { "The lights are on already. "; }
  verDoTurnoff(actor) = { "<q>Hey!</q>\ yells the nurse, <q>Knock that off or I'll have you thrown out of here!</q> "; }
;
  
doctor: Actor
  sdesc = "doctor"
  name = 'doctor'
  noun = 'doctor' 'dr' 'himself'
  takedesc = "I don't think he would appreciate that. "
  ldesc = { "Can't make much out, he's covered from head to toe in scrubs. "; }
  location = OR
  isHim = true
  actorDesc = nil
  verDoSearch(actor) = { "<q>Hey!</q>\ he protests, moving away from you. "; }
  verDoHug(actor) = {"Not a good time. "; }
  verDoKiss(actor) = {"Not a good time. "; }
  doSynonym('Search') = 'Lookin'
  actorAction(v, d, p, i) = {
    if (v.isTravelVerb) {
      "<q>I'm not going anywhere right now.</q> ";
      exit;
    }
    switch(v) {
      case noVerb:
      case yesVerb:
      case helloVerb:
        break;
      case wearVerb:
        "<q>I'm comfortable with what I'm already wearing.</q> ";
        exit;
      default:
        "He ignores you. ";
        exit;
    }
  }  
  verDoTellAbout(actor, io) = { self.verDoAskAbout(actor, io); }
  doTellAbout(actor, io) = { 
    "You wonder what <<self.thedesc>> has to say instead, so you ask him about it.\b";
    self.doAskAbout(actor, io); 
  }
  verDoAskFor(actor, io) = { self.disavow; }
  doAskFor(actor, io) = { self.doAskAbout(actor, io); }
  disavow = ""
  dontKnow = {
    local msg := [
      '<q>I don\'t know much about that,</q> says '
      '<q>I don\'t really know,</q> states '
      '<q>You probably know as much as I do,</q> quips '
      '<q>Were you talking to me?</q>\ questions '
      '<q>Sorry, not my area of expertise,</q> exclaims '
      '<q>Um... Did you say something?</q>\ asks '
      'A shrug is all you get from '
    ];
    say(msg[rand(length(msg))]);
  }
  askWord(word, lst) = {
    switch(substr(word, 1, 7)) {
      case 'baby':
        "The doctor seems to make a point of not addressing this subject. ";
        return true;
        break;
      case 'charlis':
      case 'wife':
        "<q>She's going to be alright,</q> states the doctor. <q>She's fine.</q> ";
        return true;
        break;
      case 'nurse':
        "<q>Not now,</q> says the doctor. ";
        return true;
        break;
      case 'himself':
      case 'doctor':
        "The doctor gives you a stern look. He doesn't say a word, but you get the feeling
        that if anyone can save your baby, it's him. ";
        return true;
        break;
      case 'childre':
      case 'daughte':
        "<q>She's going to be alright,</q> states the doctor. <q>She's fine.</q> ";
        return true;
        break;
      default:
        dontKnow; "<<self.thedesc>>. ";
        return nil;
      }
  }
  doAskAbout(actor, iobj) = {
    inherited.doAskAbout(actor, iobj);
  }
  doHello = { 
    if (!self.helloSaid) {
      "<q>Hello,</q>\ he says. ";
      self.helloSaid := true;
    }
    else
      "\^<<self.thedesc>> smiles at you, probably wondering why you 
      insist on repeating a greeting. ";
  }
  verDoTurnon(actor) = { "I'm sure you can think of something else to do, no? 
                         Besides, why would you want to alienate <<self.sdesc>>. "; }
  verDoAttack(actor) = { }
  doAttack(actor) = { "That would not be a good thing. "; }
  verDoAttackWith(actor, iobj) = { }
  doAttackWith(actor, iobj) = { self.doAttack(actor); }
  doListenTo(actor) = { "\^<<self.thedesc>> isn't making much noise right now. "; }
  ioSynonym('GiveTo') = 'ShowTo'
  ioGiveTo(actor, dobj) = { "You have better things to do. "; }
  count = 0
  talkCount = 0
  verDoTalkTo(actor) = {}
  doTalkTo(actor) = { 
    switch(self.talkCount++) {
      case 0: 
        "The doctor seems to speak more toward the nurse than just you. <q>It looks like the umbilical
        cord has wrapped itself around the baby's head,</q> he says. He makes a sharp cut into Charlise's
        mid-section. ";
        break;
      default:
        "He appears too focused to talk right now. ";
    }
  }
;

ORkieronDaemon: function(parm)
{
  switch(Me.ORkieronCnt++) {
    case 1:
//      Me.captureKieronOR := true;   // Kieron in OR and need his movements
      break;
    case 5:
      "\bYou overhear a bit of the conversation between the doctor and his 
      assistants. It doesn't sound good, it doesn't sound like the baby made it... ";
      break;
    case 6:
      "\bDr. McKinney comes over to you. <q>Mr.\ Scott, I'm sorry...</q>\ he begins.\b
      The words slough off your ears, you stare off, in disbelief... \b
      <q>Charlise is going to make a full recovery, but the baby, 
      we couldn't...\ she didn't make it.</q>\b
      Gone? Like that? But why, for what reason... \b
      Your knees buckle briefly, and you fall to the ground. You need to get 
      up, you know that you need to get up, 'she'? A baby girl, your baby girl, 
      gone, you imagine your wife's eventual tears, that she has yet to find this out, you have
      to be there for her, buck up, get it together, but everything your hear and see
      meshes into a horrible cacophony... ";
      remdaemon(ORkieronDaemon, nil);
      Me.captureKieronOR := nil;
// We're not capturing right now...
//      fclose(game.handle);
//MJS - Okay, it's time for Charlise's scene
      updateGameState('B');
      Me.checkRestore := true;
      die();
      break;
    default:
  }     
}     

startroom: room
;  
   

