/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;

public class Jetty {
    public static GameState state = null;
    public static OutputFormatter out = null;
    public static InputHandler in = null;
    public static Parser parser = null;
    public static Simulator simulator = null;
    public static CodeRunner runner = null;
    public static ParserError perror = null;
    private InputStream _file;
    private static int _debug_level = 1;

    public Jetty(PlatformIO platformIO, InputStream inputStream) {
        out = new OutputFormatter(platformIO);
        in = new InputHandler(platformIO);
        platformIO.set_out(out);
        this._file = inputStream;
    }

    public void load() {
        try {
            GameFileParser gameFileParser = new GameFileParser();
            state = gameFileParser.read(this._file);
            state.init();
        }
        catch (IOException iOException) {
            out.print_error("I/O error reading gamefile: " + iOException, 0);
            return;
        }
        catch (HaltTurnException haltTurnException) {
            out.print_error("Internal error reading gamefile: " + haltTurnException, 0);
            return;
        }
        runner = new CodeRunner();
        perror = new ParserError();
        simulator = new Simulator();
        parser = new Parser();
    }

    public void run() {
        try {
            TObject tObject = state.lookup_required_object(6);
            if (tObject == null) {
                out.print_error("Error: no init function found", 0);
                throw new GameOverException();
            }
            try {
                runner.run(tObject.get_data(), TObject.arg_array());
            }
            catch (ParseException parseException) {
                out.print_error("Parse exception (" + parseException + ") erroneously thrown in init()", 1);
            }
            catch (ReparseException reparseException) {
                out.print_error("Reparse exception erroneously thrown in init()", 1);
            }
            while (true) {
                parser.run_turn();
            }
        }
        catch (GameOverException gameOverException) {
            System.out.println("\n[The game has ended.]");
            out.flush();
            return;
        }
    }

    public static int get_debug_level() {
        return _debug_level;
    }

    public static void set_debug_level(int n) {
        _debug_level = n;
    }
}

