/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class VocabWord {
    public static final int VERB = 2;
    public static final int NOUN = 3;
    public static final int ADJECTIVE = 4;
    public static final int PREPOSITION = 5;
    public static final int ARTICLE = 6;
    public static final int PLURAL = 7;
    public static final int UNKNOWN = -1;
    public static final String SPECWORD_AND = ",";
    public static final String SPECWORD_THEN = ".";
    public static final String SPECWORD_OF = "O";
    public static final String SPECWORD_ALL = "A";
    public static final String SPECWORD_BOTH = "B";
    public static final String SPECWORD_IT = "I";
    public static final String SPECWORD_HIM = "M";
    public static final String SPECWORD_ONE = "N";
    public static final String SPECWORD_ONES = "P";
    public static final String SPECWORD_HER = "R";
    public static final String SPECWORD_THEM = "T";
    public static final String SPECWORD_BUT = "X";
    public static final String SPECWORD_ANY = "Y";
    String _word;
    String[] _word2s;
    int[] _types;
    int[][] _objects;
    String _specword;
    int _number_value;
    boolean _is_string;
    boolean _truncated;

    public VocabWord(String string, int n) {
        this(string, null, -1, n);
    }

    public VocabWord(String string, String string2, int n, int n2) {
        this._word = string;
        this._word2s = new String[1];
        this._word2s[0] = string2;
        this._types = new int[1];
        this._types[0] = n2;
        if (n != -1) {
            this._objects = new int[1][1];
            this._objects[0][0] = n;
        } else {
            this._objects = new int[1][0];
        }
        try {
            this._number_value = Integer.parseInt(this._word);
        }
        catch (NumberFormatException numberFormatException) {
            this._number_value = Integer.MIN_VALUE;
        }
    }

    public String get_word() {
        return this._word;
    }

    public void set_word(String string) {
        this._word = string;
    }

    public boolean is_specword() {
        return this._specword != null;
    }

    public boolean is_specword(String string) {
        return this._specword != null && this._specword.equals(string);
    }

    public boolean is_unknown() {
        return this._types[0] == -1 && !this.is_specword();
    }

    public String get_specword() {
        return this._specword;
    }

    public boolean is_number() {
        return this._number_value != Integer.MIN_VALUE;
    }

    public int get_number() {
        return this._number_value;
    }

    public void is_string(boolean bl) {
        this._is_string = bl;
    }

    public boolean is_string() {
        return this._is_string;
    }

    public void truncated(boolean bl) {
        this._truncated = bl;
    }

    public boolean is_truncated() {
        return this._truncated;
    }

    public void set_specword(String string) {
        this._specword = string;
    }

    public boolean has_objects(int n) {
        return this.get_objects(n, null) != null;
    }

    public boolean has_objects(int n, String string) {
        return this.get_objects(n, string) != null;
    }

    public int get_first_object(int n, String string) throws HaltTurnException {
        int[] nArray = this.get_objects(n, string);
        if (nArray != null && nArray.length > 0) {
            int n2 = nArray.length - 1;
            while (n2 >= 0) {
                if (!Jetty.state.lookup_object(nArray[n2]).is_class()) {
                    return nArray[n2];
                }
                --n2;
            }
        }
        return -1;
    }

    public int[] get_objects(int n, String string) {
        int n2 = 0;
        while (n2 < this._types.length) {
            if (this._types[n2] == n && (this._word2s[n2] == null && string == null || this._word2s[n2] != null && this._word2s[n2].equals(string))) {
                return this._objects[n2];
            }
            ++n2;
        }
        return null;
    }

    public boolean get_object(int n, Vector vector, Vector vector2) {
        boolean bl = false;
        int n2 = 0;
        while (n2 < this._objects.length) {
            int n3 = 0;
            while (n3 < this._objects[n2].length) {
                if (this._objects[n2][n3] == n) {
                    bl = true;
                    vector.addElement(new Integer(this._types[n2]));
                    vector2.addElement(this._word2s[n2]);
                }
                ++n3;
            }
            ++n2;
        }
        return bl;
    }

    public void add_obj(String string, int n, int n2) {
        int n3 = 0;
        while (n3 < this._types.length) {
            if (this._types[n3] == n2) {
                boolean bl = this._word2s[n3] == null ? string == null : this._word2s[n3].equals(string);
                if (bl) {
                    int n4 = 0;
                    while (n4 < this._objects[n3].length) {
                        if (this._objects[n3][n4] == n) {
                            return;
                        }
                        ++n4;
                    }
                    int[] nArray = new int[this._objects[n3].length + 1];
                    System.arraycopy(this._objects[n3], 0, nArray, 0, this._objects[n3].length);
                    nArray[this._objects[n3].length] = n;
                    this._objects[n3] = nArray;
                    return;
                }
            }
            if (this._types[n3] == -1) {
                this._word2s[n3] = string;
                this._types[n3] = n2;
                int[] nArray = new int[]{n};
                this._objects[n3] = nArray;
                return;
            }
            ++n3;
        }
        int[] nArray = new int[this._types.length + 1];
        System.arraycopy(this._types, 0, nArray, 0, this._types.length);
        nArray[this._types.length] = n2;
        this._types = nArray;
        String[] stringArray = new String[this._word2s.length + 1];
        System.arraycopy(this._word2s, 0, stringArray, 0, this._word2s.length);
        stringArray[this._word2s.length] = string;
        this._word2s = stringArray;
        int[][] nArrayArray = new int[this._objects.length + 1][];
        System.arraycopy(this._objects, 0, nArrayArray, 0, this._objects.length);
        nArrayArray[this._objects.length] = new int[1];
        nArrayArray[this._objects.length][0] = n;
        this._objects = nArrayArray;
    }

    public void remove_obj(String string, int n, int n2) {
        int n3 = 0;
        while (n3 < this._types.length) {
            if (this._types[n3] == n2) {
                boolean bl = this._word2s[n3] == null ? string == null : this._word2s[n3].equals(string);
                if (bl) {
                    int n4 = 0;
                    while (n3 < this._objects[n3].length) {
                        if (this._objects[n3][n4] == n) {
                            this._objects[n3][n4] = this._objects[n3][this._objects[n3].length - 1];
                            int[] nArray = new int[this._objects[n3].length - 1];
                            System.arraycopy(this._objects[n3], 0, nArray, 0, nArray.length);
                            this._objects[n3] = nArray;
                            return;
                        }
                        ++n4;
                    }
                }
            }
            ++n3;
        }
    }

    public int get_flags() {
        int n = 0;
        int n2 = 0;
        while (n2 < Constants.vocab_prop_flags.length) {
            if (this.get_objects(Constants.vocab_prop_flags[n2][0], null) != null) {
                n |= Constants.vocab_prop_flags[n2][1];
            }
            ++n2;
        }
        if (this.is_unknown()) {
            n |= 0x80;
        }
        if (this.is_specword()) {
            n |= 0x20;
        }
        return n;
    }

    public VocabWord do_clone() {
        VocabWord vocabWord = new VocabWord(this._word, null, -1, -1);
        vocabWord._word2s = new String[this._word2s.length];
        System.arraycopy(this._word2s, 0, vocabWord._word2s, 0, this._word2s.length);
        vocabWord._types = new int[this._types.length];
        System.arraycopy(this._types, 0, vocabWord._types, 0, this._types.length);
        vocabWord._objects = new int[this._objects.length][];
        int n = 0;
        while (n < vocabWord._objects.length) {
            vocabWord._objects[n] = new int[this._objects[n].length];
            System.arraycopy(this._objects[n], 0, vocabWord._objects[n], 0, this._objects[n].length);
            ++n;
        }
        vocabWord._specword = this._specword;
        vocabWord._number_value = this._number_value;
        vocabWord._is_string = this._is_string;
        vocabWord._truncated = this._truncated;
        return vocabWord;
    }

    public void merge(VocabWord vocabWord) {
        int n = 0;
        while (n < vocabWord._objects.length) {
            int n2 = 0;
            while (n2 < vocabWord._objects[n].length) {
                this.add_obj(vocabWord._word2s[n], vocabWord._objects[n][n2], vocabWord._types[n]);
                ++n2;
            }
            ++n;
        }
    }

    public String toString() {
        String[] stringArray = new String[]{"?", "??", "verb", "noun", "adj", "prep", "art", "plu"};
        String string = this._word + " (";
        if (this.is_truncated()) {
            string = string + "TRUNCATED ";
        }
        if (this.is_specword()) {
            string = string + "SPECIAL=" + this._specword + " ";
        }
        if (this._types[0] == -1) {
            string = string + "UNKNOWN";
        } else {
            int n = 0;
            while (n < this._types.length) {
                string = string + (n != 0 ? " " : "") + "[" + stringArray[this._types[n]];
                if (this._word2s[n] != null) {
                    string = string + " w/'" + this._word2s[n] + "'";
                }
                string = string + ":";
                int n2 = 0;
                while (n2 < this._objects[n].length) {
                    string = string + " " + this._objects[n][n2];
                    ++n2;
                }
                string = string + "]";
                ++n;
            }
        }
        return string + ")";
    }
}

