/*
 * WorldClass version 2
 * Copyright (c) 1999 The Children of Dana
 * Written by David Haire
 *
 * Thanks to:
 *
 *    - Michael J. Roberts for writing TADS in the first place.
 *    - David M. Baggett for writing the original WorldClass library.
 *    - Paul F. Gilbert for various contributions, including the WorldClass
 *      manual.
 *    - Shay Caron for suggesting improvements and reporting bugs.
 *    - Kevin Forchione for various contributions and suggestions.
 *
 * Errors, typos and omissions should be notified to David Haire via e-mail
 *   at gaebrial@clara.co.uk, along with any suggestions for improvements
 *   or enhancements.
 *
 * The modification history can be found in History.txt.
 *
 * Do not change or delete any part of this file. If you wish to alter the
 *   functionality of this library, use the "modify" or "replace" keywords
 *   in your own source file.
 */

/*
 * Parse this file using normal TADS operators.
 */
#pragma C-

/*
 * Constants for parser status codes. These codes are passed to parseError
 *   and parseErrorParam to indicate which message these routines should
 *   display. In addition, these codes are returned by
 *   parserResolveObjects.
 */

#define PRS_SUCCESS               0  /* success */

#define PRSERR_BAD_PUNCT          1  /* I don't understand the punctuation */
#define PRSERR_UNK_WORD           2  /* I don't know the word */
#define PRSERR_TOO_MANY_OBJS      3  /* Word refers to too many objects */
#define PRSERR_ALL_OF             4  /* Left something out after "all of" */
#define PRSERR_BOTH_OF            5  /* Left something out after "both of" */
#define PRSERR_OF_NOUN            6  /* Expected a noun after "of" */
#define PRSERR_ART_NOUN           7  /* Article must be followed by a noun */

#define PRSERR_DONT_SEE_ANY       9  /* I don't see any %s here */
#define PRSERR_TOO_MANY_OBJS2    10  /* Word refers to too many objects */
#define PRSERR_TOO_MANY_OBJS3    11  /* Word refers to too many objects */
#define PRSERR_ONE_ACTOR         12  /* You can only speak to one person */
#define PRSERR_DONT_KNOW_REF     13  /* Don't know what you're referring to */
#define PRSERR_DONT_KNOW_REF2    14  /* Don't know what you're referring to */
#define PRSERR_DONT_SEE_REF      15  /* Don't see what you're referring to */
#define PRSERR_DONT_SEE_ANY2     16  /* You don't see any %s here */

#define PRSERR_NO_MULTI_IO       25  /* can't use multiple indirect objects */
#define PRSERR_NO_AGAIN          26  /* There's no command to repeat */
#define PRSERR_BAD_AGAIN         27  /* You can't repeat that command */
#define PRSERR_NO_MULTI          28  /* can't use multiple objects with cmd */
#define PRSERR_ANY_OF            29  /* Left something out after "any of" */
#define PRSERR_ONLY_SEE          30  /* I only see %d of those */
#define PRSERR_CANT_TALK         31  /* You can't talk to that */
#define PRSERR_INT_PPC_INV       32  /* internal: invalid preparseCmd list */
#define PRSERR_INT_PPC_LONG      33  /* preparseCmd command too long */
#define PRSERR_INT_PPC_LOOP      34  /* internal: preparseCmd loop */

#define PRSERR_DONT_SEE_ANY_MORE 38  /* You don't see that here any more */
#define PRSERR_DONT_SEE_THAT     39  /* You don't see that here */
#define PRSERR_NO_NEW_NUM        40  /* can't create new numbered object */
#define PRSERR_BAD_DIS_STAT      41  /* invalid status from disambigXobj */
#define PRSERR_EMPTY_DISAMBIG    42  /* empty response to disambig query */
#define PRSERR_DISAMBIG_RETRY    43  /* retry object disambig response */
#define PRSERR_AMBIGUOUS         44  /* objects still ambiguous */

#define PRSERR_TRY_AGAIN        100  /* Let's try it again... */
#define PRSERR_WHICH_PFX        101  /* Which %s do you mean... */
#define PRSERR_WHICH_COMMA      102  /* (comma) */
#define PRSERR_WHICH_OR         103  /* ...or... */
#define PRSERR_WHICH_QUESTION   104  /* (question mark) */

#define PRSERR_DONTKNOW_PFX     110  /* I don't know how to... */
#define PRSERR_DONTKNOW_SPC     111  /* (space) */
#define PRSERR_DONTKNOW_ANY     112  /* ...anything */
#define PRSERR_DONTKNOW_TO      113  /* ...to... */
#define PRSERR_DONTKNOW_SPC2    114  /* (space) */
#define PRSERR_DONTKNOW_END     115  /* (period) */

#define PRSERR_MULTI            120  /* (colon) for multiple-object prefix */

#define PRSERR_ASSUME_OPEN      130  /* (open paren) for defaulted objects */
#define PRSERR_ASSUME_CLOSE     131  /* (close paren) */
#define PRSERR_ASSUME_SPC       132  /* (space) */

#define PRSERR_WHAT_PFX         140  /* What do you want to... */
#define PRSERR_WHAT_IT          141  /* ...it... */
#define PRSERR_WHAT_TO          142  /* ...to... */
#define PRSERR_WHAT_END         143  /* (question mark) */
#define PRSERR_WHAT_THEM        144  /* ...them... */
#define PRSERR_WHAT_HIM         145  /* ...him... */
#define PRSERR_WHAT_HER         146  /* ...her... */
#define PRSERR_WHAT_THEM2       147  /* ...them... */
#define PRSERR_WHAT_PFX2        148  /* What do you want... */
#define PRSERR_WHAT_TOSPC       149  /* ...to... */

#define PRSERR_MORE_SPECIFIC    160  /* you'll have to be more specific */

#define PRSERR_NOREACH_MULTI    200  /* (colon) for prefixing unreachables */

/*
 * Constants for the event codes returned by the inputevent() intrinsic
 *   function.
 */
#define INPUT_EVENT_KEY           1
#define INPUT_EVENT_TIMEOUT       2
#define INPUT_EVENT_HREF          3
#define INPUT_EVENT_NOTIMEOUT     4
#define INPUT_EVENT_EOF           5

/*
 * Constants for inputdialog().
 */
#define INDLG_OK                  1
#define INDLG_OKCANCEL            2
#define INDLG_YESNO               3
#define INDLG_YESNOCANCEL         4

#define INDLG_ICON_NONE           0
#define INDLG_ICON_WARNING        1
#define INDLG_ICON_INFO           2
#define INDLG_ICON_QUESTION       3
#define INDLG_ICON_ERROR          4

#define INDLG_LBL_OK              1
#define INDLG_LBL_CANCEL          2
#define INDLG_LBL_YES             3
#define INDLG_LBL_NO              4

/*
 * Constants for gettime() type codes.
 */
#define GETTIME_DATE_AND_TIME     1
#define GETTIME_TICKS             2

/*
 * Constants for askfile() prompt type codes.
 */
#define ASKFILE_PROMPT_OPEN       1  /* open an existing file for reading */
#define ASKFILE_PROMPT_SAVE       2  /* save to the file */

/*
 * Constants for askfile() flags 
 */
#define ASKFILE_EXT_RESULT        1  /* extended result codes */

/*
 * askfile() return codes - these are returned in the first element of the 
 *   list returned from askfile() when ASKFILE_EXT_RESULT is used in the 
 *   'flags' parameter.
 */
#define ASKFILE_SUCCESS           0  /* success - 2nd list element is file */
#define ASKFILE_FAILURE           1  /* an error occurred asking for a file */
#define ASKFILE_CANCEL            2  /* player cancelled the file selector */

/*
 * Constants for askfile() file type codes.
 */
#define FILE_TYPE_GAME            0  /* a game data file (.gam) */
#define FILE_TYPE_SAVE            1  /* a saved game (.sav) */
#define FILE_TYPE_LOG             2  /* a transcript (log) file */
#define FILE_TYPE_DATA            4  /* general data file (used for fopen()) */
#define FILE_TYPE_CMD             5  /* command input file */
#define FILE_TYPE_TEXT            7  /* text file */
#define FILE_TYPE_BIN             8  /* binary data file */
#define FILE_TYPE_UNKNOWN        11  /* unknown file type */

/*
 * Constants for execCommand() flags.
 */
#define EC_HIDE_SUCCESS           1  /* hide success messages */
#define EC_HIDE_ERROR             2  /* hide error messages */
#define EC_SKIP_VALIDDO           4  /* skip direct object validation */
#define EC_SKIP_VALIDIO           8  /* skip indirect object validation */

/*
 * Constants for execCommand() return codes.
 */
#define EC_SUCCESS                0  /* successful completion */
#define EC_EXIT                1013  /* "exit" executed */
#define EC_ABORT               1014  /* "abort" executed */
#define EC_ASKDO               1015  /* "askdo" executed */
#define EC_ASKIO               1016  /* "askio" executed */
#define EC_EXITOBJ             1019  /* "exitobj" executed */
#define EC_INVAL_SYNTAX        1200  /* invalid sentence structure */
#define EC_VERDO_FAILED        1201  /* verDoVerb failed */
#define EC_VERIO_FAILED        1202  /* verIoVerb failed */
#define EC_NO_VERDO            1203  /* no verDoVerb method defined */
#define EC_NO_VERIO            1204  /* no verIoVerb method defined */
#define EC_INVAL_DOBJ          1205  /* direct object validation failed */
#define EC_INVAL_IOBJ          1206  /* indirect object validation failed */

/*
 * Constants for parserGetObj object codes.
 */
#define PO_ACTOR                  1  /* actor */
#define PO_VERB                   2  /* deepverb object */
#define PO_DOBJ                   3  /* direct object */
#define PO_PREP                   4  /* preposition object */
#define PO_IOBJ                   5  /* indirect object */

/*
 * Constants for parseNounPhrase return codes.
 */
#define PNP_ERROR                 1  /* noun phrase syntax error */
#define PNP_USE_DEFAULT           2  /* use default processing */

/*
 * Constants for disambigDobj and disambigIobj status codes.
 */
#define DISAMBIG_CONTINUE         1  /* continue disambiguation for this list */
#define DISAMBIG_DONE             2  /* list is fully resolved */
#define DISAMBIG_ERROR            3  /* disambiguation failed; abort command */
#define DISAMBIG_PARSE_RESP       4  /* parse interactive response string */
#define DISAMBIG_PROMPTED         5  /* prompted for response, didn't read it */

/*
 * Parser word types. These values may be combined, since a given word may
 *   appear in the dictionary with multiple types. To test for a particular
 *   type, use the bitwise AND operator:
 *
 *   ((typ & PRSTYP_NOUN) != 0).
 */
#define PRSTYP_ARTICLE            1  /* the, a, an */
#define PRSTYP_ADJ                2  /* adjective */
#define PRSTYP_NOUN               4  /* noun */
#define PRSTYP_PREP               8  /* preposition */
#define PRSTYP_VERB              16  /* verb */
#define PRSTYP_SPEC              32  /* special words - "of", ",", ".", etc. */
#define PRSTYP_PLURAL            64  /* plural */
#define PRSTYP_UNKNOWN          128  /* word is not in dictionary */

/*
 * Parser noun-phrase flags. These values may be combined; to test for a
 *   single flag, use the bitwise AND operator:
 *
 *   ((flag & PRSFLG_UNKNOWN) != 0)
 */
#define PRSFLG_ALL                1  /* "all" */
#define PRSFLG_EXCEPT             2  /* "except" or "but" */
#define PRSFLG_IT                 4  /* "it" */
#define PRSFLG_THEM               8  /* "them" */
#define PRSFLG_NUM               16  /* a number */
#define PRSFLG_COUNT             32  /* noun phrase uses a count - "3 coins" */
#define PRSFLG_PLURAL            64  /* noun phrase is plural - "the coins" */
#define PRSFLG_ANY              128  /* noun phrase uses "any" - "any coin" */
#define PRSFLG_HIM              256  /* "him" */
#define PRSFLG_HER              512  /* "her" */
#define PRSFLG_STR             1024  /* a quoted string */
#define PRSFLG_UNKNOWN         2048  /* noun phrase contains an unknown word */
#define PRSFLG_ENDADJ          4096  /* noun phrase ends in an adjective */
#define PRSFLG_TRUNC           8192  /* noun phrase uses a truncated word */

/*
 * Constants for parserResolveObjects usage codes.
 */
#define PRO_RESOLVE_DOBJ          1  /* direct object */
#define PRO_RESOLVE_IOBJ          2  /* indirect object */
#define PRO_RESOLVE_ACTOR         3  /* actor */

/*
 * Constants for result codes from restore().
 */
#define RESTORE_SUCCESS           0  /* success */
#define RESTORE_FILE_NOT_FOUND    1  /* file not found */
#define RESTORE_NOT_SAVE_FILE     2  /* not a saved game file */
#define RESTORE_BAD_FMT_VSN       3  /* incompatible file format version */
#define RESTORE_BAD_GAME_VSN      4  /* file saved by another game/version */
#define RESTORE_READ_ERROR        5  /* error reading from the file */
#define RESTORE_NO_PARAM_FILE     6  /* no parameter file for restore(nil) */

/*
 * Information about this library.
 */
classlibrary: object
  majorversion = 2
  minorversion = 5
  patchlevel = 0
  copyright = "1999"
  info = {
    "WorldClass library version <<self.versiondesc>>. 
    Copyright &copy <<self.copyright>> The Children of Dana. ";
  }
  versiondesc = {
    say(self.majorversion);
    ".";
    say(self.minorversion);
    ".";
    say(self.patchlevel);
  }
;

/*
 * Versioning information.
 *
 * To add the copyright and version information for your game, modify or 
 *   replace the version object in your source file.
 *
 * For example:
 *
 *    replace version
 *    sdesc = "Your copyright information. Version 0.\n";
 *    ;
 */
version: object
  sdesc = "\(Generic\): An all-purpose adventure developed with TADS 
    and the WorldClass version 2 library. Version 0.\n";

/*
 * The WorldClass version reporting function.
 */
versioninfo: function
{
  /* Display the game copyright and version information. */
  version.sdesc;

  /* Display WorldClass usage message. */
  "<hr>This product includes portions of WorldClass version 2, a TADS class library developed by David Haire for \(The Children of Dana\). Original WorldClass library developed by David M.\ Baggett for \(ADVENTIONS\).\b";

  /* Display the WorldClass copyright and version information. */
  classlibrary.info;
}

/*
 * Class object for version information.
 */
class versionTag: object;

/*
 * Every WorldClass extension or library file should get one of these. The
 *   object name must be unique to keep TADS happy and the class should be
 *   'versionTag' so that it can be picked up by the 'credits' and
 *   'sources' verbs.
 * Note: Apart from 'id', all strings should be delimeted with single
 *   quotes.
 *
 * The versionTag shown below is for the version tracking module. The
 *   WorldClass library version is provided by the classlibrary object,
 *   above.
 */
versionVersion: versionTag
  id = "Version: v1.0 (WorldClass) 1999/02/19. Original TADS version 
       copyright &copy 1994 Jeff Laing.\n"
  author = 'Jeff Laing'
  func = 'version tracking'
;

/*
 * Format string
 *
 * Because of syntactical issues, this should only be used in extreme
 *   circumstances. It is preferable to use <<actor.subjsdesc>> in do and
 *   io routines, and <<parserGetObj(PO_ACTOR).subjsdesc>> in room ldescs.
 *
 * If you do need to use the format string and you set Player.isme to true,
 *   you will need to modify this file, because you can't use replace on
 *   the format string.
 */
formatstring 'you' fmtYou;

/*
 * Special words
 */
specialWords
  'of',
  'and',
  'then',
  'all' = 'everything',
  'both',
  'but' = 'except',
  'one',
  'ones',
  'it' = 'there',
  'them',
  'him',
  'her',
  'any' = 'either'
;

/*
 * Include the basic functions of WorldClass.
 */
#include <WorldFun.t>

/*
 * Include the vocabulary of WorldClass.
 */
#include <WorldVoc.t>

/*
 * Include the object classes of WorldClass.
 */
#include <WorldCls.t>

/*
 * Include the actor classes and routines of WorldClass.
 */
#include <WorldAct.t>

/*
 * Include the main routines of WorldClass.
 */
#include <World2.t>

/*
 * The global object.
 */
global: object
  outstate = []
  loctypes = ['in' 'on' 'under' 'behind']
  locopposites = ['out of' 'off of' 'out from under' 'out from behind']
  loccont = [&incontentslisted, &oncontentslisted, &undercontentslisted, &behindcontentslisted]
  locconthear = [&incontentslistedsound, &oncontentslistedsound, &undercontentslistedsound, &behindcontentslistedsound]
  loccontsmell = [&incontentslistedsmell, &oncontentslistedsmell, &undercontentslistedsmell, &behindcontentslistedsmell]
  locconttouch = [&incontentslistedtouch, &oncontentslistedtouch, &undercontentslistedtouch, &behindcontentslistedtouch]
  locmaxweight = [&inmaxweight, &onmaxweight, &undermaxweight, &behindmaxweight]
  locmaxbulk = [&inmaxbulk, &onmaxbulk, &undermaxbulk, &behindmaxbulk]

  loctake = ['in' 'on']               /* Only take thing on and in containers */
  turns = 0                                      /* no turns have elapsed yet */
  lastsave = 0                                 /* turn when player last saved */
  turnspertick = 1                      /* how much to add to turns each time */
  ticks = 0                             /* like turns, but used by WorldClass */
  score = 0                                /* no points have been amassed yet */
  maxscore = 100                                 /* this many points possible */
  undowarning = 10            /* warn about undoing more than this many turns */
  statuslinewidth = 74                           /* maximum status line width */

  /*
   * We use the following occassionally to avoid passing parameters.
   *   (For example, we don't want ldesc to get an actor parameter, but
   *   sometimes we need to know who's doing the looking.)
   */
  lastactor = nil
  lastprep = nil
  lastpreptime = -999       /* lastprep time stamp (so we know if it's stale) */
  lastio = nil
  lastdo = nil
  lastverb = nil                                        /* hack for cantReach */
  canoutput = nil                                       /* hack for cantReach */
  listed = []                                        /* used by listcontentsX */
  debugreach = nil                    /* print debugging text in blocksreach? */

  /*
   * failedsense and senses are used by checkReq and invalidobject in
   *   Verb.
   */
  failedsense = nil
  senses = [&cantake 'take', &cansee 'see', &canhear 'hear', &cansmell 'smell', &cantouch 'reach']

  restarting = nil                                         /* starting fresh? */
    
  footnumber = 1                            /* start numbering footnotes at 1 */
  footnotelist = []
  footavoid = []                        /* set by preinit (see note function) */

  actorlist = []                                /* list of actors in the game */
  moverlist = []                        /* list of 'Mover' actors in the game */
  lightsources = []                      /* list of light sources in the game */

  listablesmelllist = []               /* list of listable smells in the game */
  listablesoundlist = []               /* list of listable sounds in the game */
  listabletouchlist = []              /* list of listable touches in the game */

  silentincscore = nil             /* should incscore announce score changes? */

  indent = nil                         /* do not indent paragraphs by default */
  paragraphspacing = true              /* blank between paragraphs by default */

  playtesting = true                            /* allow playtesting commands */
  playtestfailtime = -999    /* initial value must not be a valid ticks value */

  searchisexamine = true                     /* "search ___" = "examine ___"? */
  nondeterministic = true                               /* be random for real */
  initcalled = nil                         /* check if init() has been called */

  basic_score = true                           /* display basic score details */
  full_score = nil                         /* display list of tasks completed */
  score_items_rooms = nil                /* display % of items and rooms seen */
  fulllist = []                                    /* list of scoring actions */
  fullnums = []                              /* points scored for each action */

  randomise = {
    if (global.nondeterministic)
      randomize();
  }

  /*
   * Direction strings used by travel verbs and Mover-type actors.
   */
  dirstringlist = ['north' 'northeast' 'east' 'southeast' 'northwest' 'west' 'southwest' 'south' 'up' 'down']
  olddirlist = [&north, &ne, &east, &se, &nw, &west, &sw, &south, &up, &down]
  verdirlist = [&verGoNorth, &verGoNortheast, &verGoEast, &verGoSoutheast, &verGoNorthwest, &verGoWest, &verGoSouthwest, &verGoSouth, &verGoUp, &verGoDown]
  dirlist = [&goNorth, &goNortheast, &goEast, &goSoutheast, &goNorthwest, &goWest, &goSouthwest, &goSouth, &goUp, &goDown]

  /*
   * Testing flag to allow certain functions to check verGoX and goX
   *   direction methods without changing the game state. Set this flag to
   *   'true' before calling the direction method. If you change the game
   *   state within any of these methods, this must be conditioned on the 
   *   'justTesting' flag being set to 'nil', otherwise the game state may be 
   *   changed invisibly.
   */
  justTesting = nil

  /*
   * Flags to determine if the time, date, and score are displayed in the
   * status bar.
   */
  timedisp = nil
  datedisp = nil
  scoredisp = true

  /*
   * Properties for autosave functions.
   */
  autosavefile = nil
  autosavestatus = nil
  turnsbetweensaves = 10

;
