//
//  XTHtmlTagUl.m
//  TadsTerp
//
//  Created by Rune Berg on 09/07/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import "XTHtmlTagUl.h"
#import "XTHtmlTag_private.h"
#import "XTHtmlListAttrs.h"
#import "XTOutputFormatterProtocol.h"
#import "XTPair.h"


@implementation XTHtmlTagUl

+ (NSString *)name
{
	return @"ul";
}

- (XTFormattingSpecification *)makeFormattingSpecificationFrom:(XTFormattingSpecification *)formattingSpec
{
	XTFormattingSpecification *res = [super makeFormattingSpecificationFrom:formattingSpec];
	
	res.listBulletType = XT_LIST_BULLET_TYPE_UNSPECIFIED;

	for (XTPair *attrNameAndValue in self.attributesArray) {

		if ([self attributeNameAndValue:attrNameAndValue hasName:@"plain"]) {
			res.listBulletType = XT_LIST_BULLET_TYPE_UL_PLAIN;
		} else if ([self attributeNameAndValue:attrNameAndValue hasName:XT_LIST_BULLET_TYPE_ATTR_NAME withCaseInsensitiveValue:XT_LIST_BULLET_TYPE_ATTR_VALUE_DISC]) {
			res.listBulletType = XT_LIST_BULLET_TYPE_DISC;
		} else 	if ([self attributeNameAndValue:attrNameAndValue hasName:XT_LIST_BULLET_TYPE_ATTR_NAME withCaseInsensitiveValue:XT_LIST_BULLET_TYPE_ATTR_VALUE_SQUARE]) {
			res.listBulletType = XT_LIST_BULLET_TYPE_SQUARE;
		} else 	if ([self attributeNameAndValue:attrNameAndValue hasName:XT_LIST_BULLET_TYPE_ATTR_NAME withCaseInsensitiveValue:XT_LIST_BULLET_TYPE_ATTR_VALUE_CIRCLE]) {
			res.listBulletType = XT_LIST_BULLET_TYPE_CIRCLE;
		}
	}
	
	return res;
}

@end
