//
//  XTTextTableBlockCaption.m
//  XTads
//
//  Created by Rune Berg on 15/09/2021.
//  Copyright © 2021 Rune Berg. All rights reserved.
//

#import "XTTextTableBlockCaption.h"
#import "XTTextTableBlock_private.h"
#import "XTTableDimensionsTracker.h"
#import "XTFontUtils.h"
#import "XTTextView.h"


@implementation XTTextTableBlockCaption

/*TODO !!! rm
- (XTHtmlColor *)backgroundHtmlColor
{
	return nil;
}

- (void)setBackgroundHtmlColor:(XTHtmlColor *)htmlColor
{
	// Nothing
	int brkpt = 1;
}*/

- (instancetype)initWithTable:(NSTextTable *)table
				  startingRow:(NSInteger)row
					  rowSpan:(NSInteger)rowSpan
			   startingColumn:(NSInteger)col
				   columnSpan:(NSInteger)colSpan
					 textView:(XTTextView *)textView;
{
	XTTextTableBlockCaption *res = [super initWithTable:table startingRow:row rowSpan:rowSpan startingColumn:col columnSpan:colSpan];
	res.textView = textView;
	return res;
}

- (NSRect)rectForLayoutAtPoint:(NSPoint)startingPoint
						inRect:(NSRect)rect
				 textContainer:(NSTextContainer *)textContainer
				characterRange:(NSRange)charRange
{
	XTTableDimensionsTracker *tracker = [XTTableDimensionsTracker tracker];
	NSTextStorage *textStorage = textContainer.layoutManager.textStorage;

	NSRect res = [super rectForLayoutAtPoint:startingPoint inRect:rect textContainer:textContainer characterRange:charRange];
	
	// Calc. the actual content rect width
	//----------------------------------------------------
	
	CGFloat tableLevelBoundsSize = [self totalTableLevelBoundsWidth];
	
	CGFloat usableWidth = rect.size.width;
	usableWidth -= self.inheritedHeadIndent;
	usableWidth += self.inheritedTailIndent; // because it's a negative number or 0
	usableWidth -= tableLevelBoundsSize;
	CGFloat contentRectWidth = [tracker contentRectWidthForTable:self.tableId textTableBlockCaption:self usableWidth:usableWidth];
	
	CGFloat minContentRectWidth = [XTFontUtils widthOfLongestIndivisibleWordInTextStorage:textStorage
																			range:charRange
																numCharsInLongest:nil];
	[tracker noteMinCaptionContentRectWidthForTable:self.tableId width:minContentRectWidth];
	if (contentRectWidth < minContentRectWidth) {
		contentRectWidth = minContentRectWidth;
	}

	res.size.width = contentRectWidth;

	// Calc. the actual content rect height
	//----------------------------------------------------

	NSAttributedString *attrString = [textStorage attributedSubstringFromRange:charRange];
	NSSize viewSize = NSMakeSize(contentRectWidth, 999999.0);
	NSSize requiredContentRectSize = [XTFontUtils requiredRectForText:attrString
													  forViewOfSize:viewSize
										   suppressCenterAndRightTabs:YES];
	CGFloat contentRectHeight = requiredContentRectSize.height;
	
	res.size.height = contentRectHeight;
	
	return res;
}

/*TODO !!! rm if not needed:
- (CGFloat)widthForLayer:(NSTextBlockLayer)layer edge:(NSRectEdge)edge
{
	CGFloat superRes = [super widthForLayer:layer
									   edge:edge];
	return 0.0;
}*/

@end
