//
//  XTGameWindowController.h
//  TadsTerp
//
//  Created by Rune Berg on 14/03/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "XTGameRunnerProtocol.h"
#import "XTCommandHistory.h"
#import "XTVmThread.h"


@interface XTGameWindowController : NSWindowController <NSWindowDelegate, NSTextViewDelegate, XTGameRunnerProtocol>

@property BOOL gameIsT3;
@property XTVmThread *tadsEventLoopThread;
@property BOOL gameIsRunning;
@property BOOL hasExitedVmThread;
@property NSUInteger countNotifyMainThreadThatGameWindowClosed;
@property (readonly) NSURL *gameFileUrl;
@property XTCommandHistory *commandHistory;

+ (XTGameWindowController *)controller;

- (NSString *)getVmThreadName;

- (BOOL)canLoadAndStartGameFile;

- (BOOL)loadAndStartGameFile:(NSURL *)gameFileUrl;

- (BOOL)confirmQuitGameIfRunning:(NSString *)informativeText;

- (BOOL)confirmQuitTerpIfGameRunning:(NSString *)informativeText;

- (BOOL)quitGameIfRunning;

- (void)closeWindow;

- (void)cleanupAtVmThreadExit;

//TODO clumsy to have this here
- (BOOL)handleSelectAll;

//TODO clumsy to have this here?
- (BOOL)isWaitingForKeyPressed;

//TODO clumsy to have this here?
- (void)exitingTagBanner;

//TODO clumsy to have this here?
- (BOOL)handleClickedOnLinkAsTadsVmEvent:(NSString *)linkString;

@end
