//
//  XTOutputFormatter.h
//  TadsTerp
//
//  Created by Rune Berg on 09/07/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//
//  Transforms
//		a stream of text|whitespace|tag elements
//	into
//		a stream of XTFormattedOutputElement with attributed strings suitable for game output.
//

#import <Foundation/Foundation.h>
#import "XTOutputFormatterProtocol.h"

@class XTTextView;


@interface XTOutputFormatter : NSObject <XTOutputFormatterProtocol>

@property (unsafe_unretained) XTTextView *textView;

@property BOOL htmlMode;
@property BOOL isForT3;
@property BOOL isForBanner;
@property BOOL tagBannerMode;
@property BOOL receivingGameTitle;

- (void)teardown;

- (void)resetFlags;

- (void)resetForNextCommand;

//TODO ren ...Output
- (NSArray *)formatElement:(id)element;

- (NSArray *)flushPendingWhitespace;

- (NSAttributedString *)formatOutputText:(NSString *)string;

- (NSAttributedString *)formatInputText:(NSString *)string;

- (NSAttributedString *)formatStringForGridBanner:(NSString *)string;

- (NSFont *)getCurrentFontForOutput;

- (NSFont *)getCurrentFontForGridBanner;

- (void)recalcAllTabStops;

- (void)removeTabStopAtRhsOfWindow;

@end
