//
//  XTVmHostIfc.h
//  TadsTerp
//
//  Created by Rune Berg on 24/05/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//


#ifndef __TadsTerp__XTVmHostIfc__
#define __TadsTerp__XTVmHostIfc__

#include <iostream>

#include "vmhost.h"
#include "resload.h"
#include "appctx.h"
//TODO ? #include "config.h"


/* Host application interface.  This provides a bridge between the T3 VM host
 * interface (class CVmHostIfc) and the TADS 2 application context (struct
 * appctxdef) mechanism.
 */
class XTVmHostIfc: public CVmHostIfc {
private:
    appctxdef* fAppctx;
    CResLoader* fCmapResLoader;

public:
    XTVmHostIfc( struct appctxdef* appctx );
	
    ~XTVmHostIfc() override;

    int
    get_io_safety_read() override;

	int
	get_io_safety_write() override;

	void
	set_io_safety( int readLvl, int writeLvl ) override;

	void
	get_net_safety( int* client_level, int* server_level ) override;

	void
	set_net_safety( int /*client_level*/, int /*server_level*/ ) override;

	class CResLoader*
	get_sys_res_loader() override;

	void
	set_image_name( const char* fname ) override;

	void
	set_res_dir( const char* fname ) override;

	int
	add_resfile( const char* fname ) override;

	int
	can_add_resfiles() override;

	void
	add_resource( unsigned long ofs, unsigned long siz, const char* res_name, size_t res_name_len,
				 int fileno ) override;

	void
	add_resource( const char* fname, size_t fname_len, const char* res_name, size_t res_name_len) override;

	const char*
	get_res_path() override;

	int
	resfile_exists( const char* res_name, size_t res_name_len ) override;

	osfildef*
	find_resource( const char* res_name, size_t res_name_len, unsigned long* res_size ) override;

	vmhost_gin_t
	get_image_name( char* buf, size_t buflen ) override;

	void
	get_special_file_path( char* buf, size_t buflen, int id ) override;
};

#endif /* defined(__TadsTerp__XTVmHostIfc__) */
