//
//  XTTextView.h
//  XTads
//
//  Created by Rune Berg on 28/01/2017.
//  Copyright © 2017 Rune Berg. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "XTPrefs.h"
#import "XTOutputFormatter.h"


@interface XTTextView : NSTextView

@property XTPrefs *prefs;

@property (weak) XTOutputFormatter *outputFormatter;

@property (readonly) CGFloat leftRightInset;
@property (readonly) CGFloat topBottomInset;

- (void)customInit;

- (void)teardown;

- (void)syncWithPrefs;

- (CGFloat)findTotalWidthAdjustedForInset;

- (CGFloat)findYCoordOfInsertionPoint;

- (BOOL)shouldLogDodgyReturnFromFindYCoordOfInsertionPoint;
	//TODO mv to private .h

- (CGFloat)findXCoordOfInsertionPointRaw;

- (CGFloat)findStartXCoordOfTextInRange:(NSRange)range;

- (CGFloat)findEndXCoordOfTextInRange:(NSRange)range;

- (void)ensureLayoutForTextContainer;

- (void)setInsertionPointAtEndOfText;

- (CGFloat)findCoordOfTabAtRhsOfView;

- (CGFloat)findCoordOfTabAtHalfwayToRhsOfViewFromLoc:(CGFloat)fromLoc;

//TODO mv these to formatter:

- (BOOL)tabStopIsAtRhsOfView:(NSTextTab *)textTab;

- (BOOL)tabStopIsAtHalfwayToRhsOfView:(NSTextTab *)textTab;

- (BOOL)tabStopIsToId:(NSTextTab *)textTab;

- (BOOL)tabStopIsAtMultiple:(NSTextTab *)textTab;

- (BOOL)tabStopIsAtFixedPos:(NSTextTab *)textTab;

- (CGFloat)findTotalHeight;

- (CGFloat)findVisibleHeight;

@end
