#charset "us-ascii"

/*
 *   TADS 3 Action Report Combiner. A sample file illustrating how this
 *   extension can be used. This source file cannot be compiled on its own.
 *   The best way to test it is simply to add it to the sample game that
 *   accompanies the TADS 3 distribution, or to one of your own projects
 *   (and along with the extension itself, of course), and then compile
 *   that.
 *
 *   In the TADS 3 sample game, you can see how things work by typing the
 *   following command when the player is together with Bob in the dining
 *   room:
 *
 *   > BOB, GO NORTH
 *
 *   The action should be summarized in a single sentence.
 */

#include <adv3.h>
#include <en_us.h>

/* ---------------------------------------------------------------------- */
/*
 *   We have a slight problem. We want to replace the message saying that an
 *   NPC leaves through a door, but if we use the report tracing mode, we
 *   find that this message is actually built up by several reports. One of
 *   them prints the name of the traveler, another prints a space character,
 *   and so on.
 *
 *   We could write a pattern for matching all of these little reports, but
 *   to make things easier, we'll replace the message with a single report
 *   from a new report class.
 */
modify libMessages
    sayDepartingThroughPassage(traveler, passage)
    {
        /*
         *   Make sure that the traveler is an actor. Our report won't work
         *   for vehicles.
         */
        if (traveler.ofKind(Actor))
        {
            gTranscript.addReport(
                new DepartingThroughPassageReport(traveler, passage));
        }
        else
            inherited(traveler, passage);
    }
;

/*
 *   Define a special report class for departing through a passage.
 */
class DepartingThroughPassageReport: MainCommandReport
    construct(traveler, passage)
    {
        /* remember the traveler and the passage */
        self.traveler = traveler;
        self.passage = passage;

        /* set up the necessary message parameters */
        gMessageParams(traveler, passage);

        /* recreate the standard message and continue as usual */
        inherited('{The traveler/he} {leaves} '
            + traveler.travelerRemoteLocName
            + ' through {the passage/him}. ');
    }

    traveler = nil
    passage = nil
;

/* ---------------------------------------------------------------------- */
/*
 *   Define a rule class for combining the reports of first opening a door,
 *   then leaving through it.
 */
combineOpenLeaveRule: CombineReportsRule
    /*
     *   Our report sequence pattern. We match an okayOpenMsg report
     *   followed by the departing report defined above.
     */
    pattern =
    [
        { x: x.messageProp_ == &okayOpenMsg
        },
        { x: x.ofKind(DepartingThroughPassageReport)
        }
    ]

    /* combine a matching sequence of reports */
    combineReports(open, leave)
    {
        /*
         *   check that the actor from the opening action is the same as the
         *   traveler from the second report, and that the opened object is
         *   the same as the passage traversed
         */
        if (open.action_.actor_ != leave.traveler
            || open.action_.dobjCur_ != leave.passage)
            return nil;

        /* extract the actor and the passage */
        local who = leave.traveler;
        local passage = leave.passage;

        /* set up the necessary message parameters */
        gMessageParams(who, passage);

        /* return the combined message */
        return '{The who/he} open{s/ed} {the passage/him} and
            {leaves who}. ';
    }
;

