#charset "us-ascii"

/*
 *   MegaTADS. Additions and modifications to the msg_neu.t file.
 *
 *   Copyright 2007, Krister Fundin.
 */

#include <adv3.h>
#include <en_us.h>

#include "mega.h"
#include "mega_en_us.h"

/* ---------------------------------------------------------------------- */
/*
 *   Add some new library messages.
 */

#ifdef MEGA_GRAMMAR_ON

modify libMessages

    /*
     *   The player has answered NOTHING or something similar when faced
     *   with a query for a missing object or a disambiguation questions.
     *   Explain that it isn't necessary to answer these questions.
     */
    abortQuestion()
    {
        "<.parser>Fine, but note that when the story asks a question like
        this one, it&rsquo;s possible to simply enter a different command
        instead of answering it.<./parser> ";
    }

;

#endif

/* ---------------------------------------------------------------------- */
/*
 *   Parser messages for the player.
 */

#ifdef MEGA_LOCATIONAL_ON

modify playerMessages
    /*
     *   The player has entered a noun phrase such as THE KEY IN THE BOX,
     *   but there was no key in the box. We replace this message so that it
     *   reflects the containment type used by the player. If the played
     *   typed THE KEY UNDER THE BOX, then we'll say "you see no key under
     *   the box" instead of "you see no key IN the box", which would have
     *   been the case otherwise.
     */
    replace noMatchForLocation(actor, loc, txt)
    {
        "<.parser>\^<<actor.nameSees>> no <<txt>>
        <<loc.badContType.objInPrep>> <<loc.theName>>.<./parser> ";
    }
;

#endif

/* ---------------------------------------------------------------------- */
/*
 *   Add some new player action messages.
 */
modify playerActionMessages

#ifdef MEGA_SAYTOPIC_ON

    /*
     *   The message that we print when trying to say a literal with no
     *   explicit target actor and when we can't find a default one. We'll
     *   use the same message as all the other types of conversation.
     */
    sayLiteralMsg = (addressingNoOneMsg)

#endif

#ifdef MEGA_USE_ON

    /*
     *   a default message when trying to USE something which doesn't have a
     *   single obvious use
     */
    vagueUseMsg =
        ('<.parser>You need to be more specific about how '
         + (gActor.referralPerson == ThirdPerson
            ? 'you want {the actor/him}' : '')
         + ' to use {subj actor}{the dobj/him}.<./parser> ')

#endif

#ifdef MEGA_UNACTOR_ON

    /* Unactor messages */
    unactorNotHereMsg(who)
    {
        gMessageParams(who);

        return '{The who/he} {is}n\'t {|t}here. ';
    }
    unactorLastSeenMsg(who, srcLoc)
    {
        gMessageParams(who);

        return 'The last place {you/he} {saw|had seen} {the who/him} was ' +
            srcLoc.getDestName(gActor, gActor.location) + '. ';
    }
    unactorHasLeftMsg(who)
    {
        gMessageParams(who);

        return '{The who/he} {has} left. ';
    }

#endif

;

