#charset "us-ascii"

/*
 *   MegaTADS. Additions and modifications to the objects.t file.
 *
 *   Copyright 2007, Krister Fundin.
 */

#include <adv3.h>

#include "mega.h"

/* ---------------------------------------------------------------------- */
/*
 *   Amend the BasicContainer and Surface classes to only recognize the 'in'
 *   and 'on' containment types, respectively.
 */

#ifdef MEGA_LOCATIONAL_ON

modify BasicContainer
    contTypes = [inContType, genericContType]
;

modify Surface
    contTypes = [onContType, genericContType]
;

#endif

/* ---------------------------------------------------------------------- */
/*
 *   Add remappings for the USE verb to a few classes.
 */

#ifdef MEGA_USE_ON

modify Button
    /* using a button usually means pushing it */
    dobjFor(Use) remapTo(Push, self)
;

modify Dial
    /*
     *   using a dial usually means setting it to something - remapping to
     *   the generic Set action means that we'll ask for a setting
     */
    dobjFor(Use) remapTo(Set, self)
;

modify Lever
    /* using a lever usually means pulling it */
    dobjFor(Use) remapTo(Pull, self)
;

modify Wearable
    /* using a wearable item usually means wearing it */
    dobjFor(Use) remapTo(Wear, self)
;

#endif

