#charset "us-ascii"

/*
 *   MegaTADS. Additions and modifications to the thing.t file.
 *
 *   Copyright 2007, Krister Fundin.
 */

#include <adv3.h>

#include "mega.h"

/* ---------------------------------------------------------------------- */
/*
 *   The Thing class.
 */
modify Thing

#ifdef MEGA_LOCATIONAL_ON

    /*
     *   A list of legal containment types for this object. This affects how
     *   we parse locational phrases. If, for instance, the list includes
     *   underContType, then any objects contained by us can be referred to
     *   as being under us in a command. By default, we'll allow 'in' and
     *   'on' plus some more generic variants like 'by' for our contents.
     */
    contTypes = [inContType, onContType, genericContType]

    /*
     *   determine whether we are contained by a given object through a
     *   specific containment type
     */
    isNominallyInWithContType(obj, contType)
    {
        /*
         *   if we are not nominally inside the given object, then it
         *   doesn't what the containment type is
         */
        if (isNominallyIn(obj) == nil)
            return nil;

        /*
         *   Ask the container if it contains us. We take this extra step to
         *   allow for ComplexContainers, which can contain objects in
         *   several ways.
         */
        return (obj.containsWithContType(self, contType));
    }

    /*
     *   determine whether an object, which is already known to be contained
     *   by us, is contained through a certain containment type
     */
    containsWithContType(obj, contType)
    {
        /*
         *   Check our list of valid containment types. If the type we're
         *   being asked about is in the list, then return true.
         */
        return (contTypes.indexOf(contType) != nil);
    }

#endif

#ifdef MEGA_INTERJECT_ON

    /* say an interjection to this object */
    dobjFor(SayInterjectionTo)
    {
        verify()
        {
            /* by default, we can't be talked to at all */
            illogical(&notAddressableMsg, self);
        }
    }

#endif

#ifdef MEGA_SAYTOPIC_ON

    /* say a literal phrase to this object */
    dobjFor(SayLiteralTo)
    {
        verify()
        {
            /* by default, we can't be talked to at all */
            illogical(&notAddressableMsg, self);
        }
    }

#endif

#ifdef MEGA_GRAMMAR_ON

    /*
     *   Change isDirectlyIn() to return true if the identity object of the
     *   thing's location is the container we're testing against. This way,
     *   contents of a ComplexContainer's subXxx components will be
     *   considered directly in the ComplexContainer.
     */
    isDirectlyIn(obj)
    {
        return (inherited(obj)
                || (location != nil
                    && location.getIdentityObject() == obj));
    }

    /*
     *   make sure that TAKE X FROM ROOM PART works by using isNominallyIn()
     *   instead of isIn()
     */
    dobjFor(TakeFrom)
    {
        verify()
        {
            /* 
             *   we can only take something from something else if the thing
             *   is (nominally) inside the other thing 
             */
            if (gIobj != nil && !self.isNominallyIn(gIobj))
                illogicalAlready(gIobj.takeFromNotInMessage);

            /* treat this otherwise like a regular "take" */
            verifyDobjTake();
        }
    }

    iobjFor(TakeFrom)
    {
        verify()
        {
            /* check what we know about the dobj */
            if (gDobj == nil)
            {
                /*
                 *   We haven't yet resolved the direct object; check the
                 *   tentative direct object list, and count us as
                 *   illogical if none of the possible direct objects are
                 *   (nominally) in me.
                 */
                if (gTentativeDobj.indexWhich(
                        { x: x.obj_.isNominallyIn(self) }) == nil)
                {
                    illogicalAlready(takeFromNotInMessage);
                }
                else if (gTentativeDobj.indexWhich(
                             { x: x.obj_.isDirectlyIn(self) }) != nil)
                    logicalRank(150, 'directly in');
            }
            else if (!gDobj.isNominallyIn(self))
            {
                /* 
                 *   the dobj isn't (nominally) in me, so it's obviously
                 *   not logical to take the dobj out of me 
                 */
                illogicalAlready(takeFromNotInMessage);
            }
            else if (gDobj.isDirectlyIn(self))
            {
                /* 
                 *   it's slightly more likely that they want to remove
                 *   the object from its direct container 
                 */
                logicalRank(150, 'directly in');
            }
        }
    }

#endif

#ifdef MEGA_USE_ON

    /*
     *   Action handling for the USE command. By default, we'll ask the
     *   player to be more specific about how to use the object, but some
     *   objects with a single, obvious use may want to remap this to a
     *   different action.
     */
    dobjFor(Use)
    {
        verify()
        {
            illogical(&vagueUseMsg);
        }
    }

    iobjFor(UseWith)
    {
        verify()
        {
            illogical(&vagueUseMsg);
        }
    }

#endif

;

