#charset "us-ascii"

/*
 *   Copyright (c) 1999, 2002 by Michael J. Roberts.  Permission is
 *   granted to anyone to copy and use this file for any purpose.    
 */

/* 
 *   Include the main header for the standard TADS 3 adventure library.
 *
 *   Also include the US English definitions, since this game is written
 *   in English.  
 */
#include <adv3.h>
#include <en_us.h>
#include "excitementobject.h"
#include "xactor.h"
  // 
  // Above rewritten to support separate compilation. 
  //
/*
 *   
 *   IMPORTANT - you must customize some of the text below, as marked.  
 */
PreinitObject
    execute()
    {
        local tab = new LookupTable();
        tab['Name'] = versionInfo.name;
        tab['Byline'] = versionInfo.byline;
        tab['HtmlByline'] = versionInfo.htmlByline;
        tab['AuthorEmail'] = versionInfo.authorEmail;
        tab['Version'] = versionInfo.version;
        tab['Desc'] = 'The Vampire is an erotic game.';
        tab['HtmlDesc'] = 'The Vampire is an erotic game.';
        tab['PresentationProfile'] = 'Multimedia';

        /* write the game information to GameInfo.txt */
        writeGameInfo(tab, 'GameInfo.txt');
    }
;

/*
 *   Our game credits and version information.  This object isn't required
 *   by the system, but our GameInfo initialization above needs this for
 *   some of its information.
 *   
 *   You should customize to provide the name of your game, your byline,
 *   and so on.  
 */
versionInfo: GameID
    name = 'The Vampire'
    byline = 'by Choices'
    htmlByline = 'by <a href="mailto:choices123@hotmail.com">
                  Choices IF</a>'
    authorEmail = 'Choices IF <choices123@hotmail.com>'
    version = '0.11'

    showCredit()
    {
        /* show our credits */
        "The game <b>The Vampire</B> is copyrighted (C) 2003 by Choices and
         contributers. All rights are reserved. This game is licensed under 
         the Open Software License version 1.1. A copy of this license should
         be a part of this archive.";

        "\b";
    }
    showAbout()
    {
      "The game <B>The Vampire</B> game is going to be an ongoing open source 
       project\, developed as a technology demonstrator and distributed as 
       part of the xactor library. Unlike other portions of the library\, the
       vampire portion has an open source license that forces distribution of
       derivative works <i>in source.</i>";
    }
;

/* 
 *   Starting location - we'll use this as the player character's initial
 *   location.  
 */
vampireHb : HeartBeatObject
  heartBeatList = [ vampireMMX, foodMMX, vampire, food, vampire_pussy ]
;

startRoom: Room 
  name = 'Outside\, on the Ground'
  desc
  {
  "A miserable place to be..The ground is cold and wet. A large tree rises 
  up from the ground\, and the branches extend into a nearby house.";
    if ( ! initialized ) {
      new Daemon( vampireHb , &hbDaemon, 1);
      initialized = true;
    }
  }
  initialized = nil
  up=uptree
;
uptree: Room 'High in the Tree'
  "High in the branches of a tree\, it is easy to look into the bedroom of the nearby house
   through the large full-length window. The jump to the ledge of the window would kill a
   mere mortal\, but that\'s not the kind of barrier that would stop you\, now would it? "
   down = startRoom
   in = windowOutside
;
  //
  // We'll need to code breakable locks and look through verbs soon.
  //
+ windowOutside : Door 'house room food window' 'window to inside'
  " It\'s a glass window\, which leads into the room inside. It\'s <<openDesc>>. "
  travelBarrier = [ nakedBarrier ]
;

inHouse: Room 'In the House'
  "It\'s the ornate bedroom of a two story house\, the room of a wealthy family. "
  out=windowInside
;
+ windowInside : Door -> windowOutside 'house window' 'outside window'
  " It\'s a glass window\, which leads to the outside. It\'s <<openDesc>>. "
  travelBarrier = [ nakedBarrier, foodBarrier, foodclothesBarrier ]
;

+ foodBed: Bed 'bed' 'bed'
 " It\'s a bed. "
;
  //
  // I like putting things that move on and off the playing field here.
  //
offStage : Room 'offstage'
" Things not on the grid yet are stored here. "
;
myInit : InitObject
  execute()
  {
     //
     // This isn't essential, but it reduces the possibility of 
     // constant simultaneous orgasms.
     //
    vampire.setSensitivity(85);
    food.setSensitivity(125);
  }
;
/*
 *   Main entrypoint. 
 */
main(args)
{
    /* show our introductory message */
    "Welcome to the sample game <B>The Vampire</B>. This game is provided as
     part of the xactor library archive and is copyrighted (C) 2003 by Choices
     and collaborators. All rights are reserved. This game file and the
     files vampire.t and food.t are licensed under the Open Software License 
     version 1.1. Source code should be provided with this package and this
     package should not be distributed apart from source or apart from the
     xactor library. \b";

    gPlayerChar = vampire;

    runGame(true);

    /* the game is now over - show our farewell message */
    "<.p>Thanks for playing!\b";
}
