# $NetBSD: directive-for-generating-endif.mk,v 1.2 2023/06/01 20:56:35 rillig Exp $
#
# Test whether a .for loop can be used to generate multiple .endif
# directives to close nested .if directives.  Depending on the exact
# implementation, this might have been possible.
#
# If it were possible, the 3 .if directives would perfectly match the
# 3 .endif directives generated by the .for loop.
#
# After the "included file" from the .for loop, the 3 .if directives
# are still open.
#
# See For_Run and ParseReadLine.  Each .for loop is treated like a separately
# included file, and in each included file the .if/.endif directives must be
# balanced.

.if 1
.  if 2
.    if 3
.for i in 3 2 1
# expect+3: if-less endif
# expect+2: if-less endif
# expect+1: if-less endif
.endif
.endfor

all:
	@:;
# expect+1: 3 open conditionals
