// Bmp.cpp: implementation of the Bmp class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "UItoSDK.h"
#include "Bmp.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

Bmp::Bmp()
{

}

Bmp::~Bmp()
{

}

HGLOBAL Bmp::OpenBmp(LPVOID& lpDIBBits, BITMAPINFO &bmInfo_, const char *fileName)
{	
	CFile file; 
	
	if( !file.Open( fileName, CFile::modeRead) )
		return FALSE;

	// Now read the file into hDIB
	bool retVal = TRUE;
	BITMAPFILEHEADER bmfHeader;

	// Read file header
	if (file.Read((LPSTR)&bmfHeader, sizeof(bmfHeader)) != sizeof(bmfHeader))
		return FALSE;

	// File type should be 'BM'
	if (bmfHeader.bfType != ((WORD) ('M' << 8) | 'B'))
		return FALSE;

	// Get length of the remainder of the file and allocate memory
	DWORD nPackedDIBLen = file.GetLength() - sizeof(BITMAPFILEHEADER);
	HGLOBAL hDIB = ::GlobalAlloc(GMEM_FIXED, nPackedDIBLen);
	if (hDIB == 0)
	{		 
		return false;
	}

	// Read the remainder of the bitmap file.
	if (file.ReadHuge((LPSTR)hDIB, nPackedDIBLen) != nPackedDIBLen )
	{
		::GlobalFree(hDIB);		 
		return false;
	}
	  
	BITMAPINFOHEADER &bmiHeader = *(LPBITMAPINFOHEADER)hDIB ;
	BITMAPINFO &bmInfo = *(LPBITMAPINFO)hDIB ;
	BITMAPINFO_AL biAl;
	memmove(&biAl, (BITMAPINFO_AL*)hDIB, min(sizeof (biAl),nPackedDIBLen)); 

	// If bmiHeader.biClrUsed is zero we have to infer the number
	// of colors from the number of bits used to specify it.
	int nColors = bmiHeader.biClrUsed ? bmiHeader.biClrUsed : 
						1 << bmiHeader.biBitCount;
	
	if( bmInfo.bmiHeader.biBitCount > 8 )
		lpDIBBits = (LPVOID)((LPDWORD)(bmInfo.bmiColors + bmInfo.bmiHeader.biClrUsed) + 
			((bmInfo.bmiHeader.biCompression == BI_BITFIELDS) ? 3 : 0));
	else
		lpDIBBits = (LPVOID)(bmInfo.bmiColors + nColors);

	int  pixelPerMeter = bmiHeader.biYPelsPerMeter;
	bmInfo_ = bmInfo;	

	return hDIB; 
}


HBITMAP Bmp::CnvToDibSec1(LPVOID lpDIBBits, BITMAPINFO &bmInfo)
{
	BITMAPINFO_AL infoAl;
	memset(&infoAl,0, sizeof(infoAl));
	infoAl.bmiHeader = bmInfo.bmiHeader;
	
	infoAl.bmiHeader.biClrUsed = 2;
	infoAl.bmiHeader.biClrImportant =2;
	infoAl.bmiHeader.biBitCount = 1;
	infoAl.bmiColors[0].rgbBlue = infoAl.bmiColors[0].rgbGreen =
		infoAl.bmiColors[0].rgbRed = 255;
	infoAl.bmiColors[1].rgbBlue = infoAl.bmiColors[1].rgbGreen =
		infoAl.bmiColors[1].rgbRed = 0;

	
	CClientDC dc(NULL);
	unsigned char* pDIBitsBuff;
	void** ppvBits = ( void** )&pDIBitsBuff;
	HBITMAP hBmpDS = CreateDIBSection( dc.m_hDC, (BITMAPINFO*)&infoAl,
			DIB_RGB_COLORS, ppvBits, NULL, NULL);
	
	if ( hBmpDS == NULL )
	{
		ASSERT(0);
		return NULL;
	}	

	// now fill this bmp with data
	int nCopiesLines = ::SetDIBits(
			dc.m_hDC,
			hBmpDS,
			0,
			bmInfo.bmiHeader.biHeight,
			lpDIBBits,
			&bmInfo, 
			DIB_RGB_COLORS);
	
	ASSERT( nCopiesLines == bmInfo.bmiHeader.biHeight);

	return hBmpDS;
}


HBITMAP Bmp::LoadBmpAsDibSec1(int &ppm, const char *fileName)
{
	BITMAPINFO bmInfo;

	LPVOID lpDIBBits; 
	HGLOBAL hBmp = OpenBmp(lpDIBBits, bmInfo, fileName);
	if ( hBmp == NULL )
		return NULL;

	HBITMAP hBmpDS = CnvToDibSec1(lpDIBBits, bmInfo );
	::GlobalFree(hBmp);

	ppm = bmInfo.bmiHeader.biXPelsPerMeter;		
	return hBmpDS;
}

