// SmDraw.cpp: implementation of the SmDraw class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "SmDraw.h"
//#include "..\..\diblib\diblib.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

SmDraw::SmDraw()
{

}

SmDraw::~SmDraw()
{

}

// this function return true if succesful.
// Given nWindowExt, drTopLeft, drWidth, sourceRct
// it fills the nViewPortExt and viewPortOrg in such a way
// that the source rectangular sourceRct is mapped ( when drawn) into
// a draw rectangular with the top left corner at drTopLeft
// and width drWidth.
// This function is intended to be used in "Fit to Window"
bool SmDraw::getFitToWndViewPortExt(int &nViewPortExt, int nWindowExt, 
	CPoint drTopLeft, int drWidth, CRect sourceRct)
{
	int sourceWidth = sourceRct.Width();
	if ( sourceWidth == 0 ) 
	{
		ASSERT(0);
		return false;
	}
	double scale = (double) drWidth / (double) sourceWidth;	
	nViewPortExt = (int)(nWindowExt * scale);	

	return true;
}

void SmDraw::paintBetweenRctgs(const CRect &clntRct,
		const CRect &innerRct, CDC *pDC, COLORREF color)
{
	if (pDC == NULL ||
		clntRct.left > innerRct.left ||
		clntRct.right < innerRct.right ||
		clntRct.top > innerRct.top ||
		clntRct.bottom < innerRct.bottom 
			
		)
	{
//		ASSERT(0);
		return;
	}
	CBrush brush( color );
	CBrush* pBrushOld = (CBrush*) 
		pDC->SelectObject( &brush );
	if ( pBrushOld == NULL )
	{
		ASSERT(0);
		return;
	}

	int mapeModeOld = pDC->SetMapMode( MM_TEXT );
	CPoint viewPrtOrgOld = pDC->SetViewportOrg(0,0);

	CPoint point1_t_r( innerRct.left, clntRct.top);
	CPoint point1_b_l( clntRct.left, innerRct.top);

	CPoint point2_t_l( innerRct.right, clntRct.top );
	CPoint point2_b_r( clntRct.right, innerRct.top );
	CPoint point2_t_r( clntRct.right, clntRct.top );
	CPoint point2_b_l( innerRct.right, innerRct.top );

	CPoint point3_t_r( clntRct.right,innerRct.bottom );
	CPoint point3_b_l( innerRct.right, clntRct.bottom );
	
	CPoint point4_t_l( clntRct.left, innerRct.bottom );
	CPoint point4_b_r( innerRct.left, clntRct.bottom );
	CPoint point4_t_r( innerRct.left, innerRct.bottom );
	CPoint point4_b_l( clntRct.left, clntRct.bottom );

	CRgn rgn;
	CPoint points[20];
	points[0]	= points[4] = clntRct.TopLeft( );
	points[1]   = point1_t_r;
	points[2]	= point4_b_r;
	points[3]   = point4_b_l;

	points[5]	= points[9] = point1_t_r;
	points[6]   = point2_t_l;
	points[7]	= point2_b_l;
	points[8]   = innerRct.TopLeft( );

	points[10]	= points[14] = point2_t_l;
	points[11]  = point2_t_r;
	points[12]	= clntRct.BottomRight();
	points[13]  = point3_b_l;

	points[15]	= points[19] = point4_t_r;
	points[16]  = innerRct.BottomRight();
	points[17]	= point3_b_l;
	points[18]  = point4_b_r;	

	int counts[4];
	counts[0] = counts[1] = counts[2] = counts[3] = 5;
	rgn.CreatePolyPolygonRgn( points, counts, 4, ALTERNATE );
	
	BOOL retVal = pDC->PaintRgn( &rgn );
	pDC->SetMapMode( mapeModeOld );
	pDC->SetViewportOrg( viewPrtOrgOld );
	if ( !retVal )
	{
		ASSERT(0);
		return;
	}
	pDC->SelectObject( pBrushOld );
}

void SmDraw::fillRct(const CRect &rect, COLORREF color,CDC* pDC)
{
	CBrush brush( color );	
	pDC->FillRect( &rect, &brush );	
}

// this function scales and merges srcRect into the trgRct
// accordint the align parameter. It fills drRect members.
// This drRect is the rectangular to draw in.
bool SmDraw::getDrawRect(CRect &drRct, const CRect &trgRct, 
						 const CRect &srcRect, Align align)
{
	int sizeTargX = trgRct.Width();
	int sizeTargY = trgRct.Height();
	int sizeSourceX = srcRect.Width();
	int sizeSourceY = srcRect.Height();

	ASSERT( sizeTargX > 0 );
	ASSERT( sizeTargY > 0 );	
	ASSERT( sizeSourceX > 0);
	ASSERT( sizeSourceY > 0);
	if ( sizeSourceX < 1 || sizeSourceY < 1 
		|| sizeTargX < 1 || sizeTargY < 1) return false;

	double ratioTarget = (double)sizeTargY / (double)sizeTargX;
	double ratioSource = (double)sizeSourceY / (double)sizeSourceX;

	int width, height;
	if ( ratioTarget > ratioSource )
	{
		width  =	(int) sizeTargX;
		height =	(int) (ratioSource * width );
	}
	else
	{
		height =	(int) sizeTargY;
		width  =	(int) (height / ratioSource );
	}

	int nWindowExt = DEFAULT_WINDOW_EXT;
	int nViewPortExt = (int) ( (double)nWindowExt * (double)width / (double) sizeSourceX);
	double scale = (double) nViewPortExt/ (double) nWindowExt;

	CRect rctSourceScaled = srcRect;
	rctSourceScaled.left	= (int) ( scale * (double) rctSourceScaled.left);
	rctSourceScaled.right	= (int) ( scale * (double) rctSourceScaled.right);
	rctSourceScaled.bottom	= (int) ( scale * (double) rctSourceScaled.bottom);
	rctSourceScaled.top		= (int) ( scale * (double) rctSourceScaled.top);
	
	drRct.left = trgRct.left;
	drRct.top  = trgRct.top;
	drRct.right = drRct.left + rctSourceScaled.Width();
	drRct.bottom = drRct.top + rctSourceScaled.Height();

	int halfDiff_X = ( trgRct.Width() - rctSourceScaled.Width() ) / 2;
	int halfDiff_Y = ( trgRct.Height() - rctSourceScaled.Height() ) / 2;
	switch(align)
	{
	case LEFT_TOP:;		
		break;
	case CENTER:
		drRct.OffsetRect(-halfDiff_X, halfDiff_Y);
		break;
	case RIGHT_TOP:;
		drRct.OffsetRect(2*halfDiff_X, 0);
		break;
	default :
		ASSERT(0);
	}
	return true;
}


/*  This function supports Zoom In and Zoom out. It provides that
	the point pointed to by the mouse occured at the position
	drawCenter after zooming. Intended for use in 
	OnLButtonDown(UINT nFlags, CPoint point) function.
*/
CPoint SmDraw::getNewViewPortOrg(CPoint viewPortOrgOld, 
		CPoint drawCenter, CPoint mouse, double newOldScaleRatio)
{
	int dX = (int) (( viewPortOrgOld.x - mouse.x ) 
		* newOldScaleRatio);
	int dY = (int) (( viewPortOrgOld.y - mouse.y ) 
		* newOldScaleRatio);
	CPoint viewPortOrgNew = drawCenter;
	viewPortOrgNew.x += dX;
	viewPortOrgNew.y += dY;
	return viewPortOrgNew;
}

bool SmDraw::simpleDIBDraw(RGBQUAD* pDIBits,int bmWidth, int bmHeight,
						   HDC hDC)
{	
	if ( pDIBits == NULL || hDC == NULL 
		|| bmWidth <= 0 || bmHeight <= 0 )
		return false;
	
	BITMAPINFO info;
	info.bmiHeader.biBitCount = 32;
	info.bmiHeader.biSize = sizeof (info.bmiHeader);
	info.bmiHeader.biClrImportant	= 0;
	info.bmiHeader.biClrUsed		= 0;
	info.bmiHeader.biCompression	= BI_RGB;
	info.bmiHeader.biHeight			= bmHeight;//BMP_FLIP*
	info.bmiHeader.biPlanes			= 1;
	info.bmiHeader.biSizeImage		= 0;
	info.bmiHeader.biWidth			= bmWidth;
	info.bmiHeader.biXPelsPerMeter	= 0;
	info.bmiHeader.biYPelsPerMeter	= 0;

	int oldmode=SetStretchBltMode(hDC,COLORONCOLOR);
	int retVal = StretchDIBits(hDC,  		  
		0, // x-coordinate of upper-left corner of dest. rectangle
		0, // y-coordinate of upper-left corner of dest. rectangle   
		bmWidth,// width of destination rectangle			
		bmHeight, // height of destination rectangle   
		0, // x-coordinate of upper-left corner of source rectangle   
		0, // y-coordinate of upper-left corner of source rectangle    
		bmWidth, // width of source rectangle
		bmHeight, // height of source rectangle
		pDIBits,  &info,  DIB_RGB_COLORS,  SRCCOPY 
		);

	SetStretchBltMode(hDC,oldmode);

	BOOL retS = retVal == bmHeight;
	ASSERT( retS );	
	return (retS == TRUE);
}

bool SmDraw::simpleDIBDraw(RGBQUAD* pDIBits,int bmWidth, 
			int bmHeight, HDC hDC, RECT* pRectToDraw)
{	
	if ( pDIBits == NULL || hDC == NULL 
		|| bmWidth <= 0 || bmHeight <= 0 )
		return false;
	int retVal(0);

	int oldmode=SetStretchBltMode(hDC,COLORONCOLOR);

	RECT rect;
	if (pRectToDraw)
	{
		rect = *pRectToDraw;
	}
	else
	{
		rect.bottom = bmHeight;
		rect.left = 0;
		rect.right = bmWidth;
		rect.top = 0;
	}


	BITMAPINFO info;
	info.bmiHeader.biBitCount = 32;
	info.bmiHeader.biSize = sizeof (info.bmiHeader);
	info.bmiHeader.biClrImportant	= 0;
	info.bmiHeader.biClrUsed		= 0;
	info.bmiHeader.biCompression	= BI_RGB;
	info.bmiHeader.biHeight			= rect.bottom;//BMP_FLIP*
	info.bmiHeader.biPlanes			= 1;
	info.bmiHeader.biSizeImage		= 0;
	info.bmiHeader.biWidth			= rect.right;
	info.bmiHeader.biXPelsPerMeter	= 0;
	info.bmiHeader.biYPelsPerMeter	= 0;

	if (pRectToDraw)
	{
		int pixNum = rect.bottom * rect.right;
		ASSERT( pixNum > 0 );
		if ( pixNum <= 0 ) return false;
		RGBQUAD* pTemp = new RGBQUAD[pixNum];
		if ( pTemp == NULL ) return false;
		for (int iX = 0; iX < rect.right; iX++)
		for (int iY = 0; iY < rect.bottom; iY++)
		{
			int iYFlip = rect.bottom - iY - 1;
			pTemp[iX + rect.right * iY] = pDIBits[rect.left + iX +
				bmWidth *(bmHeight - rect.top - 1 - iYFlip)];

		}

		
		retVal = StretchDIBits(hDC,  		  
			rect.left, // x-coordinate of upper-left corner of dest. rectangle
			rect.top, // y-coordinate of upper-left corner of dest. rectangle   
			rect.right,// width of destination rectangle			
			rect.bottom, // height of destination rectangle   
			0, // x-coordinate of upper-left corner of source rectangle   
			0, // y-coordinate of upper-left corner of source rectangle    
			rect.right, // width of source rectangle
			rect.bottom, // height of source rectangle
			pTemp,  &info,  DIB_RGB_COLORS,  SRCCOPY 
			); 
			delete pTemp;
	}
	else
	{
		retVal = StretchDIBits(hDC,  		  
			0, // x-coordinate of upper-left corner of dest. rectangle
			0, // y-coordinate of upper-left corner of dest. rectangle   
			bmWidth,// width of destination rectangle			
			bmHeight, // height of destination rectangle   
			0, // x-coordinate of upper-left corner of source rectangle   
			0, // y-coordinate of upper-left corner of source rectangle    
			bmWidth, // width of source rectangle
			bmHeight, // height of source rectangle
			pDIBits,  &info,  DIB_RGB_COLORS,  SRCCOPY 
			);
	}

	SetStretchBltMode(hDC,oldmode);
	BOOL retS = retVal == rect.bottom;
	ASSERT( retS );	
	return (retS == TRUE);
}

void SmDraw::doDIBitsGrayed(RGBQUAD* pDIBits,
				int pixelNum, int degree)
{
	if ( pDIBits == NULL || degree < 1 ) return;

	for ( int ic = 0; ic < pixelNum; ic++)
			{
				pDIBits[ic].rgbBlue = 255 -
					( 255 - pDIBits[ic].rgbBlue ) / degree;
				pDIBits[ic].rgbGreen = 255 -
					( 255 - pDIBits[ic].rgbGreen ) / degree;
				pDIBits[ic].rgbRed = 255 -
					( 255 - pDIBits[ic].rgbRed ) / degree;
			}
}

bool SmDraw::SimpleDraw(HBITMAP hBmp,HDC hDC,BITMAPINFO * pInfo, CRect* pBmRectVisible)
{
	if ( hBmp == NULL ) return false;
	BITMAP bmp;	
	::GetObject(hBmp,sizeof(bmp),&bmp);
	
	unsigned char* pDIBits = (unsigned char*) bmp.bmBits;
	int bmWidth		 = bmp.bmWidth;
	int bmHeight	 = bmp.bmHeight;
	
	CClientDC dc(NULL);
	HDC hDC_= dc.m_hDC;

	int top = bmHeight - pBmRectVisible->top -pBmRectVisible->Height()-1;
	
	int oldmode=SetStretchBltMode(hDC,COLORONCOLOR);
	int retVal = StretchDIBits(hDC,  		  
		pBmRectVisible->left, // x-coordinate of upper-left corner of dest. rectangle
		pBmRectVisible->
		top, // y-coordinate of upper-left corner of dest. rectangle   
		pBmRectVisible->Width()+1,// width of destination rectangle			
		pBmRectVisible->Height()+1, // height of destination rectangle   
		pBmRectVisible->left, // x-coordinate of upper-left corner of source rectangle   
//		pBmRectVisible->
		top, // y-coordinate of upper-left corner of source rectangle    
		pBmRectVisible->Width()+1, // width of source rectangle
		pBmRectVisible->Height()+1,//height of source rectangle
		pDIBits,  pInfo,  DIB_RGB_COLORS,  SRCCOPY 
		);
int wdth = pInfo->bmiHeader.biWidth;
	SetStretchBltMode(hDC,oldmode);
	return true;
}


/*
bool SmDraw::SimpleDraw(HBITMAP hBmp,HDC hDC,BITMAPINFO * pInfo)
{
	if ( hBmp == NULL ) return false;
	BITMAP bmp;	
	::GetObject(hBmp,sizeof(bmp),&bmp);
	
	unsigned char* pDIBits = (unsigned char*) bmp.bmBits;
	int bmWidth		 = bmp.bmWidth;
	int bmHeight	 = bmp.bmHeight;
	
	CClientDC dc(NULL);
	HDC hDC_= dc.m_hDC;

	int oldmode=SetStretchBltMode(hDC,COLORONCOLOR);
	int retVal = StretchDIBits(hDC,  		  
		0, // x-coordinate of upper-left corner of dest. rectangle
		0, // y-coordinate of upper-left corner of dest. rectangle   
		bmWidth,// width of destination rectangle			
		bmHeight, // height of destination rectangle   
		0, // x-coordinate of upper-left corner of source rectangle   
		0, // y-coordinate of upper-left corner of source rectangle    
		bmWidth, // width of source rectangle
		bmHeight, // height of source rectangle
		pDIBits,  pInfo,  DIB_RGB_COLORS,  SRCCOPY 
		);

	SetStretchBltMode(hDC,oldmode);
	return true;
}
*/

/*
bool SmDraw::SimpleDraw(HBITMAP hBmp, HDC hDC, 
		BITMAPINFO *pInfo, RECT *pRectToDraw)
{
	if (pRectToDraw == NULL)
	{
		return SimpleDraw( hBmp, hDC, pInfo);
	}

	if ( hBmp == NULL ) return false;
	BITMAP bmp;	
	::GetObject(hBmp,sizeof(bmp),&bmp);
	
	unsigned char* pDIBits = (unsigned char*) bmp.bmBits;
	int bmWidth		 = bmp.bmWidth;
	int bmHeight	 = bmp.bmHeight;

	if ( hDC == NULL || bmWidth <= 0 || bmHeight <= 0 )
		return false;

	RECT rect;
	if (pRectToDraw)
	{
		rect = *pRectToDraw;
		div_t div_result = div(rect.right, 4);
		int add = 4 - div_result.rem;
		if (add == 4) add = 0;
		rect.right += add;
	}
	else
	{
		rect.bottom = bmHeight;
		rect.left = 0;
		rect.right = bmWidth;
		rect.top = 0;
	}

	int oldmode=SetStretchBltMode(hDC,COLORONCOLOR);
	int retVal = StretchDIBits(hDC,  		  
		rect.left, // x-coordinate of upper-left corner of dest. rectangle
		rect.top, // y-coordinate of upper-left corner of dest. rectangle   
		rect.right,// width of destination rectangle			
		rect.bottom, // height of destination rectangle   
		0, // x-coordinate of upper-left corner of source rectangle   
		0, // y-coordinate of upper-left corner of source rectangle    
		rect.right, // width of source rectangle
		rect.bottom, // height of source rectangle
		//pTemp, 
		pDIBits,
		pInfo,  DIB_RGB_COLORS,  SRCCOPY 
		);

	SetStretchBltMode(hDC,oldmode);
//	if ( pTemp ) delete pTemp;

//	pInfo->bmiHeader.biWidth =  bmWidthOld;
//	pInfo->bmiHeader.biHeight = bmHeightOld;
	return true;
}
*/

// consider client as device coordinates
void SmDraw::GetVisiblePartOfBmp(CRect &visibleR,RECT client, 
	CPoint viewPortOrg, int bmWidth, int bmHeight, double scale)
{
	if ( scale < 0.0001 )
	{
		visibleR.bottom = 0;
		visibleR.top	= 0;
		visibleR.left   = 0;
		visibleR.right  = 0;
		return;
	}
	
	CRect clientLog;
	clientLog.bottom = (long)((client.bottom - viewPortOrg.y)/scale);
	clientLog.top	 = (long)((client.top	- viewPortOrg.y)/scale);
	clientLog.left   = (long)((client.left	- viewPortOrg.x)/scale);
	clientLog.right  = (long)((client.right	- viewPortOrg.x)/scale);

	
	CRect bmRect;
	bmRect.bottom = bmHeight-1;//bmHeight;
	bmRect.left = 0;
	bmRect.right = bmWidth-1;///bmWidth;
	bmRect.top = 0;

	BOOL ret = visibleR.IntersectRect(clientLog,bmRect);
	if ( !ret)
	{
		visibleR.bottom = 0;
		visibleR.top	= 0;
		visibleR.left   = 0;
		visibleR.right  = 0;
	}
	int top = visibleR.top;
	int bottom = visibleR.bottom;
	int left = visibleR.left;
	int right = visibleR.right;
}
