// vecim.cpp : Implementation of Cvecim
#include "stdafx.h"
#include "Vecom.h"
#include "vecim.h"

#include "../../../include/fio.h"
#include "../../../include/imgs.h"
#include "../../../include/vec.h"

/////////////////////////////////////////////////////////////////////////////
// Cvecim

CString g_settings;

HRESULT _stdcall Cvecim ::Test1( )
{
	AfxMessageBox("Ku-Ku");
	return S_OK;
}

HRESULT _stdcall Cvecim ::OpenRaster(  BSTR  fname, 
		long* pPixelperMeter, long* retval)
{	  
	int ppm;
	CString S(fname);
	HBITMAP hBmp = fio_openRaster(ppm, S );
	*retval = (long)hBmp; 
	*pPixelperMeter = ppm; 
	return S_OK;
}

HRESULT _stdcall Cvecim ::DelObject( long hBmp)
{
	void* pObj = (void*) hBmp;
	::DeleteObject(pObj);
	return S_OK;
}

HRESULT _stdcall Cvecim ::SaveRaster(BSTR fname, long hBitmap, 
		 long pixelPerMeter, BOOL* retval )
{
	CString S(fname);
	*retval = fio_saveRaster((HBITMAP)hBitmap,pixelPerMeter, S);
	return S_OK;
}



HRESULT _stdcall Cvecim ::RotateByLine(long hBmp,long pixelPerMeter, 
		long xBeg, long yBeg, long xEnd, long yEnd, long* retval)
{
	*retval = (long) imgs_rotateByLine((HBITMAP)hBmp, pixelPerMeter, 
		xBeg, yBeg, xEnd, yEnd);
	return S_OK;
}

HRESULT _stdcall Cvecim ::MirrorVertically(long hBmp,BOOL* retval)
{
	*retval = (long) imgs_mirrorVertically((HBITMAP)hBmp);
	return S_OK;
}

HRESULT _stdcall Cvecim ::RotateLeft(long hBmp,long pixelPerMeter, 
		long* retval)
{
	*retval = (long) imgs_rotateLeft((HBITMAP)hBmp, pixelPerMeter);
	return S_OK;
}

HRESULT _stdcall Cvecim ::RotateRight(long hBmp,long pixelPerMeter,
		long* retval)
{
	*retval = (long) imgs_rotateRight((HBITMAP)hBmp, pixelPerMeter);
	return S_OK;
}

HRESULT _stdcall Cvecim ::Negate(long hBmp, BOOL* retval)
{
	*retval = imgs_negate((HBITMAP)hBmp);
	return S_OK;
}

HRESULT _stdcall Cvecim ::Crop(long hBmp,long pixelPerMeter,long xTopLeft,long yTopLeft, 
		long xBottomRight, long yBottomRight, long* retval)
{
	*retval = (long) imgs_crop((HBITMAP)hBmp, pixelPerMeter, xTopLeft, yTopLeft, 
		 xBottomRight,  yBottomRight);
	return S_OK;
}

HRESULT _stdcall Cvecim ::FillSmallHoles(long hBmp, BOOL* retval)
{
	*retval = imgs_fillSmallHoles((HBITMAP)hBmp);
	return S_OK;
}

HRESULT _stdcall Cvecim ::FillHoles(long hBmp, BOOL* retval)
{
	*retval = imgs_fillHoles((HBITMAP)hBmp);
	return S_OK;
}

HRESULT _stdcall Cvecim ::Connect(long hBmp, BOOL* retval)
{
	*retval = imgs_connect((HBITMAP)hBmp);
	return S_OK;
}

HRESULT _stdcall Cvecim ::Clean(long hBmp, BOOL* retval)
{
	*retval = imgs_clean((HBITMAP)hBmp);
	return S_OK;
}

HRESULT _stdcall Cvecim ::Thin(long hBmp, BOOL* retval)
{
	*retval = imgs_thin((HBITMAP)hBmp);
	return S_OK;
}

HRESULT _stdcall Cvecim ::Thicken(long hBmp, BOOL* retval)
{
	*retval = imgs_thicken((HBITMAP)hBmp);
	return S_OK;
}

HRESULT _stdcall Cvecim ::Vectorize(long hBmp,long pixelPerMeter, 
		BSTR parameters, long progrCallback, BOOL* retval )
{
	CString S(parameters);
	CallBackProgress callBack = (CallBackProgress)progrCallback;
	*retval = vec_vectorize((HBITMAP)hBmp, (int)pixelPerMeter, S, callBack);
	return S_OK;
}

HRESULT _stdcall Cvecim ::Stop()
{
	vec_stop();
	return S_OK;
}
 
HRESULT _stdcall Cvecim ::GetProgress( long* prog, BSTR* retval )
{
	char buffer[_MAX_PATH];
	*prog = vec_getProgress(buffer, _MAX_PATH-1);
	CString S(buffer); 		

//	if (m_bstrCurOperation)
//			SysFreeString(m_bstrCurOperation);
	*retval = m_bstrCurOperation = S.AllocSysString();

	return S_OK;
}
	
HRESULT _stdcall Cvecim ::IsVectorizationTerminated(BOOL* retval)
{
	*retval = vec_isVectorizationTerminated();
	return S_OK;
}
 
HRESULT _stdcall Cvecim ::Request(long* retval)
{
	* retval = 121212;
	return S_OK;
}

HRESULT _stdcall Cvecim ::Reply( long reply)
{
	vec_setSc((CallBackSc)reply);	
	return S_OK;
}

HRESULT _stdcall Cvecim ::ClearSettings( )
{
	g_settings = "";	
	return S_OK;
}

HRESULT _stdcall Cvecim ::AddSettingLine(BSTR line )
{
	CString S(line);
	g_settings += line;
	g_settings += "\n";
	return S_OK;
}

HRESULT _stdcall Cvecim ::VectorizeGS(long hBmp,long pixelPerMeter, 
		long progrCallback, BOOL* retval )
{
	CString S(g_settings);
	CallBackProgress callBack = (CallBackProgress)progrCallback;
	*retval = vec_vectorize((HBITMAP)hBmp, (int)pixelPerMeter, S, callBack);
	return S_OK;
}

HRESULT _stdcall Cvecim ::GetProgress( long* retval )
{
	char buffer[_MAX_PATH];
	*retval = vec_getProgress(buffer, _MAX_PATH-1);
	if (m_curOper.Compare(buffer))
	{
		m_curOper = buffer;
		m_curOperChanged = TRUE;
	}
	return S_OK;
}

HRESULT _stdcall Cvecim ::IsCurOperChanged( BOOL* retval )
{
	*retval = m_curOperChanged;
	return S_OK;
}

HRESULT _stdcall Cvecim ::GetCuOper( BSTR* retval )
{	
	*retval = m_bstrCurOperation 
		= m_curOper.AllocSysString();
	return S_OK;
}


HRESULT _stdcall Cvecim::SetScCallBack( long val)
{ 	
	return S_OK;
}