/***************************************
  $Revision: 1.4 $

  Radix tree (rx).  er_RX_errors.h - definition of errors for the radix module

  Status: NOT REVUED, TESTED, 

  Design and implementation by: Marek Bukowy

  ******************/ /******************
  Copyright (c) 1999                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/

/* step 1 */

typedef enum {
  LOW_IP_OK=0,
  LOW_IP_INVVER,
  
  LOW_IP_INVIP4,
  LOW_IP_NOSLAS,
  LOW_IP_ADTOLO,
  LOW_IP_PRTOLO,
  LOW_IP_INVPRF,
  LOW_IP_INVRAN,
             
  LOW_IP_NO6YET,
             
  LOW_IP_TOSHRT,
  LOW_IP_INVARG

} IP_err_code_t;

/* step 2 */

#define IP_OK		ER_SEV_I + (FAC_IP<<16) + LOW_IP_OK

#define IP_INVVER	ER_SEV_E + (FAC_IP<<16) + LOW_IP_INVVER
							      
#define IP_INVIP4  	ER_SEV_E + (FAC_IP<<16) + LOW_IP_INVIP4  
#define	IP_NOSLAS	ER_SEV_E + (FAC_IP<<16) + LOW_IP_NOSLAS
#define IP_ADTOLO	ER_SEV_E + (FAC_IP<<16) + LOW_IP_ADTOLO
#define IP_PRTOLO	ER_SEV_E + (FAC_IP<<16) + LOW_IP_PRTOLO
#define IP_INVPRF	ER_SEV_E + (FAC_IP<<16) + LOW_IP_INVPRF
#define IP_INVRAN	ER_SEV_E + (FAC_IP<<16) + LOW_IP_INVRAN
							      
#define IP_NO6YET	ER_SEV_E + (FAC_IP<<16) + LOW_IP_NO6YET
							      
#define IP_TOSHRT	ER_SEV_E + (FAC_IP<<16) + LOW_IP_TOSHRT
#define IP_INVARG	ER_SEV_E + (FAC_IP<<16) + LOW_IP_INVARG

/* step 3 */

#ifdef ER_IMPL
er_list_t IP_mod_err[]={
  { ERDUP(IP_OK),  	"OK" },

  { ERDUP(IP_INVVER),   "invalid IP version code" },

  { ERDUP(IP_INVIP4),   "e2b: incorrect IPv4 address" },
  { ERDUP(IP_NOSLAS),   "e2b: missing slash in prefix" },
  { ERDUP(IP_ADTOLO),   "e2b: address part too long" },
  { ERDUP(IP_PRTOLO),   "e2b: prefix part too long" },
  { ERDUP(IP_INVPRF),   "e2b: incorrect prefix value" },
  { ERDUP(IP_INVRAN),   "e2b: invalid range specification" },

  { ERDUP(IP_NO6YET),   "IPv6 is not yet implemented" },

  { ERDUP(IP_TOSHRT),   "b2a: supplied string too short" },

  { ERDUP(IP_INVARG),   "invalid argument" },   /* very generic error */

 ER_LASTTXT
};

#endif /* ER_IMPL */
