
#	$RCSfile: processdata.pl,v $
#	$Revision: 2.3 $
#	$Author: ripe-dbm $
#	$Date: 1996/08/09 12:03:57 $


@INC = ("LIBDIR", @INC);

require "flush.pl";

require "defines.pl";
require "adderror.pl";
require "dbadd.pl";
require "enparse.pl";
require "entype.pl";
require "enwrite.pl";
require "misc.pl";
require "rconf.pl";
require "rfc822.pl";
require "syslog.pl";


#
# printstat 
#
# prints verbose version of the update result.


sub printstat {
    local($output, *entry, $type, $options) = @_;

    print STDERR "dbupdate - printstat($FROM,$options) called\n" if $opt_V;

    if ($options & $DELETEOPTION) {
       print $output "\nDelete ";
    }
    elsif ($options & $NEWOPTION) {
       print $output "\nNew ";
    }
    else {
       print $output "\nUpdate ";
    }
    
    if ($options & $OKOPTION) { 
       print $output "OK: ";
    }
    elsif ($options & $NOOPOPTION) { 
       print $output "NOOP: ";
    }
    else { 
       print $output "FAILED: ";
    }
    
    if ($entry{$type}) {
       
       print $output "[", $ATTL{$type}, "] ";
       
       if (($entry{"nh"}) && ($entry{"nh"}!~ /^$AUTONICPREFIXREGULAR/)) {
          print $output $entry{"nh"}, " (", $entry{$type},")\n";
       }
       else {
          print $output $entry{$type}, "\n";
       }
       
    }
    else {
       print $output "[unknown object]\n"; 
    }
 
}


#
# processdata($input, $output);
#
# does all the work.

sub processdata {
    local($input, $output)=@_;

    local($somethingfound)=0;
    local($haserror)=0;
    local($eof)=0;
    local(@queue)=();
    
    local($type,$key,$value,$reordered,$dbstat,$parsestat);
    local($options,$codes,$overrideattr,$deleteattr,@autonichandles);

    print STDERR "processdata - ($FROM,$input) called\n" if $opt_V;
    
    while(1) {

	print STDERR "processdata - calling enparse\n" if $opt_V;
        
	($parsestat, $type, %entry)=&enparse($input) if (!$eof);
	
	print STDERR "processdata - left parse: $parsestat $type\n" if ($opt_V);
	
	$eof=1 if ($parsestat==$EOF);
	
	#
	# get objects from the queue if we reached EOF
	
	if ($eof) {
	   
	   if (@queue) {
	      
	      # print STDERR "queue:\n", join("\n", @queue), "-\n";
	      
	      $parsestat=shift(@queue);
	      $type=shift(@queue);
	      @autonichandles=split(" ", shift(@queue));
	      	      
	      %entry=();
	      
	      while ($key=shift(@queue)) {
	         
	         $entry{$key}=shift(@queue);
	          
	      }
	      
	      
	   }
	   else {
	      
	      last;
	      
	   }
	   
	}
	else {
	   @autonichandles=();
	}

        #
        # we found an object
        
        $somethingfound=1;
        
	print STDERR "dbupdate - read an object ($parsestat,$entry{$type})\n" if $opt_V;

        if ($parsestat==$O_ERROR) {
           
           $dbstat=$O_ERROR;
           
           $options=0;
	
	   if (defined($entry{"ud"})) {
	
	      $options|=$DELETEOPTION;
	      $deleteattr=delete($entry{"ud"});
	                    
	   }
	   else {
	      $deleteattr=undef;
	   }
	
	   if (defined($entry{"uo"})) {
	
	      $options|=$OVERRIDEOPTION;
	      $overrideattr=delete($entry{"uo"});
	                    
	   }
	   else {
	      $overrideattr=undef;
	   }
           
        }
        else {
        
           #
           # very primitive check if we need to reorder the update 
           #
           # no time to make this intelligent right now
           # and it it probably not really needed for 99.9 % of
           # all updates
           
           if (!$eof) {
              
              $reordered=0;
              
              foreach (split(/ /, $OBJPOINTSTOATTR{$type})) {
                 
                 # print STDERR "$_\n";
                 
                 local($*)=1;
                 
                 if ($entry{$_}=~ /(^|\n)$AUTONICPREFIXREGULAR\d+[A-Z]*(\n|$)/o) {
                    
                    # print STDERR "pointsto: $_\n";
                       
                    push(@autonichandles, $_);
                       
                 }
              
              }
              
              # print STDERR "autofirst: ", join(" ", @autonichandles), "\n";
              
              if ($entry{"nh"}!~ /^$AUTONICPREFIXREGULAR\d+[A-Z]*$/o) {
                     
                 foreach (keys %entry) {
           
                    #
                    # it is very unlikely that a (new) maintainer
                    # will follow any object where it's immediately used
                 
                    next if (($type ne "mt") && (/^m[bl]$/));
                 
                    #
                    # reorder if an object points to another object
                 
                    if ((defined($POINTSTO{$_})) && ($POINTSTO{$_}!~ /^$_$/)) {
                    
                       $reordered++;
                    
                    } 
                 
                    local($*)=1;
                    
                    if ($entry{$_}=~ /(^|\n)$AUTONICPREFIXREGULAR\d+[A-Z]*(\n|$)/o) {
                 
                       $reordered++;
                       
                       # print STDERR "pointsto: $_\n";
                       
                    }
              
                 }
              
              }
              
              if ($reordered) {
                 
                 if (@autonichandles) {
                 
                    push(@queue, "") if (scalar(@queue));
                    push(@queue, $parsestat, $type, join(" ", @autonichandles));
	            while (($key,$value)=each(%entry)) {
	         
	               push(@queue, $key, $value);
	          
	            }
	            
                    # print STDERR "***nicqueue***:\n", join("\n", @queue), "-\n";
                 
                 }
                 else {
                    
                    unshift(@queue, "") if (scalar(@queue));
	            while (($key,$value)=each(%entry)) {
	         
	               unshift(@queue, $key, $value);
	          
	            }
	            unshift(@queue, $parsestat, $type, "");
                    
	            # print STDERR "***nonnicqueue***:\n", join("\n", @queue), "-\n";
                 
                 }
                 
                 next;
              
              }
           
           }
           
           #print STDERR "auto: ", join(" ", @autonichandles),"\n";
           #print STDERR "perform update: ", $entry{$type}, "\n"; next;
           
           #
           # perform the actual update
           
           $options=0;
	
	   if (defined($entry{"ud"})) {
	
	      $options|=$DELETEOPTION;
	      $deleteattr=delete($entry{"ud"});
	                    
	   }
	
	   if (defined($entry{"uo"})) {
	
	      $options|=$OVERRIDEOPTION;
	      $overrideattr=delete($entry{"uo"});
	                    
	   }
        
           #
	   # object parsed OK or has only warnings, now we will
	   # do the final checks when the databases are locked and opened
	
	   ($dbstat, $codes) =&finalchecksandupdate(*entry, $type, *autonichandles, *options);
	   
	   print STDERR "finalchecksandupdate - left ($FROM,$dbstat, $codes)\n" if ($opt_V);
	    
	}
	
	# print STDERR %entry, "\n";
	
	if ($dbstat==$O_COULDNOTOPEN) {
	   
	   #
	   # Not too good, probably permission problem
	   # if this is given as output ...

	   &adderror(*entry, "Failed to open DB file ($ATTL{$codes}): $!");
	   &adderror(*entry, "Contact <$HUMAILBOX> for a problem report");

           $haserror=1;

	}
	elsif (($dbstat!=$O_ERROR) && ($dbstat!=$O_OK) && ($dbstat!=$E_NOOP)) { 
	      
	    &adderror(*entry, $MESSAGE[$dbstat]);
	     
	    $haserror=1;
	      
	}
	elsif ($dbstat!=$E_NOOP) {
	   
	   if ($options & $OVERRIDEOPTION) {
	      
	      &syslog("AUDITLOG", "override [$type] $overrideattr -> \"".$entry{$type}."\"");
	      
	   }
	   elsif ($options & $DELETEOPTION) {
	         
	      &syslog("AUDITLOG", "delete [$type] $deleteattr -> \"".$entry{$type}."\"");
	         
	   }
	   
	}
		
	if ($dbstat==$E_NOOP) {
	   &printstat($output, *entry, $type, $options | $NOOPOPTION) if ($opt_v);
	   print $output "\n" if ($opt_v);
	}
	elsif (&haserror(*entry)) {
	
	   print STDERR "dbupdate - object has error\n" if $opt_V;
	   
	   $haserror=1;
	   
	   &printstat($output, *entry, $type, $options | $FAILEDOPTION);
	   &enwrite($output,*entry,1,1,1);
	   print $output "\n";
	      
	}
	elsif (&haswarning(*entry)) {
	   
	   &printstat($output, *entry, $type, $options | $OKOPTION);
	   &enwrite($output,*entry,1,1,1);
	   print $output "\n";
	   
	}
	elsif (($opt_v) || ($options & $ASSIGNEDNICOPTION)) {
	   
	   &printstat($output, *entry, $type, $options | $OKOPTION);
	   print $output "\n";
	   
	}
	
	$entry{"uo"}=$overrideattr if ($overrideattr);
	$entry{"ud"}=$deleteattr if ($deleteattr);

    }

    return ($somethingfound, $haserror);
    
}

sub dbupdate {
    local($input, $output)=@_;
    
    #
    # We want to make a local copy of the input, because we need to do multiple
    # things with it ...

    local($copyfilename)=$TMPDIR."\/dbupdcopy.".$$;
    
    open(COPY, "+>".$copyfilename) || &fatalerror("Cannot create $copyfilename: $!");
    if ($input) {
       print COPY $input;
    }
    else {
       print COPY <>;
    }
    &flush(COPY);
    seek(COPY, 0, 0);

    #
    # open the acknowledgement file
    
    local($ackfilename)=$TMPDIR."\/dbupdack.".$$;

    open(ACK, "+>".$ackfilename) || &fatalerror("Cannot create $ackfilename: $!");

    #
    # We have a mail, so let's first parse the headers ...

    local($stat)=1;

    $stat=&parserfc822(COPY) if ((!$opt_m) && ($opt_M));
    
    &ReplaceGlobalVars(*FWHEADER);
    &ReplaceGlobalVars(*FWTXT);
    &ReplaceGlobalVars(*FWMAILTXT);
    &ReplaceGlobalVars(*MTFWHEADER);
    &ReplaceGlobalVars(*MTFWTXT);
    
    &ReplaceGlobalVars(*NHEADER);
    &ReplaceGlobalVars(*NOTITXT);
    &ReplaceGlobalVars(*NOTIMAILTXT);

    if ($opt_M) {
       
       &ReplaceGlobalVars(*MHEADER);
       &ReplaceGlobalVars(*MAILTXT);
       &ReplaceGlobalVars(*ACKERR);
       &ReplaceGlobalVars(*ACKOK);
       &ReplaceGlobalVars(*ACKSIG);

       #
       # If we have at least a return address, compose the header of
       # the ack mail

       if ($stat) {

  	  if ($TESTMODE) {
	     print ACK "To: ", $DEFMAIL, "\n";
	  }
	  else {
	     #
	     # note: don't use CC since it might cause horrible
	     #       mailloops as we discovered ...
	     print ACK "To: ", $REPLYTO, "\n";
	  }
	
	  print ACK $MHEADER, $MAILTXT;

       }
       else {
 	  print ACK "Header could not be parsed ...\n";
       }

    }

    #
    # Take all the stuff from file COPY in doaction. It will process the
    # whole stuff.

    local($somethingfound, $haserror)=&processdata(COPY, ACK);

    if (($somethingfound) || (!$HELPREQUESTED)) {

       if (!$somethingfound) {

          print ACK "*** No objects were found ***\n" if (!$NETWORKUPDATE);

       }
       else {
   
          if ($haserror) {
             print ACK $ACKERR if ($opt_M);
          }
          else {
             print ACK $ACKOK if ($opt_M);
          }  

       }

       print ACK $ACKSIG if ($opt_M);

    }

    if ($HELPREQUESTED) {
   
       open(HELP, "<".$HELP);
       print ACK "=" x 60, "\n\n", <HELP>, "\n", "=" x 60;
       close(HELP);
      
    }

    #
    # We sent out the ack, now send out the notifications if needed

    if (%notify) {
       print STDERR "dbupdate - sending notifications (", keys %notify,")\n" if ($opt_V);
       &SendNotifications();
    }

    if (%forward) {
       print STDERR "dbupdate - sending forwards(", keys %forward, ")\n" if ($opt_V);
       &SendForwardMails();
    }

    #
    # log all stuff to the right places

    # This may seem yucky, but is needed to untaint the filename ...

    $filename = $LOGFILE{"UPDLOG"}."/".$DATE;
    $filename =~ /(.*)/;
    $realfile = $1;

    #
    # first let's log the updates send in

    if (open(LOG, ">>$realfile")) {
    
       &appendlock(LOG);
    
       if ($opt_M) {
          print LOG "\n>>> time: $TIME MAIL UPDATE <<<\n\n";
       } 
       elsif ($NETWORKUPDATE) {
          print LOG "\n>>> time: $TIME $NETWORKUPDATE NETWORK UPDATE <<<\n\n";
       }
       else {
          print LOG "\n>>> time: $TIME STDIN UPDATE <<<\n\n";
       }

       &flush(COPY);
       seek(COPY, 0, 0);
       print LOG <COPY>;
       close(LOG);
   
    }
    else {
      &syslog("ERRLOG", "dbupdate cannot open $LOGFILE{\"UPDLOG\"}/$DATE"); 
    }

    close(COPY);

    #
    # then we log the acknowledgement

    $filename = $LOGFILE{"ACKLOG"}."/".$DATE;
    $filename =~ /(.*)/;
    $realfile = $1;

    if (open(LOG, ">>$realfile")) {
    
       print STDERR "dbupdate - updating logs\n" if $opt_V;
    
       &appendlock(LOG);
    
       if ($opt_M) {
          print LOG "\n>>> time: $TIME MAIL ACK <<<\n\n";
       }
       elsif ($NETWORKUPDATE) {
          print LOG "\n>>> time: $TIME $NETWORKUPDATE NETWORK ACK <<<\n\n";
       }
       else {
          print LOG "\n>>> time: $TIME STDIN ACK <<<\n\n";
       }
    
       &flush(ACK);
       seek(ACK, 0, 0);
    
       local(@ack)=<ACK>;
       print LOG @ack;
       print $output @ack if (!$opt_M);
       close(LOG);
    
    }
    else {
       &syslog("ERRLOG", "dbupdate cannot open $LOGFILE{\"ACKLOG\"}/$DATE"); 
    }

    close(ACK);

    #
    # Output the ack

    if ($opt_M) {
       print STDERR "dbupdate - sending ack\n" if $opt_V;
       system("$MAILCMD <".$ackfilename);
    }
    
    #
    # remove the temp stuff we made

    unlink($copyfilename, $ackfilename);

}

1;