# newdb.pl
#
# Copyright (c) 1993, 1994, 1995, 1996, 1997  The TERENA Association
# Copyright (c) 1998                              RIPE NCC
#
# All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of the author not be
# used in advertising or publicity pertaining to distribution of the
# software without specific, written prior permission.
#
# THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
# AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
# $Id: newdb.pl,v 2.5 1999/01/12 09:57:07 roman Exp $
#
#	$RCSfile: newdb.pl,v $
#	$Revision: 2.5 $
#	$Author: roman $
#	$Date: 1999/01/12 09:57:07 $

# This is a little tool to generate an empty database which just contains
# the generation date, and the COPYRIGHT notice as defined in the config
# file. Mainly used for testing purposes.
# One should be careful with this, since it will simply overwrite existing
# database files if the -f flag is given. No Mercy.

use DB_File;

require "rconf.pl";
require "getopts.pl";

&Getopts('fab');

# You need help or have no command line arguments ?

if (!opt_a && !$ARGV[0]) {
	print <<"EOF";

Usage: $0 [-f] file

-f		Force new database even if file exists
-a		Create all new databases
-b              Print a lot of useless debugging information
filename	The name of the new database file to be generated

EOF

	exit;
}

if (!$opt_a)
{
	# OK, here is the file to be created:
	$::newdbname = $ARGV[0];
}

# Read the conf, for the COPYRIGHT notice

$conffile=$ENV{"RIPEDBCNF"};
$conffile= $RIPEConfig{DEFCONFIG} unless $conffile;
&rconf($conffile);

# Here we go ...
if( $opt_a )
{
#	local(%nd_objs_names,$nd_filename_prefix,$nd_obj_name,@nd_line_fields);

	open T, $conffile || &fatalerror("cannot open file $conffile");
	while (<T>)
	{
	chop; 
	@nd_line_fields=split(' ');
	if( /^OBJ\b/)
		{ $nd_objs_names{$nd_line_fields[1]}++ }
	if( /^DBFILE\s+(\S+)\s+(\S+)/ && $1==$DEFLOOK)
		{
		  $nd_filename_prefix=$2;
		  if( ! /SPLIT/ ) 
		     { 
		     die "the database $DEFLOOK is not SPLIT. No db files to create\n";
		     }
		}
	}
	close(T);	
	
	if($nd_filename_prefix eq '') 
        {
	&fatalerror("location of database not found in config file");
	}

	foreach $nd_obj_name (sort keys %nd_objs_names)
	{
	  print "Doing $nd_obj_name";
	  $::newdbname = lc $nd_filename_prefix.".".$nd_obj_name;
	  print "..creating $::newdbname\n";
	  &createnewdb( $::newdbname )
	}
}
else
{
	print "..creating $::newdbname\n";
	&createnewdb( $::newdbname )
}

# done.

###########################################################################

sub createnewdb
{
local($newdbname)=@_;
local(%hash,$newdbidxname);

# Check to see if file exists, and if the force overwrite flag is set
	if (-e $newdbname && !$opt_f) {
	   print STDERR "File exists, will not overwrite\n";
	   exit;
	}

# Print generation date and copyright to the database
#
# printright is required since addkey doesn\'t work
# correct when an offset==0

open(NEWDB, ">".$newdbname) || &fatalerror("Cannot open $newdbname: $!");
&printrights(NEWDB);
close(NEWDB);

# Delete indexes in case they happen to exist ...
&delormoveindices($newdbname, "", 0);
&delormoveindices($newdbname.$CLASSLESSEXT, "", 1);

# (Re)create empty index file
  %hash=(); 
  $newdbidxname=$newdbname.".db";
  tie (%hash, DB_File, $newdbidxname, O_RDWR|O_CREAT,0644,$DB_HASH) 
	|| &fatalerror("cannot create index file $newdbidxname : $!"); 

}
