#	syslog - simplified syslog "type" routine.
#
# Copyright (c) 1993, 1994, 1995, 1996, 1997  The TERENA Association
# Copyright (c) 1998                              RIPE NCC
#
# All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of the author not be
# used in advertising or publicity pertaining to distribution of the
# software without specific, written prior permission.
#
# THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
# AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
# $Id: syslog.pl,v 2.5 1999/05/28 16:19:49 roman Exp $
#
#	$RCSfile: syslog.pl,v $
#	$Revision: 2.5 $
#	$Author: roman $
#	$Date: 1999/05/28 16:19:49 $
#
#	It allows you to write to various logfiles defined in general config
#	

require	"defines.pl";
require "misc.pl";

#
# use this routine for fatal errors
# it tries to log the problem in as many places as possible

sub fatalerror {

   # log in as many places as possible...

   local($error)="Fatal error: ".join("", @_)." PID: $$\n";

   if (&syslog("ERRLOG", $error)) {
      
      print STDERR $error;
      
      if (open(CONSOLE, ">>/dev/console")) {
         &appendlock(CONSOLE);
         print CONSOLE $error;
         close(CONSOLE);
      }
   
   }
   
   exit 100;

}

sub syslog {
    local($log, $string, $nostamp) = @_;
    local($date);

    if ($nostamp) {
	$date = "";
    }
    else {
	# Get the time
	local($s, $m, $h, $md, $mo, $y, $wd, $yd, $is) = localtime(time);
	local($thismonth) = 
	    (Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec)[$mo];
	$s = "0".$s unless $s > 9;
	$m = "0".$m unless $m > 9;
	$h = "0".$h unless $h > 9;
	$date = sprintf("%3s %2d %2s:%2s:%2s", $thismonth,$md,$h,$m,$s);
    }

    #
    # Now we got a date let's open the logfile
    # If we cant try to open the errorlog or failing that write to the console

    if (!open(LOG, ">>".$LOGFILE{$log}))  {
	
	if (($log ne "ERRLOG") && (!open (LOG,">>".$LOGFILE{"ERRLOG"}))) {
	
	    if (!open (LOG, ">>/dev/console")) {
	       
	       print STDERR $date, " ", $string, "\n";
	       
	       return 0;
	       
	    }
	    
	}
	
    }
    
    # 
    # So we assume we can write the string
    # Attempt to lock the log as well
     
    &appendlock(LOG);
    # we want to use only one \n add the end of the line
    $string=~ s/\s+$//;
    print LOG $date, " ", $string, "\n";
    close(LOG);

    return 1;
    
}

1;
