/***************************************
  $Revision: 2.16 $

  mm - MIME Parser module. Functions to parse a mail message,
  find if it is MIME-encapsulated, and return the parts of
  the message which are supported by the UP module.

  Status: COMPLETE, NOT REVUED, TESTED

  Design and implementation by: daniele@ripe.net

  ******************/ /******************
  Copyright (c) 2000,2001,2002                    RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/

#ifndef _MM_H
#define _MM_H


/* Included headers: */

/* These come from c-client */
#include "mail.h"
#include "osdep.h"
/*#include "misc.h"*/
/*#include "rfc822.h"*/
/*#include "smtp.h"*/
/*#include "nntp.h"*/

/* Other RIP headers */
#include "gpg.h"
#include "mail_parser.h"
#include "memwrap.h"

/* GLib */
#include "glib.h"



/* String sizes */
#define STR_S   63
#define STR_M   255
#define STR_L   1023
#define STR_XL  4095
#define STR_XXL 16383

#define LINELENGTH 80

/* Set this as the max buffer size when you want to
   avoid buffer overflows */
#define MAXBUFSIZE 102400

/* Local #defines */

#define NO_DEBUG 0
#define DO_DEBUG 1
#define DEFAULT_DEBUG NO_DEBUG
#define TEMPDIR "/tmp"
#define FILENAMELEN STR_L
#define GLOBALPREFIX "mime"
#define MAXSUPPTYPES 50


/* Structure definition */




typedef struct MM_mail_header {
  char *from;
  char *subject;
  char *date;
  char *message_id;
  char *reply_to;
  char *cc;
  char *content_type;
} MM_header;


/* Needed for dbupdate, written in C++ */

#ifdef __cplusplus
extern "C" {
#endif


/* Function definition */

/* API functions */
int MM_store (char *source_file, char *destination_file, long custom_debug);
int MM_get_msg_headers(const char *mail_file, EP_Mail_Descr *mail_descr, long mesgno, long custom_debug);
#define MM_get_headers(mail_file, mail_descr, custom_debug) MM_get_msg_headers(mail_file, mail_descr, (long) 1, custom_debug)
int MM_extract_mime (const char *sourcefile, char *pfx, EP_mail_node *mailnode, long custom_debug);

/* Internal support functions */
void status (MAILSTREAM *stream);
Mail_Header_Field *get_mail_hdr_field (MAILSTREAM *stream, long mesgno, STRINGLIST *cur, const char *hdr_title);
char *get_header_line (MAILSTREAM *stream, long mesgno, STRINGLIST *cur, const char *hdr_title);
void write_file (char *filename, char *text, size_t text_size);
void read_file (const char *filename);
void put_in_file (char *fileprefix, char *extension, char *text, size_t text_size);
int do_regex_test(const char *pattern, char *string);
t_MM_type is_supported_MIMEtype (BODY *body);
void dispatch_to_driver(MAILSTREAM *stream, BODY *body, char *pfx, EP_mail_node *mailnode);


/* The drivers */
void parse_text_plain(MAILSTREAM *stream, BODY *body, char *pfx, EP_mail_node *mailnode);
void parse_multipart_alternative (MAILSTREAM *stream, BODY *body, char *pfx, EP_mail_node *mailnode);
void parse_multipart_signed (MAILSTREAM *stream, BODY *body, char *pfx, EP_mail_node *mailnode);
void parse_message_rfc822 (MAILSTREAM *stream, BODY *body, char *pfx, EP_mail_node *mailnode);
#define parse_application_pgp(stream, body, part_number, mailnode) parse_text_plain(stream, body, part_number, mailnode)
#define parse_unknown_unknown(stream, body, part_number, mailnode) parse_text_plain(stream, body, part_number, mailnode) /* We give a chance to the unsupported MIMEtypes to contain plain text updates... */
#define parse_multipart_mixed(stream, body, part_number, mailnode) parse_multipart_alternative(stream, body, part_number, mailnode)
#define parse_multipart_digest(stream, body, part_number, mailnode) parse_multipart_alternative(stream, body, part_number, mailnode)

/* Needed for dbupdate, written in C++ */

#ifdef __cplusplus
}
#endif


#endif /* _MM_H */
