/******************
  Copyright (c) 2002                                        RIPE NCC

  All Rights Reserved

  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.

  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/

#ifndef UP_EXTRNL_SYNTAX_H
#define UP_EXTRNL_SYNTAX_H

#include <glib.h>
#include "rip.h"

#define UP_EXTSYN_OK         0
#define UP_EXTSYN_ERR        1
#define UP_EXTSYN_WARN       2
#define UP_EXTSYN_ERR_WARN   3


typedef struct _external_syntax_struct {
  int result;
  char * error_str;
  char * warning_str;
  char * new_obj;
} external_syntax_struct;

typedef struct _attribute_struct {
  char * type;
  char * content;
} attribute_struct;

typedef struct _date_syntax_struct {
  int result;
  char * error_str;
} date_syntax_struct;


external_syntax_struct * UP_check_external_syntax(rpsl_object_t * external_syntax_obj);

char * UP_generate_kc_attrs(rpsl_object_t * generated_obj);

char * UP_generate_i6_attrs(rpsl_object_t * generated_obj);

/* GSList * up_get_attribute_list(Object * o, char * text); */

void up_reconstruct_object(rpsl_object_t * external_syntax_obj, external_syntax_struct *result);

#endif
