/***************************************
  $Revision: 1.14.8.1 $

  Status: NOT REVUED, NOT TESTED

 Author(s):       Andrei Robachevsky

  ******************/ /******************
  Modification History:
        andrei (17/01/2000) Created.
  ******************/ /******************
  Copyright (c) 2000                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 ***************************************/

/* XXX                  IMPORTANT                        XXX  */
/* XXX Many of the definitions are hardcoded here        XXX */
/* XXX Incase of adding or reordering classes/attributes XXX */
/* XXX Check this file, please                           XXX */

/*********************************************************************


This is needed for commit or rollback of the transaction (v3 software
doesn't rely on transaction support from the underlying RDBMS; MySQL
doesn't have it at all). The transaction in progress can be identified
by thread_id field not being equal 0 in corresponding tables. According
to the value of this field (insert or  update) the commit/rollback
routine either deletes or updates the record.

The arrays have the following format: first come tables that may be
affected when dummy object is created to resolve references. For
example, if one creates a inetnum object that has no corresponding
admin-c, tech-c, mnt-by, etc., dummy records will be created in
person_role table and mntner table. We need to clean up them.

Secondly (starting with TAB_START) come tables that may be affected by
the object itself. Basically it is a list of all possible attributes of
the object of the type that are stored in the db. I guess this may be
also derived from xml in the future.

And NULL is a delimiter; it is also used for padding.

**********************************************************************/

#define TAB_START	6
char *t_ak[]={  "mntner","person_role","names",NULL,NULL,NULL,
                "admin_c","tech_c","notify","mnt_by","mnt_lower","org",NULL};
                
char *t_an[]={	"mntner","person_role","as_set","names","mbrs_by_ref",NULL,
		"cross_nfy","cross_mnt","member_of","admin_c","tech_c","notify","mnt_by","mnt_lower","mnt_routes","org",NULL};
		
char *t_dn[]={	"mntner","person_role","names",NULL,NULL,NULL,
		"admin_c","tech_c","zone_c","nserver","sub_dom","notify","mnt_by","mnt_lower","refer","inaddr_arpa", "ip6int","org",NULL }; /*C_DN, */
		
char *t_i6[]={	"mntner","person_role","names","irt",NULL,NULL,
		"admin_c","tech_c","rev_srv","notify","mnt_by","mnt_lower","mnt_routes","mnt_irt","org",NULL}; /*C_I6,*/

char *t_in[]={	"mntner","person_role","names","irt",NULL,NULL,
		"admin_c","tech_c","rev_srv","notify","mnt_by","mnt_lower","mnt_routes","mnt_irt","org",NULL}; /*C_IN,*/
		
char *t_ir[]={	"mntner","person_role","names",NULL,NULL,NULL,
		"ifaddr","admin_c","tech_c","notify","mnt_by","org",NULL}; /*C_IR,*/
		
char *t_kc[]={	"mntner",NULL,NULL,NULL,NULL,NULL,
		"notify","mnt_by","org",NULL}; /*C_KC,*/
		
char *t_li[]={	"mntner","person_role","names",NULL,NULL,NULL,
		"admin_c","author","notify","mnt_by","org",NULL}; /*C_LI,*/
		
char *t_mt[]={	"mntner","person_role","names",NULL,NULL,NULL,
		"admin_c","tech_c","upd_to","mnt_nfy","auth","notify","mnt_by","auth_override","referral_by","org",NULL}; /*C_MT,*/
		
char *t_pn[]={	"mntner",NULL,NULL,NULL,NULL,NULL,
		"names","e_mail","notify","mnt_by","org",NULL}; /*C_PN,*/
		
char *t_ro[]={	"mntner","person_role","names",NULL,NULL,NULL,
		"names","e_mail","admin_c","tech_c","notify","mnt_by","org",NULL}; /**C_RO,*/
		
char *t_rt[]={	"route_set","mntner","person_role",NULL,NULL,NULL, /* admin-c, tech-c may appear in RADB */
		"cross_nfy","cross_mnt","member_of","notify","mnt_by","mnt_lower", "mnt_routes","org",NULL}; /*C_RT,*/
		
char *t_as[]={	"mntner","person_role","names",NULL,NULL,NULL,
		"mbrs_by_ref","admin_c","tech_c","notify","mnt_by","org",NULL}; /*C_AS,*/
		
char *t_rs[]={	"mntner","person_role","names",NULL,NULL,NULL,
		"mbrs_by_ref","admin_c","tech_c","notify","mnt_by","org",NULL}; /*C_RS,*/
		
char *t_fs[]={  "mntner","person_role","names",NULL,NULL,NULL,
                "admin_c","tech_c","notify","mnt_by","org",NULL}; /*C_FS,*/
                
char *t_ps[]={  "mntner","person_role","names",NULL,NULL,NULL,
                "admin_c","tech_c","notify","mnt_by","org",NULL}; /*C_PS,*/
                
char *t_is[]={  "mntner","person_role","names",NULL,NULL,NULL,
                "mbrs_by_ref","admin_c","tech_c","notify","mnt_by","org",NULL}; /*C_IS,*/
                
char *t_it[]={  "mntner","person_role","names",NULL,NULL,NULL,
                "admin_c","tech_c","notify","mnt_by","auth","irt_nfy","org",NULL}; /*C_IT,*/

char *t_oa[]={  "mntner","person_role","org_name",NULL,NULL,NULL,
                "admin_c","tech_c","org_name","mnt_by","mnt_ref","notify","org","e_mail","ref_nfy",NULL}; /*C_OA,*/
 
/* IMPORTANT !!! */
/* This stuff should be consistent with DF_classnames.def */

char **tables[]={
t_ak,
t_as,
t_an,
t_dn,
t_ir,
t_i6,
t_in,
t_kc,
t_li,
t_mt,
t_pn,
t_ro,
t_rt,
t_rs,
t_fs,
t_ps,
t_is,
t_it,
t_oa,
NULL
};

/* This tables are used for inverse querying when deleting an object */

char *t_ipn[]={  "admin_c","tech_c","zone_c","cross_nfy","author",NULL}; /*C_PN, C_RO*/
char *t_imt[]={  "mnt_by","mnt_lower","mnt_routes","cross_mnt","mbrs_by_ref","referral_by",NULL}; /* C_MT */
char *t_iit[]={  "mnt_irt", NULL}; /* C_IT */
