IFS='
'

srcdir=../src
conffile=./v6wpd-test.conf
logfile=log$$
port=`cat $conffile | grep -i ^listenport | gawk '{print $2}'`
host=`cat $conffile | grep -i ^forwardhost | gawk '{print $2}'`
pidfile=`cat $conffile | grep -i ^pidfile | gawk '{print $2}'|sed -e 's/^ *\"//' -e 's/\" *$//'`
dbhost=`cat $conffile | grep -i ^dbhost | gawk '{print $2}'`
dbport=`cat $conffile | grep -i ^dbport | gawk '{print $2}'`
dbuser=`cat $conffile | grep -i ^dbuser | gawk '{print $2}'`
dbpass=`cat $conffile | grep -i ^dbpass | gawk '{print $2}'`
dbname=`cat $conffile | grep -i ^dbname | gawk '{print $2}'`
proxytable=`cat $conffile | grep -i ^proxytable | gawk '{print $2}'`
mysqlargs="-h$dbhost -P$dbport -u$dbuser -p$dbpass $dbname"

export srcdir conffile logfile pidfile

startServer() {
    f="$1"
    if [ -z "$f" ]
    then
        $srcdir/v6wpd -f $conffile 2>$logfile
    else
        $srcdir/v6wpd -f $f 2>$logfile
    fi
    sleep 1
}

stopServer() {
    kill `cat $pidfile`
    rm -f $logfile
    rm -f $pidfile
}

mysqlDo() {
    echo $* | mysql -h$dbhost -P$dbport -u$dbuser -p$dbpass $dbname
}

testing() {
    OIFS=$IFS
    IFS=' '
    echo " TESTING $*"
    IFS=$OIFS
}
