/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * The exponential(my) distribution
 * EVALUATION VERSION - returns 0.0
 *
 * Additional parameters are ignored!
 */

#include <general.h>

double log();

double exp0(pm)
    struct param *pm;
{
    double my, res;

    tprintf("exp0() called!\n");

    if (param_nvalues(pm) < 1) {
	eprintf(EF_IN4X, SPECIFICATION, "to few parameters",
	       "exp0 distribution",
	       "Requires one parameter");
	return 0.0;
    }

    my = param_getvalue(pm, 0);

    res = bench_rand();
    dprintf("exp0: using %f\n", res);
    res = -my * log(res);
    dprintf("exp0: returning %f\n", res);
    
    return 0.0;
} /* exp0 */
	
	
