/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * Header file for benchmarks of  SunLink tsap interface to tp4 
 */

#ifndef _SUNTSAP_
#define _SUNTSAP_

#ifndef __OSI__
#define __OSI__
#include <sys/socket.h>
#include <sys/ieee802.h>
#include <netosi/osi.h>    
#include <netosi/osi_addr.h>    
#include <netosi/osi_profile.h>
#include <netosi/osi_error.h>
#include <netosi/osi_layer.h>
#include <netosi/tp_event.h>
#endif __OSI__

/* In this implementation the DisconnectIndication might occur before
 * the last DataIndication. There we use a flag in the channel data type,
 * to indicate whether a DisconnectIndication has already been seen.
 * A channel is hence a socket number + the flag
 */
typedef struct {
    int	chan;
    int	seen_disc_ind;
} channel_t;
 
struct server_t {
    int sock;		/* a socket being listened on */
};

#include "../protoaddrs/sunosiaddr.h"

/*
 * TP message structure
 */

typedef union {
    TP_MSG tp_msg;
    TP_MSG_CONNECT tp_connect;
    TP_MSG_DATA tp_data;
    TP_MSG_X_DATA tp_x_data;
    TP_MSG_DISCONNECT tp_disconnect;
    TP_MSG_ERROR tp_error;
} tp_msg;
    
/* Use a global variable to store OSI_ADDR of client. Kludgy, allows
 * for only one client in each process. Should be implemented by a CreateClient
 * operation.
 */

extern struct address_t client_address;

/*
 * Error handling
 */

typedef int error_t;
#define failed(errind)	(*errind == NOTOK)

#define report_error(errind,str)	tp4_report_error(errind,str)


#define InitClient()		tp4_init_client()

#define ConnRequest(addr,a_ch,errind) tp4_conn_request(addr, a_ch, errind)

#define CreateChannel(addr,a_ch,errind) tp4_create_channel(add,a_ch,errind)

#define DiscRequest(ch, errind) tp4_disc_request(ch, errind)

#define DestroyChannel(ch, errind)	DiscRequest(ch, errind)

#define AwaitConnInd(serverp, a_ch, errind) tp4_await_conn_ind(serverp, a_ch, errind)

#define AwaitDiscInd(ch, errind) tp4_await_disc_ind(ch,errind)

#define CreateServer(aa_server, aa_addr, errind) \
  				tp4_create_server(aa_server, aa_addr, errind)
#define DestroyServer(a_server, errind) \
    				tp4_destroy_server(a_server, errind)

#define DataRequest(channel,buffer,amount, errind) tp4_data_request(channel, buffer, amount, errind)

/* problem when length bytes aren't read! */
#define AwaitDataIndication(channel, buffer, amount, errind)	\
    tp4_await_data_ind(channel, buffer, amount, errind)

#define BulkGetDataReq		DataRequest
#define BulkPutDataReq  	DataRequest
#define BulkGetAwaitDataInd	AwaitDataIndication
#define BulkPutAwaitDataInd	AwaitDataIndication

#define RRSendRequest 		BulkPutDataReq
#define RRAwaitResponseInd	BulkGetAwaitDataInd
#define RRAwaitRequestInd	BulkPutAwaitDataInd
#define RRSendResponse		BulkGetDataReq

/*
 * Synchronize with the sender to avoid buffering anomalies (the
 * sender starting before this receiver and the receiver just retrieves
 * data from the buffers!)
 */

#define BulkGetStart(ch, errind) \
{	\
    char buffer;	/* small buffer */	\
    DataRequest(ch, &buffer, 1, errind);	\
}

#define AwaitBulkGetStart(ch, errind)	\
{	\
    char buffer;	/* small buffer */	\
    AwaitDataIndication(ch, &buffer, 1, errind);	\
}

#define BulkGetStop(ch, errind) 	\
	    			{*errind = OK; }

#define AwaitBulkGetStop(ch, errind)	\
	    			{*errind = OK; }



#define BulkPutStart(ch, errind)	\
	    			{*errind = OK; }

#define AwaitBulkPutStart(ch, errind)\
	    			{*errind = OK; }

#define BulkPutStop(ch, errind)	\
{	\
    char buffer;	/* small buffer */	\
    AwaitDataIndication(ch, &buffer, 1, errind);	\
}

#define AwaitBulkPutStop(ch, errind)	\
{	\
    char buffer;	/* small buffer */	\
    DataRequest(ch, &buffer, 1, errind);	\
}


#define QueryCall(addrp, srcbuf, srclen, dstbuf, dstlen, errind) \
{ \
  channel_t ch; \
 \
  ConnRequest(addrp, &ch, errind); \
  if (!failed(errind)) { \
    RPCCall(ch, srcbuf, srclen, dstbuf, dstlen, errind); \
    if (!failed(errind)) { \
      DiscRequest(ch, errind); \
    } \
  } \
}

#define QueryAwaitCallInd(serverp, dstbuf, dstlen, chp, errind) \
{ \
    AwaitConnInd(serverp, chp, errind); \
	if (!failed(errind)) { \
	RPCAwaitCallInd(*(chp), dstbuf, dstlen, errind); \
    } \
}

#define QueryReturn(ch, srcbuf, srclen, errind) \
{ \
    RPCReturn(ch, srcbuf, srclen, errind); \
    if (!failed(errind)) { \
	AwaitDiscInd(ch, errind); \
    } \
}

#define RPCCall(ch, srcbuf, srclen, dstbuf, dstlen, errind) \
{ \
      DataRequest(ch, srcbuf, srclen, errind); \
      if (!failed(errind)) { \
	     AwaitDataIndication(ch, dstbuf, dstlen, errind); \
	     if (failed(errind)) { \
		report_error(errind, "AwaitDataIndication in RPCCall"); \
		return NOTOK; \
	     } \
      } \
}

#define RPCAwaitCallInd(ch, dstbuf, dstlen, errind) \
{ \
    AwaitDataIndication(ch, dstbuf, dstlen, errind); \
}

#define RPCReturn(ch, srcbuf, srclen, errind) \
{ \
    DataRequest(ch, srcbuf, srclen, errind); \
}
		
#endif _SUNTSAP_
