/* 1623, Tue 22 Nov 94

   NMC.H:  Global declarations for the NeTraMet Manager/Collector

   Copyright (C) 1992-1994 by Nevil Brownlee,
   Computer Centre,  The University of Auckland */

#define noFULL_IPX  /* Net+Host => 10-byte IPX peer addresses */
#define noCLNS      /* CLNS peer addresses are 20-byte NSAPs */

#if defined(FULL_IPX) || defined(CLNS)
#define BIG_PEER_ADDR
#endif

#ifndef EXTERN
#define EXTERN  extern
#define DECLARE  0
#define INIT(v)
#else
#define EXTERN
#define DECLARE  1
#define INIT(v)  = v
#endif

#define CFGFILE  "NeMaC.cfg"
#define RULEFILE "rules.txt"
#define LOGFILE  "NeMaC.log"
#define FLAGFILE "NeMaC.flag"

extern int errno;

EXTERN int snmp_dump_packet INIT(0);

EXTERN int verbose, testing, listrules;

#define MAC_ADDR_LEN     6  /* Address lengths */

#define IP_ADDR_LEN      4
#define DN_ADDR_LEN      3
#define ET_ADDR_LEN      3
#ifdef FULL_IPX
#define IPX_ADDR_LEN    10
#else
#define IPX_ADDR_LEN     4
#endif
#define NSAP_ADDR_LEN   20

#define DETAIL_ADDR_LEN  2

#ifdef BIG_PEER_ADDR
#define PEER_ADDR_LEN   20  /* Default */
#else
#define PEER_ADDR_LEN    4  /* Default */
#endif

#ifdef BIG_PEER_ADDR
#define RULE_ADDR_LEN   20  /* Max of above */
#else
#define RULE_ADDR_LEN    6  /* Max of above */
#endif

EXTERN char addr_len[]  /* Lengths for each address type */
#if DECLARE
   = {
      PEER_ADDR_LEN,   /*  0 Default */
      MAC_ADDR_LEN,    /*  1 Adjacent */
      IP_ADDR_LEN,     /*  2 IP */
      NSAP_ADDR_LEN,   /*  3 CLNS */
      4,               /*  4 IDPR */
      DN_ADDR_LEN,     /*  5 DECnet */
      IPX_ADDR_LEN,    /*  6 Novell IPX */
      ET_ADDR_LEN,     /*  7 EtherTalk */
      DETAIL_ADDR_LEN, /*  8 Detail */
      MAC_ADDR_LEN,    /*  9 */
      MAC_ADDR_LEN,    /* 10 */
      MAC_ADDR_LEN,    /* 11 */
      MAC_ADDR_LEN,    /* 12 Other */
      }
#endif
   ;

struct flow_info {  /* Accounting flow as viewed by NeMaC */
   unsigned int FlowIndex;
   unsigned char LowInterface, HighInterface;
   unsigned char LowAdjType, HighAdjType,
      LowAdjAddress[MAC_ADDR_LEN], LowAdjMask[MAC_ADDR_LEN],
      HighAdjAddress[MAC_ADDR_LEN], HighAdjMask[MAC_ADDR_LEN];
   unsigned char 
      LowPeerType,LowPeerTypeMask, HighPeerType,HighPeerTypeMask,
      LowPeerAddress[PEER_ADDR_LEN], LowPeerMask[PEER_ADDR_LEN],
      HighPeerAddress[PEER_ADDR_LEN], HighPeerMask[PEER_ADDR_LEN];
   unsigned char 
      LowDetailType,LowDetailTypeMask,  HighDetailType,HighDetailTypeMask,
      LowDetailAddress[DETAIL_ADDR_LEN], LowDetailMask[DETAIL_ADDR_LEN],
      HighDetailAddress[DETAIL_ADDR_LEN], HighDetailMask[DETAIL_ADDR_LEN];
   unsigned char FlowStatus, FlowRuleSet, FlowType;
   unsigned long
      FwdPackets,FwdBytes,  BackPackets,BackBytes,
      FirstTime,LastTime;
   };

struct rule_info {
   int RuleSet, RuleNbr;
   unsigned char RuleSelector,
      RuleMask[RULE_ADDR_LEN], RuleMatchedValue[RULE_ADDR_LEN], 
      RuleAction;
   unsigned int RuleJumpIndex;  /* NB, 22 Oct 93:  Was unsigned char! */
   };

#define AT_IGNORE     0  /* Addr_type values */
#define AT_ADJACENT   1
#define AT_IP         2
#define AT_CLNS       3
#define AT_IDPR       4
#define AT_DECNET     5
#define AT_NOVELL     6
#define AT_ETHERTALK  7
#define AT_DETAIL     8
#define AT_OTHER     12

#define PT_ICMP       1  /* IP protocol type values */
#define PT_TCP        6
#define PT_UDP       17

#define WNP_FTPDATA  20  /* Well-known tcp/udp port numbers */
#define WNP_FTP      21
#define WNP_TELNET   23
#define WNP_SMTP     25
#define WNP_DOMAIN   53
#define WNP_GOPHER   70
#define WNP_WWW      80
#define WNP_NNTP    119
#define WNP_NTP     123
#define WNP_SNMP    161

#define RA_COUNT      1
#define RA_TALLY      2
#define RA_AGGREGATE  3
#define RA_SUCCEED    4
#define RA_FAIL       5
#define RA_PUSHTO     6
#define RA_POPTO      7
#define RA_GOTO       8
#define RA_GOSUB      9
#define RA_RETURN    10
#define RA_ASSIGN    11

#define RF_SET       -2  /* -1 is EOF !!! */
#define RF_RULES     -3
#define RF_ACTIONS   -4
#define RF_FORMAT    -5
#define RF_STATS     -6
#define RF_SYMBOL    -7

#define FTFLOWINDEX		1  /* Flow table attribute values */
#define FTFLOWSTATUS		2

#define FTLOWINTERFACE          3
#define FTLOWADJACENTTYPE       4
#define FTLOWADJACENTADDRESS    5
#define FTLOWADJACENTMASK       6
#define FTLOWPEERTYPE		7
#define FTLOWPEERTYPEMASK	8
#define FTLOWPEERADDRESS	9
#define FTLOWPEERMASK	       10
#define FTLOWDETAILTYPE        11
#define FTLOWDETAILTYPEMASK    12
#define FTLOWDETAILADDRESS     13
#define FTLOWDETAILMASK        14
#define FTLOWSUBSCRIBERID      15
#define FTLOWSUBSCRIBERMASK    16
#define FTHIINTERFACE          17
#define FTHIADJACENTTYPE       18
#define FTHIADJACENTADDRESS    19
#define FTHIADJACENTMASK       20
#define FTHIPEERTYPE	       21
#define FTHIPEERTYPEMASK       22
#define FTHIPEERADDRESS	       23
#define FTHIPEERMASK	       24
#define FTHIDETAILTYPE         25
#define FTHIDETAILTYPEMASK     26
#define FTHIDETAILADDRESS      27
#define FTHIDETAILMASK         28
#define FTHISUBSCRIBERID       29
#define FTHISUBSCRIBERMASK     30

#define FTSUBSCRIBERID         31
#define FTSUBSCRIBERMASK       32

#define FTPDUSCALE             33
#define FTOCTETSCALE           34
#define FTRULESET              35
#define FTFLOWTYPE             36

#define FTUPOCTETS	       37
#define FTUPPDUS	       38
#define FTDOWNOCTETS	       39
#define FTDOWNPDUS	       40

#define FTFIRSTTIME	       41
#define FTLASTTIME	       42

#define NATTRIBS       FTLASTTIME

#define FTFORWARD    50
#define FTV1         51
#define FTV2         52
#define FTV3         53
#define FTV4         54
#define FTV5         55

struct attrib_info {
   char *name;
   unsigned char index;
   unsigned char len;
   };

#define SZ_ATTRIBS  (1+NATTRIBS+8)
EXTERN struct attrib_info attribs[SZ_ATTRIBS]
#if DECLARE
   = {
      /* Serial search -> longest names first! */
   "null",                   0,                     0,
   "flowindex",              FTFLOWINDEX,           2,
   "flowstatus",             FTFLOWSTATUS,          1,
   "sourceinterface",        FTLOWINTERFACE,        1,
   "sourceadjacenttype",     FTLOWADJACENTTYPE,     1,
   "sourceadjacentaddress",  FTLOWADJACENTADDRESS,  MAC_ADDR_LEN,
   "sourceadjacentmask",     FTLOWADJACENTMASK,     MAC_ADDR_LEN,
   "sourcepeertypemask",     FTLOWPEERTYPEMASK,     1,
   "sourcepeertype",         FTLOWPEERTYPE,         1,
   "sourcepeeraddress",      FTLOWPEERADDRESS,      PEER_ADDR_LEN,
   "sourcepeermask",         FTLOWPEERMASK,         PEER_ADDR_LEN,
   "sourcetranstypemask",    FTLOWDETAILTYPEMASK,   1,
   "sourcetranstype",        FTLOWDETAILTYPE,       1,
   "sourcetransaddress",     FTLOWDETAILADDRESS,    DETAIL_ADDR_LEN,
   "sourcetransmask",        FTLOWDETAILMASK,       DETAIL_ADDR_LEN,
   "sourcesubscriberid",     FTLOWSUBSCRIBERID,     0,
   "sourcesubscribermask",   FTLOWSUBSCRIBERMASK,   0,
   "destinterface",          FTHIINTERFACE,         1,
   "destadjacenttype",       FTHIADJACENTTYPE,      1,
   "destadjacentaddress",    FTHIADJACENTADDRESS,   MAC_ADDR_LEN,
   "destadjacentmask",       FTHIADJACENTMASK,      MAC_ADDR_LEN,
   "destpeertypemask",       FTHIPEERTYPEMASK,      1,
   "destpeertype",           FTHIPEERTYPE,          1,
   "destpeeraddress",        FTHIPEERADDRESS,       PEER_ADDR_LEN,
   "destpeermask",           FTHIPEERMASK,          PEER_ADDR_LEN,
   "desttranstypemask",      FTHIDETAILTYPEMASK,    1,
   "desttranstype",          FTHIDETAILTYPE,        1,
   "desttransaddress",       FTHIDETAILADDRESS,     DETAIL_ADDR_LEN,
   "desttransmask",          FTHIDETAILMASK,        DETAIL_ADDR_LEN,
   "destsubscriberid",       FTHISUBSCRIBERID,      0,
   "destsubscribermask",     FTHISUBSCRIBERMASK,    0,
   "subscriberid",           FTSUBSCRIBERID,        0,
   "subscribermask",         FTSUBSCRIBERMASK,      0,
   "pduscale",               FTPDUSCALE,            0,
   "octetscale",             FTOCTETSCALE,          0,
   "flowruleset",            FTRULESET,             1,
   "flowtype",               FTFLOWTYPE,            1,
   "tooctets",               FTUPOCTETS,            4,
   "topdus",                 FTUPPDUS,              4,
   "fromoctets",             FTDOWNOCTETS,          4,
   "frompdus",               FTDOWNPDUS,            4,
   "firsttime",              FTFIRSTTIME,           4,
   "lasttime",               FTLASTTIME,            4,
   "sourcedetailtypemask",   FTLOWDETAILTYPEMASK,   1,
   "sourcedetailtype",       FTLOWDETAILTYPE,       1,
   "sourcedetailaddress",    FTLOWDETAILADDRESS,    DETAIL_ADDR_LEN,
   "sourcedetailmask",       FTLOWDETAILMASK,       DETAIL_ADDR_LEN,
   "destdetailtypemask",     FTHIDETAILTYPEMASK,    1,
   "destdetailtype",         FTHIDETAILTYPE,        1,
   "destdetailaddress",      FTHIDETAILADDRESS,     DETAIL_ADDR_LEN,
   "destdetailmask",         FTHIDETAILMASK,        DETAIL_ADDR_LEN }
#endif
   ;

EXTERN unsigned char col_order[1+NATTRIBS]  /* In descending-length order */
#if DECLARE
   = {
   FTLOWADJACENTADDRESS,FTLOWADJACENTMASK,
   FTHIADJACENTADDRESS,FTHIADJACENTMASK,
   
   FTLOWPEERADDRESS,FTLOWPEERMASK,
   FTHIPEERADDRESS,FTHIPEERMASK,
   FTUPOCTETS,FTUPPDUS, FTDOWNOCTETS,FTDOWNPDUS,
   FTFIRSTTIME,FTLASTTIME,
   
   FTLOWDETAILADDRESS,FTLOWDETAILMASK,
   FTHIDETAILADDRESS,FTHIDETAILMASK,
   
   FTFLOWSTATUS,
   FTLOWINTERFACE,FTLOWADJACENTTYPE,
   FTLOWPEERTYPE,FTLOWPEERTYPEMASK,
   FTLOWDETAILTYPE,FTLOWDETAILTYPEMASK,
   FTHIINTERFACE,FTHIADJACENTTYPE,
   FTHIPEERTYPE,FTHIPEERTYPEMASK,
   FTHIDETAILTYPE,FTHIDETAILTYPEMASK,
   FTRULESET,FTFLOWTYPE,
   
   NULL,  /* Marks end of implemented attributes */
   
   FTPDUSCALE,FTOCTETSCALE,
   FTLOWSUBSCRIBERID,FTLOWSUBSCRIBERMASK,
   FTHISUBSCRIBERID,FTHISUBSCRIBERMASK,
   FTSUBSCRIBERID,FTSUBSCRIBERMASK,

   FTFLOWINDEX }  /* Never retrieve FlowIndex explicitly! */
#endif
   ;

#define FLOWBLOBSZ  55

#define FB_OBJECT_SZ  (2+1+MAC_ADDR_LEN)
#define FB_DATA_SZ    FLOWBLOBSZ*FB_OBJECT_SZ

EXTERN unsigned char column_blob[
   FB_DATA_SZ + 2*(2+1+RULE_ADDR_LEN)];

#define MX_BLOB_FLOWS  ((FLOWBLOBSZ+2)*MAC_ADDR_LEN/DETAIL_ADDR_LEN)
EXTERN struct flow_info flows[MX_BLOB_FLOWS];

#if defined(AU_MSDOS) || defined(ULTRIX) || defined(SOLARIS) || defined(LINUX)
   /* ntoh routines swap the byte order for these systems .. */
#define netshort(x)  x
#define netlong(x)   x
#else
   /* .. other systems ntoh routines don't swap the byte order */
#define netshort(x)  htons(x)
#define netlong(x)   htonl(x)
#endif

#define NAME_LN  64

struct meter_status {
   struct meter_status *next;

   char name[NAME_LN];  /* Meter name (DNS name or IP address) */
   unsigned char community[NAME_LN],  /* Write-access SNMP community */
      write_OK,  /* We really do have write access */
      no_write_warned;  /* 'No write' warning logged */
   char rulefile[NAME_LN];
   unsigned int sample_interval,  /* Seconds between samples */
      keepalive_interval;  /* Seconds between keepalives. 0 = no keepalives */
   time_t next_keepalive, next_sample,  /* Time events are to happen */
      next_event;

   struct snmp_session *ss;

   short status;

   char descr[NAME_LN];  /* From meter_info() */
   oid versionid[20];  char version[10];
   unsigned long uptime;
   unsigned long OurLastCollectTime;

   int CurrentRuleSet,  /* From meter */
      ruleset, nrules, nactions;  /* From rule file */

   unsigned char format[1+NATTRIBS];
   char *separator[1+NATTRIBS];
   unsigned char required[1+NATTRIBS];

   unsigned long LastCollectTime;  /* By any collector, not neccessarily us */

   unsigned int snmp_delay;  /* ms to wait after snmp requests */

   unsigned char statsreqd;

   int InactivityTime, SamplingRate;  /* Meter control variables */
   unsigned char HighWaterMark, GCIntervalReqd;

   unsigned char GCInterval;  /* Meter Statistics variables */
   unsigned int
      MaxPktRate,MaxPktBacklog,
      TotalHashSize,NbrHashEntries,
      NbrFlows,MaxFlows,
      AvIdle1000,MinIdle1000;
   unsigned long
      StatsTime,NbrPackets,TotPktBacklog,LostPackets,
      RuleMatches,HashSearches,HashCompares,
      FlowsRecovered;

   FILE *flows;
   };

struct calendar_entry {
   struct calendar_entry *next;
   time_t next_event;
   struct meter_status *ms;
   };

EXTERN FILE *log;

EXTERN struct meter_status *first_meter;
EXTERN int nmeters;

EXTERN struct calendar_entry *calendar;

/* Values for status */

#define	MT_MANAGE    0x0001  /* Manage this meter */
#define	MT_INFO	     0x0002  /* Have basic info */
#define	MT_UP	     0x0004  /* Meter is running */
#define	MT_REPORTED  0x0008  /* Current status reported */


EXTERN FILE *rfp;  /* Scanner globals */
EXTERN char inbuf[256], *ibp;
EXTERN int lic, ic,  /* Last input char, current input char */
   iblisted, rule_line, rferrors;
EXTERN char err_msg[60];

struct symbol {
   char id[40];
   int kind;
   unsigned int value;
   };

#define MXSYMBOLS  200
EXTERN struct symbol symbol_table[MXSYMBOLS];
EXTERN int st_top,st_index, pass;


/* Forward procedure declarations .. */

unsigned short getshort(unsigned char *ucp);
unsigned long getlong(unsigned char *ucp);
unsigned short get_slice(struct meter_status *ms,
   unsigned short first_row, unsigned char col, 
   unsigned char first);

void write_attrib(FILE *f,
   struct flow_info *fp, unsigned char col);

int create_meter(struct meter_status *ms, time_t first_t);
void monitor(struct meter_status *ms);
void print_meters();
void meter_print(FILE *f,struct meter_status *ms);

/* Functions declared in nmc_pars.c */

void mswait(unsigned int ms);
FILE *wfopen(char *fn);
char *gnbr(unsigned int *n, char *s);
char *gcstring(char *s, int *len);

char *fmt_time(time_t *t);
char *uptime_string(unsigned long timeticks, char *buf);
void printaddress(FILE *f,unsigned char *a,unsigned char addrsz);
void printruleaddress(FILE *f,unsigned char *a);

int parse_open(char *fn);
int nextchar(void);
void getarg(char *arg);
int wordis(char *p,char *w);
void p_error(char *msg);
int getword(void);
int getnbr(int maxnbr);
unsigned int getint(unsigned int *base);
void getaddress(unsigned char *a,unsigned char len,
   unsigned char addrsz);
int getattribute(unsigned char col,struct flow_info *fp);

int scan_rulefile(struct meter_status *ms, int doset, int list);
void parse_rulefile(struct meter_status *ms,
   int list, int syntax);

/* Functions declared in nmc_snmp.c */

int trim(unsigned char *s, int len);
int start_snmp_session(struct meter_status *ms);
int set_meter_params(struct meter_status *ms);
int set_collect_time(struct meter_status *ms, int v);
int set_rule_info(struct meter_status *ms, int setset);
int add_rule(struct meter_status *ms, struct rule_info *ri);
int add_action(struct meter_status *ms, struct flow_info *ai,
   unsigned char ActionSet,unsigned char ActionNbr,
   unsigned char *required);
int same_acct_oid(oid *a, oid *b);
int column_info(struct meter_status *ms, unsigned char *fb,
   unsigned char a, unsigned long ft, int *fn);
int meter_is_current(struct meter_status *ms);
int meter_info(struct meter_status *ms);
   


