/* 1715, Mon 10 May 93

   PKTSNAP.H:  Declarations for AU packet monitoring
		  extensions to Waterloo TCP/IP

   Copyright (C) 1992 by Nevil Brownlee,
   Computer Centre,  University of Auckland */

#ifdef PKTSNAP
#define EXTERN
#else
#define EXTERN extern
#endif


/* Declared in wattcp\src\pcpkt.c .. */

extern char au_monitor;  /* 1 to enable monitoring */

extern unsigned char eth_addr[6];
extern long npackets,nbytes, badpackets,nobufpackets;

void pkt_rcv_call2(unsigned int handle, unsigned int len,
   unsigned char far *buff);


/* Declared in wattcp\elib\q*.asm .. */

void qmove(unsigned char far *s, unsigned char far *d, unsigned int n);
int qcmp(unsigned char far *s, unsigned char far *d, unsigned int n);


/* Monitor variables .. */

EXTERN long lostpackets;

#define SNAPFROM  14  /* Save bytes FROM to TO in pkt */
#define SNAPTO    35
#define SNAPLEN   (SNAPTO - SNAPFROM + 1)

#define MAXPKTLEN  1526

/* pkt data structure */
struct pkt {
   unsigned int p_len;
   unsigned char p_type,
      p_data[SNAPLEN];
   };

#define MAXPKT   1024  /* Must be a power of 2 */
#define PKTMASK  MAXPKT-1

EXTERN struct pkt far *pkts;

EXTERN int prcv, pproc;

EXTERN long l_tod;  /* Time of day */
EXTERN char tod_h,tod_m,tod_s,
   s_tod_h,s_tod_m,s_tod_s;  /* Time when counters last saved */

EXTERN int midnight_crossings;
EXTERN long boot_time;

EXTERN long elapsed_sec;  /* Seconds since counters last saved */

void chart(int tx, int ty,  /* Declared in chart.c */
   int bx, int by,
   int x1, int x2, int x3);

long biosticks(void);  /* PC clock ticks */
long uptime(void);  /* Since startup, in centiseconds */

/* 12 bytes interframe space + 8 bytes preamble + 4 byte FCS */
#define util_pc(p,b)  (((24l*p + b)/1250l + 5l)/10l)  /* % utilisation */

#ifndef NULL
#define NULL  0
#endif