/* 0950, Tue 27 Apr 93

   PRTSERV: TCP Stream <-> RS232 Print Server with XON/XOFF

   Copyright (C) 1993 by Nevil Brownlee
   Computer Centre,  University of Auckland */

#define VERSION "NPS:  Nevil's Async Print Server  V1.3"

#define noDEBUG

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <dos.h>
#include <conio.h>
#include <alloc.h>
#include <mem.h>
#include <time.h>

#include <tcp.h>

#define EXTERN
#include "prtserv.h"

#define SERIAL_TICK  4  /* 4 ticks -> 4.5 tests per second */
#define CONTROL_TIMEOUT  300*18  /* 5 minutes (300s) of ticks */

void put_msg(tcp_Socket *t, char *msg)
{
   char buf[90], *bp;
   if (t == NULL) printf("%s\n",msg);
   else {
      bp = strmov(buf,msg);
      bp = strmov(bp,"\r\n");
      sock_write(t,buf,bp-buf);  /* Doesn't flush */
      }
   }

char *time_str(time_t *t)
{
   char *r = ctime(t);
   r[24] = '\0';  /* Trim trailing \n */
   return r;
   }

void print_server_id(tcp_Socket *t)
{
   char msg[80], idbuf[60];
   int n;
   put_msg(t,VERSION);
   put_msg(t,"   Copyright (C) 1993 by Nevil Brownlee");
   put_msg(t,"   Computer Centre,  University of Auckland");
   sprintf(msg,"Running on %s", inet_ntoa(idbuf, gethostid()));
   put_msg(t,msg);
   sprintf(msg,"Start time:  %s", time_str(&startup_t));
   put_msg(t,msg);
   sprintf(msg,"Statistics last Zeroed:  %s", time_str(&last_reset_t));
   put_msg(t,msg);
   }

void printwelcome(tcp_Socket *t)
{
   print_server_id(t);
   }

int password_tries, password_OK = 0, cmd_countdown = 0;

void issue_challenge(tcp_Socket *t)
{
   password_tries = 3;
   sock_puts(t,"password: ");  /* Flushes */
   }

void reset_stats(void)
{
   int sess;
   prtinfo *s;
   struct printer_i_s *isp;
   for (sess = 1;  sess != ps_sessions;  ++sess) {
      s = prt[sess];
      isp = &printer_info[s->print_ix-1];
      isp->high_water = 0;
      isp->chars_sent = 0L;
      }
   last_reset_t = time(NULL);
   }

char *peer_name(prtinfo *s)
{
   struct sockaddr from;
   static char tcp_peer[30];
   int j;
   if (s->status != S_CONN) tcp_peer[0] = '\0';
   else {
      j = sizeof(struct sockaddr);
      getpeername(&s->socket, &from,&j);
      inet_ntoa(tcp_peer,from.s_ip);
      }
   return tcp_peer;
   }

void write_log(char *msg)
{
   time_t tod = time(NULL);
   printf("%s:  %s\n",time_str(&tod),msg);
   }

int cmd_nbr(char *cp)
{
   while (!isspace(*cp) && *cp != NULL)  /* Find object after next space */
      ++cp;
   while (isspace(*cp)) ++cp;
   return atoi(cp);
   }

void control(prtinfo *s, unsigned char *command)
{
   prtinfo *pi;
   tcp_Socket *t = &s->socket;
   struct printer_i_s *isp;
   int i,j;
   unsigned char c, *cp;
#ifdef DEBUG
   for (i = 0;  ; ++i) {
      if ((c = command[i]) == '\0') break;
      if (isprint(c)) printf("%c ",c);
      else printf("%02x ",c);
      }
   printf("\n");
#endif
   cmd_countdown = CONTROL_TIMEOUT;
   for (cp = command; isspace(*cp); ++cp) ;
   if (!password_OK) {
      if (strcmp(server_password,cp) != 0) {
	 if (--password_tries == 0) {
	    write_log("Three bad passwords <<<");
	    sock_close(t);
	    s->status = S_CLOS;
	    return;
	    }
	 sock_puts(t,"password: ");  /* Flushes */
	 }
      else {
	 password_OK = 1;
	 sock_puts(t,"prtserv> ");  /* Flushes */
	 }
      return;
      }
   c = toupper(*cp++);
   if (c == '\0') c = 'S';  /* Null command -> Status */
   if (c == 'Q') {
      printf("Control Quit\n");
      sock_close(t);
      s->status = S_CLOS;
      return;
      }
   if (c == '?') {
      put_msg(t, "Commands are ..");
      put_msg(t, "  C    show server Configuration");
      put_msg(t, "  D p  Disconnect stream to COM port p");
      put_msg(t, "  I    show server Info");
      put_msg(t, "  Q    Quit (log off from server)");
      put_msg(t, "  R p  Reset COM port p");
      put_msg(t, "  S    show server Status");
      put_msg(t, "  Z    Zero statistics");
      }
   else if (c == 'C') print_config(t);
   else if (c == 'S') print_state(t);
   else if (c == 'I') print_server_id(t);
   else if (c == 'Z') {
      reset_stats();
      put_msg(t,"Statistics reset");
      }
   else if (c == 'R' || c == 'D') {
      i = cmd_nbr(cp);
      if (i < 1 || i > 4) put_msg(t,"Bad COM port number");
      else {
	 for (j = 1; j != ps_sessions; ++j) {
	    pi = prt[j];
	    if (pi->print_ix == i) break;
	    }
	 if (j == ps_sessions) sock_printf(t, "COM%d not in use\r\n",i);
	 else {
	    if (c == 'D') {
	       sock_close(&pi->socket);
	       pi->status = S_CLOS;
	       sock_printf(t,"Disconnecting stream to COM%d\r\n",i);
	       }
	    else sock_printf(t,"Reseting COM%d\r\n",i);
	    isp = &printer_info[i-1];
	    cominit(isp->ap);
	    }
	 }
      }
   else sock_puts(t,"unrecognised command\r\n");
   sock_flushnext(t);
   sock_puts(t,"prtserv> ");
   }

#ifdef DEBUG
long lastdebug = 0;
/*  unsigned long *mem0 = 0L;  /* For finding null ponter assignments */
/*     printf("mem0 -> %08lx\n", *mem0);  */
#define DEBUG_PERIOD  30  /* Seconds */
#endif /* DEBUG */

static char cmd_buf[30], *cbp;

void prtd_tick()
{
   int sess, i,j;
   unsigned char c;
   prtinfo *s;
   tcp_Socket *t;
   struct printer_i_s *isp;

#ifdef DEBUG
/*
*  Display some stats every DEBUG_PERIOD
*/
   if (chk_timeout(lastdebug)) {
      for (i = 0;  i != ps_sessions; ++i) {
	 s = prt[i];  t = &s->socket;
	 printf(" %u : %u : %u : %s\n",
	    i, s->status, t->undoc[4], sockstate(t));
	 }
      lastdebug = set_timeout(DEBUG_PERIOD);
      }
#endif  /* DEBUG */

   /* Check the TCP sessions for any activity */

   for (sess = 0;  sess != ps_sessions;  ++sess) {
      tcp_tick(NULL);
      s = prt[sess];  t = &s->socket;
      switch (s->status) {
      case S_INIT:
	 sprintf(messagebuf,"INIT session %u",sess);
	 write_log(messagebuf);
	 sock_abort(t);  /* Make sure old session has completely finished */
	 tcp_listen(t, s->tcpport, 0L, 0, NULL, 0);
	 /* Default is binary mode - chars sent as they arrive,
	       no translation of \n to \r\n */
	 if (s->print_ix == 0) password_OK = 0;  /* Control port */
	 s->status = S_WAIT;
	 break;

      case S_WAIT:
	 if (sock_established(t)) {
	    s->status = S_CONN;
	    if (s->print_ix == 0) {  /* Control port */
	       please_echo();
	       issue_challenge(t);
	       cbp = cmd_buf;
	       sprintf(messagebuf,"OPEN console for %s",peer_name(s));
	       }
	    else sprintf(messagebuf,"OPEN COM%u for %s",
	       s->print_ix,peer_name(s));
	    write_log(messagebuf);
	    }
	 if (!tcp_tick(t)) s->status = S_CLOS;
	 break;

      case S_CONN:
      case S_CLOS:
	 if ((j = sock_dataready(t)) != 0) {  /* New data has arrived */
	    if (s->print_ix == 0) {  /* Control port */
	       j = sock_fastread(t, messagebuf,j);
	       j = TO_parse(t,j);  /* Remove Telnet option bytes */
	       if (j) {
		  for (i = 0; i != j; ++i) {
		     c = messagebuf[i];
		     if (c == '\0' || c == '\n') continue;
		     if (echo) {  /* We are echoing */
			sock_flushnext(t);
			sock_putc(t, password_OK || c == '\r' ? c : '*');
			}
		     else {  /* Host is echoing */
			if (!password_OK && c != '\r') {  /* Overwrite it */
			   sock_flushnext(t);
			   sock_write(t, "\b*",2);
			   }
			}
		     if (c == '\r') {
			if (echo || messagebuf[i+1] != '\n') {
			   sock_putc(t, '\n');  /* \n causes flush */
			   }
			*cbp = '\0';  control(s,cmd_buf);
			cbp = cmd_buf;
			}
		     else *cbp++ = c;
		     }
		  }
	       }
	    else {  /* Serial port */
	       isp = &printer_info[s->print_ix-1];
	       j = comsbuf(isp->ap,0);  /* <0 if waiting for XON */
	       if (j < 0) j = -j;  /* j = chars in tx buffer */
	       if (!isp->xoff_sent && isp->bufsz-j > 500) {  /* Our buffer isn't full */
		  j = sock_fastread(t, messagebuf,500);  /* Max 500 bytes */
		  for (i = 0; i != j; ++i) comsend(isp->ap, messagebuf[i]);
		  isp->chars_sent += j;
		  j = comsbuf(isp->ap,0);  /* <0 if waiting for XON */
		  if (j < 0) j = -j;  /* j = chars in tx buffer */
		  if (j > isp->maxchar) {
		     sock_putc(t, XOFF);  sock_flush(t);
		     isp->xoff_sent = 1;
		     }
		  if (j > isp->high_water) isp->high_water = j;
		  }
	       }
	    }
	 if (!tcp_tick(t)) {  /* TCP keepalive */
	    if (s->status == S_CONN) {
	       sprintf(messagebuf,"SHUTDOWN by remote host");
	       sock_close(t);
	       s->status = S_CLOS;
	       }
	    else {  /* Was closing */
	       sprintf(messagebuf,"CLOSE session %u",sess);
	       s->status = S_INIT;
	       }
	    write_log(messagebuf);
	    }
	 break;
	 }
      }
   }

#ifdef QQRRSS
int lognum = 0;
void intmap(char *msg)  /* Log the current interrupt vector */
{
   FILE *log;
   void interrupt (*oldfunc)();
   void far *fp;
   int j;
   char fname[40];
   sprintf(fname, "intmap.%03d", ++lognum);
   log = fopen(fname,"w");
   if (log == NULL) {
      printf("Failed to open %s\n",fname);
      }
   else printf("%s opened: %s\n",fname,msg);
   fprintf(log,"--- %s --- %s\n",fname,msg);
   for (j = 0; j != 0x61; ++j) {
      oldfunc = getvect(j);
      fp = (void far *)oldfunc;
      fprintf(log,"%02x %04x:%04x\n", j, FP_SEG(fp),FP_OFF(fp));
      }
   fclose(log);
   }
#endif

void close_coms(void)
{
   int i;
   prtinfo *s;
   struct printer_i_s *isp;
   for (i = 1;  i != ps_sessions; ++i) {
      s = prt[i];
      isp = &printer_info[s->print_ix-1];
      comfin(isp->ap);  /* Close serial port */
      printf("COM%d: closed\n",s->print_ix);
      }
   }

void print_state(tcp_Socket *t)
{
   int sess,j,k;
   prtinfo *s;
   struct printer_i_s *isp;
   static char *stream_state[4] = {"Init","Wait","Conn","Close"};
   static char *flow_state[2] = {"OK", "XOFF"};
   struct sockaddr from;
   char buf[80];
   put_msg(t,
   "COM  State  Peer           Stream     Peak  Buffer  Printer      Chars");
   for (sess = 1;  sess != ps_sessions;  ++sess) {
      s = prt[sess];
      isp = &printer_info[s->print_ix-1];
      j = comsbuf(isp->ap,0);  /* <0 if waiting for XON */
      if (j < 0) {
	 j = -j;  k = 1;
	 }
      else k = 0;
      sprintf(buf,"%3d  %5s  %-15s  %4s    %5d   %5d    %4s %11ld",
	 sess, stream_state[s->status],
	 peer_name(s), flow_state[isp->xoff_sent],
	 isp->high_water, j, flow_state[k],
	 isp->chars_sent);
      put_msg(t,buf);
      }
   }

void main()
{
   int i,j, fatal;
   prtinfo *s;
   tcp_Socket *t;
   struct printer_i_s *isp;
   long lastserial = 0;

   sock_init();
   last_reset_t = startup_t = time(NULL);
   print_server_id(NULL);

   get_prt_config();
   print_config(NULL);

   prt[0] = s = calloc(1,sizeof(prtinfo));  /* Allocate control port */
   s->status = S_INIT;  s->print_ix = 0;
   s->tcpport = 23;  /* Telnet */

   for (fatal = 0, i = j = 1;  j != ps_sessions;  ++j) {
      isp = &printer_info[j-1];
      if (isp->ln_speed == 0) continue;  /* Find next active COM port */
      if ((s = calloc(1,sizeof(prtinfo))) == NULL) {
	 printf("Could only open %i tcp ports\n", i);
	 break;
	 }
      prt[i++] = s;
      s->status = S_INIT;  s->print_ix = j;
      s->tcpport = isp->tcpport_nbr;
      isp->high_water = 0;  isp->chars_sent = 0L;
      isp->xoff_sent = 0;
      if ((isp->ap = COMopen(j)) == NULL) fatal = 1;
      }
   ps_sessions = i;
   printf("%d sessions allocated, %u bytes near memory left\n",
      ps_sessions,coreleft());
   if (fatal) {  /* Hardware problem! */
      close_coms();
      exit(3);
      }

   for (;;) {
      prtd_tick();  /* Keep tcp sessions alive */
      if (chk_timeout(lastserial)) {

	 /* Check the serial ports for XON/XOFF changes */

	 for (i = 1;  i != ps_sessions; ++i) {
	    s = prt[i];
	    if (s->status != S_CONN) continue;  /* Session has stopped */
	    isp = &printer_info[s->print_ix-1];
	    j = comsbuf(isp->ap,0);  /* <0 if waiting for XON */
	    if (j < 0) j = -j;  /* j = chars in tx buffer */
	    t = &s->socket;
	    if (j > isp->maxchar) {
	       sock_putc(t, XOFF);  sock_flush(t);
	       isp->xoff_sent = 1;
	       }
	    else if (isp->xoff_sent && j < isp->minchar) {
	       sock_putc(t, XON);  sock_flush(t);
	       isp->xoff_sent = 0;
	       }
	    if ((j = comrecv(isp->ap)) >= 0) {  /* Char rcvd from printer */
	       sock_putc(t, j);
	       sock_flush(t);  /* Pass it on to host */
	       }
	    }

	 /* Time out an inactive console session */

	 if (cmd_countdown > 0) {
	    if ((cmd_countdown -= SERIAL_TICK) <= 0) {
	       s = prt[0];
	       if (s->status == S_CONN) {
		  printf("Control Timeout\n");
		  sock_puts(t = &s->socket,"Inactivity timeout\r\n");
		  sock_close(t);
		  s->status = S_CLOS;
		  }
	       }
	    }

	 /* See if there's anything at the keyboard */

	 if (kbhit()) {
	    i = toupper(getch());
	    if (i == 'C') print_config(NULL);
	    else if (i == 'I') print_server_id(NULL);
	    else if (i == 'S') print_state(NULL);
	    else if (i == 'Q') {  /* Shut the server down */
	       close_coms();
	       exit(1);
	       }
	    }

	 lastserial = set_ttimeout(SERIAL_TICK);
	 }
      }
   }
