/*****************************************************************************
 *  File:  misc.c      Miscellaneous modules needed for pingky & Display.      *
 *                                                                           *
 *  Version 1.0       Author: WB Norton  Merit Computer Network              *
 *  Modification History:                                                    *
 *  written 5/18/89   Bill Norton, Merit Computer Network                    *
 *                    Much of this code actually came from the Rochkind      *
 *                    "Advanced UNIX Programming" Book.                      *
 *  09/12/89 - Added itoa from K + R					     *
 *****************************************************************************/
#include <stdio.h>
#include <errno.h>
#include <fcntl.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "../INCLUDE/defs.h"
#include "../INCLUDE/misc.h"	/* Defs for Miscellaneous routines */

#define LOCKDIR "/tmp/"
#define MAXTRIES 5

static struct stat omstat,nmstat;
static char *mailbox;
static long laststattime,moves;
#define NAPTIME 5

ckmailstatus() {
        if(!mailbox)
                return;
        laststattime = moves;
        if(stat(mailbox, &nmstat)){
              nmstat.st_mtime = 0;
	}
        else if(nmstat.st_mtime > omstat.st_mtime) {
                      if(nmstat.st_size)
                          printf("MAIL IS WAITING\n");
                         /*     newmail();  */
                      /* getmailstatus();        /* might be too late ... */
        }
}

reverse(s)	/* reverse string s in place */
char s[];
{
	int c, i, j;

	for (i=0, j=strlen(s)-1; i < j; i++, j--) {
		c = s[i];
		s[i] = s[j];
		s[j] = c;
	}
}

char *itoa(n, s)	/* convert n to characters in s */
char s[];
int n;
{
	int i, sign;

	if ((sign = n) < 0) /* record sign */
		n = -n;	    /* make n positive */
	i = 0;
	do {		/* generate digits in reverse order */
		s[i++] = n % 10 + '0';	/* get next digit */
	} while ((n /= 10) > 0);	/* Delete it */
	if (sign < 0)
		s[i++] = '-';
	s[i] = '\0';
	reverse(s);
	return(s);
}


/************************************************************************
 *       Log:         Append a time-stamped log record to a file	*
 ************************************************************************/
void Log(line,logfile)
char *line;             /* line to be logged */
char *logfile;		/* File to log it in */
{
int fd,length;
char Event[60];

   GetTime(Event);

   length=strlen(line);

   if ((fd = open(logfile,O_WRONLY | O_APPEND)) == -1)
      syserr("Log");
   if ( write(fd,Event,17) != 17)       /* Write Date/Time to disk */
      syserr("Write Log");
   if ( write(fd,line,length) != length ) /* Write line to disk */
      syserr("Write Log");
   if (close(fd)==-1) syserr("fclose log");
}


/*****************************************************************************
 *    GetTime - Returns a string in the form we most often want to deal with *
 *                    Mon Mar 23 13:23\0                                     *
 *****************************************************************************/
char *GetTime(putithere)
char *putithere;
{
long t;           /* Structure to hold the time */
struct tm *tm;

   time(&t);
   tm=localtime(&t);
   sprintf(putithere,"%s",asctime(tm));
   putithere[16]=' ';
   putithere[17]='\0';
   return(putithere);
}

/****************************************************************
 * FileChanged: Return whether or not the file has changed      *
 ****************************************************************/
BOOLEAN FileChanged(filename,lastmodtime)
char *filename;         /* Filename of file we are interested in     */
long *lastmodtime;      /* Last Modification Time returned from fstat */
{
struct stat buf;

   if(stat(filename,&buf) != 0) {
        perror(filename);
        perror("FileChanged:");
        exit(1);
   }
   if ( *lastmodtime != buf.st_mtime) {
      *lastmodtime=buf.st_mtime;
      return(TRUE);	/* File HAS changed */
   }
   return(FALSE);	/* File HAS NOT changed */
}

/****************************************************************
 *        Empty_File:   Empty a file                            *
 ****************************************************************/
void Empty_File(File)
char *File;
{
int pfd;

    if ((pfd=open(File,O_WRONLY | O_CREAT | O_TRUNC, 0644)) == -1)
        syserr("Empty_File: open");
    if (close(pfd) == -1)
        syserr("Empty_File: close");
}

void panic(str)
char *str;
{
  perror(str);
  exit(1);
}

void syserr(msg) /* print system call error message and terminate */
char *msg;
{
   extern int errno, sys_nerr;
   extern char *sys_errlist[];

   fprintf(stderr,"ERROR: %s (%d", msg, errno);
   if (errno > 0 && errno < sys_nerr)
      fprintf(stderr,"; %s)\n",sys_errlist[errno]);
   else
      fprintf(stderr,")\n");
   exit(1);
}

void fatal(msg) /* print error message and terminate */
char *msg;
{
   fprintf(stderr,"ERROR: %s\n",msg);
   exit(1);
}

BOOLEAN lock(name)    /* Acquire lock */
char *name;
{
   char *path,*lockpath();
   int fd,tries;
   extern int errno;
   
   path = lockpath(name);
   tries=0;
/*   while((fd = creat(path, 0)) == -1 && errno == EACCES) { */
   while((fd=open(path,O_WRONLY|O_CREAT|O_EXCL,0666))==-1 && errno==EEXIST) {
      if (++tries >= MAXTRIES)
         return(FALSE);
      sleep(5);
   }
   if (fd==-1 || close(fd)==-1)
      syserr("lock");
   return(TRUE);
}

void unlock(name)  /* free lock */
char *name;
{
   char *lockpath();

   if (unlink(lockpath(name))==-1)
      syserr("unlock");
}

char *lockpath(name) /* generate lock file path */
char *name;
{
   static char path[20];
   char *strcat();

   strcpy(path,LOCKDIR);
   return(strcat(path,name));
}

