/******************************************************************************
 *    pingky - Query nodes and report problems to the problem file            *
 *									      *
 *  Version 1.0       Author: WB Norton  Merit Computer Network               *
 *  Modification History:                                                     *
 *  written 5/18/89   Bill Norton, Merit Computer Network                     *
 *  5/23/89 - Modified NetQuery.c to fork and exec ping itself for speed @wes *
 *            Called Init routine to initialize netquery routines	      *
 *  08/16/89 - Modified fileio.c to parse netprotocols and parms during read  *
 *		instead of each time through module.    @wbn1		      *
 *  09/14/89 - Checking NSS logical links, and error counters		      *
 *  10/01/89 - Added Generic Error - Just create a protocol I don't understand*
 *		and I check for the existance of Generic/<addr>.<PROTO>       *
 *		if it doesn't exists we'll print the generic protocol	      *
 ******************************************************************************/
/*
  * Copyright 1989
  * The Regents of the University of Michigan
  * All Rights Reserved
  *
  * Permission to use, copy, modify, and distribute this software and its
  * documentation for any purpose and without fee is hereby granted, provided
  * that the above copyright notice and this permission notice appear in
  * all copies of the software and derivative works or modified versions
  * thereof, and that both that copyright notice and this permission
  * notice appear in supporting documentation.
  *
  * The software is provided "as is" and the University of Michigan
  * disclaims all warranties with regard to this software, including
  * all implied warranties of merchantability and fitness.  In no event
  * shall the University of Michigan be liable for any special, direct,
  * indirect, or consequential damages or any damages whatsoever
  * resulting from loss of use, data or profits, whether in an action of
  * contract, negligence or other tortious action, arising out of or in
  * connection with the use or performance of this software.
  */

#include <stdio.h>
#include <errno.h>
#include <fcntl.h>
#include <string.h>
#include "../INCLUDE/defs.h"
#include "../INCLUDE/fileio.h"	/* File I/O with Problem and hostfiles    */ 
#include "../INCLUDE/misc.h"	/* Defs for Miscellaneous useful routines */
#include "netquery.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
/*#define DEBUG 1 /* */

int Version=1;
int SubVersion=2;

#define ADD_PROBLEM 0
#define DEL_PROBLEM 1


#define NET_BROKE_DELAY 20    /* Delay in secs between cycles if things are */
                              /* Broken  - short delay */
#define NET_OK_DELAY 120  /* Delay in secs if no problems were detected last */
                          /* cycle through the hostfile                      */


struct NodeType Node[MAXNODES];		/* In ore version of node file */
int NumNodes=0; 		    /* Number of nodes we are to keep trackof */

struct ProblemType Problem[MAXPROBLEMS];/* In Coreversion of existing problems*/
int NumProblems=0;

long ProblemFileLastUpdated;	/* Last time PROBLEM.FILE was updated */
long ProblemFileLastTime;      /* Last time PROBLEM.FILE was updated */
long NodeFileLastUpdated;	/* Last Time the node file was updated */

char *Problem_File="PROBLEM.FILE";	/* File Containing Reported Problems */
char *checking="CHECKING";              /* Filename - What node are we on    */
char *logfile="pingky.log";		/* Log system messages here          */
char *cycletime="pingky.cycle";		/* file containing cycle time        */
char *hostfile="hostfile";              /* File containing our Hosts/Address */
char *tempdir="/tmp";			/*    Temporary files kept here      */
char *tempfile="P";			/* temporary file to store garbage   */
char tempfilename[100];			/* Filled in temporary workspace     */

/****************************************************************
 *  ProblemTime: Print the current time in the form:		*
 *                    Mon 03:34 \0				*
 ****************************************************************/
char *ProblemTime(EventTime)
char *EventTime;
{

   GetTime(EventTime);
   EventTime[4]=EventTime[11];  /* Put date here */
   EventTime[5]=EventTime[12];  /* Put date here */
   EventTime[6]=EventTime[13];  /* Put date here */
   EventTime[7]=EventTime[14];  /* Put date here */
   EventTime[8]=EventTime[15];  /* Put date here */
   EventTime[9]=' ';
   EventTime[10]='\0';              /* Mon 03:34 \0 */
   return(EventTime);
}

/****************************************************************
 *   Problem_Manager: 						*
 *           I am the manager: Report ALL happenings to me.	*
 *	I want to know who is up, who is down, EVERYTHING.	*
 *	Add Problem Types to NetServices in netquery.c		*
 *  								*
 ****************************************************************/
void Problem_Manager(Status,Service,node,addr,Problem_File)
int Status;	/* Status =0 if it is broke, Status=1 if it works           */
char *Service;	/* Service is a Service Index defined by Net Services Layer */
char *addr,*node;	/* Address and nodename of node we are reporting    */
char *Problem_File;	/*    Problem File we are to log problems to        */
{
int i,changed;


#ifdef DEBUG 
   printf("ProblemManager: The %s node %s Status: %s\n",node,Service,NetStatusString(Status));
#endif

   /**************************************************************/
   /************* ReRead Problem File if it has changed **********/
   /**************************************************************/
   if (FileChanged(Problem_File,&ProblemFileLastUpdated)) {
      NumProblems=ReadProblemFile(Problem,Problem_File);
      FileChanged(Problem_File,&ProblemFileLastUpdated);
   }

   switch(Status) {
	case ITDEAD :		/* Dead Machine- Delete secondary problems */
		changed=0;
   		  for (i=0; i<NumProblems ; i++)
       			if (strcmp(Problem[i].Addr,addr)==0)
          			if (strcmp(Problem[i].NetProto,Service)!=0){
				      Problem[i].Name[0]='\0';
				       changed=1;
				}
		if ( changed )
		  WriteProblemFile( Problem,Problem_File,NumProblems);
	case ITBROKE : 
		  AddProblem(node,addr,Service,Problem_File);
		  break;
	case ITWORKS : 
		     DelProblem(node,addr,Service,Problem_File);
		  break;
	default:  panic("Bad Problem Manager Call!");
		  break;
   }
#ifdef DEBUG
   printf("Exitting Problem_Manager\n");
#endif
}

/***************************************************************************
 * Problem_Exists:  Returns index of Problem if it exists and -1 otherwise *
 ***************************************************************************/
int Problem_Exists(Addr,Service)
char *Addr;
char *Service;	
{
int i;

   for (i=0; i<NumProblems ; i++)
       if (strcmp(Problem[i].Addr,Addr)==0)
          if (strcmp(Problem[i].NetProto,Service)==0) 
                        return(i); 

   return(-1);
}


/********************************************************************
 * AddProblem:   Add a problem to the Problem File if necessary     *
 *  								    *
 *  Variables:							    *
 *	Node: The name of the node that is having problems.	    *
 *  	Addr: The IP Address of the node that is having the problem *
 *	Service: The service that is failing (PING,TELNET,etc)	    *
 *	Problem_File: Name of the Problem File containing Problems  *
 *	Status_File:  The temporary file that was used during the   *
 *			investigation.  This file typically contains*
 *			the actuall error indication like:	    * 
 *			connection refused, 100% packet loss, etc   *
 ********************************************************************/
AddProblem(Node,Addr,Service,Problem_File)
char *Node,*Addr,*Problem_File;
char * Service;
{
char buffer2[100],Event[100];



#ifdef DEBUG 
  printf("Entering AddProblem \n");
#endif

   if ( Problem_Exists(Addr,Service) == -1 ) {  
        if (strcmp(Service,"PING")==0)
         	sprintf(Event,"%s %s WENT DOWN!\n",Node,Addr);
	else
           	sprintf(Event,"%s %s %s didn't work!\n",
		          Node,Addr,Service);

        Log(Event,logfile);	
        
        buffer2[0]='\0';
        Add_Problem_Entry(Node,Addr,Service,buffer2,Problem_File);
   }

#ifdef DEBUG
   printf("Exitting AddProblem\n");
#endif
}
 
/**************************************************************************
 * Add_Problem_Entry:  Add a problem to the Problem structure and to disk *
 * To Do: Open this file with the append flag                             *
 **************************************************************************/ 
Add_Problem_Entry(Node,Addr,ServiceString,Status,Problem_File)
char *Node,*Addr,*ServiceString,*Status,*Problem_File;
{
char buffer[100],Event[100];
	

   sprintf(Event,"echo '%s %s %s %s %s' >>%s",
              ProblemTime(buffer),Node,Addr,ServiceString,Status,Problem_File);
   if (system(Event)) syserr("Add_Problem_Entry: Appending to Problem_File");
/*   NumProblems=ReadProblemFile(Problem,Problem_File);*/
}


/********************************************************************
 * DelProblem:   Delete a problem in the Problem File if necessary  *
 *  								    *
 *  Variables:							    *
 *	Node: The name of the node that is now behaving.	    *
 *  	Addr: The IP Address of the node that is behaving correctly *
 *	Service: The service that works now (PING,TELNET,etc)	    *
 *	Problem_File: Name of the Problem File containing Problems  *
 ********************************************************************/
DelProblem(Node,Addr,Service,Problem_File)
char *Node,*Addr,*Problem_File;
char *Service;
{
char Event[100];
int index;

#ifdef DEBUG
printf("Entering DelProblem addr=%s Service=%s\n",Addr,Service);
#endif

   if  ( (index=Problem_Exists(Addr,Service)) != -1 ) {

      Problem[index].Name[0]='\0';    /* Mark this node invalid */
      WriteProblemFile(Problem,Problem_File,NumProblems);
      NumProblems=ReadProblemFile(Problem,Problem_File );

      if (strcmp(Service,"PING") == 0 )
         sprintf(Event,"%s %s came back up!\n",Node,Addr);
      else
         sprintf(Event,"%s %s %s Service is back!\n",Node,Addr,NetServiceString(Service));
      Log(Event,logfile);
   }

#ifdef DEBUG
   printf("Exitting DelProblem\n");
#endif
}


/****************************************************************
 *      Init:    Initialize pingky filenames etc.               *
 *               Initialize NetQuery Layer routines             *
 ****************************************************************/
Init(tempdir,tempfile,tempfilename,Problem_File,cycletime,logfile)
char *tempdir,*tempfile,*tempfilename,*Problem_File,*cycletime,*logfile;
{
char buffer[30];

    Log("Starting Internet Rover\nWB Norton\nMerit Computer Network\n",logfile);
    sprintf(tempfilename,"%s/%s.%d",tempdir,tempfile,getpid());
    Log(tempfilename,logfile);
    sprintf(buffer,"Version # %d.%d\n",Version,SubVersion);
    Log(buffer,logfile);
    Empty_File(Problem_File);         /* Empty Problem file */
    Empty_File(cycletime);         /* Empty Problem file */
    init_netquery();		/* initialize net_query variables @wes */
}

/***********************************************************************
 *   LogChecking : Print to a file what node we are currently checking *
 ***********************************************************************/
LogChecking(node,checking)
char *node,*checking;	/* node name and file name to log checking to */
{
FILE *stream;
char MyTime[40]; /* Read Buffer */

   if ((stream=fopen(checking,"w")) == NULL)
      syserr("fopen checking");
   fprintf(stream,"%s %s",GetTime(MyTime),node);
   if (fclose(stream) == -1) syserr("fclose checking");
}

/****************************************************************
 *       pingky main:     					*
 *                    see if a node is up and tell the problem  *
 *                    manager of the results			* 
 ****************************************************************/
main(argc,argv)
int argc;
char *argv[];
{
FILE *stream;
long StartClock,StopClock;
int ElapsedTime;
int i,j;
char *service;
char Name[MAXNODENAME],Addr[MAXADDRESS];

   if ( argc != 1 ) {
	fprintf( stderr , "usage: %s \n" , argv[0] );
	exit(1);
   }

   Init(tempdir,tempfile,tempfilename,Problem_File,cycletime,logfile);

   LogChecking("Rover is taking his first walk of the day ....",checking);
   while(1) {
      if (FileChanged(hostfile,&NodeFileLastUpdated)) { /*  if modified   */ 
         NumNodes=ReadNodeFile(Node,hostfile);       /* reread hostfile */
	 /*PrintNodes(NumNodes,Node); Prints Internal Node Storage*/
         FileChanged(hostfile,&NodeFileLastUpdated); 
      }
      StartClock=time(0);

      /* For each entry in the hostfile, ping and inform Manager of results */
      /*********************** BEV1: Main Loop ******************************/
      for(i=0; i<NumNodes; i++) {
         strcpy(Name,Node[i].Name);
         strcpy(Addr,Node[i].Addr);

	 /*LogChecking(Node[i].Name,checking); /* Log what node we are checking */
	 service=Node[i].Protocols[0].parms[0];

         if ( NetQuery(Addr,tempfilename,&Node[i].Protocols[0]) == ITWORKS ) {
            Problem_Manager( DEL_PROBLEM, service, Name, Addr, Problem_File );

            for( j=1; Node[i].Protocols[j].parms[0] != NULL; j++) {
		service=Node[i].Protocols[j].parms[0];
                if ( NetQuery(Addr,tempfilename,&Node[i].Protocols[j]) == ITWORKS) 
		   Problem_Manager( DEL_PROBLEM,service,Name,Addr,Problem_File);
	   	else 
                   Problem_Manager( ADD_PROBLEM,service,Name,Addr,Problem_File);
            }

 	 }
         else 					/* Node is NOT responding */
             Problem_Manager( ITDEAD, service, Name, Addr, Problem_File ); 
       }
       /**********************************************************************/

       StopClock=time(0);
       ElapsedTime=StopClock-StartClock;
       if ((stream=fopen(cycletime,"w")) == NULL)
          syserr("fopen pingky.cycle");
       fprintf(stream,"%2.2d:%2.2d",ElapsedTime/60,ElapsedTime%60);
       if (fclose(stream) == -1) syserr("fclose pingky cycle");

       if (ProblemFileLastTime!= ProblemFileLastUpdated) {
          LogChecking("Rover is taking a short nap ",checking); 
          ProblemFileLastTime = ProblemFileLastUpdated;
          sleep(NET_BROKE_DELAY);  /* Things are changing-sleep short */
          LogChecking("Rover is patrolling Gotham City.......",checking); 
       } else {
          LogChecking("Rover is taking a snooze - the network is stable",checking); 
	  sleep(NET_OK_DELAY);  /* Give network a rest - all is OK */
          LogChecking("Rover is making his rounds........",checking); 
       }
    }
}
