/*
 * Copyright (c) 1992 Regents of the University of Michigan.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of Michigan at Ann Arbor. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 *
 * All I/O with PROBLEM_FILE uses these routines
 */

#define STATUSX 	53
#define MAXSTATUSLINE 	26

#define ADD_PROBLEM		1   
#define ADD_PRIMARY_PROBLEM	2	
#define DELETE_PROBLEM  	3 
#define UPDATE_PROBLEM  	4 
#define CLAIM_PROBLEM  		5 
#define CHECK			6 
#define FUTURIZE_PROBLEM	7 
#define ADD_BATCH_PRIMARY_PROBLEM 	8 
#define DELETE_BATCH_PRIMARY_PROBLEM	9 
#define FLUSH_BATCH_PRIMARY_PROBLEM	10 

/* Note: ADD Problem and DELETE Problem are straight forward.  ADD_PRIMARY
 *	will automatically DELETE all problems associated with this UniqueID
 *	that are not of ProbType.   That way, you can ADD_PRIMARY problems,
 *	that will automatically delete secondary problems for you.
 *
 */

struct ProblemType {
	time_t TimeStamp;
	char Name[MAXNODENAME];
	char UniqueID[MAXUNIQUEID];
	char TestName[MAXTESTNAME];
	char StatusLine[MAXSTATUSLINE];
};

int ReadProblemFile();  /* read Problems into ProblemType Array from File */
int WriteProblemFile(); /* write Problems into Problem File               */
int Problem_Exists();   /* returns index, (Addr,Service,Problem,#Problems)*/

int Problem_Manager();
int TestNode();
int SetProblemPrefix();
