/*
 * Copyright (c) 1992 Regents of the University of Michigan.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of Michigan at Ann Arbor. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 */
#include <stdio.h>
#include <sys/types.h>
#include <dirent.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <time.h>
#include "CommonDefs.h"
#include "xmap.h"
#include "motif.h"
#include <X11/StringDefs.h>
#include <X11/cursorfont.h>
#include "LinkWidth.h"

char *Class;

static int LinkWidthPolicy=LINKWIDTH0;

/************************************************************************
 *  AdjustLinkWidthPolicy( ) - New Link Width policy from user		*
 ************************************************************************/
static void AdjustLinkWidthPolicy(filename)
char *filename;
{
	extern void ReDrawMap();

	if (filename == NULL) {
		LinkWidthCount = 0;		/* User wants line width 0 */
		LinkWidthPolicy=LINKWIDTH0;
	} else {
		ReadLinkWidthFile(filename);	/* User has LineWidth file */
		LinkWidthPolicy=LINKWIDTHVARIABLE;
	}	
	ReDrawMap();
}

int ReadLinkWidthFileIfNecessary()
{
	static time_t LastLinkWidthFileModTime;

	if ( LinkWidthPolicy==LINKWIDTH0 ) return(0);
	if ( FileChanged(CurrentLinkWidthFile, &LastLinkWidthFileModTime ) ) {
		ReadLinkWidthFile( CurrentLinkWidthFile );
		return(1);
	}
	else return(0);
}

/************************************************************************
 *  GetLinkWidth() - Externally callable interface - return link width	*
 ************************************************************************/
GetLinkWidth(Node1, Node2)
char *Node1, *Node2;
{
	register int i;

	if ( LinkWidthPolicy == LINKWIDTH0 ) return(0);

	for( i=0; i< LinkWidthCount; i++ ) {
		/*fprintf(stderr,"Comparing %s-%s against %s-%s\n",Node1,Node2,LinkWidthArray[ i ].Node1,LinkWidthArray[ i ].Node2);*/
		if ( (( strcmp(Node1, LinkWidthArray[ i ].Node1) == 0 ) &&
		      ( strcmp(Node2, LinkWidthArray[ i ].Node2) == 0 ))  ||
		     (( strcmp(Node1, LinkWidthArray[ i ].Node2) == 0 ) &&
		      ( strcmp(Node2, LinkWidthArray[ i ].Node1) == 0 )) ) 
			return( LinkWidthArray[ i ].LinkWidth );
	}
	fprintf(stderr,"Warning: can't get line width for %s-%s default width=0\n",Node1,Node2 );
	return(0);
}

/************************************************************************
 *  NewLinkWidthPolicy() - This routine gets called when the user 	*
 *			selects the LinkWidth() menu entry.  We are 	*
 *			passed the filename, which we will read and 	*
 *			process.                			*
 ************************************************************************/
/*ARGSUSED*/
static void NewLinkWidthPolicyCallback( w , LinkWidthFileName, call_data )
Widget w;
char *LinkWidthFileName;
XtCallbackList *call_data;
{
	AdjustLinkWidthPolicy( LinkWidthFileName );
}

/************************************************************************
 *  CreateLinkWidthWidgets() - for each .LW file in $PINGKYDIR, create  *
 *                      a linkwidth file entry in the main window       *
 ************************************************************************/
void CreateLinkWidthWidgets(dir, linkwidthpulldown)
char *dir;
Widget linkwidthpulldown;
{
	DIR *dp;
	struct dirent *entry;
	static Widget linkwidth[MAXLINKWIDTHFILES];
	static int count = 0, i, plen;
	static char *lwfiles[MAXLINKWIDTHFILES][MAXPATHLEN];
	char *p, *p2, itemname[100];
	struct stat st;
	time_t TimeNow=time(&TimeNow);

	/*
	 *  Set up the widget.
	 */
        linkwidth[count] = XmCreatePushButton(linkwidthpulldown, "LinkWidth0", 
							NULL, 0);
        XtManageChild(linkwidth[count]);
        XtAddCallback(linkwidth[count], XmNactivateCallback, 
				NewLinkWidthPolicyCallback, (caddr_t) NULL);
        count++;
        if ((dp = opendir(dir)) == NULL) {
		perror("opendir");
                return;
        }
        while ((entry = readdir(dp ) ) != NULL ) {
                if ((p = strrchr(entry->d_name, '.')) == NULL) 
			continue;
                if (strcmp(p, ".LW") == 0) {
			/*
			 *	BEV - only look at files that start with 
			 *	this network name
			 */
			plen=strlen(Class);
			if ( strncmp( entry->d_name, Class, plen )!=0) 
				continue;
			/* 
			 * Don't bother if this LW file is > 1 day old 
			 */
			sprintf(lwfiles[count], "%s/%s", dir, entry->d_name);
			if ( stat( lwfiles[count], &st ) != 0 ) {
				fprintf(stderr,"CreateLinkWidthWidgets() failed for %s\n",lwfiles[count]);
				exit(1);
			}
			if ( TimeNow - st.st_mtime > 24*60*60 ) continue;
			
                        for (p2 = entry->d_name+plen+1, i = 0; p2 != p; p2++ )
                                itemname[i++] = *p2;
                        itemname[i] = '\0';
			/*
			 *  Set up the widget.
			 */
                        linkwidth[count] = XmCreatePushButton(
						linkwidthpulldown, itemname, 
						NULL, 0);
                        XtManageChild(linkwidth[count]);
                        XtAddCallback(linkwidth[count], XmNactivateCallback, 
					NewLinkWidthPolicyCallback, 
					(caddr_t) lwfiles[count]);
                        count++;
                }
        }
        closedir(dp);
}

#ifdef STANDALONE
main()
{
	printf("%d links read\n", ReadLinkWidthFile("LinkSpeed.LW"));
	
}
#endif
