
/*
 * Copyright (c) 1992 Regents of the University of Michigan.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of Michigan at Ann Arbor. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 *
 * This is the main Merit Rover module.  We call the initialization
 * routines, read the config files, and fire off the network engines.
 */

#include <stdio.h>
#include <string.h>
#include <time.h>
#include <sys/param.h>
#include "pathnames.h"
#include "CommonDefs.h"
#include "GetNeighborTable.h"

extern int ResolveNames;

int FetchDSU = 0;
int NoDiscovery = 0;	/* Flag - Don't append any Queryable Nodes to List */
			/* We'll use what is in the Config file only */

char *SubNet, *SubNetMask;	/* For use with generic networks only */

char *progname;
char hostname[MAXHOSTNAMELEN];
char Error_Buf[MAXPATHLEN];
char *Error_Log=Error_Buf;

char CommunityName[100];

static char *DefaultPingkyDir = DEFAULT_PINGKY_DIR;
static char cycletime[MAXPATHLEN];     /* How long did pingky take to cycle */
static char logfile[MAXPATHLEN];       /* Where do we log things */
static int NetworkType;
char *NetworkName;		/* Actual name of the network */

Usage()
{
	extern void exit();

	fprintf(stderr,
		"Usage(): %s -t <net> [-r] [ -T SNMPTimeout ] [ -R SNMP Retries ] -c community -s statefile [ -r ]\n\
where net::= nsfnett3 | merit | anything4generic\n\
SNMPTimeout is in seconds\n\
community is the SNMP community name for the network\n\
statefile is the Network Status File", progname);
	exit(1);
}

char *GetStateFile(prog, parm)
char *prog, *parm;
{
	static char statefile[MAXPATHLEN];
	char *p;

	if (parm != NULL) {
		if ((p = strrchr(parm, '/' )) == NULL) 
			strcpy(statefile, parm);
		else 
			strcpy(statefile, p + 1);
		if ((p = strrchr(statefile, '.' )) != NULL) 
			*p = '\0';
		NetworkType = Str_To_NetworkType(statefile);
		return(parm);
	}
	if ((p = strrchr(prog, '/' )) == NULL) 
		strcpy(statefile, prog);
	else 
		strcpy(statefile, p + 1);
	p = statefile;
	while (isupper(*p) || isdigit(*p)) 
		p++;
	*p = '\0';
	NetworkType = Str_To_NetworkType(statefile);
	strcat(statefile, ".STATUS");
	return(statefile);
}

main(argc, argv)
int argc;
char *argv[];
{
	struct NetworkType Network,*NetworkNow;
	extern struct NetworkType *MergeNetworks(), *BuildNetworkTable();
	extern void exit();
#ifdef OLD
	time_t StartClock, StopClock;
	int ElapsedTime;
	FILE *stream;
#endif
	char *pingkydir, *getenv();
	char *StateFile = NULL, statefile[BUFSIZ];
	register int c;
	extern char Version[];
	extern char *optarg;
	extern int SNMPRetries, SNMPTimeout;

	if ((pingkydir = getenv("PINGKYDIR")) == NULL) 
		pingkydir=DefaultPingkyDir;
#ifdef OLD
	sprintf(cycletime, "%s/%s", pingkydir, NEWROVER_CYCLE);
#endif
	sprintf(logfile, "%s/%s", pingkydir, PROBLEM_LOG);
	sprintf(Error_Log, "%s/%s", pingkydir, ROVER_LOG);
	sprintf(statefile, "%s/", pingkydir);

	progname = argv[0];
	while ((c = getopt(argc, argv, "R:T:c:rs:t:n:m:")) != EOF) {
		switch (c) {
		case 'T':
			SNMPTimeout=atoi(optarg);
			if ( SNMPTimeout == 0 ) {
				fprintf(stderr,"Invalid SNMP Timeout specified\n");
				Usage();
			}
			break;
		case 'R':
			SNMPRetries=atoi(optarg);
			if ( SNMPRetries == 0 ) {
				fprintf(stderr,"Invalid SNMP Retries specified\n");
				Usage();
			}
			break;
		case 'n':
			SubNet = optarg;
			break;
		case 'm':
			SubNetMask = optarg;
			break;
		case 't':
			NetworkType = Str_To_NetworkType(optarg);
			if ( NetworkType == GENERICNET ) NetworkName=optarg;
			break;
		case 's':
			strcat(statefile, optarg);
			StateFile = statefile;
			break;
		case 'r':
			ResolveNames = FetchDSU = 1;
			break;
		case 'c':
			strcpy(CommunityName, optarg);
			break;
		default:
			Usage();
			break;
		}
	}
	if (NetworkType == 0) {
		printf("You must specify network type\n");
		Usage();
		exit(1);
		/*NOTREACHED*/
	}
	if (StateFile == NULL) {
		printf("You must specify a statefile\n");
		Usage();
		exit(2);
		/*NOTREACHED*/
	}
	if ( strlen(CommunityName) == 0 ) {
		fprintf(stderr,"You must specify a community name\n");
		Usage();
		exit(3);
		/*NOTREACHED*/
	}
	gethostname(hostname, sizeof(hostname));
	strtok(hostname, " \t\n.");

	printf("%s\n",Version);

#ifdef OLD
	if ((stream = fopen(cycletime, "w")) == NULL) {
		syserr("fopen NewRover.cycle");
		/*NOTREACHED*/
	}
	fprintf(stream, "--:--");
	if (fclose(stream) < 0) {
		syserr("fclose pingky.cycle");
		/*NOTREACHED*/
	}
	StartClock = time((time_t *) NULL);
#endif

	init_query_engine();
	ReadConfig( &Network , NetworkType , StateFile );

	NetworkNow = BuildNetworkTable(&Network);
	NetworkNow = MergeNetworks(NetworkNow, &Network);
	WriteConfig(NetworkNow, NetworkType, StateFile);
#ifdef OLD
	StopClock = time((time_t *) NULL);
	ElapsedTime = (int) (StopClock - StartClock);
	if ((stream = fopen(cycletime, "w")) == NULL) {
		syserr("fopen NewRover.cycle");
		/*NOTREACHED*/
	}
	fprintf(stream, "%2.2d:%2.2d", ElapsedTime / 60,ElapsedTime % 60);
	if (fclose(stream) < 0) {
		syserr("fclose pingky.cycle");
		/*NOTREACHED*/
	}
#endif
	exit(0);
	/*NOTREACHED*/
}
