/*

A new, slightly changed version is appended.  All I did was to up the
timeout for the test (which should fix the problem of it reporting
x500 down when it's really up).  I also changed the exit()'s to
returns, so it won't die in case there's trouble.

As for the other problem (x500 not being reported as down when it is),
I don't think it's a problem with this test.  In all my testing, this
works just fine.  How is it being called by rover?  That's the only
thing that could be going wrong, as far as I can see...

*/
#include <stdio.h>
#include "dixie.h"
#include <netdb.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#ifdef _AIX
#include <sys/select.h>
#endif

#ifndef FD_SET
#define NFDBITS         32
#define FD_SETSIZE      32
#define FD_SET(n, p)    ((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS)))
#define FD_CLR(n, p)    ((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))
#define FD_ISSET(n, p)  ((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))
#define FD_ZERO(p)      bzero((char *)(p), sizeof(*(p)))
#endif

#define DIXIE	1
#define DSA	2

#define STANDALONE
#ifdef STANDALONE

main( argc, argv )
int	argc;
char	**argv;
{
	int	rc;

	if ( argc < 3 ) {
		fprintf( stderr, "usage: %s host {dsa|dixie}\n", argv[0] );
		return( -1 );
	}

	if ( strcasecmp( argv[2], "dixie" ) == 0 )
		if ( dxi_ping( argv[1], DIXIE ) == 0 )
			return( 0 );	/* dixie up */
		else
			return( 1 );	/* dixie down */
	else if ( strcasecmp( argv[2], "dsa" ) == 0 )
		if ( (rc = dxi_ping( argv[1], DSA )) == 0 )
			return( 0 );	/* dsa up */
		else
			return( rc );	/* dsa down or unknown */
	else {
		fprintf( stderr, "usage: %s host {dsa|dixie}\n", argv[0] );
		return( -1 );
	}
}

#endif /* STANDALONE */

/*
 * dxi_ping - checks the specified service on host.  Service can be
 * DIXIE or DSA.  For DIXIE, there are three possible outcomes:
 *	-1	something bad happened
 *	0	DIXIE is up
 *	1	DIXIE is down
 * for DSA, there are four possible outcomes:
 *	-1	something bad happened
 *	0	the DSA is up
 *	1	the DSA is down
 *	2	the DSA is unknown (because DIXIE was down)
 */

dxi_ping( host, service )
char	*host;
int	service;
{
	int			s;
	int			i, rc;
	fd_set			fdset;
	struct hostent		*hp, *gethostbyname();
	struct sockaddr_in	addr;
	char			buf[1024];
	struct timeval		timeout;
	short			pingcode;

	if ( (addr.sin_addr.s_addr = inet_addr( host )) == -1 ) {
		if ( (hp = gethostbyname( host )) == NULL ) {
			fprintf( stderr, "%s: unknown host\n", host );
			return( -1 );
		}
		bcopy( hp->h_addr, (char *) &addr.sin_addr.s_addr,
		    hp->h_length );
	}
	addr.sin_family = AF_INET;
	addr.sin_port = DXI_PORT;

	if ( (s = socket( AF_INET, SOCK_DGRAM, 0)) < 0 ) {
		perror( "socket" );
		return( -1 );
	}

	if ( connect( s, (struct sockaddr *) &addr, sizeof(struct sockaddr) )
	    < 0 ) {
		perror( "connect" );
		return( -1 );
	}

	/* make the packet */
	buf[0] = DXI_PING;
	pingcode = 2;
	bcopy( (char *) &pingcode, buf + DXI_H_SIZE, sizeof(pingcode) );

	timeout.tv_sec = 2;
	timeout.tv_usec = 0;
	for ( i = 0; i < 3; i++ ) {
		if ( send( s, buf, DXI_H_SIZE + sizeof(short), 0 ) < 0 ) {
			perror( "send" );
			return( -1 );
		}

		timeout.tv_sec *= 2;
		FD_ZERO( &fdset );
		FD_SET( s, &fdset );
		if ( (rc = select( FD_SETSIZE, &fdset, (fd_set *) 0,
		    (fd_set *) 0, &timeout )) < 0 ) {
			perror( "select" );
			return( -1 );
		}

		if ( rc != 0 )
			break;
	}

	if ( i == 3 ) {
		close( s );
		return( service == DIXIE ? 1 : 2 );	/* dixie down */
	}

	if ( recv( s, buf, sizeof(buf), 0 ) < 0 ) {
		perror( "recv" );
		return( -1 );
	}
	close( s );

	if ( buf[0] == DXI_SUCCESS || service == DIXIE )
		return( 0 );	/* dixie & DSA up, only dixie status wanted */
	else
		return( 1 );	/* dixie up & DSA down */
}
