/*
 * Copyright (c) 1992 Regents of the University of Michigan.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of Michigan at Ann Arbor. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 *
 * PROBLEM FILE management routines
 */

#include <stdio.h>
#include <ctype.h>
#include <time.h>
#include <pwd.h>
#include <sys/param.h>

#include "pathnames.h"
#include "CommonDefs.h"
#include "problem.h"

char *progname;

main(argc, argv)
int argc;
char *argv[];
{
        extern void exit();
	char statusline[300];
	int i;

        progname = argv[0];

        if ( argc < 5 ) {
                printf("%s Usage(): ADD|DELETE|UPDATE ProblemType NodeName NodeUniqueID [ status ]\n",argv[0] );
                exit(1);
        }

	strcpy( statusline, "" );
	for ( i=5; i<argc; i++ ) {
		strcat( statusline,argv[i] );
		strcat( statusline, " ");
	}
		

        if (strcmp( argv[1],"ADD")==0)
                Problem_Manager(ADD_PROBLEM,argv[2],argv[3],argv[4],statusline);
        else if (strcmp( argv[1],"DELETE")==0)
                Problem_Manager(DELETE_PROBLEM,argv[2],argv[3],argv[4],statusline);
        else if (strcmp( argv[1],"UPDATE")==0)
                Problem_Manager(UPDATE_PROBLEM,argv[2],argv[3],argv[4],statusline);
        else printf("Unknown command: %s %s %s %s %s\n",
                        argv[1],argv[2],argv[3],argv[4],statusline);
}
