/* Help file defineing the VarList structure and routines */

#include "Bindings.h"

struct VarList {
        char *VarName;                  /* Object Name */
        char *Prefix;                   /* 1.3.6.1.4.1. - Encoding */
        struct bindings *Head;          /* List of instance/values */
        struct VarList *Next;           /* Next Var to List */
        struct VarList *Prev;
};

/************************************************************************
 * struct VarList *MakeVar( char *var, char *encoding )			*
 *	Makes a VarList structure and returns a pointer to it		*
 ************************************************************************/
struct VarList *MakeVar();


/************************************************************************
 * struct VarList *AddVarToChain( VarListHead, v )			*
 *	Adds a VarListStructure to chain pointer to by VarListHead	*
 *	returns Pointer to Head of Varlist Chain			*
 ************************************************************************/
struct VarList *AddVarToChain();

/************************************************************************
 * DupVarAndChain( Head,v )						*
 *	Duplicates a VarList structure and adds to the passed chain	*
 * 	returns updated chain pointer					*
 ************************************************************************/
struct VarList *DupVarAndChain();

/************************************************************************
 * AddVar() - Creates a VarList structure and adds to VarList Chain	*
 *		returns updated VarList chain pointer 			*
 ************************************************************************/
struct VarList *AddVar();

/************************************************************************
 * FreeVarList( ) - Free a VarListChain					*
 *	Always Returns NULL						*
 ************************************************************************/
struct VarList *FreeVarListChain();	/* Free all vars & bindings in chain */
